-- Manual SQL Dump of kspguard_ksp
-- Generated: 2025-08-21 17:01:01

--
-- Structure for table `assign`
--
CREATE TABLE `assign` (
  `id` int NOT NULL AUTO_INCREMENT,
  `guard_id` int NOT NULL DEFAULT '0',
  `loc_id` int NOT NULL DEFAULT '0',
  `shift` int NOT NULL DEFAULT '0',
  `active` int NOT NULL DEFAULT '0',
  `info` text,
  `area` text,
  PRIMARY KEY (`id`),
  KEY `FK_assign_guard_id` (`guard_id`),
  KEY `FK_assign_loc_id` (`loc_id`),
  CONSTRAINT `FK_assign_guard_id` FOREIGN KEY (`guard_id`) REFERENCES `guard` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_assign_loc_id` FOREIGN KEY (`loc_id`) REFERENCES `loc` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=151 DEFAULT CHARSET=latin1;

--
-- Data for table `assign`
--
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('32','19','21','1','1','','Lobby\nReal-Time Report\nReal-Time Report MO-OT\nStatic Guard 1\nMO-OT');
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('36','21','21','1','1','','Roll Call\nGuard House\nReal-Time Report\nSupervisor\nCar Park Patrolling\nManagement Office');
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('52','37','21','1','0','','Real-Time Report\nReal-Time Report MO-OT\nStatic Guard 4\nMO-OT\nPatrolling Block B');
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('60','34','21','2','1','','Level 8\nReal-Time Report\nStatic Guard 3\nPatrolling Block B\nWater Riser Block B');
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('89','11','21','1','1','','Level 8\nReal-Time Report\nStatic Guard 2');
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('91','15','21','2','1','','Real-Time Report\nStatic Guard 2');
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('93','62','21','2','1','','Roll Call\nGuard House\nLevel 8\nReal-Time Report\nSupervisor\nWater Tank / Water Pump\nParcel Collection / Arrangement');
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('94','63','21','2','1','','Real-Time Report\nStatic Guard 1\nCar Park Patrolling');
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('107','80','23','2','1','','Loading A\nReal-Time Report\nStatic Guard 2');
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('108','81','23','1','0','','Lobby B\nReal-Time Report\nStatic Guard 4\nPatrolling Block B\nWater Riser Block B');
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('109','35','23','1','1','','Lobby B\nReal-Time Report\nStatic Guard 4\nPatrolling Block B\nWater Riser Block B');
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('110','83','23','1','1','','Roll Call\nLoading B\nReal-Time Report\nSupervisor\nManagement Office\nPerimeter\nCar Park Patrolling');
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('111','84','23','2','1','','Roll Call\nLoading B\nReal-Time Report\nSupervisor\nLevel 7\nPerimeter\nBarrier Gate\nWater Tank / Water Pump\nCar Park Patrolling');
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('112','77','23','1','1','','Loading A\nReal-Time Report\nStatic Guard 3\nPatrolling Block A (Secondary)');
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('114','76','23','2','1','','Lobby B\nReal-Time Report\nStatic Guard 3');
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('115','82','23','2','1','','Lobby A\nReal-Time Report\nStatic Guard 1\nBarrier Gate');
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('116','85','21','2','0','','Real-Time Report\nStatic Guard 2');
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('117','36','31','2','1','','Guard House\nReal-Time Report\nStatic Guard\nCar Park Patrolling\nParcel Updates');
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('118','61','31','1','1','','Guard House\nReal-Time Report\nStatic Guard\nCar Park Patrolling\nParcel Updates');
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('131','102','21','1','1','','Real-Time Report\nStatic Guard 3\nPatrolling Block A\nParcel Collection / Arrangement');
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('132','99','21','1','0','','Real-Time Report\nStatic Guard 1');
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('134','100','21','1','1','','Real-Time Report\nStatic Guard 4\nPatrolling Block B');
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('135','101','21','1','0','','Real-Time Report\nStatic Guard 1');
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('137','104','21','1','0','','Real-Time Report\nStatic Guard 1');
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('139','97','23','1','1','','Real-Time Report\nStatic Guard 1\nPatrolling Block A\nWater Riser Block A');
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('141','50','23','1','1','','Roll Call\nStatic Guard 1');
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('144','107','32','1','1','','Guard House\nReal-Time Report\nPatrolling');
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('145','108','23','1','1','','Roll Call\nLobby A\nLobby B\nLoading A\nLoading B\nReal-Time Report\nReal-Time Report - OT Guard 1st\nReal-Time Report - OT Guard 2nd\nSupervisor\nStatic Guard 1\nStatic Guard 2\nStatic Guard 3\nStatic Guard 4\nManagement Office\nOT SG 1 - 1st\nOT SG 1 - 2nd\nLevel 7\nPerimeter\nBarrier Gate\nPatrolling Block A\nPatrolling Block B\nWater Riser Block A\nWater Riser Block B\nWater Tank / Water Pump\nCar Park Patrolling\nPatrolling Block A (Secondary)\nPatrolling Block B (Secondary)\nFire Extinguisher');
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('146','109','32','2','1','','Guard House\nReal-Time Report\nPatrolling');
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('147','110','32','1','1','','Roll Call');
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('148','98','33','1','1','','Roll Call\nGuard House\nReal-Time Report\nStatic Guard 1\nPatrolling Block A\nPatrolling Block B\nWater Riser Block A\nWater Riser Block B\nRefuse Room A\nRefuse Room B\nWater Tank / Water Pump\nFire Extinguisher\nContractor Checks');
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('149','79','33','1','1','','Real-Time Report\nStatic Guard 2\nCar Park Patrolling\nPerimeter Patrolling\nCommon Area\nManagement Office\nParcels Update\nRenovation Checks');
INSERT INTO `assign` (`id`,`guard_id`,`loc_id`,`shift`,`active`,`info`,`area`) VALUES ('150','103','33','2','1','','Roll Call\nGuard House\nReal-Time Report\nCar Park Patrolling\nPerimeter Patrolling\nParcels Update');

--
-- Structure for table `duty`
--
CREATE TABLE `duty` (
  `id` int NOT NULL AUTO_INCREMENT,
  `guard_id` int NOT NULL DEFAULT '0',
  `loc_id` int NOT NULL DEFAULT '0',
  `dt` text,
  `shift` int NOT NULL DEFAULT '0',
  `complete` int NOT NULL DEFAULT '0',
  `dtm` datetime DEFAULT NULL,
  `num1` int NOT NULL DEFAULT '0',
  `num2` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `FK_duty_guard_id` (`guard_id`),
  KEY `FK_duty_loc_id` (`loc_id`),
  CONSTRAINT `FK_duty_guard_id` FOREIGN KEY (`guard_id`) REFERENCES `guard` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_duty_loc_id` FOREIGN KEY (`loc_id`) REFERENCES `loc` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4613 DEFAULT CHARSET=latin1;

--
-- Data for table `duty`
--
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('646','15','21','2025-02-09','0','1','2025-02-10 05:32:28','85','85');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('649','19','21','2025-02-10','0','1','2025-02-10 20:11:18','24','24');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('650','11','21','2025-02-10','0','1','2025-02-11 00:22:05','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('652','21','21','2025-02-10','0','1','2025-02-10 20:09:07','35','35');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('653','15','21','2025-02-10','0','1','2025-02-11 08:12:25','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('668','19','21','2025-02-11','0','1','2025-02-12 00:20:48','99','99');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('669','11','21','2025-02-11','0','1','2025-02-11 20:12:59','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('671','21','21','2025-02-11','0','1','2025-02-11 20:12:59','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('674','15','21','2025-02-11','2','1','2025-02-12 08:08:38','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('677','19','21','2025-02-12','0','1','2025-02-12 20:11:50','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('678','11','21','2025-02-12','0','1','2025-02-12 20:19:37','58','58');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('680','21','21','2025-02-12','0','1','2025-02-12 20:22:37','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('683','15','21','2025-02-12','0','1','2025-02-13 08:02:25','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('685','19','21','2025-02-13','0','1','2025-02-14 01:29:31','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('688','21','21','2025-02-13','1','1','2025-02-14 00:20:00','110','110');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('689','11','21','2025-02-13','1','1','2025-02-13 20:15:35','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('706','15','21','2025-02-13','2','1','2025-02-14 08:07:32','105','105');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('711','11','21','2025-02-14','1','1','2025-02-15 00:16:11','129','129');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('713','21','21','2025-02-14','1','1','2025-02-14 20:16:28','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('714','19','21','2025-02-14','1','1','2025-02-14 20:20:24','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('715','15','21','2025-02-14','2','1','2025-02-15 08:03:19','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('719','19','21','2025-02-15','1','1','2025-02-16 00:16:43','99','99');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('720','11','21','2025-02-15','1','1','2025-02-15 20:28:20','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('722','21','21','2025-02-15','1','1','2025-02-15 20:22:19','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('723','15','21','2025-02-15','2','1','2025-02-16 19:58:37','105','105');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('727','19','21','2025-02-16','1','1','2025-02-16 20:11:36','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('728','11','21','2025-02-16','1','1','2025-02-17 08:05:02','69','69');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('730','21','21','2025-02-16','1','1','2025-02-17 02:05:12','52','52');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('735','15','21','2025-02-16','2','1','2025-02-17 08:07:36','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('736','19','21','2025-02-17','1','1','2025-02-17 20:15:18','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('738','21','21','2025-02-17','1','1','2025-02-17 20:19:21','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('740','11','21','2025-02-17','1','1','2025-02-17 20:14:32','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('741','15','21','2025-02-17','2','1','2025-02-18 08:07:43','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('744','50','21','2025-02-17','1','1','2025-02-18 05:32:44','73','73');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('745','19','21','2025-02-18','1','1','2025-02-18 20:08:07','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('746','11','21','2025-02-18','1','1','2025-02-18 20:09:15','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('748','21','21','2025-02-18','1','1','2025-02-19 01:10:02','110','110');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('751','15','21','2025-02-18','2','1','2025-02-19 08:10:41','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('755','19','21','2025-02-19','1','1','2025-02-19 20:10:30','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('758','21','21','2025-02-19','1','1','2025-02-19 20:12:27','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('760','11','21','2025-02-19','1','1','2025-02-20 00:16:21','129','129');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('772','15','21','2025-02-19','2','1','2025-02-20 08:05:29','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('774','19','21','2025-02-20','1','1','2025-02-21 00:18:00','99','99');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('775','11','21','2025-02-20','1','1','2025-02-20 20:18:39','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('777','21','21','2025-02-20','1','1','2025-02-20 20:14:53','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('782','15','21','2025-02-20','2','1','2025-02-21 08:08:21','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('783','19','21','2025-02-21','1','1','2025-02-21 20:10:26','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('784','11','21','2025-02-21','1','1','2025-02-21 20:10:54','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('786','21','21','2025-02-21','1','1','2025-02-22 00:16:37','110','110');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('791','15','21','2025-02-21','2','1','2025-02-22 08:06:10','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('792','19','21','2025-02-22','1','1','2025-02-22 20:09:38','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('793','11','21','2025-02-22','1','1','2025-02-22 20:12:52','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('795','21','21','2025-02-22','1','1','2025-02-22 20:15:03','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('800','15','21','2025-02-22','2','1','2025-02-23 08:11:37','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('801','19','21','2025-02-23','1','1','2025-02-23 20:10:40','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('802','11','21','2025-02-23','1','1','2025-02-24 00:15:49','99','99');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('804','21','21','2025-02-23','1','1','2025-02-23 20:17:37','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('809','15','21','2025-02-23','2','1','2025-02-24 08:09:54','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('810','19','21','2025-02-24','1','1','2025-02-25 00:19:07','99','99');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('811','11','21','2025-02-24','1','1','2025-02-24 20:13:19','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('813','21','21','2025-02-24','1','1','2025-02-24 20:19:36','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('818','15','21','2025-02-24','2','1','2025-02-25 08:11:29','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('819','19','21','2025-02-25','1','1','2025-02-25 20:13:42','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('820','11','21','2025-02-25','1','1','2025-02-25 20:16:10','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('822','21','21','2025-02-25','1','1','2025-02-25 20:13:16','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('823','37','23','2025-02-25','2','1','2025-02-26 08:11:28','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('824','36','23','2025-02-25','2','1','2025-02-26 18:03:08','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('827','34','23','2025-02-25','2','1','2025-02-26 08:17:12','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('838','15','21','2025-02-25','2','1','2025-02-26 08:05:28','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('845','19','21','2025-02-26','1','1','2025-02-26 20:12:10','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('846','11','21','2025-02-26','1','1','2025-02-26 20:14:55','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('847','21','21','2025-02-26','1','1','2025-02-27 00:16:38','110','110');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('857','37','23','2025-02-26','2','1','2025-02-27 08:11:30','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('858','36','23','2025-02-26','2','1','2025-02-27 20:05:01','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('860','34','23','2025-02-26','2','1','2025-02-27 08:11:39','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('863','15','21','2025-02-26','2','1','2025-02-27 08:08:13','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('864','19','21','2025-02-27','1','1','2025-02-27 20:10:59','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('865','11','21','2025-02-27','1','1','2025-02-28 00:16:18','99','99');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('874','21','21','2025-02-27','1','1','2025-02-27 20:10:37','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('876','37','23','2025-02-27','2','1','2025-02-28 11:29:15','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('878','34','23','2025-02-27','2','1','2025-02-28 08:09:54','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('881','15','21','2025-02-27','2','1','2025-02-28 08:07:02','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('882','36','23','2025-02-27','2','1','2025-02-28 11:26:17','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('886','21','21','2025-02-28','1','1','2025-02-28 20:10:31','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('897','34','23','2025-02-28','2','1','2025-03-01 08:06:42','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('900','15','21','2025-02-28','2','1','2025-03-01 08:03:34','106','106');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('903','36','23','2025-02-28','2','1','2025-03-01 10:05:37','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('904','37','23','2025-02-28','2','1','2025-03-01 08:05:20','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('906','11','21','2025-02-28','1','1','2025-02-28 20:08:41','18','18');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('908','11','21','2025-03-01','1','1','2025-03-01 20:16:40','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('910','21','21','2025-03-01','1','1','2025-03-01 20:17:27','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('914','37','23','2025-03-01','2','1','2025-03-02 08:04:13','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('922','19','21','2025-03-01','1','1','2025-03-01 20:11:10','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('923','15','21','2025-03-01','2','1','2025-03-02 08:02:31','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('924','34','23','2025-03-01','2','1','2025-03-02 08:13:36','23','23');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('925','36','23','2025-03-01','2','1','2025-03-02 19:57:05','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('926','19','21','2025-03-02','1','1','2025-03-02 20:26:40','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('927','11','21','2025-03-02','1','1','2025-03-02 20:28:37','58','58');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('933','37','23','2025-03-02','2','1','2025-03-03 08:02:11','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('935','34','23','2025-03-02','2','1','2025-03-03 08:09:15','23','23');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('938','15','21','2025-03-02','2','1','2025-03-03 08:07:45','106','106');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('940','21','21','2025-03-02','1','1','2025-03-03 00:18:47','110','110');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('942','36','23','2025-03-02','2','1','2025-03-03 19:18:02','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('943','19','21','2025-03-03','1','1','2025-03-03 20:11:14','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('944','11','21','2025-03-03','1','1','2025-03-04 00:16:56','131','131');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('946','21','21','2025-03-03','1','1','2025-03-03 20:15:18','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('952','37','23','2025-03-03','2','1','2025-03-04 08:01:53','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('954','34','23','2025-03-03','2','1','2025-03-04 08:04:49','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('956','15','21','2025-03-03','2','1','2025-03-04 08:02:50','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('957','36','23','2025-03-03','2','1','2025-03-04 08:02:12','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('963','21','21','2025-03-04','1','1','2025-03-04 20:14:21','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('968','19','21','2025-03-04','1','1','2025-03-05 00:35:21','99','99');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('969','11','21','2025-03-04','1','1','2025-03-04 20:16:46','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('971','37','23','2025-03-04','2','1','2025-03-05 12:22:20','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('972','36','23','2025-03-04','2','1','2025-03-05 08:03:13','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('974','34','23','2025-03-04','2','1','2025-03-05 08:29:49','18','18');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('976','15','21','2025-03-04','2','1','2025-03-05 08:07:30','106','106');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('978','19','21','2025-03-05','1','1','2025-03-05 20:11:02','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('979','11','21','2025-03-05','1','1','2025-03-05 20:10:23','58','58');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('981','21','21','2025-03-05','1','1','2025-03-06 00:19:52','110','110');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('986','36','23','2025-03-05','2','1','2025-03-06 07:30:48','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('988','34','23','2025-03-05','2','1','2025-03-05 23:05:49','22','22');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('990','15','21','2025-03-05','2','1','2025-03-06 08:03:41','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('992','37','23','2025-03-05','2','1','2025-03-06 08:06:14','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1001','19','21','2025-03-06','1','1','2025-03-06 20:08:13','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1002','11','21','2025-03-06','1','1','2025-03-07 00:18:39','99','99');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1004','21','21','2025-03-06','1','1','2025-03-06 20:14:20','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1005','36','23','2025-03-06','2','1','2025-03-07 07:56:28','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1006','35','23','2025-03-06','1','1','2025-03-06 20:02:25','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1008','34','23','2025-03-06','2','1','2025-03-07 08:05:32','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1013','37','23','2025-03-06','2','1','2025-03-07 08:05:28','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1016','15','21','2025-03-06','2','1','2025-03-07 08:06:00','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1018','19','21','2025-03-07','1','1','2025-03-07 20:08:26','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1019','11','21','2025-03-07','1','1','2025-03-07 20:06:18','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1021','21','21','2025-03-07','1','1','2025-03-07 20:43:56','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1022','35','23','2025-03-07','1','1','2025-03-07 20:02:56','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1028','37','23','2025-03-07','2','1','2025-03-08 08:01:00','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1029','36','23','2025-03-07','2','1','2025-03-08 08:07:08','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1031','34','23','2025-03-07','2','1','2025-03-08 08:02:40','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1033','15','21','2025-03-07','2','1','2025-03-08 08:07:14','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1035','19','21','2025-03-08','1','1','2025-03-09 00:18:53','99','99');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1036','11','21','2025-03-08','1','1','2025-03-08 20:10:26','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1038','21','21','2025-03-08','1','1','2025-03-08 20:12:03','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1039','35','23','2025-03-08','1','1','2025-03-08 20:01:27','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1045','37','23','2025-03-08','2','1','2025-03-09 08:06:12','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1046','36','23','2025-03-08','2','1','2025-03-09 08:23:56','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1048','34','23','2025-03-08','2','1','2025-03-09 08:05:49','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1050','15','21','2025-03-08','2','1','2025-03-09 08:06:19','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1055','21','21','2025-03-09','1','1','2025-03-09 20:08:31','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1056','35','23','2025-03-09','1','1','2025-03-09 20:02:55','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1060','19','21','2025-03-09','1','1','2025-03-09 20:07:28','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1061','11','21','2025-03-09','1','1','2025-03-10 00:15:42','99','99');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1062','37','23','2025-03-09','2','1','2025-03-10 08:05:27','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1064','34','23','2025-03-09','2','1','2025-03-10 08:06:05','30','30');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1068','36','23','2025-03-09','2','1','2025-03-10 08:02:13','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1071','19','21','2025-03-10','1','1','2025-03-10 20:09:13','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1074','21','21','2025-03-10','1','1','2025-03-11 00:20:27','110','110');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1075','35','23','2025-03-10','1','1','2025-03-10 20:02:29','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1082','37','23','2025-03-10','2','1','2025-03-11 08:02:15','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1083','36','23','2025-03-10','2','1','2025-03-11 08:03:33','41','41');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1084','34','23','2025-03-10','2','1','2025-03-11 08:01:46','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1086','15','21','2025-03-10','2','1','2025-03-11 14:10:31','106','106');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1088','11','21','2025-03-10','1','1','2025-03-10 20:14:35','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1092','19','21','2025-03-11','1','1','2025-03-11 20:15:12','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1094','21','21','2025-03-11','1','1','2025-03-11 20:28:59','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1095','35','23','2025-03-11','1','1','2025-03-11 20:01:09','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1099','11','21','2025-03-11','1','1','2025-03-11 20:13:54','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1100','37','23','2025-03-11','2','1','2025-03-12 08:09:11','41','41');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1101','36','23','2025-03-11','2','1','2025-03-12 08:02:44','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1103','34','23','2025-03-11','2','1','2025-03-12 08:04:04','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1107','15','21','2025-03-11','2','1','2025-03-12 08:04:45','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1110','21','21','2025-03-12','1','1','2025-03-12 20:18:51','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1111','35','23','2025-03-12','1','1','2025-03-12 20:02:46','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1115','11','21','2025-03-12','1','1','2025-03-12 20:18:40','58','58');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1116','19','21','2025-03-12','1','1','2025-03-13 00:18:14','99','99');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1118','37','23','2025-03-12','2','1','2025-03-13 08:07:28','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1119','36','23','2025-03-12','2','1','2025-03-13 08:00:53','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1120','34','23','2025-03-12','2','1','2025-03-13 08:18:59','30','30');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1124','15','21','2025-03-12','2','1','2025-03-13 08:00:45','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1125','19','21','2025-03-13','1','1','2025-03-13 20:17:30','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1127','21','21','2025-03-13','1','1','2025-03-13 20:14:07','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1128','35','23','2025-03-13','1','1','2025-03-13 20:03:01','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1132','11','21','2025-03-13','1','1','2025-03-14 00:16:16','130','130');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1133','37','23','2025-03-13','2','1','2025-03-14 08:04:51','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1134','36','23','2025-03-13','2','1','2025-03-14 08:11:33','41','41');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1136','15','21','2025-03-13','2','1','2025-03-14 08:05:14','106','106');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1137','34','23','2025-03-13','2','1','2025-03-14 08:01:53','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1141','19','21','2025-03-14','1','1','2025-03-14 20:12:02','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1143','21','21','2025-03-14','1','1','2025-03-15 00:20:56','110','110');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1144','35','23','2025-03-14','1','1','2025-03-14 20:04:18','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1149','11','21','2025-03-14','1','1','2025-03-14 20:09:30','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1150','37','23','2025-03-14','2','1','2025-03-15 08:01:58','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1151','36','23','2025-03-14','2','1','2025-03-15 08:03:45','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1152','34','23','2025-03-14','2','1','2025-03-15 08:06:05','30','30');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1153','15','21','2025-03-14','2','1','2025-03-15 08:04:33','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1160','35','23','2025-03-15','1','1','2025-03-15 20:01:50','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1165','11','21','2025-03-15','1','1','2025-03-15 20:06:53','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1166','19','21','2025-03-15','1','1','2025-03-15 20:09:35','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1167','21','21','2025-03-15','1','1','2025-03-15 20:07:50','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1173','37','23','2025-03-15','2','1','2025-03-16 08:01:56','40','40');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1174','36','23','2025-03-15','2','1','2025-03-16 08:00:58','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1175','34','23','2025-03-15','2','1','2025-03-16 08:31:00','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1177','15','21','2025-03-15','2','1','2025-03-16 08:07:26','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1189','19','21','2025-03-16','1','1','2025-03-16 20:09:21','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1191','21','21','2025-03-16','1','1','2025-03-16 20:12:37','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1192','37','23','2025-03-16','2','1','2025-03-17 08:06:47','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1194','35','23','2025-03-16','1','1','2025-03-16 20:08:16','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1197','11','21','2025-03-16','1','1','2025-03-16 20:06:22','58','58');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1198','15','21','2025-03-16','2','1','2025-03-17 08:00:41','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1199','36','23','2025-03-16','2','1','2025-03-17 08:02:28','98','98');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1205','34','23','2025-03-16','2','1','2025-03-17 08:08:56','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1206','61','23','2025-03-16','2','1','2025-03-17 08:05:46','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1207','19','21','2025-03-17','1','1','2025-03-17 20:14:11','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1209','21','21','2025-03-17','1','1','2025-03-17 20:14:08','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1210','35','23','2025-03-17','1','1','2025-03-17 20:04:34','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1214','11','21','2025-03-17','1','1','2025-03-18 00:15:33','131','131');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1217','34','23','2025-03-17','2','1','2025-03-18 08:11:23','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1221','15','21','2025-03-17','2','1','2025-03-18 08:03:42','106','106');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1222','61','23','2025-03-17','2','1','2025-03-18 19:53:36','99','99');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1231','19','21','2025-03-18','1','1','2025-03-19 00:17:54','99','99');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1233','21','21','2025-03-18','1','1','2025-03-18 20:09:32','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1234','37','23','2025-03-18','2','1','2025-03-19 08:01:42','99','99');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1236','35','23','2025-03-18','1','1','2025-03-18 20:03:03','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1241','11','21','2025-03-18','1','1','2025-03-18 20:07:05','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1242','36','23','2025-03-18','2','1','2025-03-19 08:02:04','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1243','34','23','2025-03-18','2','1','2025-03-19 08:03:31','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1247','15','21','2025-03-18','2','1','2025-03-19 08:06:00','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1248','61','23','2025-03-18','2','1','2025-03-19 08:07:43','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1252','35','23','2025-03-19','1','1','2025-03-19 20:05:15','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1257','11','21','2025-03-19','1','1','2025-03-19 20:10:25','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1258','19','21','2025-03-19','1','1','2025-03-19 20:08:18','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1259','21','21','2025-03-19','1','1','2025-03-20 00:31:40','110','110');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1260','37','23','2025-03-19','2','1','2025-03-20 08:01:20','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1261','36','23','2025-03-19','2','1','2025-03-20 08:01:14','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1262','34','23','2025-03-19','2','1','2025-03-20 08:01:39','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1266','15','21','2025-03-19','2','1','2025-03-20 08:05:12','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1268','61','23','2025-03-19','2','1','2025-03-20 08:01:15','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1269','19','21','2025-03-20','1','1','2025-03-20 20:12:13','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1272','35','23','2025-03-20','1','1','2025-03-20 20:02:10','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1277','11','21','2025-03-20','1','1','2025-03-20 20:11:35','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1279','21','21','2025-03-20','1','1','2025-03-20 20:12:10','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1280','37','23','2025-03-20','2','1','2025-03-21 08:02:10','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1281','36','23','2025-03-20','2','1','2025-03-21 08:03:51','99','99');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1282','34','23','2025-03-20','2','1','2025-03-21 08:07:24','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1285','15','21','2025-03-20','2','1','2025-03-21 08:06:19','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1286','61','23','2025-03-20','2','1','2025-03-21 08:00:50','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1288','19','21','2025-03-21','1','1','2025-03-21 20:11:41','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1290','21','21','2025-03-21','1','1','2025-03-21 20:13:59','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1291','35','23','2025-03-21','1','1','2025-03-21 20:02:21','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1298','34','23','2025-03-21','2','1','2025-03-22 08:01:18','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1299','15','21','2025-03-21','2','1','2025-03-22 08:09:16','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1300','61','23','2025-03-21','2','1','2025-03-22 08:00:41','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1302','37','23','2025-03-21','2','1','2025-03-22 08:11:44','99','99');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1303','36','23','2025-03-21','2','1','2025-03-22 08:01:35','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1306','11','21','2025-03-21','1','1','2025-03-22 00:15:36','99','99');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1310','21','21','2025-03-22','1','1','2025-03-22 20:09:17','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1311','35','23','2025-03-22','1','1','2025-03-22 20:01:54','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1317','11','21','2025-03-22','1','1','2025-03-22 20:06:04','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1318','19','21','2025-03-22','1','1','2025-03-23 00:17:22','99','99');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1323','37','23','2025-03-22','2','1','2025-03-23 08:09:13','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1324','36','23','2025-03-22','2','1','2025-03-23 08:05:47','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1325','34','23','2025-03-22','2','1','2025-03-23 08:07:08','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1328','15','21','2025-03-22','2','1','2025-03-23 08:09:07','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1329','61','23','2025-03-22','2','1','2025-03-23 08:09:27','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1334','35','23','2025-03-23','1','1','2025-03-23 20:00:56','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1339','11','21','2025-03-23','1','1','2025-03-23 20:07:26','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1340','19','21','2025-03-23','1','1','2025-03-23 20:10:22','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1341','21','21','2025-03-23','1','1','2025-03-24 00:15:54','110','110');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1343','37','23','2025-03-23','2','1','2025-03-24 08:02:17','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1344','36','23','2025-03-23','2','1','2025-03-24 08:04:01','99','99');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1345','34','23','2025-03-23','2','1','2025-03-24 08:04:03','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1349','15','21','2025-03-23','2','1','2025-03-24 08:09:34','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1350','61','23','2025-03-23','2','1','2025-03-24 08:03:05','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1351','19','21','2025-03-24','1','1','2025-03-24 20:08:54','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1359','11','21','2025-03-24','1','1','2025-03-24 20:09:19','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1361','21','21','2025-03-24','1','1','2025-03-24 20:09:24','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1363','37','23','2025-03-24','2','1','2025-03-25 08:15:02','41','41');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1364','36','23','2025-03-24','2','1','2025-03-25 08:35:30','99','99');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1365','34','23','2025-03-24','2','1','2025-03-25 08:35:04','29','29');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1369','15','21','2025-03-24','2','1','2025-03-25 08:02:06','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1370','61','23','2025-03-24','2','1','2025-03-25 20:02:31','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1371','19','21','2025-03-25','1','1','2025-03-25 20:11:16','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1373','21','21','2025-03-25','1','1','2025-03-25 20:11:31','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1385','37','23','2025-03-25','2','1','2025-03-26 08:08:00','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1386','11','21','2025-03-25','1','1','2025-03-26 00:17:36','133','133');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1387','15','21','2025-03-25','2','1','2025-03-26 08:03:45','105','105');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1388','36','23','2025-03-25','2','1','2025-03-26 19:41:55','99','99');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1389','34','23','2025-03-25','2','1','2025-03-26 08:09:22','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1390','35','23','2025-03-25','1','1','2025-03-25 20:02:51','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1391','61','23','2025-03-25','2','1','2025-03-26 08:06:32','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1394','21','21','2025-03-26','1','1','2025-03-26 20:11:34','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1395','35','23','2025-03-26','1','1','2025-03-26 20:02:04','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1401','19','21','2025-03-26','1','1','2025-03-27 00:20:27','99','99');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1402','37','23','2025-03-26','2','1','2025-03-27 08:02:44','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1406','11','21','2025-03-26','1','1','2025-03-26 20:12:00','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1408','15','21','2025-03-26','2','1','2025-03-27 08:00:54','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1409','61','23','2025-03-26','2','1','2025-03-27 08:07:28','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1410','34','23','2025-03-26','2','1','2025-03-27 09:00:39','88','88');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1411','36','23','2025-03-26','2','1','2025-03-27 08:02:40','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1414','35','23','2025-03-27','1','1','2025-03-27 20:03:11','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1418','11','21','2025-03-27','1','1','2025-03-27 20:15:05','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1419','37','23','2025-03-27','2','1','2025-03-28 08:03:21','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1424','15','21','2025-03-27','2','1','2025-03-28 08:08:21','106','106');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1429','19','21','2025-03-27','1','1','2025-03-27 20:13:03','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1430','21','21','2025-03-27','1','1','2025-03-28 00:32:34','110','110');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1431','34','23','2025-03-27','2','1','2025-03-28 08:04:42','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1432','36','23','2025-03-27','2','1','2025-03-28 08:01:28','41','41');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1433','61','23','2025-03-27','2','1','2025-03-28 08:04:03','40','40');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1434','19','21','2025-03-28','1','1','2025-03-28 20:10:03','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1436','35','23','2025-03-28','1','1','2025-03-28 20:02:30','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1441','21','21','2025-03-28','1','1','2025-03-28 21:05:57','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1442','37','23','2025-03-28','2','1','2025-03-29 08:00:59','41','41');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1443','36','23','2025-03-28','2','1','2025-03-29 08:02:59','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1444','11','21','2025-03-28','1','1','2025-03-29 00:18:10','129','129');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1445','34','23','2025-03-28','2','1','2025-03-29 08:03:02','29','29');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1448','61','23','2025-03-28','2','1','2025-03-29 08:04:29','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1449','15','21','2025-03-28','2','1','2025-03-29 08:00:56','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1453','21','21','2025-03-29','1','1','2025-03-29 20:16:34','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1454','35','23','2025-03-29','1','1','2025-03-29 20:02:01','15','15');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1461','34','23','2025-03-29','2','1','2025-03-30 18:43:03','15','29');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1467','19','21','2025-03-29','1','1','2025-03-30 00:18:05','99','99');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1468','37','23','2025-03-29','2','1','2025-03-30 08:07:54','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1469','36','23','2025-03-29','2','1','2025-03-30 08:06:01','41','41');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1472','11','21','2025-03-29','1','1','2025-03-29 20:13:36','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1474','61','23','2025-03-29','2','1','2025-03-30 08:05:40','40','40');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1476','15','21','2025-03-29','2','1','2025-03-30 08:02:26','106','106');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1484','19','21','2025-03-30','1','1','2025-03-30 19:38:28','0','0');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1485','21','21','2025-03-30','1','1','2025-03-30 19:38:14','1','1');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1488','11','21','2025-03-30','1','1','2025-03-30 19:35:12','10','10');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1489','35','23','2025-03-30','1','1','2025-03-30 20:01:07','28','28');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1494','61','23','2025-03-30','2','1','2025-03-31 08:11:42','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1495','37','23','2025-03-30','2','1','2025-03-31 08:04:42','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1496','36','23','2025-03-30','2','1','2025-04-04 21:44:11','0','0');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1500','50','21','2025-03-30','1','1','2025-03-30 17:36:04','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1501','15','21','2025-03-30','2','1','2025-03-31 08:01:41','92','92');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1502','34','23','2025-03-30','2','1','2025-04-02 07:35:50','0','0');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1503','62','21','2025-03-30','2','1','2025-03-31 08:07:49','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1504','63','21','2025-03-30','2','1','2025-03-31 09:57:50','41','41');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1520','21','21','2025-03-31','1','1','2025-04-01 02:04:57','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1521','11','21','2025-03-31','1','1','2025-04-01 00:15:51','135','135');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1525','19','21','2025-03-31','1','1','2025-03-31 20:21:25','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1526','63','21','2025-03-31','1','1','2025-03-31 20:18:33','89','89');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1527','15','21','2025-03-31','2','1','2025-04-01 08:08:06','92','92');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1528','62','21','2025-03-31','2','1','2025-04-01 08:10:29','29','29');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1530','19','21','2025-04-01','1','1','2025-04-01 20:09:25','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1531','21','21','2025-04-01','1','1','2025-04-01 20:15:26','35','35');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1532','11','21','2025-04-01','1','1','2025-04-01 20:11:57','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1533','63','21','2025-04-01','1','1','2025-04-01 20:08:03','89','89');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1535','15','21','2025-04-01','2','1','2025-04-02 08:10:43','92','92');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1536','62','21','2025-04-01','2','1','2025-04-02 08:04:19','29','29');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1540','50','21','2025-04-01','1','1','2025-04-02 00:15:32','108','108');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1547','19','21','2025-04-02','1','1','2025-04-03 06:35:28','95','95');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1548','21','21','2025-04-02','1','1','2025-04-03 00:33:08','110','110');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1549','50','21','2025-04-02','1','1','2025-04-02 20:21:40','95','95');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1550','11','21','2025-04-02','1','1','2025-04-03 02:01:49','39','39');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1551','63','21','2025-04-02','1','1','2025-04-02 20:19:18','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1552','15','21','2025-04-02','2','1','2025-04-03 08:10:39','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1553','62','21','2025-04-02','2','1','2025-04-03 08:04:41','28','28');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1562','21','21','2025-04-03','1','1','2025-04-03 20:16:07','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1563','50','21','2025-04-03','1','1','2025-04-03 20:18:47','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1566','19','21','2025-04-03','1','1','2025-04-04 00:35:58','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1567','11','21','2025-04-03','1','1','2025-04-04 07:54:12','39','39');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1569','63','21','2025-04-03','1','1','2025-04-04 02:05:18','39','39');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1570','35','23','2025-04-03','1','1','2025-04-03 20:05:08','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1575','15','21','2025-04-03','2','1','2025-04-04 08:12:18','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1576','62','21','2025-04-03','2','1','2025-04-04 08:06:09','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1589','19','21','2025-04-04','1','1','2025-04-04 20:16:08','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1590','21','21','2025-04-04','1','1','2025-04-05 02:03:38','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1591','35','23','2025-04-04','1','1','2025-04-04 20:02:05','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1593','50','21','2025-04-04','1','1','2025-04-04 21:19:01','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1596','11','21','2025-04-04','1','1','2025-04-05 00:16:48','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1597','63','21','2025-04-04','1','1','2025-04-04 20:11:49','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1598','15','21','2025-04-04','2','1','2025-04-05 08:13:36','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1599','62','21','2025-04-04','2','1','2025-04-05 08:03:00','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1601','37','23','2025-04-04','2','1','2025-04-05 08:11:08','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1602','34','23','2025-04-04','2','1','2025-04-05 08:18:20','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1603','61','23','2025-04-04','2','1','2025-04-05 19:58:40','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1604','36','23','2025-04-04','2','1','2025-04-05 08:15:20','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1607','35','23','2025-04-05','1','1','2025-04-05 20:03:10','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1615','19','21','2025-04-05','1','1','2025-04-05 20:14:48','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1616','21','21','2025-04-05','1','1','2025-04-05 20:20:15','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1618','50','21','2025-04-05','1','1','2025-04-05 20:15:34','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1619','11','21','2025-04-05','1','1','2025-04-06 02:03:30','39','39');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1620','62','21','2025-04-05','2','1','2025-04-06 08:10:35','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1621','63','21','2025-04-05','1','1','2025-04-06 00:16:19','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1622','37','23','2025-04-05','2','1','2025-04-06 08:03:24','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1623','36','23','2025-04-05','2','1','2025-04-06 08:04:17','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1624','34','23','2025-04-05','2','1','2025-04-06 08:05:37','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1625','15','21','2025-04-05','2','1','2025-04-06 08:16:50','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1627','61','23','2025-04-05','2','1','2025-04-06 08:01:23','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1637','19','21','2025-04-06','1','1','2025-04-06 20:12:56','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1638','21','21','2025-04-06','1','1','2025-04-07 00:31:32','111','111');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1639','35','23','2025-04-06','1','1','2025-04-06 20:16:07','54','54');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1641','50','21','2025-04-06','1','1','2025-04-08 20:01:03','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1645','11','21','2025-04-06','1','1','2025-04-07 02:02:37','39','39');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1646','63','21','2025-04-06','1','1','2025-04-06 20:19:40','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1647','37','23','2025-04-06','2','1','2025-04-07 08:18:18','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1648','36','23','2025-04-06','2','1','2025-04-07 08:07:53','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1649','34','23','2025-04-06','2','1','2025-04-07 08:16:30','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1650','15','21','2025-04-06','2','1','2025-04-07 08:09:26','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1651','61','23','2025-04-06','2','1','2025-04-07 08:39:01','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1652','62','21','2025-04-06','2','1','2025-04-07 08:18:49','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1662','19','21','2025-04-07','1','1','2025-04-08 00:35:24','131','131');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1663','21','21','2025-04-07','1','1','2025-04-07 20:22:34','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1664','36','23','2025-04-07','2','1','2025-04-08 08:03:54','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1665','35','23','2025-04-07','1','1','2025-04-07 20:02:04','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1671','11','21','2025-04-07','1','1','2025-04-07 20:29:05','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1672','15','21','2025-04-07','2','1','2025-04-08 08:08:01','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1673','63','21','2025-04-07','1','1','2025-04-08 02:00:44','39','39');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1674','37','23','2025-04-07','2','1','2025-04-08 08:04:58','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1675','34','23','2025-04-07','2','1','2025-04-08 08:06:32','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1676','61','23','2025-04-07','2','1','2025-04-08 08:01:27','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1677','62','21','2025-04-07','2','1','2025-04-08 08:20:23','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1679','19','21','2025-04-08','1','1','2025-04-09 00:19:02','131','131');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1680','21','21','2025-04-08','1','1','2025-04-08 20:04:57','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1681','35','23','2025-04-08','1','1','2025-04-08 20:03:40','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1686','11','21','2025-04-08','1','1','2025-04-08 20:04:56','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1687','63','21','2025-04-08','1','1','2025-04-09 02:03:21','39','39');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1689','37','23','2025-04-08','2','1','2025-04-09 08:02:08','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1690','36','23','2025-04-08','2','1','2025-04-09 08:05:40','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1691','34','23','2025-04-08','2','1','2025-04-09 08:11:04','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1692','15','21','2025-04-08','2','1','2025-04-09 08:07:20','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1693','61','23','2025-04-08','2','1','2025-04-09 08:01:25','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1694','62','21','2025-04-08','2','1','2025-04-09 08:08:33','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1706','19','21','2025-04-09','1','1','2025-04-10 02:05:45','39','39');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1707','21','21','2025-04-09','1','1','2025-04-09 20:11:52','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1708','35','21','2025-04-09','1','1','2025-04-09 20:04:23','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1713','11','21','2025-04-09','1','1','2025-04-09 20:09:42','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1714','63','21','2025-04-09','1','1','2025-04-09 20:05:32','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1715','37','23','2025-04-09','2','1','2025-04-10 08:06:00','44','44');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1717','15','21','2025-04-09','2','1','2025-04-10 08:11:47','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1718','61','23','2025-04-09','2','1','2025-04-10 08:01:55','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1719','62','21','2025-04-09','2','1','2025-04-10 08:11:21','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1721','34','23','2025-04-09','2','1','2025-04-10 08:08:14','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1724','36','23','2025-04-09','2','1','2025-04-10 08:04:06','59','59');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1733','19','21','2025-04-10','1','1','2025-04-10 20:11:54','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1734','21','21','2025-04-10','1','1','2025-04-11 00:57:39','113','113');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1735','36','23','2025-04-10','2','1','2025-04-11 08:08:04','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1736','35','21','2025-04-10','1','1','2025-04-10 20:04:03','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1740','11','21','2025-04-10','1','1','2025-04-11 02:11:50','75','75');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1741','61','23','2025-04-10','2','1','2025-04-11 08:09:54','40','40');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1742','63','21','2025-04-10','1','1','2025-04-10 20:10:42','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1743','37','23','2025-04-10','2','1','2025-04-11 08:11:24','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1744','34','23','2025-04-10','2','1','2025-04-11 08:09:13','129','129');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1745','15','21','2025-04-10','2','1','2025-04-11 08:13:32','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1746','62','21','2025-04-10','2','1','2025-04-11 08:07:18','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1761','19','21','2025-04-11','1','1','2025-04-12 00:34:14','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1762','21','21','2025-04-11','1','1','2025-04-11 20:13:27','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1763','35','21','2025-04-11','1','1','2025-04-11 20:02:45','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1764','11','21','2025-04-11','1','1','2025-04-11 20:14:56','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1765','63','21','2025-04-11','1','1','2025-04-12 02:01:54','39','39');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1766','36','23','2025-04-11','2','1','2025-04-12 08:02:46','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1767','62','21','2025-04-11','2','1','2025-04-12 08:05:37','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1768','34','23','2025-04-11','2','1','2025-04-12 08:00:32','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1769','61','23','2025-04-11','2','1','2025-04-12 08:04:41','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1770','37','23','2025-04-11','2','1','2025-04-12 08:01:22','59','59');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1771','15','21','2025-04-11','2','1','2025-04-12 08:09:58','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1782','19','21','2025-04-12','1','1','2025-04-12 20:13:22','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1783','21','21','2025-04-12','1','1','2025-04-13 02:05:19','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1785','35','21','2025-04-12','1','1','2025-04-12 20:05:59','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1791','11','21','2025-04-12','1','1','2025-04-13 00:19:41','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1792','63','21','2025-04-12','1','1','2025-04-12 20:33:34','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1795','62','21','2025-04-12','2','1','2025-04-13 08:05:34','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1797','37','23','2025-04-12','2','1','2025-04-13 08:08:02','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1798','36','23','2025-04-12','2','1','2025-04-13 08:07:19','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1800','34','23','2025-04-12','2','1','2025-04-13 08:00:38','129','129');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1804','15','21','2025-04-12','2','1','2025-04-13 08:06:29','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1806','61','23','2025-04-12','2','1','2025-04-13 08:17:14','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1807','19','21','2025-04-13','1','1','2025-04-14 02:03:51','39','39');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1808','21','21','2025-04-13','1','1','2025-04-13 20:15:51','36','36');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1809','35','21','2025-04-13','1','1','2025-04-13 20:14:09','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1813','11','21','2025-04-13','1','1','2025-04-13 20:20:57','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1814','63','21','2025-04-13','1','1','2025-04-14 00:17:26','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1816','34','23','2025-04-13','2','1','2025-04-14 08:04:57','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1817','37','23','2025-04-13','2','1','2025-04-14 10:52:14','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1818','36','23','2025-04-13','2','1','2025-04-14 08:04:16','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1819','15','21','2025-04-13','2','1','2025-04-14 08:11:17','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1820','61','23','2025-04-13','2','1','2025-04-14 08:09:57','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1821','62','21','2025-04-13','2','1','2025-04-14 08:12:43','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1823','19','21','2025-04-14','1','1','2025-04-15 02:01:45','39','39');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1824','21','21','2025-04-14','1','1','2025-04-14 20:19:31','36','36');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1825','35','21','2025-04-14','1','1','2025-04-14 20:05:36','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1830','11','21','2025-04-14','1','1','2025-04-14 20:15:12','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1831','63','21','2025-04-14','1','1','2025-04-15 00:33:43','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1832','37','23','2025-04-14','2','1','2025-04-15 08:10:09','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1833','36','23','2025-04-14','2','1','2025-04-15 08:07:06','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1834','34','23','2025-04-14','2','1','2025-04-15 08:26:34','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1835','15','21','2025-04-14','2','1','2025-04-15 08:03:53','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1836','61','23','2025-04-14','2','1','2025-04-15 08:00:45','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1837','62','21','2025-04-14','2','1','2025-04-15 08:12:47','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1847','19','21','2025-04-15','1','1','2025-04-16 00:33:01','131','131');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1848','21','21','2025-04-15','1','1','2025-04-15 20:15:36','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1856','11','21','2025-04-15','1','1','2025-04-15 20:06:15','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1857','15','21','2025-04-15','2','1','2025-04-16 08:09:50','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1859','62','21','2025-04-15','2','1','2025-04-16 08:20:02','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1860','63','21','2025-04-15','1','1','2025-04-16 02:00:37','39','39');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1865','35','23','2025-04-15','1','1','2025-04-15 20:01:38','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1871','37','23','2025-04-15','2','1','2025-04-16 08:13:07','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1872','36','23','2025-04-15','2','1','2025-04-16 08:04:38','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1873','34','23','2025-04-15','2','1','2025-04-16 08:19:05','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1874','61','23','2025-04-15','2','1','2025-04-16 08:06:39','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1875','19','21','2025-04-16','1','1','2025-04-16 20:12:18','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1876','21','21','2025-04-16','1','1','2025-04-16 20:19:28','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1877','35','23','2025-04-16','1','1','2025-04-16 20:03:02','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1880','11','21','2025-04-16','1','1','2025-04-17 00:18:19','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1881','63','21','2025-04-16','1','1','2025-04-16 20:28:34','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1883','37','23','2025-04-16','2','1','2025-04-17 08:16:06','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1884','36','23','2025-04-16','2','1','2025-04-17 08:10:11','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1885','34','23','2025-04-16','2','1','2025-04-17 08:06:21','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1886','15','21','2025-04-16','2','1','2025-04-17 08:14:12','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1887','61','23','2025-04-16','2','1','2025-04-17 08:04:34','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1888','62','21','2025-04-16','2','1','2025-04-17 08:27:20','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1892','19','21','2025-04-17','1','1','2025-04-18 02:01:53','39','39');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1893','21','21','2025-04-17','1','1','2025-04-17 20:12:24','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1894','35','21','2025-04-17','1','1','2025-04-17 20:02:15','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1899','11','21','2025-04-17','1','1','2025-04-17 20:15:16','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1900','63','21','2025-04-17','1','1','2025-04-18 00:16:56','131','131');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1902','37','23','2025-04-17','2','1','2025-04-18 08:00:50','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1903','36','23','2025-04-17','2','1','2025-04-18 08:01:19','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1904','34','23','2025-04-17','2','1','2025-04-18 08:00:54','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1905','15','21','2025-04-17','2','1','2025-04-18 08:06:19','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1906','61','23','2025-04-17','2','1','2025-04-19 20:07:14','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1907','62','21','2025-04-17','2','1','2025-04-18 08:05:02','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1909','19','21','2025-04-18','1','1','2025-04-18 20:09:38','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1910','21','21','2025-04-18','1','1','2025-04-19 00:32:19','113','113');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1911','35','21','2025-04-18','1','1','2025-04-18 20:03:47','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1915','11','21','2025-04-18','1','1','2025-04-19 02:05:59','69','69');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1916','63','21','2025-04-18','1','1','2025-04-18 20:10:51','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1919','37','23','2025-04-18','2','1','2025-04-19 08:10:02','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1920','36','23','2025-04-18','2','1','2025-04-19 08:03:19','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1921','34','23','2025-04-18','2','1','2025-04-19 08:12:44','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1922','15','21','2025-04-18','2','1','2025-04-19 08:14:38','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1923','62','21','2025-04-18','2','1','2025-04-19 08:13:02','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1935','19','21','2025-04-19','1','1','2025-04-20 00:32:08','131','131');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1936','21','21','2025-04-19','1','1','2025-04-19 20:19:36','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1937','35','21','2025-04-19','1','1','2025-04-19 20:05:08','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1942','11','21','2025-04-19','1','1','2025-04-19 20:19:50','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1943','63','21','2025-04-19','1','1','2025-04-20 02:00:36','39','39');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1945','37','23','2025-04-19','2','1','2025-04-20 08:03:07','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1946','36','23','2025-04-19','2','1','2025-04-20 08:10:10','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1947','34','23','2025-04-19','2','1','2025-04-20 08:05:44','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1948','15','21','2025-04-19','2','1','2025-04-20 08:10:53','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1949','62','21','2025-04-19','2','1','2025-04-20 08:04:56','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1951','61','23','2025-04-19','2','1','2025-04-21 08:15:41','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1952','19','21','2025-04-20','1','1','2025-04-20 20:10:52','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1954','35','21','2025-04-20','1','1','2025-04-20 20:04:27','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1960','63','21','2025-04-20','1','1','2025-04-20 20:06:20','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1962','21','21','2025-04-20','1','1','2025-04-21 02:07:25','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1963','11','21','2025-04-20','1','1','2025-04-21 00:18:28','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1964','37','23','2025-04-20','2','1','2025-04-21 08:09:10','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1965','36','23','2025-04-20','2','1','2025-04-21 08:05:15','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1966','34','23','2025-04-20','2','1','2025-04-21 19:56:01','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1967','15','21','2025-04-20','2','1','2025-04-21 08:08:28','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1968','62','21','2025-04-20','2','1','2025-04-21 08:17:02','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1979','19','21','2025-04-21','1','1','2025-04-22 02:11:17','75','75');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1980','21','21','2025-04-21','1','1','2025-04-21 21:34:15','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1981','37','23','2025-04-21','2','1','2025-04-22 08:13:30','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1982','36','23','2025-04-21','2','1','2025-04-22 08:12:37','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1983','35','21','2025-04-21','1','1','2025-04-21 20:02:13','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1988','11','21','2025-04-21','1','1','2025-04-21 20:16:04','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1989','15','21','2025-04-21','2','1','2025-04-22 08:12:26','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1990','63','21','2025-04-21','1','1','2025-04-22 00:27:42','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1993','61','23','2025-04-21','2','1','2025-04-22 20:04:40','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1994','62','21','2025-04-21','2','1','2025-04-22 08:08:20','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('1995','34','23','2025-04-21','2','1','2025-04-22 08:10:35','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2004','19','21','2025-04-22','1','1','2025-04-22 20:13:46','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2005','21','21','2025-04-22','1','1','2025-04-23 00:36:43','113','113');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2006','35','21','2025-04-22','1','1','2025-04-22 20:07:25','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2011','11','21','2025-04-22','1','1','2025-04-23 02:06:59','39','39');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2012','63','21','2025-04-22','1','1','2025-04-22 20:18:31','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2014','37','23','2025-04-22','2','1','2025-04-23 08:08:00','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2015','36','23','2025-04-22','2','1','2025-04-23 08:10:00','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2016','34','23','2025-04-22','2','1','2025-04-23 08:08:48','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2017','15','21','2025-04-22','2','1','2025-04-23 08:04:28','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2018','62','21','2025-04-22','2','1','2025-04-23 08:18:45','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2020','61','23','2025-04-22','2','1','2025-04-23 08:18:42','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2021','19','21','2025-04-23','1','1','2025-04-24 00:33:39','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2022','21','21','2025-04-23','1','1','2025-04-23 20:14:54','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2023','35','21','2025-04-23','1','1','2025-04-23 20:02:14','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2027','11','21','2025-04-23','1','1','2025-04-23 20:11:51','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2028','63','21','2025-04-23','1','1','2025-04-24 02:28:57','75','75');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2029','37','23','2025-04-23','2','1','2025-04-24 08:01:05','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2030','36','23','2025-04-23','2','1','2025-04-24 08:01:22','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2031','34','23','2025-04-23','2','1','2025-04-24 08:09:56','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2033','15','21','2025-04-23','2','1','2025-04-24 08:05:09','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2034','61','23','2025-04-23','2','1','2025-04-24 08:12:20','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2035','62','21','2025-04-23','2','1','2025-04-24 08:09:03','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2044','19','21','2025-04-24','1','1','2025-04-24 20:11:14','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2045','21','21','2025-04-24','1','1','2025-04-25 02:10:11','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2046','35','21','2025-04-24','1','1','2025-04-24 20:03:15','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2049','11','21','2025-04-24','1','1','2025-04-25 00:17:48','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2050','63','21','2025-04-24','1','1','2025-04-24 20:10:39','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2051','37','23','2025-04-24','2','1','2025-04-25 08:09:01','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2052','36','23','2025-04-24','2','1','2025-04-25 08:23:23','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2056','34','23','2025-04-24','2','1','2025-04-25 08:30:27','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2057','15','21','2025-04-24','2','1','2025-04-25 08:06:26','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2059','62','21','2025-04-24','2','1','2025-04-25 08:05:29','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2067','19','21','2025-04-25','1','1','2025-04-26 02:04:30','75','75');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2068','21','21','2025-04-25','1','1','2025-04-25 20:13:00','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2069','35','21','2025-04-25','1','1','2025-04-25 20:04:08','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2073','11','21','2025-04-25','1','1','2025-04-25 20:11:51','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2074','63','21','2025-04-25','1','1','2025-04-26 00:21:03','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2078','15','21','2025-04-25','2','1','2025-04-26 08:09:22','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2079','62','21','2025-04-25','2','1','2025-04-26 08:10:09','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2080','37','23','2025-04-25','2','1','2025-04-26 08:00:52','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2081','36','23','2025-04-25','2','1','2025-04-26 08:01:16','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2084','34','23','2025-04-25','2','1','2025-04-26 08:14:27','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2092','19','21','2025-04-26','1','1','2025-04-26 20:14:48','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2093','21','21','2025-04-26','1','1','2025-04-27 00:34:05','112','112');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2094','35','21','2025-04-26','1','1','2025-04-26 20:03:05','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2095','11','21','2025-04-26','1','1','2025-04-27 02:04:42','39','39');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2096','63','21','2025-04-26','1','1','2025-04-26 20:01:40','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2097','37','23','2025-04-26','2','1','2025-04-27 08:03:29','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2098','36','23','2025-04-26','2','1','2025-04-27 08:06:59','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2099','34','23','2025-04-26','2','1','2025-04-27 11:24:40','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2100','15','21','2025-04-26','2','1','2025-04-27 08:11:49','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2101','62','21','2025-04-26','2','1','2025-04-27 08:07:55','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2112','19','21','2025-04-27','1','1','2025-04-28 00:32:07','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2113','21','21','2025-04-27','1','1','2025-04-27 20:14:57','36','36');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2117','11','21','2025-04-27','1','1','2025-04-27 20:11:38','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2118','63','21','2025-04-27','1','1','2025-04-28 02:29:57','75','75');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2123','37','23','2025-04-27','2','1','2025-04-28 08:06:38','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2124','36','23','2025-04-27','2','1','2025-04-28 08:12:20','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2128','15','21','2025-04-27','2','1','2025-04-28 08:03:11','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2129','62','21','2025-04-27','2','1','2025-04-28 08:15:19','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2140','34','23','2025-04-27','2','1','2025-04-28 08:20:50','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2147','19','21','2025-04-28','1','1','2025-04-28 20:12:48','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2148','21','21','2025-04-28','1','1','2025-04-29 21:25:57','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2149','37','23','2025-04-28','2','1','2025-04-29 21:25:43','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2150','35','23','2025-04-28','1','1','2025-04-28 20:01:18','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2155','11','21','2025-04-28','1','1','2025-04-29 00:18:21','131','131');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2156','15','21','2025-04-28','2','1','2025-04-29 21:25:47','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2157','63','21','2025-04-28','1','1','2025-04-28 20:20:12','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2159','36','23','2025-04-28','2','1','2025-04-29 22:01:12','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2161','34','23','2025-04-28','2','1','2025-04-29 22:01:06','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2162','62','21','2025-04-28','2','1','2025-04-29 21:26:12','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2178','19','21','2025-04-29','1','1','2025-04-29 22:00:16','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2179','21','21','2025-04-29','1','1','2025-04-29 22:00:53','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2180','37','23','2025-04-29','2','1','2025-04-29 22:00:11','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2181','35','23','2025-04-29','1','1','2025-04-29 22:00:04','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2186','11','21','2025-04-29','1','1','2025-04-29 22:00:07','131','131');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2187','15','21','2025-04-29','2','1','2025-04-30 08:08:45','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2188','62','21','2025-04-29','2','1','2025-04-30 08:06:34','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2189','63','21','2025-04-29','1','1','2025-04-29 22:01:26','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2207','19','21','2025-04-30','1','1','2025-04-30 20:13:41','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2208','21','21','2025-04-30','1','1','2025-05-01 08:15:49','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2209','37','21','2025-04-30','2','1','2025-05-01 08:13:32','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2210','36','23','2025-04-30','1','1','2025-04-30 20:03:00','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2211','35','23','2025-04-30','1','1','2025-04-30 20:03:34','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2213','34','23','2025-04-30','2','1','2025-05-01 08:02:56','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2217','11','21','2025-04-30','1','1','2025-05-01 08:23:41','39','39');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2218','15','21','2025-04-30','2','1','2025-05-01 08:08:59','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2219','61','23','2025-04-30','2','1','2025-05-01 08:00:05','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2220','62','21','2025-04-30','2','1','2025-05-01 08:02:39','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2221','63','21','2025-04-30','1','1','2025-04-30 20:36:19','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2249','21','21','2025-05-01','1','1','2025-05-01 20:19:24','9','9');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2250','37','21','2025-05-01','2','1','2025-05-02 08:04:13','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2251','36','23','2025-05-01','1','1','2025-05-01 20:03:45','9','9');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2252','35','23','2025-05-01','1','1','2025-05-01 20:00:56','21','21');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2254','34','23','2025-05-01','2','1','2025-05-02 08:15:33','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2257','11','21','2025-05-01','1','1','2025-05-01 20:15:53','12','12');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2258','15','21','2025-05-01','2','1','2025-05-02 08:04:44','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2259','61','23','2025-05-01','2','1','2025-05-02 08:02:20','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2260','62','21','2025-05-01','2','1','2025-05-02 08:12:17','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2266','19','21','2025-05-01','1','1','2025-05-02 00:34:56','84','84');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2267','63','21','2025-05-01','1','1','2025-05-02 02:07:38','22','22');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2268','19','21','2025-05-02','1','1','2025-05-02 20:13:40','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2269','21','21','2025-05-02','1','1','2025-05-03 02:28:30','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2271','35','23','2025-05-02','1','1','2025-05-02 20:04:53','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2273','11','21','2025-05-02','1','1','2025-05-03 00:19:38','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2274','63','21','2025-05-02','1','1','2025-05-02 20:01:48','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2277','36','21','2025-05-02','1','1','2025-05-02 20:07:09','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2278','50','23','2025-05-02','1','1','2025-05-03 08:11:16','30','30');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2281','37','21','2025-05-02','2','1','2025-05-03 08:08:18','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2282','34','23','2025-05-02','2','1','2025-05-03 08:06:20','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2284','15','21','2025-05-02','2','1','2025-05-03 08:01:20','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2285','61','23','2025-05-02','2','1','2025-05-03 08:00:41','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2286','62','21','2025-05-02','2','1','2025-05-03 08:08:07','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2297','21','21','2025-05-03','1','1','2025-05-04 00:06:44','50','50');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2299','36','23','2025-05-03','1','1','2025-05-04 08:10:49','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2300','35','23','2025-05-03','1','1','2025-05-03 20:02:51','55','55');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2302','34','23','2025-05-03','2','1','2025-05-04 08:06:18','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2305','11','21','2025-05-03','1','1','2025-05-03 20:16:08','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2306','15','21','2025-05-03','2','1','2025-05-04 08:07:59','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2307','61','23','2025-05-03','2','1','2025-05-04 08:00:43','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2308','62','21','2025-05-03','2','1','2025-05-04 08:05:05','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2313','19','21','2025-05-03','1','1','2025-05-03 20:14:41','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2314','63','21','2025-05-03','1','1','2025-05-04 00:23:20','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2315','37','21','2025-05-03','2','1','2025-05-04 08:04:58','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2317','19','21','2025-05-04','1','1','2025-05-05 00:31:46','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2318','21','21','2025-05-04','1','1','2025-05-04 20:12:23','36','36');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2319','35','23','2025-05-04','1','1','2025-05-04 20:01:10','54','54');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2320','11','21','2025-05-04','1','1','2025-05-04 20:18:47','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2321','63','21','2025-05-04','1','1','2025-05-04 20:16:46','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2325','37','21','2025-05-04','2','1','2025-05-05 08:02:43','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2326','36','23','2025-05-04','1','1','2025-05-04 20:06:23','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2328','34','23','2025-05-04','2','1','2025-05-05 08:05:14','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2331','15','21','2025-05-04','2','1','2025-05-05 08:11:29','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2332','61','23','2025-05-04','2','1','2025-05-05 08:00:36','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2333','62','21','2025-05-04','2','1','2025-05-05 08:07:21','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2344','35','23','2025-05-05','1','1','2025-05-05 20:08:49','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2348','19','21','2025-05-05','1','1','2025-05-05 20:10:03','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2349','21','21','2025-05-05','1','1','2025-05-06 00:32:04','113','113');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2351','11','21','2025-05-05','1','1','2025-05-05 20:13:09','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2352','63','21','2025-05-05','1','1','2025-05-05 20:12:15','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2354','37','21','2025-05-05','2','1','2025-05-06 08:05:17','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2360','34','23','2025-05-05','2','1','2025-05-06 08:05:37','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2363','15','21','2025-05-05','2','1','2025-05-06 08:07:51','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2364','61','23','2025-05-05','2','1','2025-05-06 08:01:31','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2365','62','21','2025-05-05','2','1','2025-05-06 08:07:40','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2372','19','21','2025-05-06','1','1','2025-05-06 20:16:07','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2373','21','21','2025-05-06','1','1','2025-05-06 20:16:57','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2374','36','23','2025-05-06','1','1','2025-05-07 07:23:35','19','19');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2375','35','23','2025-05-06','1','1','2025-05-06 20:08:08','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2376','11','21','2025-05-06','1','1','2025-05-07 00:18:13','104','104');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2377','63','21','2025-05-06','1','1','2025-05-06 20:09:42','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2379','37','21','2025-05-06','2','1','2025-05-07 08:03:26','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2381','34','23','2025-05-06','2','1','2025-05-07 08:06:29','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2384','15','21','2025-05-06','2','1','2025-05-07 08:07:08','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2385','61','23','2025-05-06','2','1','2025-05-07 08:06:00','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2386','62','21','2025-05-06','2','1','2025-05-07 08:15:24','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2393','19','21','2025-05-07','1','1','2025-05-07 20:10:07','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2394','21','21','2025-05-07','1','1','2025-05-07 20:18:20','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2395','36','23','2025-05-07','1','1','2025-05-07 20:00:46','19','19');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2396','35','23','2025-05-07','1','1','2025-05-07 20:02:07','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2397','11','21','2025-05-07','1','1','2025-05-07 20:17:15','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2398','63','21','2025-05-07','1','1','2025-05-08 00:16:15','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2399','37','21','2025-05-07','2','1','2025-05-08 08:03:17','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2400','34','23','2025-05-07','2','1','2025-05-08 08:02:38','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2401','15','21','2025-05-07','2','1','2025-05-08 08:08:37','105','105');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2402','61','23','2025-05-07','2','1','2025-05-08 08:14:01','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2406','62','21','2025-05-07','2','1','2025-05-08 08:17:34','45','45');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2413','19','21','2025-05-08','1','1','2025-05-09 00:30:43','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2414','21','21','2025-05-08','1','1','2025-05-08 20:20:35','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2415','36','23','2025-05-08','1','1','2025-05-08 20:00:50','19','19');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2416','35','23','2025-05-08','1','1','2025-05-08 20:02:41','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2417','11','21','2025-05-08','1','1','2025-05-08 20:17:37','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2418','63','21','2025-05-08','1','1','2025-05-08 20:14:54','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2421','37','21','2025-05-08','2','1','2025-05-09 08:16:06','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2423','34','23','2025-05-08','2','1','2025-05-09 08:12:36','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2426','15','21','2025-05-08','2','1','2025-05-09 08:10:20','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2427','61','23','2025-05-08','2','1','2025-05-09 08:02:26','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2428','62','21','2025-05-08','2','1','2025-05-09 08:09:55','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2429','19','21','2025-05-09','1','1','2025-05-09 20:12:22','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2430','21','21','2025-05-09','1','1','2025-05-10 00:34:53','113','113');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2431','36','23','2025-05-09','1','1','2025-05-09 20:02:29','19','19');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2432','35','23','2025-05-09','1','1','2025-05-09 20:02:21','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2434','11','21','2025-05-09','1','1','2025-05-09 20:20:08','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2435','63','21','2025-05-09','1','1','2025-05-09 20:12:49','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2437','37','21','2025-05-09','2','1','2025-05-10 08:01:00','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2439','34','23','2025-05-09','2','1','2025-05-10 08:04:46','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2441','15','21','2025-05-09','2','1','2025-05-10 08:04:01','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2442','61','23','2025-05-09','2','1','2025-05-10 08:00:47','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2443','62','21','2025-05-09','2','1','2025-05-10 08:01:58','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2446','36','23','2025-05-10','1','1','2025-05-10 20:02:33','19','19');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2447','35','23','2025-05-10','1','1','2025-05-10 20:02:04','55','55');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2452','19','21','2025-05-10','1','1','2025-05-10 20:10:26','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2453','21','21','2025-05-10','1','1','2025-05-10 20:11:21','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2454','37','21','2025-05-10','2','1','2025-05-11 08:08:18','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2455','11','21','2025-05-10','1','1','2025-05-11 00:18:37','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2456','61','23','2025-05-10','2','1','2025-05-11 08:01:21','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2457','63','21','2025-05-10','1','1','2025-05-10 20:07:25','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2459','34','23','2025-05-10','2','1','2025-05-11 08:19:03','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2461','15','21','2025-05-10','2','1','2025-05-11 08:05:43','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2462','62','21','2025-05-10','2','1','2025-05-11 08:07:39','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2474','19','21','2025-05-11','1','1','2025-05-12 00:31:50','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2475','21','21','2025-05-11','1','1','2025-05-11 20:12:38','36','36');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2476','36','23','2025-05-11','1','1','2025-05-11 20:02:58','19','19');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2477','35','23','2025-05-11','1','1','2025-05-11 20:16:46','54','54');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2479','11','21','2025-05-11','1','1','2025-05-11 20:13:08','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2480','63','21','2025-05-11','1','1','2025-05-11 20:07:32','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2483','37','21','2025-05-11','2','1','2025-05-12 08:11:03','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2485','34','23','2025-05-11','2','1','2025-05-12 08:08:22','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2487','15','21','2025-05-11','2','1','2025-05-12 08:01:09','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2488','61','23','2025-05-11','2','1','2025-05-12 08:02:00','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2489','62','21','2025-05-11','2','1','2025-05-12 08:02:17','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2490','19','21','2025-05-12','1','1','2025-05-12 20:11:23','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2491','21','21','2025-05-12','1','1','2025-05-12 20:10:37','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2492','36','23','2025-05-12','1','1','2025-05-12 20:00:59','19','19');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2493','35','23','2025-05-12','1','1','2025-05-12 20:06:35','54','54');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2495','11','21','2025-05-12','1','1','2025-05-12 20:09:33','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2496','63','21','2025-05-12','1','1','2025-05-13 00:38:43','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2500','15','21','2025-05-12','2','1','2025-05-13 08:02:43','105','105');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2501','61','23','2025-05-12','2','1','2025-05-13 08:01:41','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2502','62','21','2025-05-12','2','1','2025-05-13 08:03:58','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2503','37','21','2025-05-12','2','1','2025-05-13 08:00:54','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2505','34','23','2025-05-12','2','1','2025-05-13 08:03:23','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2507','19','21','2025-05-13','1','1','2025-05-13 20:17:18','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2508','21','21','2025-05-13','1','1','2025-05-14 00:32:33','113','113');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2509','36','23','2025-05-13','1','1','2025-05-13 20:00:29','19','19');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2510','35','23','2025-05-13','1','1','2025-05-13 20:02:53','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2512','11','21','2025-05-13','1','1','2025-05-13 20:20:02','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2513','63','21','2025-05-13','1','1','2025-05-13 20:19:43','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2518','37','21','2025-05-13','2','1','2025-05-14 08:07:47','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2520','34','23','2025-05-13','2','1','2025-05-14 08:13:00','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2522','15','21','2025-05-13','2','1','2025-05-14 08:17:16','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2523','61','23','2025-05-13','2','1','2025-05-14 08:01:51','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2524','62','21','2025-05-13','2','1','2025-05-14 08:10:54','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2525','19','21','2025-05-14','1','1','2025-05-14 20:13:30','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2526','21','21','2025-05-14','1','1','2025-05-15 06:18:57','0','0');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2527','36','23','2025-05-14','1','1','2025-05-14 20:01:36','19','19');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2528','35','23','2025-05-14','1','1','2025-05-14 20:01:28','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2530','11','21','2025-05-14','1','1','2025-05-14 20:22:17','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2531','63','21','2025-05-14','1','1','2025-05-14 20:22:44','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2534','37','21','2025-05-14','2','1','2025-05-15 08:14:15','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2536','34','23','2025-05-14','2','1','2025-05-15 08:10:21','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2538','15','21','2025-05-14','2','1','2025-05-15 07:56:20','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2539','61','23','2025-05-14','2','1','2025-05-15 08:00:40','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2540','62','21','2025-05-14','2','1','2025-05-15 08:06:49','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2550','19','21','2025-05-15','1','1','2025-05-16 00:31:47','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2551','21','21','2025-05-15','1','1','2025-05-15 20:19:05','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2553','35','23','2025-05-15','1','1','2025-05-15 20:03:28','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2555','11','21','2025-05-15','1','1','2025-05-15 20:18:49','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2556','63','21','2025-05-15','1','1','2025-05-15 20:19:07','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2559','15','21','2025-05-15','2','1','2025-05-15 07:58:43','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2560','61','23','2025-05-15','2','1','2025-05-16 08:00:55','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2562','36','23','2025-05-15','1','1','2025-05-15 20:04:53','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2564','62','21','2025-05-15','2','1','2025-05-16 08:08:54','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2566','37','21','2025-05-15','2','1','2025-05-16 08:01:38','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2567','34','23','2025-05-15','2','1','2025-05-16 08:04:11','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2580','19','21','2025-05-16','1','1','2025-05-16 20:19:16','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2581','21','21','2025-05-16','1','1','2025-05-16 20:23:55','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2582','37','21','2025-05-16','2','1','2025-05-17 08:04:50','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2583','36','23','2025-05-16','1','1','2025-05-16 20:06:03','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2584','35','23','2025-05-16','1','1','2025-05-16 20:04:50','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2586','34','23','2025-05-16','2','1','2025-05-17 08:01:13','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2589','11','21','2025-05-16','1','1','2025-05-16 20:27:27','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2590','15','21','2025-05-16','2','1','2025-05-17 08:03:01','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2591','61','23','2025-05-16','2','1','2025-05-17 08:00:25','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2592','62','21','2025-05-16','2','1','2025-05-17 08:02:46','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2593','63','21','2025-05-16','1','1','2025-05-17 00:36:34','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2597','19','21','2025-05-17','1','1','2025-05-17 20:20:13','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2598','21','21','2025-05-17','1','1','2025-05-18 00:31:59','112','112');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2599','36','23','2025-05-17','1','1','2025-05-17 20:05:25','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2600','35','23','2025-05-17','1','1','2025-05-17 20:05:03','55','55');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2602','11','21','2025-05-17','1','1','2025-05-17 20:24:30','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2603','63','21','2025-05-17','1','1','2025-05-17 20:24:25','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2607','37','21','2025-05-17','2','1','2025-05-18 08:04:10','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2609','34','23','2025-05-17','2','1','2025-05-18 08:10:07','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2612','15','21','2025-05-17','2','1','2025-05-18 08:01:34','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2613','61','23','2025-05-17','2','1','2025-05-18 08:00:58','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2614','62','21','2025-05-17','2','1','2025-05-18 08:09:12','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2626','19','21','2025-05-18','1','1','2025-05-18 20:07:20','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2627','21','21','2025-05-18','1','1','2025-05-18 20:16:55','36','36');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2628','37','21','2025-05-18','2','1','2025-05-19 08:01:24','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2629','36','23','2025-05-18','2','1','2025-05-19 08:00:54','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2630','35','23','2025-05-18','1','1','2025-05-18 20:08:19','54','54');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2632','34','23','2025-05-18','2','1','2025-05-19 08:12:47','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2635','11','21','2025-05-18','1','1','2025-05-19 00:17:07','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2636','15','21','2025-05-18','2','1','2025-05-19 08:04:10','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2637','61','23','2025-05-18','2','1','2025-05-19 08:01:10','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2638','62','21','2025-05-18','2','1','2025-05-19 08:04:54','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2639','63','21','2025-05-18','1','1','2025-05-18 20:13:47','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2644','19','21','2025-05-19','1','1','2025-05-20 00:31:09','131','131');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2645','21','21','2025-05-19','1','1','2025-05-19 20:19:09','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2646','35','23','2025-05-19','1','1','2025-05-19 20:02:23','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2649','11','21','2025-05-19','1','1','2025-05-19 20:20:52','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2650','63','21','2025-05-19','1','1','2025-05-19 20:11:58','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2653','37','21','2025-05-19','2','1','2025-05-20 08:00:57','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2654','36','23','2025-05-19','2','1','2025-05-20 08:03:28','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2655','34','23','2025-05-19','2','1','2025-05-20 08:03:46','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2658','15','21','2025-05-19','2','1','2025-05-20 08:00:43','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2659','61','23','2025-05-19','2','1','2025-05-20 08:02:11','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2660','62','21','2025-05-19','2','1','2025-05-20 08:14:26','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2664','35','23','2025-05-20','1','1','2025-05-20 20:03:28','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2671','19','21','2025-05-20','1','1','2025-05-20 20:14:16','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2672','21','21','2025-05-20','1','1','2025-05-20 20:22:43','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2674','36','23','2025-05-20','2','1','2025-05-21 08:04:16','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2675','34','23','2025-05-20','2','1','2025-05-21 08:04:36','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2678','11','21','2025-05-20','1','1','2025-05-20 20:19:41','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2679','15','21','2025-05-20','2','1','2025-05-21 08:02:16','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2680','61','23','2025-05-20','2','1','2025-05-21 08:02:02','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2681','63','21','2025-05-20','1','1','2025-05-20 20:13:16','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2683','62','21','2025-05-20','2','1','2025-05-21 08:03:11','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2693','19','21','2025-05-21','1','1','2025-05-21 20:15:39','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2694','21','21','2025-05-21','1','1','2025-05-21 20:17:28','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2695','37','21','2025-05-21','2','1','2025-05-22 08:13:20','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2696','35','23','2025-05-21','1','1','2025-05-21 20:03:59','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2699','11','21','2025-05-21','1','1','2025-05-21 20:08:37','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2700','63','21','2025-05-21','1','1','2025-05-22 00:16:43','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2703','50','21','2025-05-21','1','1','2025-05-21 20:07:38','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2706','36','23','2025-05-21','2','1','2025-05-22 08:07:15','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2707','34','23','2025-05-21','2','1','2025-05-22 08:06:03','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2710','15','21','2025-05-21','2','1','2025-05-22 08:01:04','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2711','61','23','2025-05-21','2','1','2025-05-22 08:02:43','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2712','62','21','2025-05-21','2','1','2025-05-22 08:02:54','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2724','19','21','2025-05-22','1','1','2025-05-22 20:14:26','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2725','21','21','2025-05-22','1','1','2025-05-23 00:45:48','113','113');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2726','35','23','2025-05-22','1','1','2025-05-22 20:03:08','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2728','34','23','2025-05-22','2','1','2025-05-23 08:08:37','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2730','11','21','2025-05-22','1','1','2025-05-22 20:18:08','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2732','61','23','2025-05-22','2','1','2025-05-23 08:02:33','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2733','62','21','2025-05-22','2','1','2025-05-23 08:06:28','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2734','63','21','2025-05-22','1','1','2025-05-22 23:17:59','39','39');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2738','36','23','2025-05-22','2','1','2025-05-23 08:03:01','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2739','37','21','2025-05-22','2','1','2025-05-23 08:05:21','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2742','15','21','2025-05-22','2','1','2025-05-23 08:02:59','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2745','35','23','2025-05-23','1','1','2025-05-23 20:04:14','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2753','19','21','2025-05-23','1','1','2025-05-24 00:41:44','131','131');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2754','21','21','2025-05-23','1','1','2025-05-23 20:14:26','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2757','34','23','2025-05-23','2','1','2025-05-24 08:12:42','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2760','11','21','2025-05-23','1','1','2025-05-23 20:15:12','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2761','15','21','2025-05-23','2','1','2025-05-24 08:06:39','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2762','61','23','2025-05-23','2','1','2025-05-24 08:03:49','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2763','62','21','2025-05-23','2','1','2025-05-24 08:05:59','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2764','63','21','2025-05-23','1','1','2025-05-23 20:12:55','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2765','37','21','2025-05-23','2','1','2025-05-24 08:16:08','65','65');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2769','35','23','2025-05-24','1','1','2025-05-24 20:04:14','55','55');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2777','19','21','2025-05-24','1','1','2025-05-24 20:16:04','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2778','21','21','2025-05-24','1','1','2025-05-24 20:17:34','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2779','37','21','2025-05-24','2','1','2025-05-25 07:29:52','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2780','34','23','2025-05-24','2','1','2025-05-25 08:10:16','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2783','11','21','2025-05-24','1','1','2025-05-24 20:14:52','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2784','15','21','2025-05-24','2','1','2025-05-25 08:01:05','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2786','62','21','2025-05-24','2','1','2025-05-25 08:04:25','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2787','63','21','2025-05-24','1','1','2025-05-25 00:18:09','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2788','36','21','2025-05-24','1','1','2025-05-24 21:12:28','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2792','61','23','2025-05-24','2','1','2025-05-25 11:56:28','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2794','19','21','2025-05-25','1','1','2025-05-25 20:15:51','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2795','21','21','2025-05-25','1','1','2025-05-25 20:21:04','36','36');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2797','35','23','2025-05-25','1','1','2025-05-25 20:04:18','54','54');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2800','11','21','2025-05-25','1','1','2025-05-25 20:22:16','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2801','63','21','2025-05-25','1','1','2025-05-26 00:44:33','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2805','37','21','2025-05-25','2','1','2025-05-26 08:12:03','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2809','34','23','2025-05-25','2','1','2025-05-26 08:02:09','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2813','15','21','2025-05-25','2','1','2025-05-26 08:02:31','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2815','62','21','2025-05-25','2','1','2025-05-26 08:16:27','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2824','19','21','2025-05-26','1','1','2025-05-27 00:31:09','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2825','21','21','2025-05-26','1','1','2025-05-26 20:18:39','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2826','37','23','2025-05-26','1','1','2025-05-26 20:06:29','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2827','36','23','2025-05-26','1','1','2025-05-26 20:06:40','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2828','35','23','2025-05-26','1','1','2025-05-26 20:04:15','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2829','34','23','2025-05-26','2','1','2025-05-27 08:00:29','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2832','11','21','2025-05-26','1','1','2025-05-26 20:19:16','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2833','15','21','2025-05-26','2','1','2025-05-27 08:03:29','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2834','61','23','2025-05-26','1','1','2025-05-26 20:03:17','30','30');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2835','62','21','2025-05-26','2','1','2025-05-27 08:07:21','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2836','63','21','2025-05-26','1','1','2025-05-26 20:18:13','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2843','21','21','2025-05-27','1','1','2025-05-27 20:12:54','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2844','37','23','2025-05-27','1','1','2025-05-27 20:03:09','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2845','36','23','2025-05-27','1','1','2025-05-27 20:03:10','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2846','35','23','2025-05-27','1','1','2025-05-27 20:01:37','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2849','61','23','2025-05-27','1','1','2025-05-27 20:02:10','30','30');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2853','19','21','2025-05-27','1','1','2025-05-27 20:11:12','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2854','34','23','2025-05-27','2','1','2025-05-28 08:03:38','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2856','11','21','2025-05-27','1','1','2025-05-28 00:19:46','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2857','15','21','2025-05-27','2','1','2025-05-28 08:03:28','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2858','62','21','2025-05-27','2','1','2025-05-28 08:07:38','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2859','63','21','2025-05-27','1','1','2025-05-27 20:13:22','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2877','19','21','2025-05-28','1','1','2025-05-28 20:13:38','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2878','21','21','2025-05-28','1','1','2025-05-28 20:19:55','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2879','37','23','2025-05-28','1','1','2025-05-28 20:01:56','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2880','36','23','2025-05-28','1','1','2025-05-28 20:04:00','30','30');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2881','35','23','2025-05-28','1','1','2025-05-28 20:04:28','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2884','61','23','2025-05-28','1','1','2025-05-28 20:01:43','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2885','63','21','2025-05-28','1','1','2025-05-29 00:20:13','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2888','34','23','2025-05-28','2','1','2025-05-29 08:04:09','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2890','15','21','2025-05-28','2','1','2025-05-29 08:07:23','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2891','62','21','2025-05-28','2','1','2025-05-29 08:08:46','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2896','11','21','2025-05-28','1','1','2025-05-28 20:12:27','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2897','19','21','2025-05-29','1','1','2025-05-29 20:13:04','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2898','21','21','2025-05-29','1','1','2025-05-29 20:13:59','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2899','37','23','2025-05-29','1','1','2025-05-29 20:01:14','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2900','36','23','2025-05-29','1','1','2025-05-29 20:02:15','30','30');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2901','35','23','2025-05-29','1','1','2025-05-29 20:02:25','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2903','11','21','2025-05-29','1','1','2025-05-29 20:13:32','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2904','61','23','2025-05-29','1','1','2025-05-29 20:00:46','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2905','63','21','2025-05-29','1','1','2025-05-30 00:42:06','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2907','34','23','2025-05-29','2','1','2025-05-30 08:03:25','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2908','15','21','2025-05-29','2','1','2025-05-30 08:05:24','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2909','62','21','2025-05-29','2','1','2025-05-30 08:14:05','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2915','21','21','2025-05-30','1','1','2025-05-30 20:19:10','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2916','37','23','2025-05-30','1','1','2025-05-30 20:02:29','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2917','36','23','2025-05-30','1','1','2025-05-30 20:00:53','30','30');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2918','35','23','2025-05-30','1','1','2025-05-30 20:03:15','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2921','61','23','2025-05-30','1','1','2025-05-30 20:02:12','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2924','19','21','2025-05-30','1','1','2025-05-30 20:15:51','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2925','34','23','2025-05-30','2','1','2025-05-31 08:08:10','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2927','11','21','2025-05-30','1','1','2025-05-31 00:17:10','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2928','15','21','2025-05-30','2','1','2025-05-31 08:04:37','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2929','62','21','2025-05-30','2','1','2025-05-31 08:04:03','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2930','63','21','2025-05-30','1','1','2025-05-30 20:08:48','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2936','19','21','2025-05-31','1','1','2025-05-31 20:11:00','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2937','21','21','2025-05-31','1','1','2025-05-31 20:18:34','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2938','37','23','2025-05-31','1','1','2025-05-31 20:01:52','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2939','36','23','2025-05-31','1','1','2025-05-31 20:03:58','30','30');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2940','35','23','2025-05-31','1','1','2025-05-31 20:01:16','55','55');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2942','11','21','2025-05-31','1','1','2025-06-01 00:18:55','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2943','61','23','2025-05-31','1','1','2025-05-31 20:02:27','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2944','63','21','2025-05-31','1','1','2025-05-31 20:10:01','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2947','34','23','2025-05-31','2','1','2025-06-01 08:07:18','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2949','15','21','2025-05-31','2','1','2025-06-01 08:03:23','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2950','62','21','2025-05-31','2','1','2025-06-01 08:08:00','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2956','21','21','2025-06-01','1','1','2025-06-01 20:20:17','36','36');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2957','37','23','2025-06-01','1','1','2025-06-01 20:03:23','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2958','36','23','2025-06-01','1','1','2025-06-01 20:00:59','30','30');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2959','35','23','2025-06-01','1','1','2025-06-01 20:10:21','54','54');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2962','61','23','2025-06-01','1','1','2025-06-03 20:01:42','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2966','19','21','2025-06-01','1','1','2025-06-01 20:16:05','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2967','11','21','2025-06-01','1','1','2025-06-01 20:17:44','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2968','63','21','2025-06-01','1','1','2025-06-02 00:16:28','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2970','34','23','2025-06-01','2','1','2025-06-02 08:05:51','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2972','15','21','2025-06-01','2','1','2025-06-02 08:01:52','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2973','62','21','2025-06-01','2','1','2025-06-02 08:01:48','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2978','19','21','2025-06-02','1','1','2025-06-02 20:13:57','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2979','21','21','2025-06-02','1','1','2025-06-02 20:09:55','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2980','37','23','2025-06-02','1','1','2025-06-02 20:09:44','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2981','36','23','2025-06-02','1','1','2025-06-02 20:01:40','30','30');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2982','35','23','2025-06-02','1','1','2025-06-02 20:01:34','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2984','11','21','2025-06-02','1','1','2025-06-02 20:18:08','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2985','63','21','2025-06-02','1','1','2025-06-03 00:51:43','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2988','34','23','2025-06-02','2','1','2025-06-03 08:01:12','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2989','15','21','2025-06-02','2','1','2025-06-03 08:01:36','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2990','62','21','2025-06-02','2','1','2025-06-03 08:02:12','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2995','19','21','2025-06-03','1','1','2025-06-03 20:14:09','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2996','21','21','2025-06-03','1','1','2025-06-03 20:17:58','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2997','37','23','2025-06-03','1','1','2025-06-03 20:01:42','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2998','36','23','2025-06-03','1','1','2025-06-03 20:01:56','30','30');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('2999','35','23','2025-06-03','1','1','2025-06-03 20:01:36','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3001','11','21','2025-06-03','1','1','2025-06-03 20:19:09','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3002','63','21','2025-06-03','1','1','2025-06-04 00:16:12','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3005','34','23','2025-06-03','2','1','2025-06-04 08:09:33','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3006','15','21','2025-06-03','2','1','2025-06-04 08:01:20','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3007','62','21','2025-06-03','2','1','2025-06-04 08:06:03','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3011','61','23','2025-06-03','1','1','2025-06-04 07:57:34','0','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3014','21','21','2025-06-04','1','1','2025-06-04 20:29:07','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3015','37','23','2025-06-04','1','1','2025-06-04 20:01:35','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3016','36','23','2025-06-04','1','1','2025-06-04 20:01:12','30','30');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3017','35','23','2025-06-04','1','1','2025-06-04 20:02:11','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3024','11','21','2025-06-04','1','1','2025-06-04 20:20:09','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3025','63','21','2025-06-04','1','1','2025-06-04 20:04:09','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3028','19','21','2025-06-04','1','1','2025-06-05 00:23:05','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3029','34','23','2025-06-04','2','1','2025-06-05 08:05:03','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3030','15','21','2025-06-04','2','1','2025-06-05 08:05:02','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3031','62','21','2025-06-04','2','1','2025-06-05 08:03:38','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3036','19','21','2025-06-05','1','1','2025-06-06 00:15:45','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3037','21','21','2025-06-05','1','1','2025-06-05 20:19:38','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3038','37','23','2025-06-05','1','1','2025-06-05 20:05:44','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3039','36','23','2025-06-05','1','1','2025-06-05 20:00:43','30','30');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3040','35','23','2025-06-05','1','1','2025-06-05 20:00:50','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3042','11','21','2025-06-05','1','1','2025-06-05 20:18:33','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3043','63','21','2025-06-05','1','1','2025-06-05 20:02:13','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3046','34','23','2025-06-05','2','1','2025-06-06 08:08:34','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3047','15','21','2025-06-05','2','1','2025-06-06 08:02:39','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3048','62','21','2025-06-05','2','1','2025-06-06 08:12:41','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3052','19','21','2025-06-06','1','1','2025-06-07 00:35:10','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3053','21','21','2025-06-06','1','1','2025-06-06 20:02:31','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3054','37','23','2025-06-06','1','1','2025-06-06 20:04:13','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3055','36','23','2025-06-06','1','1','2025-06-08 20:04:54','30','30');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3056','35','23','2025-06-06','1','1','2025-06-06 20:02:02','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3058','11','21','2025-06-06','1','1','2025-06-06 20:17:37','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3059','63','21','2025-06-06','1','1','2025-06-06 20:05:01','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3062','34','23','2025-06-06','2','1','2025-06-07 08:17:59','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3063','15','21','2025-06-06','2','1','2025-06-07 08:14:31','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3064','62','21','2025-06-06','2','1','2025-06-07 08:15:23','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3068','19','21','2025-06-07','1','1','2025-06-08 00:17:17','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3069','21','21','2025-06-07','1','1','2025-06-07 20:14:39','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3070','37','23','2025-06-07','1','1','2025-06-07 20:06:25','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3071','35','23','2025-06-07','1','1','2025-06-07 20:10:54','55','55');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3073','11','21','2025-06-07','1','1','2025-06-07 20:12:50','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3074','63','21','2025-06-07','1','1','2025-06-07 20:03:55','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3076','34','23','2025-06-07','2','1','2025-06-08 08:05:29','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3077','15','21','2025-06-07','2','1','2025-06-08 08:03:30','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3078','62','21','2025-06-07','2','1','2025-06-08 08:04:21','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3083','19','21','2025-06-08','1','1','2025-06-09 00:20:17','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3084','21','21','2025-06-08','1','1','2025-06-08 20:08:44','36','36');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3085','37','23','2025-06-08','1','1','2025-06-08 20:06:28','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3086','35','23','2025-06-08','1','1','2025-06-08 20:12:05','54','54');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3087','11','21','2025-06-08','1','1','2025-06-08 20:25:57','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3088','63','21','2025-06-08','1','1','2025-06-08 20:05:51','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3090','34','23','2025-06-08','2','1','2025-06-09 08:28:52','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3091','15','21','2025-06-08','2','1','2025-06-09 08:01:44','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3092','62','21','2025-06-08','2','1','2025-06-09 08:08:21','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3096','19','21','2025-06-09','1','1','2025-06-10 00:15:41','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3097','21','21','2025-06-09','1','1','2025-06-09 20:23:55','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3098','37','23','2025-06-09','1','1','2025-06-09 20:06:52','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3100','35','23','2025-06-09','1','1','2025-06-09 20:04:44','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3101','11','21','2025-06-09','1','1','2025-06-09 20:19:56','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3102','63','21','2025-06-09','1','1','2025-06-09 20:02:22','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3105','34','23','2025-06-09','2','1','2025-06-10 08:02:22','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3106','15','21','2025-06-09','2','1','2025-06-10 08:05:18','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3107','62','21','2025-06-09','2','1','2025-06-10 08:12:50','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3111','19','21','2025-06-10','1','1','2025-06-11 01:24:19','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3112','21','21','2025-06-10','1','1','2025-06-10 20:01:39','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3113','37','23','2025-06-10','1','1','2025-06-10 20:07:38','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3114','35','23','2025-06-10','1','1','2025-06-10 20:08:44','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3115','11','21','2025-06-10','1','1','2025-06-10 20:19:20','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3116','63','21','2025-06-10','1','1','2025-06-10 20:12:52','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3119','34','23','2025-06-10','2','1','2025-06-11 08:23:01','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3120','15','21','2025-06-10','2','1','2025-06-11 08:06:31','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3121','62','21','2025-06-10','2','1','2025-06-11 08:05:20','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3125','19','21','2025-06-11','1','1','2025-06-12 00:15:54','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3126','21','21','2025-06-11','1','1','2025-06-11 20:07:21','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3127','37','23','2025-06-11','1','1','2025-06-11 20:08:54','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3128','35','23','2025-06-11','1','1','2025-06-11 20:19:59','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3129','11','21','2025-06-11','1','1','2025-06-11 20:08:07','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3130','63','21','2025-06-11','1','1','2025-06-11 20:13:32','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3133','34','23','2025-06-11','2','1','2025-06-12 08:22:21','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3134','15','21','2025-06-11','2','1','2025-06-12 08:01:26','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3135','62','21','2025-06-11','2','1','2025-06-12 08:02:31','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3139','19','21','2025-06-12','1','1','2025-06-13 00:16:52','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3140','21','21','2025-06-12','1','1','2025-06-12 20:12:34','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3141','37','23','2025-06-12','1','1','2025-06-12 20:08:09','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3142','35','23','2025-06-12','1','1','2025-06-12 20:03:13','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3143','11','21','2025-06-12','1','1','2025-06-12 20:11:02','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3144','63','21','2025-06-12','1','1','2025-06-12 20:09:15','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3147','34','23','2025-06-12','2','1','2025-06-13 08:18:14','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3148','15','21','2025-06-12','2','1','2025-06-13 08:07:46','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3149','62','21','2025-06-12','2','1','2025-06-13 08:02:55','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3153','19','21','2025-06-13','1','1','2025-06-14 00:17:05','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3154','21','21','2025-06-13','1','1','2025-06-13 20:07:57','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3155','37','23','2025-06-13','1','1','2025-06-13 20:14:02','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3156','35','23','2025-06-13','1','1','2025-06-13 20:07:44','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3157','11','21','2025-06-13','1','1','2025-06-13 20:15:10','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3158','63','21','2025-06-13','1','1','2025-06-13 20:00:52','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3160','34','23','2025-06-13','2','1','2025-06-14 08:30:01','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3161','15','21','2025-06-13','2','1','2025-06-14 08:01:41','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3162','62','21','2025-06-13','2','1','2025-06-14 08:08:29','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3166','19','21','2025-06-14','1','1','2025-06-15 01:12:54','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3167','21','21','2025-06-14','1','1','2025-06-14 20:04:43','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3168','37','23','2025-06-14','1','1','2025-06-14 20:04:20','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3169','35','23','2025-06-14','1','1','2025-06-14 20:04:38','55','55');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3170','11','21','2025-06-14','1','1','2025-06-14 20:17:42','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3171','63','21','2025-06-14','1','1','2025-06-14 20:05:32','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3173','34','23','2025-06-14','2','1','2025-06-15 08:02:11','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3174','15','21','2025-06-14','2','1','2025-06-15 08:04:53','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3175','62','21','2025-06-14','2','1','2025-06-15 08:20:26','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3179','19','21','2025-06-15','1','1','2025-06-16 00:17:28','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3180','21','21','2025-06-15','1','1','2025-06-15 20:14:10','36','36');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3181','37','23','2025-06-15','1','1','2025-06-15 20:03:41','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3182','35','23','2025-06-15','1','1','2025-06-15 20:03:04','54','54');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3183','11','21','2025-06-15','1','1','2025-06-15 20:14:21','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3184','63','21','2025-06-15','1','1','2025-06-15 20:05:29','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3186','34','23','2025-06-15','2','1','2025-06-16 08:20:43','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3187','15','21','2025-06-15','2','1','2025-06-16 08:00:48','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3188','62','21','2025-06-15','2','1','2025-06-16 08:08:02','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3191','80','23','2025-06-15','1','1','2025-06-16 20:11:38','24','24');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3192','81','23','2025-06-15','1','1','2025-06-15 21:11:02','24','24');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3193','78','23','2025-06-15','1','1','2025-06-15 20:01:43','24','24');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3194','83','23','2025-06-15','1','1','2025-06-15 21:19:58','24','24');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3195','84','23','2025-06-15','1','1','2025-06-15 21:16:27','24','24');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3196','77','23','2025-06-15','1','1','2025-06-15 21:09:17','24','24');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3197','79','23','2025-06-15','1','1','2025-06-15 20:02:38','24','24');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3198','76','23','2025-06-15','1','1','2025-06-15 21:09:35','24','24');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3199','82','23','2025-06-15','1','1','2025-06-15 20:53:38','24','24');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3201','19','21','2025-06-16','1','1','2025-06-17 00:15:44','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3202','21','21','2025-06-16','1','1','2025-06-16 20:18:07','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3203','37','23','2025-06-16','1','1','2025-06-16 20:07:56','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3204','35','23','2025-06-16','1','1','2025-06-16 20:01:06','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3205','11','21','2025-06-16','1','1','2025-06-16 20:20:13','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3206','63','21','2025-06-16','1','1','2025-06-16 20:06:18','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3207','81','23','2025-06-16','1','1','2025-06-17 07:56:31','50','50');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3208','78','23','2025-06-16','1','1','2025-06-17 07:57:48','50','50');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3209','83','23','2025-06-16','1','1','2025-06-16 20:01:29','50','50');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3210','84','23','2025-06-16','1','1','2025-06-16 20:01:13','50','50');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3211','77','23','2025-06-16','1','1','2025-06-16 20:19:47','50','50');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3212','79','23','2025-06-16','1','1','2025-06-17 21:03:06','50','50');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3213','76','23','2025-06-16','1','1','2025-06-16 20:10:11','50','50');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3214','82','23','2025-06-16','1','1','2025-06-16 20:11:06','50','50');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3215','34','23','2025-06-16','2','1','2025-06-17 08:05:33','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3216','15','21','2025-06-16','2','1','2025-06-17 08:03:57','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3217','62','21','2025-06-16','2','1','2025-06-17 08:06:59','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3220','19','21','2025-06-17','1','1','2025-06-18 00:17:14','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3221','21','21','2025-06-17','1','1','2025-06-17 20:16:53','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3222','37','23','2025-06-17','1','1','2025-06-17 20:08:15','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3223','35','23','2025-06-17','1','1','2025-06-17 20:04:36','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3224','11','21','2025-06-17','1','1','2025-06-17 20:26:04','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3225','63','21','2025-06-17','1','1','2025-06-17 20:10:24','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3227','80','23','2025-06-17','1','1','2025-06-17 20:55:04','50','50');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3228','83','23','2025-06-17','1','1','2025-06-17 20:38:27','50','50');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3229','84','23','2025-06-17','1','1','2025-06-17 20:27:40','50','50');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3230','77','23','2025-06-17','1','1','2025-06-17 20:36:42','50','50');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3231','76','23','2025-06-17','1','1','2025-06-17 23:46:45','50','50');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3232','82','23','2025-06-17','1','1','2025-06-17 20:41:33','50','50');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3233','34','23','2025-06-17','2','1','2025-06-18 09:38:58','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3234','15','21','2025-06-17','2','1','2025-06-18 08:02:20','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3235','62','21','2025-06-17','2','1','2025-06-18 08:02:47','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3238','81','23','2025-06-17','1','1','2025-06-17 21:03:12','50','50');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3239','78','23','2025-06-17','1','1','2025-06-18 08:05:55','50','50');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3240','19','21','2025-06-18','1','1','2025-06-19 01:09:36','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3241','21','21','2025-06-18','1','1','2025-06-18 20:16:21','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3243','35','23','2025-06-18','1','1','2025-06-18 20:05:31','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3245','63','21','2025-06-18','1','1','2025-06-18 20:01:36','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3255','15','21','2025-06-18','2','1','2025-06-19 08:09:15','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3256','62','21','2025-06-18','2','1','2025-06-19 08:06:54','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3257','78','23','2025-06-18','1','1','2025-06-19 08:02:42','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3258','80','23','2025-06-18','2','1','2025-06-19 08:16:03','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3259','11','21','2025-06-18','1','1','2025-06-18 20:18:50','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3260','81','23','2025-06-18','1','1','2025-06-18 20:03:54','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3261','83','23','2025-06-18','1','1','2025-06-18 20:05:45','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3262','84','23','2025-06-18','2','1','2025-06-19 08:04:58','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3263','77','23','2025-06-18','2','1','2025-06-19 08:05:04','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3264','79','23','2025-06-18','1','1','2025-06-19 20:07:00','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3265','76','23','2025-06-18','1','1','2025-06-18 20:03:09','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3266','82','23','2025-06-18','2','1','2025-06-19 08:01:26','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3267','34','23','2025-06-18','2','1','2025-06-19 08:04:47','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3268','19','21','2025-06-19','1','1','2025-06-20 00:15:54','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3269','21','21','2025-06-19','1','1','2025-06-19 20:16:37','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3270','35','23','2025-06-19','1','1','2025-06-19 20:05:04','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3271','11','21','2025-06-19','1','1','2025-06-19 20:11:02','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3272','63','21','2025-06-19','1','1','2025-06-19 20:06:34','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3274','81','23','2025-06-19','1','1','2025-06-19 20:06:41','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3275','83','23','2025-06-19','1','1','2025-06-19 20:04:49','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3276','76','23','2025-06-19','1','1','2025-06-19 20:06:11','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3277','34','23','2025-06-19','2','1','2025-06-20 08:05:41','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3278','15','21','2025-06-19','2','1','2025-06-20 08:01:44','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3279','62','21','2025-06-19','2','1','2025-06-20 08:08:22','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3280','80','23','2025-06-19','2','1','2025-06-20 08:02:55','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3281','78','23','2025-06-19','1','1','2025-06-19 21:05:01','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3282','84','23','2025-06-19','2','1','2025-06-20 08:06:06','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3283','77','23','2025-06-19','2','1','2025-06-20 08:03:58','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3284','82','23','2025-06-19','2','1','2025-06-20 08:06:35','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3285','19','21','2025-06-20','1','1','2025-06-21 00:16:40','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3286','21','21','2025-06-20','1','1','2025-06-20 20:09:45','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3287','35','23','2025-06-20','1','1','2025-06-20 20:04:54','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3288','11','21','2025-06-20','1','1','2025-06-20 20:08:21','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3289','63','21','2025-06-20','1','1','2025-06-20 20:01:45','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3290','81','23','2025-06-20','1','1','2025-06-20 20:15:36','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3291','78','23','2025-06-20','1','1','2025-06-20 20:25:05','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3292','83','23','2025-06-20','1','1','2025-06-20 20:04:51','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3293','79','23','2025-06-20','1','1','2025-06-20 20:03:27','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3294','76','23','2025-06-20','1','1','2025-06-20 20:07:12','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3295','34','23','2025-06-20','2','1','2025-06-21 08:06:03','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3296','15','21','2025-06-20','2','1','2025-06-21 08:01:46','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3297','62','21','2025-06-20','2','1','2025-06-21 08:06:26','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3299','80','23','2025-06-20','2','1','2025-06-21 08:03:22','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3300','84','23','2025-06-20','2','1','2025-06-21 08:06:47','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3301','77','23','2025-06-20','2','1','2025-06-21 08:12:01','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3303','82','23','2025-06-20','2','1','2025-06-21 08:02:56','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3304','19','21','2025-06-21','1','1','2025-06-22 00:15:59','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3305','21','21','2025-06-21','1','1','2025-06-21 20:11:03','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3306','35','23','2025-06-21','1','1','2025-06-21 20:03:43','55','55');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3307','11','21','2025-06-21','1','1','2025-06-21 20:18:21','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3308','63','21','2025-06-21','1','1','2025-06-21 20:05:38','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3309','81','23','2025-06-21','1','1','2025-06-21 20:09:29','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3310','78','23','2025-06-21','1','1','2025-06-21 20:12:24','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3311','83','23','2025-06-21','1','1','2025-06-21 20:03:00','55','55');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3312','79','23','2025-06-21','1','1','2025-06-21 20:03:33','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3313','76','23','2025-06-21','1','1','2025-06-21 20:04:43','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3314','34','23','2025-06-21','2','1','2025-06-22 08:07:36','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3315','15','21','2025-06-21','2','1','2025-06-22 08:05:31','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3316','62','21','2025-06-21','2','1','2025-06-22 08:03:59','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3317','80','23','2025-06-21','2','1','2025-06-22 08:01:54','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3318','84','23','2025-06-21','2','1','2025-06-22 08:10:40','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3319','77','23','2025-06-21','2','1','2025-06-22 08:06:42','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3320','82','23','2025-06-21','2','1','2025-06-22 08:05:56','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3321','19','21','2025-06-22','1','1','2025-06-23 07:59:27','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3322','21','21','2025-06-22','1','1','2025-06-22 20:15:43','36','36');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3323','35','23','2025-06-22','1','1','2025-06-22 20:01:52','54','54');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3324','11','21','2025-06-22','1','1','2025-06-22 20:08:18','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3325','63','21','2025-06-22','1','1','2025-06-22 20:07:50','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3327','81','23','2025-06-22','1','1','2025-06-22 20:11:47','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3328','78','23','2025-06-22','1','1','2025-06-22 20:07:59','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3329','83','23','2025-06-22','1','1','2025-06-22 20:03:39','54','54');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3330','79','23','2025-06-22','1','1','2025-06-22 20:06:23','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3331','76','23','2025-06-22','1','1','2025-06-22 20:03:07','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3332','34','23','2025-06-22','2','1','2025-06-23 08:11:38','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3333','15','21','2025-06-22','2','1','2025-06-23 08:02:43','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3334','62','21','2025-06-22','2','1','2025-06-23 08:10:33','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3335','80','23','2025-06-22','2','1','2025-06-23 08:04:16','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3336','84','23','2025-06-22','2','1','2025-06-23 08:02:15','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3337','77','23','2025-06-22','2','1','2025-06-23 08:14:20','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3338','82','23','2025-06-22','2','1','2025-06-23 08:03:57','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3339','21','21','2025-06-23','1','1','2025-06-23 20:12:21','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3340','35','23','2025-06-23','1','1','2025-06-23 20:01:24','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3341','11','21','2025-06-23','1','1','2025-06-23 20:15:38','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3342','63','21','2025-06-23','1','1','2025-06-23 20:07:10','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3344','81','23','2025-06-23','1','1','2025-06-23 20:09:25','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3345','78','23','2025-06-23','1','1','2025-06-23 20:09:21','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3346','83','23','2025-06-23','1','1','2025-06-23 20:06:13','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3347','79','23','2025-06-23','1','1','2025-06-23 20:02:47','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3348','76','23','2025-06-23','1','1','2025-06-23 20:03:27','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3349','19','21','2025-06-23','1','1','2025-06-24 00:16:04','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3350','34','23','2025-06-23','2','1','2025-06-24 08:04:09','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3351','15','21','2025-06-23','2','1','2025-06-24 08:08:30','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3352','62','21','2025-06-23','2','1','2025-06-24 08:15:56','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3353','80','23','2025-06-23','2','1','2025-06-24 08:02:16','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3354','84','23','2025-06-23','2','1','2025-06-24 08:02:58','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3355','77','23','2025-06-23','2','1','2025-06-24 08:09:28','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3356','82','23','2025-06-23','2','1','2025-06-24 08:06:48','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3357','19','21','2025-06-24','1','1','2025-06-25 00:19:59','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3358','21','21','2025-06-24','1','1','2025-06-24 20:43:26','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3359','35','23','2025-06-24','1','1','2025-06-24 20:02:30','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3360','11','21','2025-06-24','1','1','2025-06-24 20:15:01','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3361','63','21','2025-06-24','1','1','2025-06-24 20:03:34','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3363','81','23','2025-06-24','1','1','2025-06-24 20:10:42','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3364','78','23','2025-06-24','1','1','2025-06-24 20:04:26','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3365','83','23','2025-06-24','1','1','2025-06-24 20:06:24','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3366','79','23','2025-06-24','1','1','2025-06-24 20:02:47','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3367','76','23','2025-06-24','1','1','2025-06-24 20:03:10','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3368','34','23','2025-06-24','2','1','2025-06-25 08:06:11','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3369','15','21','2025-06-24','2','1','2025-06-25 08:06:46','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3370','62','21','2025-06-24','2','1','2025-06-25 08:26:19','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3371','80','23','2025-06-24','2','1','2025-06-25 08:01:33','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3372','84','23','2025-06-24','2','1','2025-06-25 08:03:10','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3373','77','23','2025-06-24','2','1','2025-06-25 08:05:31','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3374','82','23','2025-06-24','2','1','2025-06-25 08:02:09','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3375','19','21','2025-06-25','1','1','2025-06-26 00:17:25','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3376','21','21','2025-06-25','1','1','2025-06-25 20:13:49','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3377','35','23','2025-06-25','1','1','2025-06-25 20:02:13','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3378','11','21','2025-06-25','1','1','2025-06-25 20:11:17','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3379','63','21','2025-06-25','1','1','2025-06-25 20:05:39','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3381','81','23','2025-06-25','1','1','2025-06-25 20:09:58','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3382','78','23','2025-06-25','1','1','2025-06-25 20:04:16','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3383','83','23','2025-06-25','1','1','2025-06-25 20:02:15','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3384','79','23','2025-06-25','1','1','2025-06-25 20:02:45','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3385','76','23','2025-06-25','1','1','2025-06-25 20:01:21','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3386','34','23','2025-06-25','2','1','2025-06-26 08:09:15','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3387','15','21','2025-06-25','2','1','2025-06-26 08:01:35','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3388','62','21','2025-06-25','2','1','2025-06-26 08:03:34','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3389','80','23','2025-06-25','2','1','2025-06-26 08:05:08','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3390','84','23','2025-06-25','2','1','2025-06-26 08:07:34','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3391','77','23','2025-06-25','2','1','2025-06-26 08:03:15','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3392','82','23','2025-06-25','2','1','2025-06-26 08:05:26','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3393','19','21','2025-06-26','1','1','2025-06-27 00:18:07','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3394','21','21','2025-06-26','1','1','2025-06-26 20:14:29','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3395','35','23','2025-06-26','1','1','2025-06-26 20:01:13','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3396','11','21','2025-06-26','1','1','2025-06-26 20:12:11','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3397','63','21','2025-06-26','1','1','2025-06-26 20:07:03','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3399','81','23','2025-06-26','1','1','2025-06-26 20:11:58','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3400','78','23','2025-06-26','1','1','2025-06-26 20:03:23','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3401','83','23','2025-06-26','1','1','2025-06-26 20:15:34','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3402','79','23','2025-06-26','1','1','2025-06-26 20:01:18','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3403','76','23','2025-06-26','1','1','2025-06-26 20:01:10','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3404','34','23','2025-06-26','2','1','2025-06-27 08:04:58','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3405','15','21','2025-06-26','2','1','2025-06-27 08:09:11','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3406','62','21','2025-06-26','2','1','2025-06-27 08:03:33','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3407','80','23','2025-06-26','2','1','2025-06-27 08:02:37','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3408','84','23','2025-06-26','2','1','2025-06-27 08:01:55','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3409','77','23','2025-06-26','2','1','2025-06-27 08:02:11','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3410','82','23','2025-06-26','2','1','2025-06-27 08:02:53','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3411','19','21','2025-06-27','1','1','2025-06-28 01:18:14','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3412','21','21','2025-06-27','1','1','2025-06-27 20:14:46','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3413','35','23','2025-06-27','1','1','2025-06-27 20:03:59','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3414','11','21','2025-06-27','1','1','2025-06-27 20:13:42','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3415','63','21','2025-06-27','1','1','2025-06-27 20:02:24','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3417','81','23','2025-06-27','1','1','2025-06-27 20:12:46','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3418','78','23','2025-06-27','1','1','2025-06-27 20:02:55','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3419','83','23','2025-06-27','1','1','2025-06-27 20:02:17','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3420','79','23','2025-06-27','1','1','2025-06-27 20:03:12','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3421','76','23','2025-06-27','1','1','2025-06-27 20:02:08','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3422','34','23','2025-06-27','2','1','2025-06-28 08:04:27','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3423','15','21','2025-06-27','2','1','2025-06-28 08:05:27','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3424','62','21','2025-06-27','2','1','2025-06-28 08:10:51','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3425','80','23','2025-06-27','2','1','2025-06-28 08:03:38','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3426','84','23','2025-06-27','2','1','2025-06-28 08:01:46','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3427','77','23','2025-06-27','2','1','2025-06-28 08:04:47','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3428','82','23','2025-06-27','2','1','2025-06-28 08:02:47','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3429','19','21','2025-06-28','1','1','2025-06-29 00:26:44','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3430','21','21','2025-06-28','1','1','2025-06-28 20:22:30','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3432','11','21','2025-06-28','1','1','2025-06-28 20:22:30','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3433','63','21','2025-06-28','1','1','2025-06-28 20:27:04','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3435','81','23','2025-06-28','1','1','2025-06-28 20:09:55','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3436','78','23','2025-06-28','1','1','2025-06-28 20:04:32','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3437','83','23','2025-06-28','1','1','2025-06-28 20:10:16','55','55');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3438','79','23','2025-06-28','1','1','2025-06-28 20:02:37','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3439','76','23','2025-06-28','1','1','2025-06-28 20:01:12','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3441','15','21','2025-06-28','2','1','2025-06-29 08:04:23','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3442','62','21','2025-06-28','2','1','2025-06-29 08:06:27','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3443','80','23','2025-06-28','2','1','2025-06-29 08:06:37','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3444','84','23','2025-06-28','2','1','2025-06-29 08:05:35','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3445','77','23','2025-06-28','2','1','2025-06-29 08:01:56','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3446','82','23','2025-06-28','2','1','2025-06-29 08:03:16','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3447','19','21','2025-06-29','1','1','2025-06-30 00:19:07','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3448','21','21','2025-06-29','1','1','2025-06-29 20:05:25','36','36');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3449','11','21','2025-06-29','1','1','2025-06-29 20:06:28','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3450','63','21','2025-06-29','1','1','2025-06-29 20:08:06','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3452','81','23','2025-06-29','1','1','2025-06-29 20:10:49','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3453','78','23','2025-06-29','1','1','2025-06-29 20:05:05','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3454','83','23','2025-06-29','1','1','2025-06-29 20:04:25','54','54');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3455','79','23','2025-06-29','1','1','2025-06-29 20:04:42','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3456','76','23','2025-06-29','1','1','2025-06-29 20:04:35','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3457','15','21','2025-06-29','2','1','2025-06-30 08:02:34','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3458','62','21','2025-06-29','2','1','2025-06-30 08:11:28','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3459','80','23','2025-06-29','2','1','2025-06-30 08:06:06','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3460','84','23','2025-06-29','2','1','2025-06-30 08:03:24','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3461','77','23','2025-06-29','2','1','2025-06-30 08:02:35','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3462','82','23','2025-06-29','2','1','2025-06-30 08:06:13','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3463','19','21','2025-06-30','1','1','2025-07-01 00:26:23','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3464','21','21','2025-06-30','1','1','2025-06-30 20:10:38','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3465','11','21','2025-06-30','1','1','2025-06-30 20:18:29','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3466','63','21','2025-06-30','1','1','2025-06-30 20:03:21','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3468','81','23','2025-06-30','1','1','2025-06-30 20:09:53','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3469','78','23','2025-06-30','1','1','2025-06-30 20:05:33','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3470','83','23','2025-06-30','1','1','2025-06-30 20:04:52','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3471','79','23','2025-06-30','1','1','2025-06-30 20:05:04','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3472','76','23','2025-06-30','1','1','2025-06-30 20:07:02','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3473','15','21','2025-06-30','2','1','2025-07-01 08:06:39','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3474','62','21','2025-06-30','2','1','2025-07-01 08:02:37','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3475','80','23','2025-06-30','2','1','2025-07-01 08:02:02','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3476','84','23','2025-06-30','2','1','2025-07-01 08:10:59','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3477','77','23','2025-06-30','2','1','2025-07-01 08:01:08','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3478','82','23','2025-06-30','2','1','2025-07-01 08:04:21','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3479','19','21','2025-07-01','1','1','2025-07-02 00:16:08','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3480','21','21','2025-07-01','1','1','2025-07-01 20:14:22','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3481','11','21','2025-07-01','1','1','2025-07-01 20:15:05','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3482','63','21','2025-07-01','1','1','2025-07-01 20:10:00','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3483','81','23','2025-07-01','1','1','2025-07-01 20:14:25','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3484','78','23','2025-07-01','1','1','2025-07-01 20:18:44','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3485','83','23','2025-07-01','1','1','2025-07-01 20:11:10','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3486','79','23','2025-07-01','1','1','2025-07-01 20:09:52','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3487','76','23','2025-07-01','1','1','2025-07-01 20:05:47','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3488','15','21','2025-07-01','2','1','2025-07-02 08:03:56','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3489','62','21','2025-07-01','2','1','2025-07-02 08:04:24','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3490','80','23','2025-07-01','2','1','2025-07-02 08:01:57','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3491','84','23','2025-07-01','2','1','2025-07-02 08:05:07','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3492','77','23','2025-07-01','2','1','2025-07-02 08:06:59','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3493','82','23','2025-07-01','2','1','2025-07-02 08:05:23','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3494','19','21','2025-07-02','1','1','2025-07-03 01:10:56','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3495','21','21','2025-07-02','1','1','2025-07-02 20:23:37','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3496','11','21','2025-07-02','1','1','2025-07-02 20:12:02','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3497','63','21','2025-07-02','1','1','2025-07-02 20:03:56','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3498','81','23','2025-07-02','1','1','2025-07-02 20:11:23','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3499','78','23','2025-07-02','1','1','2025-07-02 20:12:53','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3500','83','23','2025-07-02','1','1','2025-07-02 20:04:54','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3501','79','23','2025-07-02','1','1','2025-07-02 20:02:42','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3502','76','23','2025-07-02','1','1','2025-07-02 20:06:23','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3503','15','21','2025-07-02','2','1','2025-07-03 08:00:58','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3504','62','21','2025-07-02','2','1','2025-07-03 08:06:11','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3505','80','23','2025-07-02','2','1','2025-07-03 08:11:49','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3506','84','23','2025-07-02','2','1','2025-07-03 08:07:56','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3507','77','23','2025-07-02','2','1','2025-07-03 08:01:48','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3508','82','23','2025-07-02','2','1','2025-07-03 08:09:25','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3509','19','21','2025-07-03','1','1','2025-07-04 00:16:14','137','137');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3510','21','21','2025-07-03','1','1','2025-07-03 20:12:03','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3511','11','21','2025-07-03','1','1','2025-07-03 20:14:46','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3512','63','21','2025-07-03','1','1','2025-07-03 20:13:22','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3513','81','23','2025-07-03','1','1','2025-07-03 20:09:09','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3514','78','23','2025-07-03','1','1','2025-07-03 20:02:33','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3515','83','23','2025-07-03','1','1','2025-07-03 20:09:58','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3516','79','23','2025-07-03','1','1','2025-07-03 20:02:36','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3517','76','23','2025-07-03','1','1','2025-07-03 20:04:29','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3518','15','21','2025-07-03','2','1','2025-07-04 08:03:11','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3519','62','21','2025-07-03','2','1','2025-07-04 08:13:17','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3520','80','23','2025-07-03','2','1','2025-07-04 08:12:11','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3521','84','23','2025-07-03','2','1','2025-07-04 08:13:47','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3522','77','23','2025-07-03','2','1','2025-07-04 08:00:46','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3523','82','23','2025-07-03','2','1','2025-07-04 08:08:08','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3541','19','21','2025-07-10','1','1','2025-07-10 20:13:23','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3542','21','21','2025-07-10','1','1','2025-07-10 20:10:27','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3543','11','21','2025-07-10','1','1','2025-07-10 20:12:33','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3544','15','21','2025-07-10','2','1','2025-07-11 08:06:00','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3545','62','21','2025-07-10','2','1','2025-07-11 08:01:36','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3546','63','21','2025-07-10','1','1','2025-07-11 00:16:08','131','131');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3559','80','23','2025-07-10','2','1','2025-07-11 08:13:14','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3560','81','23','2025-07-10','1','1','2025-07-10 20:05:58','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3561','78','23','2025-07-10','1','1','2025-07-10 20:07:04','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3562','83','23','2025-07-10','1','1','2025-07-10 20:03:59','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3563','84','23','2025-07-10','2','1','2025-07-11 08:11:18','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3564','77','23','2025-07-10','2','1','2025-07-11 08:03:07','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3565','79','23','2025-07-10','1','1','2025-07-10 20:08:17','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3566','76','23','2025-07-10','1','1','2025-07-10 20:11:14','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3567','82','23','2025-07-10','2','1','2025-07-11 08:04:55','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3568','37','21','2025-07-10','1','1','2025-07-10 20:10:52','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3569','34','21','2025-07-10','2','1','2025-07-11 08:12:12','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3570','35','31','2025-07-10','2','1','2025-07-11 08:10:08','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3571','61','31','2025-07-10','1','1','2025-07-10 20:32:12','28','28');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3573','19','21','2025-07-11','1','1','2025-07-11 20:02:20','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3574','21','21','2025-07-11','1','1','2025-07-11 20:12:00','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3575','37','21','2025-07-11','1','1','2025-07-11 20:05:42','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3576','11','21','2025-07-11','1','1','2025-07-11 20:13:28','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3577','63','21','2025-07-11','1','1','2025-07-12 00:16:21','131','131');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3578','81','23','2025-07-11','1','1','2025-07-11 20:14:10','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3579','78','23','2025-07-11','1','1','2025-07-11 20:11:25','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3580','83','23','2025-07-11','1','1','2025-07-11 20:16:56','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3581','79','23','2025-07-11','1','1','2025-07-11 20:08:31','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3582','76','23','2025-07-11','1','1','2025-07-11 20:10:46','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3583','61','31','2025-07-11','1','1','2025-07-11 22:26:52','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3584','34','21','2025-07-11','2','1','2025-07-12 08:13:41','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3585','15','21','2025-07-11','2','1','2025-07-12 08:04:45','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3586','62','21','2025-07-11','2','1','2025-07-12 08:07:09','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3587','80','23','2025-07-11','2','1','2025-07-12 08:07:04','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3588','84','23','2025-07-11','2','1','2025-07-12 08:09:44','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3589','77','23','2025-07-11','2','1','2025-07-12 08:05:12','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3590','82','23','2025-07-11','2','1','2025-07-12 19:54:08','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3591','35','31','2025-07-11','2','1','2025-07-12 08:21:51','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3598','85','21','2025-07-11','2','0',NULL,'0','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3613','83','23','2025-07-12','1','1','2025-07-12 20:02:57','55','55');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3616','61','31','2025-07-12','1','1','2025-07-12 20:02:11','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3621','19','21','2025-07-12','1','1','2025-07-12 20:13:59','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3622','21','21','2025-07-12','1','1','2025-07-13 07:31:49','112','112');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3623','37','21','2025-07-12','1','1','2025-07-12 20:05:50','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3624','11','21','2025-07-12','1','1','2025-07-12 20:11:16','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3625','63','21','2025-07-12','1','1','2025-07-12 20:03:38','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3626','81','23','2025-07-12','1','1','2025-07-13 00:14:34','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3627','78','23','2025-07-12','1','1','2025-07-12 20:10:19','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3628','79','23','2025-07-12','1','1','2025-07-12 20:03:32','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3629','76','23','2025-07-12','1','1','2025-07-12 20:04:34','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3635','34','21','2025-07-12','2','1','2025-07-13 08:13:26','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3636','15','21','2025-07-12','2','1','2025-07-13 08:05:27','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3637','62','21','2025-07-12','2','1','2025-07-13 08:12:19','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3639','84','23','2025-07-12','2','1','2025-07-13 08:10:23','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3640','77','23','2025-07-12','2','1','2025-07-13 08:10:14','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3641','35','31','2025-07-12','2','1','2025-07-13 08:07:03','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3646','19','21','2025-07-13','1','1','2025-07-13 20:07:48','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3647','37','21','2025-07-13','1','1','2025-07-13 20:04:19','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3648','11','21','2025-07-13','1','1','2025-07-13 20:02:58','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3649','63','21','2025-07-13','1','1','2025-07-13 20:10:59','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3650','81','23','2025-07-13','1','1','2025-07-13 20:15:31','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3651','78','23','2025-07-13','1','1','2025-07-13 20:06:22','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3652','83','23','2025-07-13','1','1','2025-07-13 20:06:48','54','54');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3653','79','23','2025-07-13','1','1','2025-07-13 20:07:21','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3654','76','23','2025-07-13','1','1','2025-07-13 20:03:27','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3655','82','23','2025-07-13','2','1','2025-07-14 08:15:23','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3656','61','31','2025-07-13','1','1','2025-07-13 20:02:26','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3663','21','21','2025-07-13','1','1','2025-07-14 00:16:12','111','111');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3664','34','21','2025-07-13','2','1','2025-07-14 08:13:30','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3665','15','21','2025-07-13','2','1','2025-07-14 08:06:06','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3666','62','21','2025-07-13','2','1','2025-07-14 08:05:06','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3667','84','23','2025-07-13','2','1','2025-07-14 08:15:10','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3669','35','31','2025-07-13','2','1','2025-07-14 08:17:03','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3672','80','23','2025-07-13','2','1','2025-07-14 08:16:22','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3673','77','23','2025-07-13','2','1','2025-07-14 08:01:37','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3690','19','21','2025-07-14','1','1','2025-07-14 20:06:59','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3691','21','21','2025-07-14','1','1','2025-07-14 20:07:40','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3692','37','21','2025-07-14','1','1','2025-07-15 00:16:10','131','131');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3693','11','21','2025-07-14','1','1','2025-07-14 20:06:52','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3694','63','21','2025-07-14','1','1','2025-07-14 20:05:44','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3697','83','23','2025-07-14','1','1','2025-07-14 20:05:02','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3698','79','23','2025-07-14','1','1','2025-07-14 20:04:25','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3699','76','23','2025-07-14','1','1','2025-07-14 20:05:37','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3700','61','31','2025-07-14','1','1','2025-07-14 20:09:34','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3701','102','21','2025-07-14','1','1','2025-07-15 18:36:17','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3702','99','21','2025-07-14','1','0',NULL,'0','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3703','103','21','2025-07-14','1','1','2025-07-14 20:06:59','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3704','100','21','2025-07-14','1','1','2025-07-15 09:43:38','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3705','101','21','2025-07-14','1','1','2025-07-14 20:03:04','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3706','98','21','2025-07-14','1','1','2025-07-14 20:10:34','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3707','104','21','2025-07-14','1','1','2025-07-14 20:00:58','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3709','81','23','2025-07-14','1','1','2025-07-14 20:01:32','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3710','78','23','2025-07-14','1','1','2025-07-14 06:31:09','0','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3717','97','21','2025-07-14','1','1','2025-07-14 20:03:19','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3718','34','21','2025-07-14','2','1','2025-07-15 08:13:41','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3719','15','21','2025-07-14','2','1','2025-07-15 08:04:08','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3720','62','21','2025-07-14','2','1','2025-07-15 08:06:35','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3721','80','23','2025-07-14','2','1','2025-07-15 08:11:12','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3722','84','23','2025-07-14','2','1','2025-07-15 08:20:00','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3723','77','23','2025-07-14','2','1','2025-07-15 08:02:33','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3724','82','23','2025-07-14','2','1','2025-07-15 08:09:24','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3725','35','31','2025-07-14','2','1','2025-07-15 08:15:32','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3726','19','21','2025-07-15','1','1','2025-07-15 20:06:16','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3727','21','21','2025-07-15','1','1','2025-07-15 20:07:11','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3728','37','21','2025-07-15','1','1','2025-07-16 00:31:32','131','131');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3729','11','21','2025-07-15','1','1','2025-07-15 20:07:41','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3730','63','21','2025-07-15','1','1','2025-07-15 20:04:49','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3731','81','23','2025-07-15','1','1','2025-07-16 20:00:38','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3732','83','23','2025-07-15','1','1','2025-07-15 21:53:18','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3733','79','23','2025-07-15','1','1','2025-07-15 22:35:54','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3734','76','23','2025-07-15','1','1','2025-07-15 20:10:00','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3735','61','31','2025-07-15','1','1','2025-07-15 20:14:52','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3736','103','21','2025-07-15','1','1','2025-07-15 20:09:54','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3737','101','21','2025-07-15','1','0',NULL,'13','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3738','98','21','2025-07-15','1','1','2025-07-15 20:28:51','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3739','104','21','2025-07-15','1','1','2025-07-15 20:02:17','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3741','34','21','2025-07-15','2','1','2025-07-16 08:17:58','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3742','15','21','2025-07-15','2','1','2025-07-16 08:06:47','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3743','62','21','2025-07-15','2','1','2025-07-16 08:14:45','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3744','80','23','2025-07-15','2','1','2025-07-16 08:06:56','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3745','84','23','2025-07-15','2','1','2025-07-16 08:02:28','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3747','82','23','2025-07-15','2','1','2025-07-16 08:06:58','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3749','102','21','2025-07-15','1','1','2025-07-17 07:53:40','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3750','100','21','2025-07-15','1','1','2025-07-16 19:46:23','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3751','35','31','2025-07-15','2','1','2025-07-16 08:12:26','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3752','19','21','2025-07-16','1','1','2025-07-16 20:06:50','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3753','21','21','2025-07-16','1','1','2025-07-16 20:08:23','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3754','37','21','2025-07-16','1','0',NULL,'77','131');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3755','11','21','2025-07-16','1','1','2025-07-16 20:11:02','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3757','83','23','2025-07-16','1','1','2025-07-16 20:07:19','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3758','79','23','2025-07-16','1','1','2025-07-16 20:05:39','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3760','61','31','2025-07-16','1','1','2025-07-16 20:02:26','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3761','103','21','2025-07-16','1','1','2025-07-16 20:10:45','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3762','98','21','2025-07-16','1','1','2025-07-16 20:04:30','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3764','34','21','2025-07-16','2','1','2025-07-17 08:14:07','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3765','15','21','2025-07-16','2','1','2025-07-17 08:13:09','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3766','62','21','2025-07-16','2','1','2025-07-17 08:13:24','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3767','80','23','2025-07-16','2','1','2025-07-17 08:09:58','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3768','84','23','2025-07-16','2','1','2025-07-17 08:10:28','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3769','82','23','2025-07-16','2','1','2025-07-17 08:02:40','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3770','35','31','2025-07-16','2','1','2025-07-17 08:09:29','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3777','61','31','2025-07-17','1','1','2025-07-17 20:51:48','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3781','19','21','2025-07-17','1','1','2025-07-17 20:17:07','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3782','21','21','2025-07-17','1','1','2025-07-18 00:41:10','113','113');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3783','34','21','2025-07-17','2','1','2025-07-18 08:12:22','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3784','11','21','2025-07-17','1','1','2025-07-17 20:23:53','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3785','15','21','2025-07-17','2','1','2025-07-18 08:07:17','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3786','62','21','2025-07-17','2','1','2025-07-18 08:02:51','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3787','63','21','2025-07-17','2','1','2025-07-18 08:06:32','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3788','80','23','2025-07-17','2','1','2025-07-18 08:11:07','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3790','83','23','2025-07-17','1','1','2025-07-17 20:02:44','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3791','84','23','2025-07-17','2','1','2025-07-18 08:02:30','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3792','77','23','2025-07-17','1','1','2025-07-17 20:03:39','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3793','79','23','2025-07-17','1','1','2025-07-17 20:04:50','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3794','76','23','2025-07-17','2','1','2025-07-18 08:04:13','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3795','82','23','2025-07-17','2','1','2025-07-18 08:04:14','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3796','35','31','2025-07-17','2','1','2025-07-18 08:19:53','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3797','102','21','2025-07-17','1','1','2025-07-17 20:21:30','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3798','103','23','2025-07-17','1','1','2025-07-17 20:06:35','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3799','100','21','2025-07-17','1','1','2025-07-17 20:20:17','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3800','98','23','2025-07-17','1','1','2025-07-17 20:05:48','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3803','19','21','2025-07-18','1','1','2025-07-18 20:09:44','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3804','21','21','2025-07-18','1','1','2025-07-19 00:16:14','113','113');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3805','11','21','2025-07-18','1','1','2025-07-18 20:16:29','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3806','83','23','2025-07-18','1','1','2025-07-18 20:05:28','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3807','77','23','2025-07-18','1','1','2025-07-18 20:06:21','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3808','79','23','2025-07-18','1','1','2025-07-18 20:04:12','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3809','61','31','2025-07-18','1','1','2025-07-18 20:17:01','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3810','102','21','2025-07-18','1','1','2025-07-18 20:15:12','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3812','100','21','2025-07-18','1','1','2025-07-18 20:15:18','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3814','34','21','2025-07-18','2','1','2025-07-19 08:18:25','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3815','15','21','2025-07-18','2','1','2025-07-19 08:02:05','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3816','62','21','2025-07-18','2','1','2025-07-19 08:03:03','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3817','63','21','2025-07-18','2','1','2025-07-19 08:11:28','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3818','80','23','2025-07-18','2','1','2025-07-19 08:10:00','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3819','84','23','2025-07-18','2','1','2025-07-19 08:07:01','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3820','76','23','2025-07-18','2','1','2025-07-19 08:04:36','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3821','82','23','2025-07-18','2','1','2025-07-19 08:06:47','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3822','35','31','2025-07-18','2','1','2025-07-19 08:08:15','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3823','19','21','2025-07-19','1','1','2025-07-20 00:16:59','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3824','21','21','2025-07-19','1','1','2025-07-19 20:16:06','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3825','11','21','2025-07-19','1','1','2025-07-19 20:11:36','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3826','83','23','2025-07-19','1','1','2025-07-19 20:02:48','55','55');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3827','77','23','2025-07-19','1','1','2025-07-19 20:07:28','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3828','79','23','2025-07-19','1','1','2025-07-19 20:02:11','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3829','61','31','2025-07-19','1','1','2025-07-19 20:04:42','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3830','102','21','2025-07-19','1','1','2025-07-19 20:13:36','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3831','100','21','2025-07-19','1','1','2025-07-19 20:15:15','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3832','97','23','2025-07-19','1','1','2025-07-19 20:02:52','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3834','103','23','2025-07-19','1','1','2025-07-20 07:58:53','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3837','98','23','2025-07-19','2','1','2025-07-20 19:17:22','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3838','34','21','2025-07-19','2','1','2025-07-20 08:19:52','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3839','15','21','2025-07-19','2','1','2025-07-20 08:02:46','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3840','62','21','2025-07-19','2','1','2025-07-20 08:07:04','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3841','63','21','2025-07-19','2','1','2025-07-20 08:08:24','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3842','80','23','2025-07-19','2','1','2025-07-20 08:06:50','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3843','35','23','2025-07-19','1','1','2025-07-19 20:06:34','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3844','84','23','2025-07-19','2','1','2025-07-20 08:11:51','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3845','76','23','2025-07-19','2','1','2025-07-20 08:11:46','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3846','82','23','2025-07-19','2','1','2025-07-20 08:16:30','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3848','50','23','2025-07-19','1','0',NULL,'0','11');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3849','19','21','2025-07-20','1','1','2025-07-21 00:34:32','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3850','21','21','2025-07-20','1','1','2025-07-20 20:15:18','36','36');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3851','11','21','2025-07-20','1','1','2025-07-20 20:13:48','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3852','35','23','2025-07-20','1','1','2025-07-20 20:07:09','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3853','83','23','2025-07-20','1','1','2025-07-20 20:01:37','54','54');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3854','77','23','2025-07-20','1','1','2025-07-20 20:03:58','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3855','79','23','2025-07-20','1','1','2025-07-20 20:00:53','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3856','61','31','2025-07-20','1','1','2025-07-20 20:02:28','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3857','102','21','2025-07-20','1','1','2025-07-20 20:09:25','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3858','100','21','2025-07-20','1','1','2025-07-20 20:09:39','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3859','97','23','2025-07-20','1','1','2025-07-20 20:01:23','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3860','34','21','2025-07-20','2','1','2025-07-21 08:21:16','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3861','15','21','2025-07-20','2','1','2025-07-21 08:03:52','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3862','62','21','2025-07-20','2','1','2025-07-21 08:05:53','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3863','63','21','2025-07-20','2','1','2025-07-21 08:03:59','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3864','80','23','2025-07-20','2','1','2025-07-21 08:06:57','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3865','84','23','2025-07-20','2','1','2025-07-21 08:09:32','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3866','76','23','2025-07-20','2','1','2025-07-21 08:10:42','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3867','82','23','2025-07-20','2','1','2025-07-21 08:18:22','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3868','103','23','2025-07-20','1','1','2025-07-20 20:09:56','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3869','98','23','2025-07-20','2','1','2025-07-21 08:01:20','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3870','36','31','2025-07-20','2','1','2025-07-21 08:03:07','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3871','19','21','2025-07-21','1','1','2025-07-22 00:16:25','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3872','21','21','2025-07-21','1','1','2025-07-21 20:20:42','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3873','11','21','2025-07-21','1','1','2025-07-21 20:07:50','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3874','35','23','2025-07-21','1','1','2025-07-21 20:03:44','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3875','83','23','2025-07-21','1','1','2025-07-21 20:04:24','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3876','77','23','2025-07-21','1','1','2025-07-21 20:02:42','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3877','79','23','2025-07-21','1','1','2025-07-21 20:02:45','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3878','61','31','2025-07-21','1','1','2025-07-21 20:01:49','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3879','102','21','2025-07-21','1','1','2025-07-21 20:15:14','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3880','103','23','2025-07-21','1','1','2025-07-21 20:07:47','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3881','100','21','2025-07-21','1','1','2025-07-21 20:25:12','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3882','97','23','2025-07-21','1','1','2025-07-21 20:01:16','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3883','34','21','2025-07-21','2','1','2025-07-22 08:21:51','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3884','15','21','2025-07-21','2','1','2025-07-22 08:01:26','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3885','62','21','2025-07-21','2','1','2025-07-22 08:09:00','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3886','63','21','2025-07-21','2','1','2025-07-22 08:05:42','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3887','80','23','2025-07-21','2','1','2025-07-22 08:02:49','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3888','84','23','2025-07-21','2','1','2025-07-22 08:00:50','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3889','76','23','2025-07-21','2','1','2025-07-22 08:04:25','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3890','82','23','2025-07-21','2','1','2025-07-22 08:11:58','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3891','36','31','2025-07-21','2','1','2025-07-22 10:56:27','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3892','98','23','2025-07-21','2','1','2025-07-22 08:03:12','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3893','19','21','2025-07-22','1','1','2025-07-23 00:18:51','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3894','21','21','2025-07-22','1','1','2025-07-22 20:11:24','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3895','11','21','2025-07-22','1','1','2025-07-22 20:12:49','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3896','35','23','2025-07-22','1','1','2025-07-22 20:07:38','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3897','83','23','2025-07-22','1','1','2025-07-22 20:09:14','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3898','77','23','2025-07-22','1','1','2025-07-22 20:02:27','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3899','79','23','2025-07-22','1','1','2025-07-22 20:09:25','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3900','61','31','2025-07-22','1','1','2025-07-22 20:04:20','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3901','102','21','2025-07-22','1','1','2025-07-22 20:10:53','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3902','103','23','2025-07-22','1','1','2025-07-23 07:55:27','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3903','100','21','2025-07-22','1','1','2025-07-22 20:20:54','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3904','97','23','2025-07-22','1','1','2025-07-22 20:02:12','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3905','34','21','2025-07-22','2','1','2025-07-23 08:11:07','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3906','15','21','2025-07-22','2','1','2025-07-23 08:01:14','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3907','62','21','2025-07-22','2','1','2025-07-23 08:03:36','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3908','63','21','2025-07-22','2','1','2025-07-23 08:07:22','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3909','80','23','2025-07-22','2','1','2025-07-23 08:06:25','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3910','84','23','2025-07-22','2','1','2025-07-23 08:12:12','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3911','76','23','2025-07-22','2','1','2025-07-23 08:08:33','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3912','82','23','2025-07-22','2','1','2025-07-23 08:07:30','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3913','36','31','2025-07-22','2','1','2025-07-23 08:07:37','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3914','98','23','2025-07-22','2','1','2025-07-23 08:01:54','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3915','19','21','2025-07-23','1','1','2025-07-24 07:16:34','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3916','21','21','2025-07-23','1','1','2025-07-23 20:16:21','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3917','11','21','2025-07-23','1','1','2025-07-23 20:08:50','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3918','35','23','2025-07-23','1','1','2025-07-23 20:02:21','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3919','83','23','2025-07-23','1','1','2025-07-23 20:15:37','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3920','77','23','2025-07-23','1','1','2025-07-23 20:03:11','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3921','79','23','2025-07-23','1','1','2025-07-23 20:03:33','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3922','61','31','2025-07-23','1','1','2025-07-23 20:01:57','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3923','102','21','2025-07-23','1','1','2025-07-23 20:13:38','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3924','100','21','2025-07-23','1','1','2025-07-23 20:14:31','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3925','97','23','2025-07-23','1','1','2025-07-23 20:02:12','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3926','34','21','2025-07-23','2','1','2025-07-24 08:05:49','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3927','15','21','2025-07-23','2','1','2025-07-24 08:01:59','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3928','62','21','2025-07-23','2','1','2025-07-24 08:07:17','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3929','63','21','2025-07-23','2','1','2025-07-24 08:20:34','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3930','80','23','2025-07-23','2','1','2025-07-24 08:04:54','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3931','84','23','2025-07-23','2','1','2025-07-24 08:03:30','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3932','76','23','2025-07-23','2','1','2025-07-24 08:06:44','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3933','82','23','2025-07-23','2','1','2025-07-24 08:06:33','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3934','36','31','2025-07-23','2','1','2025-07-24 08:09:10','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3935','103','23','2025-07-23','1','1','2025-07-23 20:07:40','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3936','98','23','2025-07-23','2','1','2025-07-24 08:06:25','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3937','21','21','2025-07-24','1','1','2025-07-24 20:12:11','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3938','11','21','2025-07-24','1','1','2025-07-24 20:06:43','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3939','35','23','2025-07-24','1','1','2025-07-24 20:03:00','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3940','83','23','2025-07-24','1','1','2025-07-24 20:01:18','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3941','77','23','2025-07-24','1','1','2025-07-24 20:01:58','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3942','79','23','2025-07-24','1','1','2025-07-24 20:04:13','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3943','61','31','2025-07-24','1','1','2025-07-24 20:01:09','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3944','102','21','2025-07-24','1','1','2025-07-24 20:11:53','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3945','103','23','2025-07-24','1','1','2025-07-24 20:08:46','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3946','100','21','2025-07-24','1','1','2025-07-24 20:14:36','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3947','97','23','2025-07-24','1','1','2025-07-24 20:04:42','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3948','19','21','2025-07-24','1','1','2025-07-26 00:15:42','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3949','34','21','2025-07-24','2','1','2025-07-25 20:22:48','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3950','15','21','2025-07-24','2','1','2025-07-25 08:05:13','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3951','62','21','2025-07-24','2','1','2025-07-25 08:09:21','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3952','63','21','2025-07-24','2','1','2025-07-25 08:05:14','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3953','80','23','2025-07-24','2','1','2025-07-25 08:03:45','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3954','84','23','2025-07-24','2','1','2025-07-25 08:04:59','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3955','76','23','2025-07-24','2','1','2025-07-25 08:08:27','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3956','82','23','2025-07-24','2','1','2025-07-25 08:09:56','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3957','36','31','2025-07-24','2','1','2025-07-25 08:07:15','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3958','98','23','2025-07-24','2','1','2025-07-25 08:03:03','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3959','21','21','2025-07-25','1','1','2025-07-25 20:12:41','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3960','11','21','2025-07-25','1','1','2025-07-25 20:13:49','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3961','35','23','2025-07-25','1','1','2025-07-25 20:10:47','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3962','83','23','2025-07-25','1','1','2025-07-25 20:01:39','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3963','77','23','2025-07-25','1','1','2025-07-25 20:03:05','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3964','79','23','2025-07-25','1','1','2025-07-25 20:09:54','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3965','61','31','2025-07-25','1','1','2025-07-25 20:04:41','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3966','102','21','2025-07-25','1','1','2025-07-25 20:13:47','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3967','103','23','2025-07-25','1','1','2025-07-25 20:09:07','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3968','100','21','2025-07-25','1','1','2025-07-25 20:04:32','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3969','97','23','2025-07-25','1','1','2025-07-25 20:02:34','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3970','15','21','2025-07-25','2','1','2025-07-26 08:03:28','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3971','62','21','2025-07-25','2','1','2025-07-26 08:04:51','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3972','63','21','2025-07-25','2','1','2025-07-26 08:05:39','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3973','80','23','2025-07-25','2','1','2025-07-26 08:06:31','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3974','84','23','2025-07-25','2','1','2025-07-26 08:09:29','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3975','76','23','2025-07-25','2','1','2025-07-26 08:12:36','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3976','82','23','2025-07-25','2','1','2025-07-26 08:09:59','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3977','36','31','2025-07-25','2','1','2025-07-26 08:03:23','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3978','98','23','2025-07-25','2','1','2025-07-26 08:02:42','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3979','34','21','2025-07-25','2','1','2025-07-26 08:03:40','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3980','19','21','2025-07-26','1','1','2025-07-27 00:34:06','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3981','21','21','2025-07-26','1','1','2025-07-26 20:15:03','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3982','11','21','2025-07-26','1','1','2025-07-26 20:15:15','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3983','35','23','2025-07-26','1','1','2025-07-26 20:08:31','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3984','83','23','2025-07-26','1','1','2025-07-26 20:02:57','55','55');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3985','77','23','2025-07-26','1','1','2025-07-26 20:04:54','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3986','79','23','2025-07-26','1','1','2025-07-26 20:05:29','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3987','61','31','2025-07-26','1','1','2025-07-27 08:16:54','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3988','102','21','2025-07-26','1','1','2025-07-26 20:09:46','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3989','103','23','2025-07-26','1','1','2025-07-26 20:06:38','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3990','100','21','2025-07-26','1','1','2025-07-26 20:08:06','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3991','97','23','2025-07-26','1','1','2025-07-26 20:01:38','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3992','34','21','2025-07-26','2','1','2025-07-27 08:06:56','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3993','15','21','2025-07-26','2','1','2025-07-27 08:06:41','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3994','62','21','2025-07-26','2','1','2025-07-27 08:04:03','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3995','63','21','2025-07-26','2','1','2025-07-27 08:03:21','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3996','80','23','2025-07-26','2','1','2025-07-27 08:04:30','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3997','84','23','2025-07-26','2','1','2025-07-27 08:05:10','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3998','76','23','2025-07-26','2','1','2025-07-27 20:06:34','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('3999','82','23','2025-07-26','2','1','2025-07-27 08:11:54','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4000','36','31','2025-07-26','2','1','2025-07-27 08:04:07','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4001','98','23','2025-07-26','2','1','2025-07-27 08:01:20','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4002','19','21','2025-07-27','1','1','2025-07-28 00:16:38','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4003','21','21','2025-07-27','1','1','2025-07-27 20:16:05','36','36');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4004','11','21','2025-07-27','1','1','2025-07-27 20:15:20','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4005','35','23','2025-07-27','1','1','2025-07-27 20:02:31','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4006','83','23','2025-07-27','1','1','2025-07-27 20:05:40','54','54');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4007','77','23','2025-07-27','1','1','2025-07-27 20:03:06','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4008','79','23','2025-07-27','1','1','2025-07-27 20:04:02','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4009','102','21','2025-07-27','1','1','2025-07-27 20:15:36','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4010','103','23','2025-07-27','1','1','2025-07-27 20:15:49','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4011','100','21','2025-07-27','1','1','2025-07-27 20:15:36','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4012','97','23','2025-07-27','1','1','2025-07-27 20:01:38','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4013','34','21','2025-07-27','2','1','2025-07-28 08:07:42','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4014','15','21','2025-07-27','2','1','2025-07-28 08:06:08','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4015','62','21','2025-07-27','2','1','2025-07-28 08:07:17','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4016','63','21','2025-07-27','2','1','2025-07-28 08:07:12','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4017','80','23','2025-07-27','2','1','2025-07-28 08:05:21','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4018','84','23','2025-07-27','2','1','2025-07-28 08:04:51','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4019','82','23','2025-07-27','2','1','2025-07-28 08:02:10','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4020','36','31','2025-07-27','2','1','2025-07-28 08:06:40','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4021','61','31','2025-07-27','1','1','2025-07-27 20:04:55','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4022','98','23','2025-07-27','2','1','2025-07-28 08:06:38','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4023','19','21','2025-07-28','1','1','2025-07-29 00:15:57','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4024','21','21','2025-07-28','1','1','2025-07-28 20:17:12','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4025','11','21','2025-07-28','1','1','2025-07-28 20:15:01','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4026','35','23','2025-07-28','1','1','2025-07-28 20:03:30','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4027','83','23','2025-07-28','1','1','2025-07-28 20:05:14','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4028','77','23','2025-07-28','1','1','2025-07-28 20:11:15','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4029','79','23','2025-07-28','1','1','2025-07-28 20:03:59','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4030','76','23','2025-07-28','2','1','2025-07-29 08:05:55','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4031','61','31','2025-07-28','1','1','2025-07-28 20:15:44','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4032','102','21','2025-07-28','1','1','2025-07-28 20:07:27','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4033','103','23','2025-07-28','1','1','2025-07-28 20:14:22','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4034','100','21','2025-07-28','1','1','2025-07-28 20:05:51','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4035','97','23','2025-07-28','1','1','2025-07-28 20:01:04','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4036','34','21','2025-07-28','2','1','2025-07-29 08:04:41','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4037','15','21','2025-07-28','2','1','2025-07-29 08:02:21','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4038','62','21','2025-07-28','2','1','2025-07-29 08:03:55','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4039','63','21','2025-07-28','2','1','2025-07-29 08:03:07','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4040','80','23','2025-07-28','2','1','2025-07-29 08:05:03','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4041','84','23','2025-07-28','2','1','2025-07-29 08:04:52','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4042','82','23','2025-07-28','2','1','2025-07-29 08:03:27','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4043','36','31','2025-07-28','2','1','2025-07-29 08:09:15','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4044','98','23','2025-07-28','2','1','2025-07-29 08:02:14','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4045','19','21','2025-07-29','1','1','2025-07-30 00:34:49','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4046','21','21','2025-07-29','1','1','2025-07-29 20:07:01','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4047','11','21','2025-07-29','1','1','2025-07-29 20:15:07','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4048','35','23','2025-07-29','1','1','2025-07-29 20:10:59','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4049','83','23','2025-07-29','1','1','2025-07-29 20:04:01','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4050','77','23','2025-07-29','1','1','2025-07-29 20:12:22','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4051','79','23','2025-07-29','1','1','2025-07-30 08:00:39','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4052','61','31','2025-07-29','1','1','2025-07-29 20:07:04','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4053','102','21','2025-07-29','1','1','2025-07-29 20:15:23','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4054','103','23','2025-07-29','1','1','2025-07-29 20:08:35','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4055','100','21','2025-07-29','1','1','2025-07-29 20:11:26','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4056','97','23','2025-07-29','1','1','2025-07-29 20:00:51','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4057','34','21','2025-07-29','2','1','2025-07-30 08:15:34','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4058','15','21','2025-07-29','2','1','2025-07-30 08:05:32','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4059','62','21','2025-07-29','2','1','2025-07-30 08:09:51','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4060','63','21','2025-07-29','2','1','2025-07-30 08:05:02','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4061','80','23','2025-07-29','2','1','2025-07-30 08:02:48','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4062','84','23','2025-07-29','2','1','2025-07-30 08:01:45','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4063','76','23','2025-07-29','2','1','2025-07-30 08:08:43','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4064','82','23','2025-07-29','2','1','2025-07-30 08:04:00','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4065','36','31','2025-07-29','2','1','2025-07-30 08:03:14','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4066','98','23','2025-07-29','2','1','2025-07-30 08:00:50','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4067','19','21','2025-07-30','1','1','2025-07-31 00:15:40','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4068','21','21','2025-07-30','1','1','2025-07-30 20:19:49','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4069','11','21','2025-07-30','1','1','2025-07-30 20:11:24','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4070','35','23','2025-07-30','1','1','2025-07-30 20:05:45','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4071','83','23','2025-07-30','1','1','2025-07-30 20:02:27','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4072','77','23','2025-07-30','1','1','2025-07-30 20:10:32','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4073','61','31','2025-07-30','1','1','2025-07-30 20:07:24','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4074','102','21','2025-07-30','1','1','2025-07-30 20:16:53','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4075','103','23','2025-07-30','1','1','2025-07-30 20:11:08','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4076','100','21','2025-07-30','1','1','2025-07-30 20:17:24','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4077','97','23','2025-07-30','1','1','2025-07-30 20:01:47','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4078','34','21','2025-07-30','2','1','2025-07-31 08:09:07','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4079','15','21','2025-07-30','2','1','2025-07-31 08:01:47','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4080','62','21','2025-07-30','2','1','2025-07-31 08:02:16','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4081','63','21','2025-07-30','2','1','2025-07-31 08:03:38','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4082','80','23','2025-07-30','2','1','2025-07-31 08:02:47','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4083','84','23','2025-07-30','2','1','2025-07-31 08:09:00','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4084','79','23','2025-07-30','1','1','2025-07-31 20:03:55','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4085','76','23','2025-07-30','2','1','2025-07-31 08:06:35','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4086','82','23','2025-07-30','2','1','2025-07-31 08:02:27','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4087','36','31','2025-07-30','2','1','2025-07-31 08:14:36','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4088','98','23','2025-07-30','2','1','2025-07-31 08:02:31','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4089','19','21','2025-07-31','1','1','2025-08-01 00:16:09','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4090','21','21','2025-07-31','1','1','2025-07-31 20:07:59','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4091','11','21','2025-07-31','1','1','2025-07-31 20:10:05','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4092','35','23','2025-07-31','1','1','2025-07-31 20:02:25','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4093','83','23','2025-07-31','1','1','2025-07-31 20:01:29','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4094','77','23','2025-07-31','1','1','2025-07-31 20:08:39','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4095','61','31','2025-07-31','1','1','2025-07-31 20:06:25','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4096','102','21','2025-07-31','1','1','2025-07-31 20:08:31','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4097','103','23','2025-07-31','1','1','2025-07-31 20:05:53','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4098','100','21','2025-07-31','1','1','2025-07-31 20:04:05','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4099','97','23','2025-07-31','1','1','2025-07-31 20:00:54','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4100','34','21','2025-07-31','2','1','2025-08-01 08:06:01','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4101','15','21','2025-07-31','2','1','2025-08-01 08:01:24','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4102','62','21','2025-07-31','2','1','2025-08-01 08:04:06','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4103','63','21','2025-07-31','2','1','2025-08-01 08:01:36','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4104','80','23','2025-07-31','2','1','2025-08-01 08:03:38','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4105','84','23','2025-07-31','2','1','2025-08-01 08:04:36','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4106','76','23','2025-07-31','2','1','2025-08-01 08:01:39','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4107','82','23','2025-07-31','2','1','2025-08-01 08:06:13','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4108','36','31','2025-07-31','2','1','2025-08-01 08:07:29','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4109','98','23','2025-07-31','2','1','2025-08-01 08:03:13','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4110','19','21','2025-08-01','1','1','2025-08-02 00:48:36','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4111','21','21','2025-08-01','1','1','2025-08-01 20:20:14','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4112','11','21','2025-08-01','1','1','2025-08-01 20:13:48','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4113','35','23','2025-08-01','1','1','2025-08-01 20:05:50','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4114','83','23','2025-08-01','1','1','2025-08-01 20:12:05','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4115','77','23','2025-08-01','1','1','2025-08-01 20:08:49','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4116','79','23','2025-08-01','1','1','2025-08-01 20:07:15','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4117','61','31','2025-08-01','1','1','2025-08-01 20:06:29','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4118','102','21','2025-08-01','1','1','2025-08-01 20:15:02','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4119','103','23','2025-08-01','1','1','2025-08-01 20:08:17','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4120','100','21','2025-08-01','1','1','2025-08-01 20:12:37','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4121','97','23','2025-08-01','1','1','2025-08-01 20:01:16','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4122','34','21','2025-08-01','2','1','2025-08-02 08:04:12','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4123','15','21','2025-08-01','2','1','2025-08-02 08:03:38','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4124','62','21','2025-08-01','2','1','2025-08-02 08:09:33','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4125','63','21','2025-08-01','2','1','2025-08-02 08:01:04','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4126','80','23','2025-08-01','2','1','2025-08-02 08:02:32','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4127','84','23','2025-08-01','2','1','2025-08-02 08:07:15','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4128','76','23','2025-08-01','2','1','2025-08-02 08:01:32','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4129','82','23','2025-08-01','2','1','2025-08-02 08:05:30','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4130','36','31','2025-08-01','2','1','2025-08-02 08:02:29','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4131','98','23','2025-08-01','2','1','2025-08-02 08:01:00','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4132','107','32','2025-08-01','1','1','2025-08-01 20:01:58','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4133','108','23','2025-08-01','1','0',NULL,'0','249');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4134','19','21','2025-08-02','1','1','2025-08-03 00:18:35','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4135','21','21','2025-08-02','1','1','2025-08-02 20:19:45','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4136','11','21','2025-08-02','1','1','2025-08-02 20:14:46','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4138','83','23','2025-08-02','1','1','2025-08-02 20:04:07','55','55');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4139','77','23','2025-08-02','1','1','2025-08-02 20:01:33','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4140','79','23','2025-08-02','1','1','2025-08-02 20:21:33','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4141','61','31','2025-08-02','1','1','2025-08-02 20:08:56','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4142','102','21','2025-08-02','1','1','2025-08-02 20:13:22','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4143','103','23','2025-08-02','1','1','2025-08-02 20:35:11','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4144','100','21','2025-08-02','1','1','2025-08-02 20:13:55','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4145','97','23','2025-08-02','1','1','2025-08-02 20:01:35','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4146','107','32','2025-08-02','1','1','2025-08-02 20:01:33','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4147','34','21','2025-08-02','2','1','2025-08-03 08:10:30','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4148','15','21','2025-08-02','2','1','2025-08-03 08:04:17','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4149','62','21','2025-08-02','2','1','2025-08-03 08:02:34','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4150','63','21','2025-08-02','2','1','2025-08-03 08:05:04','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4151','80','23','2025-08-02','2','1','2025-08-03 08:09:28','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4152','84','23','2025-08-02','2','1','2025-08-03 08:01:00','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4153','76','23','2025-08-02','2','1','2025-08-03 08:01:50','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4154','82','23','2025-08-02','2','1','2025-08-03 08:03:19','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4155','36','31','2025-08-02','2','1','2025-08-03 08:10:22','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4156','98','23','2025-08-02','2','1','2025-08-03 08:03:03','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4157','109','32','2025-08-02','2','1','2025-08-03 12:26:55','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4158','19','21','2025-08-03','1','1','2025-08-04 00:32:41','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4159','21','21','2025-08-03','1','1','2025-08-03 20:04:31','36','36');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4160','11','21','2025-08-03','1','1','2025-08-03 20:14:38','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4161','83','23','2025-08-03','1','1','2025-08-03 20:02:39','54','54');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4162','77','23','2025-08-03','1','1','2025-08-03 20:05:22','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4163','79','23','2025-08-03','1','1','2025-08-03 20:03:06','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4164','61','31','2025-08-03','1','1','2025-08-03 20:11:25','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4165','102','21','2025-08-03','1','1','2025-08-03 20:08:16','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4166','103','23','2025-08-03','1','1','2025-08-03 20:19:32','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4167','100','21','2025-08-03','1','1','2025-08-03 20:06:25','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4168','97','23','2025-08-03','1','1','2025-08-03 20:01:44','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4169','107','32','2025-08-03','1','1','2025-08-04 08:11:51','25','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4170','34','21','2025-08-03','2','1','2025-08-04 08:14:53','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4171','15','21','2025-08-03','2','1','2025-08-04 08:04:27','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4172','62','21','2025-08-03','2','1','2025-08-04 08:04:30','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4173','63','21','2025-08-03','2','1','2025-08-04 08:06:26','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4174','80','23','2025-08-03','2','1','2025-08-04 08:02:02','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4175','84','23','2025-08-03','2','1','2025-08-04 08:04:04','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4176','76','23','2025-08-03','2','1','2025-08-04 08:02:42','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4177','82','23','2025-08-03','2','1','2025-08-04 08:03:21','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4178','36','31','2025-08-03','2','1','2025-08-04 08:03:11','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4179','98','23','2025-08-03','2','1','2025-08-04 08:01:36','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4180','109','32','2025-08-03','2','1','2025-08-04 08:12:12','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4181','19','21','2025-08-04','1','1','2025-08-05 00:18:43','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4182','21','21','2025-08-04','1','1','2025-08-04 20:16:27','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4183','11','21','2025-08-04','1','1','2025-08-04 20:14:32','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4184','83','23','2025-08-04','1','1','2025-08-04 20:03:25','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4185','77','23','2025-08-04','1','1','2025-08-04 20:02:09','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4186','79','23','2025-08-04','1','1','2025-08-04 20:04:42','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4187','61','31','2025-08-04','1','1','2025-08-04 20:09:23','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4188','102','21','2025-08-04','1','1','2025-08-04 20:17:31','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4190','100','21','2025-08-04','1','1','2025-08-04 20:13:44','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4191','97','23','2025-08-04','1','1','2025-08-04 20:02:27','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4192','15','21','2025-08-04','2','1','2025-08-05 08:10:49','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4193','62','21','2025-08-04','2','1','2025-08-05 08:04:22','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4194','63','21','2025-08-04','2','1','2025-08-05 08:05:38','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4195','80','23','2025-08-04','2','1','2025-08-05 08:04:07','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4196','35','23','2025-08-04','1','1','2025-08-04 20:19:19','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4197','84','23','2025-08-04','2','1','2025-08-05 08:04:41','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4198','76','23','2025-08-04','2','1','2025-08-05 08:01:19','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4199','82','23','2025-08-04','2','1','2025-08-05 08:02:31','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4200','36','31','2025-08-04','2','1','2025-08-05 08:03:54','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4202','107','32','2025-08-04','1','1','2025-08-04 20:00:51','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4203','109','32','2025-08-04','2','1','2025-08-05 20:01:02','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4204','34','21','2025-08-04','2','1','2025-08-05 08:05:59','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4205','103','23','2025-08-04','2','1','2025-08-05 08:12:54','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4206','98','23','2025-08-04','1','1','2025-08-04 20:22:21','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4207','19','21','2025-08-05','1','1','2025-08-06 00:16:36','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4208','21','21','2025-08-05','1','1','2025-08-05 20:21:34','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4209','11','21','2025-08-05','1','1','2025-08-05 20:07:33','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4210','35','23','2025-08-05','1','1','2025-08-05 20:10:04','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4211','83','23','2025-08-05','1','1','2025-08-05 20:01:50','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4212','77','23','2025-08-05','1','1','2025-08-05 20:07:37','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4213','79','23','2025-08-05','1','1','2025-08-05 20:04:11','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4214','61','31','2025-08-05','1','1','2025-08-05 20:07:13','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4215','102','21','2025-08-05','1','1','2025-08-05 20:06:57','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4216','100','21','2025-08-05','1','1','2025-08-05 20:01:38','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4217','98','23','2025-08-05','1','1','2025-08-05 20:01:32','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4218','97','23','2025-08-05','1','1','2025-08-05 20:01:23','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4219','107','32','2025-08-05','1','1','2025-08-05 20:06:02','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4220','34','21','2025-08-05','2','1','2025-08-06 08:05:15','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4221','15','21','2025-08-05','2','1','2025-08-06 08:00:59','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4222','62','21','2025-08-05','2','1','2025-08-06 08:11:31','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4223','63','21','2025-08-05','2','1','2025-08-06 08:03:17','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4224','80','23','2025-08-05','2','1','2025-08-06 08:09:26','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4225','84','23','2025-08-05','2','1','2025-08-06 08:01:16','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4226','76','23','2025-08-05','2','1','2025-08-06 08:02:51','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4227','82','23','2025-08-05','2','1','2025-08-06 08:05:16','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4228','36','31','2025-08-05','2','1','2025-08-06 08:02:25','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4229','103','23','2025-08-05','2','1','2025-08-06 08:07:22','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4230','109','32','2025-08-05','2','1','2025-08-06 20:06:59','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4231','19','21','2025-08-06','1','1','2025-08-07 00:16:25','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4232','21','21','2025-08-06','1','1','2025-08-06 20:05:20','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4233','11','21','2025-08-06','1','1','2025-08-06 20:06:03','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4234','35','23','2025-08-06','1','1','2025-08-06 20:15:54','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4235','83','23','2025-08-06','1','1','2025-08-06 20:10:12','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4236','77','23','2025-08-06','1','1','2025-08-06 20:02:27','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4237','79','23','2025-08-06','1','1','2025-08-06 20:02:26','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4238','61','31','2025-08-06','1','1','2025-08-06 20:08:06','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4239','102','21','2025-08-06','1','1','2025-08-06 20:11:13','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4240','100','21','2025-08-06','1','1','2025-08-06 20:05:56','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4241','98','23','2025-08-06','1','1','2025-08-06 20:04:45','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4242','97','23','2025-08-06','1','1','2025-08-06 20:02:06','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4243','107','32','2025-08-06','1','1','2025-08-06 20:06:48','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4244','34','21','2025-08-06','2','1','2025-08-07 08:03:28','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4245','15','21','2025-08-06','2','1','2025-08-07 08:02:38','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4246','62','21','2025-08-06','2','1','2025-08-07 08:04:04','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4247','63','21','2025-08-06','2','1','2025-08-07 08:03:50','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4248','80','23','2025-08-06','2','1','2025-08-07 08:04:46','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4249','84','23','2025-08-06','2','1','2025-08-07 08:04:16','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4250','76','23','2025-08-06','2','1','2025-08-07 08:01:32','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4251','82','23','2025-08-06','2','1','2025-08-07 08:02:00','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4252','36','31','2025-08-06','2','1','2025-08-07 08:02:01','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4253','103','23','2025-08-06','2','1','2025-08-07 08:05:01','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4254','19','21','2025-08-07','1','1','2025-08-08 00:15:45','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4255','21','21','2025-08-07','1','1','2025-08-07 20:14:10','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4256','11','21','2025-08-07','1','1','2025-08-07 20:11:36','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4257','35','23','2025-08-07','1','1','2025-08-07 20:13:52','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4258','83','23','2025-08-07','1','1','2025-08-07 20:07:23','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4259','77','23','2025-08-07','1','1','2025-08-07 20:01:25','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4260','79','23','2025-08-07','1','1','2025-08-07 20:01:38','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4261','61','31','2025-08-07','1','1','2025-08-07 20:07:58','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4262','102','21','2025-08-07','1','1','2025-08-07 20:08:15','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4263','100','21','2025-08-07','1','1','2025-08-07 20:12:07','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4264','98','23','2025-08-07','1','1','2025-08-07 20:03:53','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4265','97','23','2025-08-07','1','1','2025-08-07 20:01:51','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4266','107','32','2025-08-07','1','1','2025-08-07 20:01:51','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4267','109','32','2025-08-07','2','1','2025-08-08 08:03:35','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4268','34','21','2025-08-07','2','1','2025-08-08 08:03:10','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4269','15','21','2025-08-07','2','1','2025-08-08 08:01:42','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4270','62','21','2025-08-07','2','1','2025-08-08 08:05:41','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4271','63','21','2025-08-07','2','1','2025-08-08 08:01:36','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4272','80','23','2025-08-07','2','1','2025-08-08 08:01:36','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4273','84','23','2025-08-07','2','1','2025-08-08 08:03:52','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4274','76','23','2025-08-07','2','1','2025-08-08 08:02:11','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4275','82','23','2025-08-07','2','1','2025-08-08 08:06:03','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4276','36','31','2025-08-07','2','1','2025-08-08 08:08:37','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4277','103','23','2025-08-07','2','1','2025-08-08 08:04:03','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4278','110','32','2025-08-07','1','0',NULL,'0','1');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4279','19','21','2025-08-08','1','1','2025-08-09 00:33:16','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4280','21','21','2025-08-08','1','1','2025-08-08 20:16:43','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4281','11','21','2025-08-08','1','1','2025-08-08 20:10:14','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4282','35','23','2025-08-08','1','1','2025-08-08 20:14:24','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4283','83','23','2025-08-08','1','1','2025-08-08 20:01:06','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4284','77','23','2025-08-08','1','1','2025-08-08 20:04:34','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4285','79','23','2025-08-08','1','1','2025-08-08 20:02:47','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4286','61','31','2025-08-08','1','1','2025-08-08 20:07:22','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4287','102','21','2025-08-08','1','1','2025-08-08 20:11:56','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4288','100','21','2025-08-08','1','1','2025-08-08 20:12:18','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4289','98','23','2025-08-08','1','1','2025-08-08 20:01:06','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4290','97','23','2025-08-08','1','1','2025-08-08 20:03:12','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4291','107','32','2025-08-08','1','1','2025-08-08 20:02:42','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4292','34','21','2025-08-08','2','1','2025-08-09 08:16:42','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4293','15','21','2025-08-08','2','1','2025-08-09 08:09:05','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4294','62','21','2025-08-08','2','1','2025-08-09 08:10:37','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4295','63','21','2025-08-08','2','1','2025-08-09 08:03:21','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4296','80','23','2025-08-08','2','1','2025-08-09 08:04:01','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4297','84','23','2025-08-08','2','1','2025-08-09 08:03:08','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4298','76','23','2025-08-08','2','1','2025-08-09 08:02:13','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4299','82','23','2025-08-08','2','1','2025-08-09 08:03:42','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4300','36','31','2025-08-08','2','1','2025-08-09 08:04:05','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4301','103','23','2025-08-08','2','1','2025-08-09 08:03:57','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4302','109','32','2025-08-08','2','1','2025-08-09 08:01:34','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4303','19','21','2025-08-09','1','1','2025-08-10 00:16:57','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4304','21','21','2025-08-09','1','1','2025-08-09 20:08:04','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4305','11','21','2025-08-09','1','1','2025-08-09 20:03:50','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4306','35','23','2025-08-09','1','1','2025-08-09 20:04:10','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4307','83','23','2025-08-09','1','1','2025-08-09 20:06:25','55','55');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4308','77','23','2025-08-09','1','1','2025-08-09 20:09:05','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4309','79','23','2025-08-09','1','1','2025-08-09 20:03:16','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4310','61','31','2025-08-09','1','1','2025-08-09 20:06:15','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4311','102','21','2025-08-09','1','1','2025-08-09 20:08:24','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4312','100','21','2025-08-09','1','1','2025-08-09 20:06:26','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4313','98','23','2025-08-09','1','1','2025-08-09 20:01:51','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4314','97','23','2025-08-09','1','1','2025-08-09 20:01:39','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4315','107','32','2025-08-09','1','1','2025-08-09 20:02:49','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4316','34','21','2025-08-09','2','1','2025-08-10 08:11:19','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4317','15','21','2025-08-09','2','1','2025-08-10 08:01:01','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4318','62','21','2025-08-09','2','1','2025-08-10 08:06:34','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4319','63','21','2025-08-09','2','1','2025-08-10 08:05:06','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4320','80','23','2025-08-09','2','1','2025-08-10 08:06:05','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4321','84','23','2025-08-09','2','1','2025-08-10 08:06:07','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4322','76','23','2025-08-09','2','1','2025-08-10 08:16:08','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4323','82','23','2025-08-09','2','1','2025-08-10 08:04:03','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4324','36','31','2025-08-09','2','1','2025-08-10 08:08:24','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4325','103','23','2025-08-09','2','1','2025-08-10 08:04:51','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4326','109','32','2025-08-09','2','1','2025-08-10 08:01:18','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4327','19','21','2025-08-10','1','1','2025-08-11 00:16:26','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4328','21','21','2025-08-10','1','1','2025-08-10 20:11:23','36','36');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4329','11','21','2025-08-10','1','1','2025-08-10 20:12:57','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4330','35','23','2025-08-10','1','1','2025-08-10 20:17:04','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4331','83','23','2025-08-10','1','1','2025-08-10 20:07:06','54','54');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4332','77','23','2025-08-10','1','1','2025-08-10 20:05:50','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4333','79','23','2025-08-10','1','1','2025-08-11 08:13:24','0','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4334','61','31','2025-08-10','1','1','2025-08-10 20:07:30','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4335','102','21','2025-08-10','1','1','2025-08-10 20:10:08','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4336','100','21','2025-08-10','1','1','2025-08-10 20:11:15','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4337','98','23','2025-08-10','1','1','2025-08-10 20:01:40','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4338','97','23','2025-08-10','1','1','2025-08-10 20:01:55','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4339','107','32','2025-08-10','1','1','2025-08-10 20:01:06','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4340','34','21','2025-08-10','2','1','2025-08-11 08:13:05','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4341','15','21','2025-08-10','2','1','2025-08-11 08:03:31','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4342','62','21','2025-08-10','2','1','2025-08-11 08:07:20','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4343','63','21','2025-08-10','2','1','2025-08-11 08:02:45','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4344','80','23','2025-08-10','2','1','2025-08-11 08:02:33','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4345','84','23','2025-08-10','2','1','2025-08-11 08:02:16','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4346','76','23','2025-08-10','2','1','2025-08-11 08:02:26','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4347','82','23','2025-08-10','2','1','2025-08-11 08:01:23','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4348','36','31','2025-08-10','2','1','2025-08-11 08:05:54','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4349','103','23','2025-08-10','2','1','2025-08-11 08:03:04','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4350','109','32','2025-08-10','2','1','2025-08-11 08:00:54','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4351','19','21','2025-08-11','1','1','2025-08-12 00:18:46','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4352','21','21','2025-08-11','1','1','2025-08-11 20:11:50','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4353','11','21','2025-08-11','1','1','2025-08-11 20:12:01','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4354','35','23','2025-08-11','1','1','2025-08-11 20:13:48','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4355','83','23','2025-08-11','1','1','2025-08-11 20:04:04','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4356','77','23','2025-08-11','1','1','2025-08-11 20:01:55','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4357','61','31','2025-08-11','1','1','2025-08-11 20:06:02','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4358','102','21','2025-08-11','1','1','2025-08-11 20:15:48','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4359','100','21','2025-08-11','1','1','2025-08-11 20:11:34','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4360','98','23','2025-08-11','1','1','2025-08-11 20:00:53','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4361','97','23','2025-08-11','1','1','2025-08-11 20:01:19','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4362','107','32','2025-08-11','1','1','2025-08-11 20:01:36','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4363','34','21','2025-08-11','2','1','2025-08-12 08:10:08','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4364','15','21','2025-08-11','2','1','2025-08-12 08:03:23','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4365','62','21','2025-08-11','2','1','2025-08-12 08:05:57','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4366','63','21','2025-08-11','2','1','2025-08-12 08:01:59','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4367','80','23','2025-08-11','2','1','2025-08-12 08:10:02','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4368','84','23','2025-08-11','2','1','2025-08-12 08:08:29','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4369','79','23','2025-08-11','1','1','2025-08-11 20:05:44','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4370','76','23','2025-08-11','2','1','2025-08-12 08:05:05','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4371','82','23','2025-08-11','2','1','2025-08-12 08:08:46','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4372','36','31','2025-08-11','2','1','2025-08-12 08:04:23','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4373','103','23','2025-08-11','2','1','2025-08-12 08:03:44','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4374','109','32','2025-08-11','2','1','2025-08-12 08:01:12','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4375','19','21','2025-08-12','1','1','2025-08-13 00:16:52','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4376','21','21','2025-08-12','1','1','2025-08-12 20:17:27','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4377','11','21','2025-08-12','1','1','2025-08-12 20:11:52','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4378','35','23','2025-08-12','1','1','2025-08-12 20:14:31','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4379','83','23','2025-08-12','1','1','2025-08-12 20:09:57','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4380','77','23','2025-08-12','1','1','2025-08-12 20:03:08','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4381','79','23','2025-08-12','1','1','2025-08-12 20:01:36','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4382','61','31','2025-08-12','1','1','2025-08-12 20:05:12','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4383','102','21','2025-08-12','1','1','2025-08-12 20:05:59','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4384','100','21','2025-08-12','1','1','2025-08-12 20:12:59','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4385','98','23','2025-08-12','1','1','2025-08-12 20:01:56','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4386','97','23','2025-08-12','1','1','2025-08-12 20:02:27','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4387','107','32','2025-08-12','1','1','2025-08-12 20:01:45','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4388','34','21','2025-08-12','2','1','2025-08-13 08:11:42','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4389','15','21','2025-08-12','2','1','2025-08-13 08:10:08','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4390','62','21','2025-08-12','2','1','2025-08-13 08:05:38','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4391','63','21','2025-08-12','2','1','2025-08-13 08:03:07','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4392','80','23','2025-08-12','2','1','2025-08-13 08:04:36','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4393','84','23','2025-08-12','2','1','2025-08-13 08:02:46','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4394','76','23','2025-08-12','2','1','2025-08-13 08:01:27','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4395','82','23','2025-08-12','2','1','2025-08-13 08:04:42','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4396','36','31','2025-08-12','2','1','2025-08-13 08:02:30','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4397','103','23','2025-08-12','2','1','2025-08-13 08:04:40','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4398','109','32','2025-08-12','2','1','2025-08-13 08:01:28','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4399','19','21','2025-08-13','1','1','2025-08-14 00:34:15','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4400','21','21','2025-08-13','1','1','2025-08-13 20:23:29','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4401','11','21','2025-08-13','1','1','2025-08-13 20:12:24','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4402','35','23','2025-08-13','1','1','2025-08-13 20:21:18','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4403','83','23','2025-08-13','1','1','2025-08-13 20:05:05','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4404','77','23','2025-08-13','1','1','2025-08-13 20:01:21','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4405','79','23','2025-08-13','1','1','2025-08-13 20:03:28','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4406','61','31','2025-08-13','1','1','2025-08-13 20:07:30','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4407','102','21','2025-08-13','1','1','2025-08-13 20:13:42','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4408','100','21','2025-08-13','1','1','2025-08-13 20:12:13','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4409','98','23','2025-08-13','1','1','2025-08-13 20:01:22','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4410','97','23','2025-08-13','1','1','2025-08-13 20:02:33','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4411','107','32','2025-08-13','1','1','2025-08-13 20:01:21','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4412','34','21','2025-08-13','2','1','2025-08-14 08:02:36','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4413','15','21','2025-08-13','2','1','2025-08-14 08:15:34','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4414','62','21','2025-08-13','2','1','2025-08-14 08:04:24','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4415','63','21','2025-08-13','2','1','2025-08-14 08:04:41','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4416','80','23','2025-08-13','2','1','2025-08-14 08:10:03','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4417','84','23','2025-08-13','2','1','2025-08-14 08:07:31','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4418','76','23','2025-08-13','2','1','2025-08-14 08:02:49','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4419','82','23','2025-08-13','2','1','2025-08-14 20:12:12','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4420','36','31','2025-08-13','2','1','2025-08-14 08:04:37','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4421','103','23','2025-08-13','2','1','2025-08-14 08:03:42','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4422','109','32','2025-08-13','2','1','2025-08-14 08:02:50','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4423','19','21','2025-08-14','1','1','2025-08-15 00:16:50','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4424','21','21','2025-08-14','1','1','2025-08-14 20:13:06','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4425','11','21','2025-08-14','1','1','2025-08-14 20:09:34','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4426','35','23','2025-08-14','1','1','2025-08-14 20:15:40','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4427','83','23','2025-08-14','1','1','2025-08-14 20:08:10','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4428','77','23','2025-08-14','1','1','2025-08-14 20:01:36','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4429','79','23','2025-08-14','1','1','2025-08-14 20:09:04','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4430','61','31','2025-08-14','1','1','2025-08-14 20:07:35','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4431','102','21','2025-08-14','1','1','2025-08-14 20:12:20','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4432','100','21','2025-08-14','1','1','2025-08-14 20:05:33','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4433','98','23','2025-08-14','1','1','2025-08-14 20:00:34','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4434','97','23','2025-08-14','1','1','2025-08-14 20:03:08','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4435','107','32','2025-08-14','1','1','2025-08-14 20:01:53','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4436','34','21','2025-08-14','2','1','2025-08-15 08:03:08','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4437','15','21','2025-08-14','2','1','2025-08-15 08:05:46','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4438','62','21','2025-08-14','2','1','2025-08-15 08:05:50','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4439','63','21','2025-08-14','2','1','2025-08-15 08:05:13','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4440','80','23','2025-08-14','2','1','2025-08-15 08:04:30','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4441','84','23','2025-08-14','2','1','2025-08-15 08:08:00','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4442','76','23','2025-08-14','2','1','2025-08-15 08:03:00','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4443','36','31','2025-08-14','2','1','2025-08-15 08:05:43','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4444','103','23','2025-08-14','2','1','2025-08-15 08:02:41','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4445','109','32','2025-08-14','2','1','2025-08-15 08:00:36','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4446','82','23','2025-08-14','2','1','2025-08-15 08:01:04','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4447','19','21','2025-08-15','1','1','2025-08-16 00:16:18','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4448','21','21','2025-08-15','1','1','2025-08-15 20:10:29','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4449','11','21','2025-08-15','1','1','2025-08-15 20:10:23','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4450','35','23','2025-08-15','1','1','2025-08-15 20:19:15','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4451','83','23','2025-08-15','1','1','2025-08-15 20:24:01','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4452','77','23','2025-08-15','1','1','2025-08-15 20:00:51','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4453','79','23','2025-08-15','1','1','2025-08-15 20:24:58','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4454','61','31','2025-08-15','1','1','2025-08-15 20:02:16','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4455','102','21','2025-08-15','1','1','2025-08-15 20:10:15','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4456','100','21','2025-08-15','1','1','2025-08-15 20:01:56','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4457','98','23','2025-08-15','1','1','2025-08-15 20:01:28','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4458','97','23','2025-08-15','1','1','2025-08-15 20:04:15','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4459','107','32','2025-08-15','1','1','2025-08-15 20:08:25','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4460','34','21','2025-08-15','2','1','2025-08-16 08:06:06','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4461','15','21','2025-08-15','2','1','2025-08-16 08:03:40','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4462','62','21','2025-08-15','2','1','2025-08-16 08:05:24','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4463','63','21','2025-08-15','2','1','2025-08-16 08:00:35','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4464','80','23','2025-08-15','2','1','2025-08-16 08:06:02','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4465','84','23','2025-08-15','2','1','2025-08-16 08:04:43','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4466','76','23','2025-08-15','2','1','2025-08-16 08:02:09','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4467','82','23','2025-08-15','2','1','2025-08-16 08:01:14','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4468','36','31','2025-08-15','2','1','2025-08-16 08:01:58','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4469','103','23','2025-08-15','2','1','2025-08-16 08:04:27','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4470','109','32','2025-08-15','2','1','2025-08-16 08:01:28','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4471','19','21','2025-08-16','1','1','2025-08-17 00:17:44','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4472','21','21','2025-08-16','1','1','2025-08-16 20:12:32','37','37');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4473','11','21','2025-08-16','1','1','2025-08-16 20:11:25','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4474','35','23','2025-08-16','1','1','2025-08-17 20:09:59','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4475','83','23','2025-08-16','1','1','2025-08-16 20:07:32','55','55');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4476','77','23','2025-08-16','1','1','2025-08-16 20:06:35','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4477','79','23','2025-08-16','1','1','2025-08-16 20:12:30','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4478','61','31','2025-08-16','1','1','2025-08-16 20:05:56','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4479','102','21','2025-08-16','1','1','2025-08-16 20:15:56','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4480','100','21','2025-08-16','1','1','2025-08-16 20:05:57','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4481','98','23','2025-08-16','1','1','2025-08-16 20:02:18','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4482','97','23','2025-08-16','1','1','2025-08-16 20:01:59','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4483','107','32','2025-08-16','1','1','2025-08-16 20:02:33','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4484','34','21','2025-08-16','2','1','2025-08-17 08:04:05','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4485','15','21','2025-08-16','2','1','2025-08-17 08:01:53','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4486','62','21','2025-08-16','2','1','2025-08-17 08:06:38','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4487','63','21','2025-08-16','2','1','2025-08-17 08:05:48','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4488','80','23','2025-08-16','2','1','2025-08-17 08:02:35','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4489','84','23','2025-08-16','2','1','2025-08-17 08:05:56','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4490','76','23','2025-08-16','2','1','2025-08-17 08:03:38','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4491','82','23','2025-08-16','2','1','2025-08-17 08:01:02','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4492','36','31','2025-08-16','2','1','2025-08-17 08:02:06','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4493','103','23','2025-08-16','2','1','2025-08-17 08:04:08','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4494','109','32','2025-08-16','2','1','2025-08-17 08:03:27','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4495','19','21','2025-08-17','1','1','2025-08-18 00:16:01','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4496','21','21','2025-08-17','1','1','2025-08-17 20:10:50','36','36');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4497','11','21','2025-08-17','1','1','2025-08-17 20:05:52','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4498','83','23','2025-08-17','1','1','2025-08-17 20:05:38','54','54');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4499','77','23','2025-08-17','1','1','2025-08-17 20:11:04','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4500','79','23','2025-08-17','1','1','2025-08-18 20:02:34','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4501','61','31','2025-08-17','1','1','2025-08-17 20:04:07','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4502','102','21','2025-08-17','1','1','2025-08-17 20:00:39','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4503','100','21','2025-08-17','1','1','2025-08-17 20:07:05','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4504','98','23','2025-08-17','1','1','2025-08-17 20:01:56','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4505','97','23','2025-08-17','1','1','2025-08-17 20:03:23','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4506','107','32','2025-08-17','1','1','2025-08-17 20:02:57','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4507','34','21','2025-08-17','2','1','2025-08-18 08:07:34','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4508','15','21','2025-08-17','2','1','2025-08-18 08:00:34','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4509','62','21','2025-08-17','2','1','2025-08-18 08:07:25','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4510','63','21','2025-08-17','2','1','2025-08-18 08:06:41','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4511','80','23','2025-08-17','2','1','2025-08-18 08:02:21','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4512','84','23','2025-08-17','2','1','2025-08-18 08:01:31','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4513','76','23','2025-08-17','2','1','2025-08-18 08:01:25','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4514','82','23','2025-08-17','2','1','2025-08-18 08:01:48','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4515','36','31','2025-08-17','2','1','2025-08-18 08:04:00','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4516','103','23','2025-08-17','2','1','2025-08-18 08:04:16','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4517','109','32','2025-08-17','2','1','2025-08-18 08:04:33','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4518','19','21','2025-08-18','1','1','2025-08-19 00:36:04','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4519','21','21','2025-08-18','1','1','2025-08-18 20:15:34','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4520','11','21','2025-08-18','1','1','2025-08-18 20:11:25','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4521','35','23','2025-08-18','1','1','2025-08-18 20:12:55','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4522','83','23','2025-08-18','1','1','2025-08-18 20:06:52','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4523','77','23','2025-08-18','1','1','2025-08-18 20:03:07','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4524','61','31','2025-08-18','1','1','2025-08-18 20:05:59','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4525','102','21','2025-08-18','1','1','2025-08-18 20:10:16','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4526','100','21','2025-08-18','1','1','2025-08-18 20:05:44','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4527','98','23','2025-08-18','1','1','2025-08-18 20:05:43','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4528','97','23','2025-08-18','1','1','2025-08-18 20:03:38','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4529','107','32','2025-08-18','1','1','2025-08-18 20:05:35','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4530','34','21','2025-08-18','2','1','2025-08-19 08:09:14','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4531','15','21','2025-08-18','2','1','2025-08-19 08:03:19','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4532','62','21','2025-08-18','2','1','2025-08-19 08:04:36','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4533','63','21','2025-08-18','2','1','2025-08-19 08:14:26','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4534','80','23','2025-08-18','2','1','2025-08-19 08:02:20','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4535','84','23','2025-08-18','2','1','2025-08-19 08:02:39','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4536','76','23','2025-08-18','2','1','2025-08-19 08:01:27','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4537','82','23','2025-08-18','2','1','2025-08-19 08:02:41','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4538','36','31','2025-08-18','2','1','2025-08-19 08:03:44','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4539','103','23','2025-08-18','2','1','2025-08-19 08:07:14','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4540','109','32','2025-08-18','2','1','2025-08-19 19:48:18','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4541','19','21','2025-08-19','1','1','2025-08-20 00:15:28','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4542','21','21','2025-08-19','1','1','2025-08-19 20:18:05','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4543','11','21','2025-08-19','1','1','2025-08-19 20:07:38','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4544','35','23','2025-08-19','1','1','2025-08-19 20:19:34','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4545','83','23','2025-08-19','1','1','2025-08-19 20:08:51','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4546','77','23','2025-08-19','1','1','2025-08-19 20:05:59','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4547','79','23','2025-08-19','1','1','2025-08-19 20:07:11','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4548','61','31','2025-08-19','1','1','2025-08-19 20:05:13','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4549','102','21','2025-08-19','1','1','2025-08-19 20:12:19','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4550','100','21','2025-08-19','1','1','2025-08-20 07:43:42','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4551','98','23','2025-08-19','1','1','2025-08-19 20:02:45','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4552','97','23','2025-08-19','1','1','2025-08-19 20:03:10','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4553','107','32','2025-08-19','1','1','2025-08-20 07:57:48','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4554','34','21','2025-08-19','2','1','2025-08-20 08:13:33','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4555','15','21','2025-08-19','2','1','2025-08-20 08:04:17','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4556','62','21','2025-08-19','2','1','2025-08-20 08:08:13','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4557','63','21','2025-08-19','2','1','2025-08-20 08:08:17','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4558','80','23','2025-08-19','2','1','2025-08-20 08:04:31','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4559','84','23','2025-08-19','2','1','2025-08-20 08:03:11','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4560','76','23','2025-08-19','2','1','2025-08-20 08:04:03','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4561','82','23','2025-08-19','2','1','2025-08-20 08:02:20','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4562','36','31','2025-08-19','2','1','2025-08-20 08:03:35','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4563','103','23','2025-08-19','2','1','2025-08-20 08:05:14','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4564','19','21','2025-08-20','1','1','2025-08-21 00:22:28','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4565','21','21','2025-08-20','1','1','2025-08-20 20:15:14','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4566','11','21','2025-08-20','1','1','2025-08-20 20:10:49','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4567','35','23','2025-08-20','1','1','2025-08-20 20:39:52','64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4568','83','23','2025-08-20','1','1','2025-08-20 20:08:07','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4569','77','23','2025-08-20','1','1','2025-08-20 20:12:03','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4570','79','23','2025-08-20','1','1','2025-08-20 20:04:35','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4571','61','31','2025-08-20','1','1','2025-08-20 20:05:34','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4572','102','21','2025-08-20','1','1','2025-08-20 20:12:23','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4573','98','23','2025-08-20','1','1','2025-08-21 07:53:55','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4574','97','23','2025-08-20','1','1','2025-08-20 20:02:35','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4575','109','32','2025-08-20','2','1','2025-08-21 08:03:58','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4576','34','21','2025-08-20','2','1','2025-08-21 08:12:33','91','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4577','15','21','2025-08-20','2','1','2025-08-21 08:02:49','25','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4578','62','21','2025-08-20','2','1','2025-08-21 08:09:05','32','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4579','63','21','2025-08-20','2','1','2025-08-21 08:02:46','51','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4580','80','23','2025-08-20','2','1','2025-08-21 08:04:45','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4581','84','23','2025-08-20','2','1','2025-08-21 08:07:45','97','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4582','76','23','2025-08-20','2','1','2025-08-21 08:01:52','31','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4583','82','23','2025-08-20','2','1','2025-08-21 08:01:57','33','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4584','36','31','2025-08-20','2','1','2025-08-21 08:04:24','49','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4585','103','23','2025-08-20','2','1','2025-08-21 08:09:56','13','13');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4586','100','21','2025-08-20','1','1','2025-08-20 22:31:33','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4587','107','32','2025-08-20','1','1','2025-08-21 18:04:42','27','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4588','19','21','2025-08-21','1','1','2025-08-22 00:17:21','101','101');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4589','21','21','2025-08-21','1','1','2025-08-21 20:11:02','38','38');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4590','11','21','2025-08-21','1','1','2025-08-21 20:09:03','26','26');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4591','35','23','2025-08-21','1','0',NULL,'64','64');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4592','83','23','2025-08-21','1','1','2025-08-21 20:04:17','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4593','77','23','2025-08-21','1','1','2025-08-21 20:03:31','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4595','61','31','2025-08-21','1','1','2025-08-21 20:06:10','46','46');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4596','102','21','2025-08-21','1','1','2025-08-21 20:02:07','62','62');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4597','100','21','2025-08-21','1','1','2025-08-21 20:12:37','56','56');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4598','97','23','2025-08-21','1','1','2025-08-21 20:01:55','57','57');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4599','34','21','2025-08-21','2','0',NULL,'40','91');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4600','15','21','2025-08-21','2','0',NULL,'10','25');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4601','62','21','2025-08-21','2','0',NULL,'15','32');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4602','63','21','2025-08-21','2','0',NULL,'18','51');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4603','80','23','2025-08-21','2','0',NULL,'12','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4604','84','23','2025-08-21','2','0',NULL,'44','97');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4605','76','23','2025-08-21','2','0',NULL,'17','31');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4606','82','23','2025-08-21','2','0',NULL,'19','33');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4607','36','31','2025-08-21','2','0',NULL,'20','49');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4608','109','32','2025-08-21','2','0',NULL,'11','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4609','98','33','2025-08-21','1','1','2025-08-21 20:41:55','142','142');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4610','79','33','2025-08-21','1','1','2025-08-21 23:01:21','96','96');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4611','107','32','2025-08-21','1','0',NULL,'2','27');
INSERT INTO `duty` (`id`,`guard_id`,`loc_id`,`dt`,`shift`,`complete`,`dtm`,`num1`,`num2`) VALUES ('4612','103','33','2025-08-21','2','0',NULL,'15','41');

--
-- Structure for table `duty_task`
--
CREATE TABLE `duty_task` (
  `id` int NOT NULL AUTO_INCREMENT,
  `duty_id` int NOT NULL DEFAULT '0',
  `task_id` int NOT NULL DEFAULT '0',
  `area` text,
  `status` int NOT NULL DEFAULT '0',
  `sdtm` datetime DEFAULT NULL,
  `dtm` datetime DEFAULT NULL,
  `gps` text,
  `iremark` text,
  `problem` int NOT NULL DEFAULT '0',
  `remark` text CHARACTER SET latin1 COLLATE latin1_swedish_ci,
  `pdone` int NOT NULL DEFAULT '0',
  `pdonedtm` datetime DEFAULT NULL,
  `premark` text,
  `employee_id` int DEFAULT NULL,
  `name` text,
  `info` text,
  `tm` text,
  `dur` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `FK_duty_task_duty_id` (`duty_id`),
  KEY `FK_duty_task_task_id` (`task_id`),
  CONSTRAINT `FK_duty_task_duty_id` FOREIGN KEY (`duty_id`) REFERENCES `duty` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `FK_duty_task_task_id` FOREIGN KEY (`task_id`) REFERENCES `task` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=214459 DEFAULT CHARSET=latin1;

--
-- Data for table `duty_task`
--
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('15832','652','43','Roll Call','1','2025-02-10 08:08:29','2025-02-10 08:10:41','','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.riez\r\n4.aiman\r\n5.anit','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('16844','671','43','Roll Call','1','2025-02-11 08:06:38','2025-02-11 08:09:44','3.0822861,101.7006776','Security Personnel On-Duty Report:\r\n1.judda\r\n2.riez\r\n3.dipak\r\n4.aiman\r\n5.anit','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('17314','680','43','Roll Call','1','2025-02-12 08:17:30','2025-02-12 08:20:47','3.0827971,101.7004563','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.durga\r\n5.laxuman','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('17772','688','43','Roll Call','1','2025-02-13 08:13:01','2025-02-13 08:16:17','3.0823752,101.7005261','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.aiman\r\n4.anit\r\n5.bartaman','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('19106','713','43','Roll Call','1','2025-02-14 08:14:39','2025-02-14 08:19:22','3.0821449,101.7007811','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.durga\r\n5.laxuman','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('19604','722','43','Roll Call','1','2025-02-15 08:16:10','2025-02-15 08:20:05','3.0821284,101.7006653','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.brataman\r\n5.durga','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('20003','730','43','Roll Call','1','2025-02-16 08:12:31','2025-02-16 08:19:40','3.0821756,101.7008171','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.aiman\r\n4.anit\r\n5.durga','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('20333','730','43','Roll Call','1','2025-02-16 21:01:45','2025-02-16 21:21:07','3.0826751,101.6989147','Security Personnel On-Duty Report:\r\n1.judda\r\n2.laxuman\r\n3.brataman\r\n4.hasta\r\n5.aiman','0','','0',NULL,NULL,NULL,'','','20:02','120');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('20444','738','43','Roll Call','1','2025-02-17 08:07:23','2025-02-17 08:12:22','3.0822763,101.700634','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.adam\r\n5.laxuman','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('20912','748','43','Roll Call','1','2025-02-18 08:08:15','2025-02-18 08:12:05','3.0821531,101.7008426','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.farit\r\n5.laxuman','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('21524','758','43','Roll Call','1','2025-02-19 08:10:41','2025-02-19 08:16:45','3.0823183333333333,101.70084166666666','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.aiman\r\n5.farid','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('22339','777','43','Roll Call','1','2025-02-20 08:10:22','2025-02-20 08:12:17','3.0822921,101.7007148','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.aiman\r\n5.farid','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('22810','786','43','Roll Call','1','2025-02-21 08:03:04','2025-02-21 08:08:16','3.0828006,101.7004349','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.aiman\r\n4.anit\r\n5.farid','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('23397','795','43','Roll Call','1','2025-02-22 08:04:00','2025-02-22 08:07:08','3.0824532,101.7005199','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.aiman\r\n5.farid','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('23868','804','43','Roll Call','1','2025-02-23 08:13:32','2025-02-23 08:16:17','3.0821657,101.7007253','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.durga\r\n5.laxuman','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('24336','813','43','Roll Call','1','2025-02-24 08:14:12','2025-02-24 08:17:34','3.0826978,101.6991942','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.durga\r\n5.laxuma','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('24807','822','43','Roll Call','1','2025-02-25 08:10:01','2025-02-25 08:13:52','3.0825819,101.6994974','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.aint\r\n4.durga\r\n5.laxuman','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('25847','847','43','Roll Call','1','2025-02-26 08:14:09','2025-02-26 08:19:49','3.0817929,101.7013142','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.fitri\r\n5.ridzuan','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('27279','874','43','Roll Call','1','2025-02-27 08:11:02','2025-02-27 08:13:21','3.0823465,101.6995487','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.durga\r\n5.laxuman','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('27784','886','43','Roll Call','1','2025-02-28 08:05:13','2025-02-28 08:09:25','3.0831749999999998,101.70132','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.aiman\r\n4.anit\r\n5.durga','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('28895','910','43','Roll Call','1','2025-03-01 08:14:27','2025-03-01 08:19:14','3.0822263,101.7008618','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.laxuman\r\n5.durga','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('30138','940','43','Roll Call','1','2025-03-02 09:14:28','2025-03-02 09:15:04','3.0822986,101.6994921','','1','System issues ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('30528','946','43','Roll Call','1','2025-03-03 08:10:54','2025-03-03 08:15:46','3.0800041,101.7038995','Security Personnel On-Duty Report:\r\n1.\r\n2.\r\n3.\r\n4.\r\n5.Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.laxuman\r\n5.durga','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('31200','963','43','Roll Call','1','2025-03-04 08:13:20','2025-03-04 08:15:12','3.0805565,101.7020258','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.brataman\r\n5.durga','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('31957','981','43','Roll Call','1','2025-03-05 08:12:37','2025-03-05 08:15:06','3.0832162,101.7013144','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.aiman\r\n4.laxuman\r\n5.anit','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('33024','1004','43','Roll Call','1','2025-03-06 08:10:27','2025-03-06 08:12:51','3.082555,101.70086666666666','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.adam\r\n5.durga','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('33679','1021','43','Roll Call','1','2025-03-07 08:05:46','2025-03-07 08:07:29','3.0795764,101.703946','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.adam\r\n5.aiman','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('34336','1038','43','Roll Call','1','2025-03-08 08:07:04','2025-03-08 08:09:40','3.0821213,101.7005486','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.adam\r\n5.durga','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('35139','1055','43','Roll Call','1','2025-03-09 08:04:03','2025-03-09 08:13:18','3.0827337,101.7009579','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.aint\r\n4.adam\r\n5.aiman','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('35997','1074','43','Roll Call','1','2025-03-10 08:15:13','2025-03-10 08:18:54','3.0821449,101.70008','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.aiman\r\n5.adam','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('37097','1094','43','Roll Call','1','2025-03-11 08:11:43','2025-03-11 08:13:31','3.082191666666667,101.70211666666667','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.brataman\r\n5.durga','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('37830','1110','43','Roll Call','1','2025-03-12 08:12:33','2025-03-12 08:16:01','3.0832566666666668,101.70130499999999','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.laxuman\r\n5.durga','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('38694','1127','43','Roll Call','1','2025-03-13 08:09:21','2025-03-13 08:14:54','3.0824651,101.7001878','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.brataman\r\n5.durga','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('39500','1143','43','Roll Call','1','2025-03-14 08:10:32','2025-03-14 08:12:17','3.0825032,101.7007889','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.adam\r\n5.laxuman','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('40724','1167','43','Roll Call','1','2025-03-15 08:08:35','2025-03-15 08:12:42','3.0823459,101.6993909','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.aiman\r\n5.adam','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('42046','1191','43','Roll Call','1','2025-03-16 08:14:23','2025-03-16 08:15:47','3.0797718,101.7039928','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.aiman\r\n5.laxuman','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('42756','1209','43','Roll Call','1','2025-03-17 08:11:30','2025-03-17 08:13:36','3.0821849,101.700868','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.aiman\r\n5.brataman','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('43905','1233','43','Roll Call','1','2025-03-18 08:07:26','2025-03-18 08:08:58','3.0822891,101.7006224','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.aiman\r\n5.adam','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('44974','1259','43','Roll Call','1','2025-03-19 08:09:16','2025-03-19 08:12:11','3.0821272,101.7007479','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.aiman\r\n5.durga','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('46044','1279','43','Roll Call','1','2025-03-20 08:11:42','2025-03-20 08:13:30','3.0822027,101.7008417','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.adam\r\n5.laxuman','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('46596','1290','43','Roll Call','1','2025-03-21 08:10:11','2025-03-21 08:12:39','3.0822116,101.7008127','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.hasta\r\n5.adam','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('47507','1310','43','Roll Call','1','2025-03-22 08:10:06','2025-03-22 08:12:02','3.080021,101.7038875','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.adam\r\n5.durga','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('48691','1341','43','Roll Call','1','2025-03-23 08:09:14','2025-03-23 08:12:57','3.0822204,101.7008347','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.adam\r\n5.aiman','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('49685','1361','43','Roll Call','1','2025-03-24 08:10:39','2025-03-24 08:13:10','3.0847283333333335,101.69809666666667','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.adam\r\n5.aiman','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('50282','1373','43','Roll Call','1','2025-03-25 08:10:42','2025-03-25 08:12:28','3.08225,101.70084833333334','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.aiman\r\n5.brataman','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('51273','1394','43','Roll Call','1','2025-03-26 08:06:09','2025-03-26 08:07:44','3.0815698,101.7023323','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.adam\r\n5.laxuman','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('52878','1430','43','Roll Call','1','2025-03-27 09:02:06','2025-03-27 09:06:45','3.0821956,101.7008906','','1','System issues ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('53401','1441','43','Roll Call','1','2025-03-28 08:13:33','2025-03-28 08:16:03','3.0815678,101.7023286','Security Personnel On-Duty Report:\r\n1. judda \r\n2. DIPAk \r\n3.anit\r\n4. laxuman \r\n5. Durga ','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('53953','1453','43','Roll Call','1','2025-03-29 08:10:45','2025-03-29 08:13:51','3.0817968,101.7009584','Security Personnel On-Duty Report:\r\n1. judda \r\n2. DIPAk \r\n3. anti \r\n4. bartaman \r\n5. Adam ','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('55433','1485','43','Roll Call','1','2025-03-30 08:10:36','2025-03-30 08:20:05','3.0821119,101.7002468','Security Personnel On-Duty Report:\r\n1. judda \r\n2. DIPAk \r\n3.aint \r\n4.adam \r\n5. laxuman ','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56175','1500','4678','Patrolling Block A - PH','1','2025-03-30 17:33:28','2025-03-30 17:34:33','3.0828732,101.7001462','Performed a thorough patrol on Level 10, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56176','1500','4679','Patrolling Block A - PH','1','2025-03-30 17:24:15','2025-03-30 17:27:52','','','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56177','1500','4680','Patrolling Block A - PH','1','2025-03-30 17:23:05','2025-03-30 17:24:14','3.0830703,101.7007132','Performed a thorough patrol on Level 16, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56178','1500','4681','Patrolling Block A - PH','1','2025-03-30 17:21:30','2025-03-30 17:23:03','3.0826107,101.7000521','Performed a thorough patrol on Level 17, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56179','1500','4682','Patrolling Block A - PH','1','2025-03-30 17:20:07','2025-03-30 17:21:29','3.082747,101.7001367','Performed a thorough patrol on Level 18, no incidents were reported and no issues were found.\r\n','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56180','1500','4683','Patrolling Block A - PH','1','2025-03-30 17:19:17','2025-03-30 17:20:00','3.0828011,101.7001629','Performed a thorough patrol on Level 19, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56181','1500','4684','Patrolling Block A - PH','1','2025-03-30 17:15:20','2025-03-30 17:18:28','3.0828006,101.700165','Performed a thorough patrol on Level 20, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56182','1500','4685','Patrolling Block A - PH','1','2025-03-30 17:13:08','2025-03-30 17:14:35','3.0827974,101.7001532','Performed a thorough patrol on Level 21, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56183','1500','4686','Patrolling Block A - PH','1','2025-03-30 17:02:40','2025-03-30 17:04:29','3.0842838,101.7007772','Performed a thorough patrol on Level 27, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56184','1500','4687','Patrolling Block A - PH','1','2025-03-30 17:27:54','2025-03-30 17:29:02','3.082554,101.6999258','Performed a thorough patrol on Level 14, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56185','1500','4688','Patrolling Block A - PH','1','2025-03-30 16:31:55','2025-03-30 16:43:15','3.0826865,101.7001309','','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56186','1500','4689','Patrolling Block A - PH','1','2025-03-30 16:39:57','2025-03-30 16:41:48','3.0830493,101.7004982','Performed a thorough patrol on Level 39, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56187','1500','4690','Patrolling Block A - PH','1','2025-03-30 17:29:19','2025-03-30 17:30:27','3.0827461,101.7001809','Performed a thorough patrol on Level 13, no incidents were reported and no issues were found','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56188','1500','4691','Patrolling Block A - PH','1','2025-03-30 16:32:08','2025-03-30 16:39:52','3.082573,101.6999515','','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56189','1500','4692','Patrolling Block A - PH','1','2025-03-30 16:31:31','2025-03-30 16:38:36','3.0788712,101.6972391','Performed a thorough patrol on Level 41, no incidents were reported and no issues were found.\r\nInformation Remarks\r\nPhotos','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56190','1500','4693','Patrolling Block A - PH','1','2025-03-30 16:32:09','2025-03-30 17:35:59','3.0828627,101.7002358','Performed a thorough patrol on Level 9\r\n, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56191','1500','4694','Patrolling Block A - PH','1','2025-03-30 17:31:09','2025-03-30 17:31:48','3.0827444,101.7002751','Performed a thorough patrol on Level 12, no incidents were reported and no issues were found','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56192','1500','4695','Patrolling Block A - PH','1','2025-03-30 17:31:52','2025-03-30 17:33:22','3.0826569,101.7003065','Performed a thorough patrol on Level 11, no incidents were reported and no issues were found','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56193','1500','4696','Patrolling Block A - PH','1','2025-03-30 17:05:20','2025-03-30 17:06:17','3.0828081,101.7001088','Performed a thorough patrol on Level 26, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56194','1500','4697','Patrolling Block A - PH','1','2025-03-30 17:06:18','2025-03-30 17:07:30','3.082904,101.7002139','Performed a thorough patrol on Level 25, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56195','1500','4698','Patrolling Block A - PH','1','2025-03-30 17:07:32','2025-03-30 17:09:11','3.0829504,101.7002495','Performed a thorough patrol on Level 24, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56196','1500','4699','Patrolling Block A - PH','1','2025-03-30 17:09:15','2025-03-30 17:11:29','3.0828977,101.7002106','Performed a thorough patrol on Level 23, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56197','1500','4700','Patrolling Block A - PH','1','2025-03-30 17:11:33','2025-03-30 17:13:00','3.0827988,101.7001915','Performed a thorough patrol on Level 22, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56198','1500','4701','Patrolling Block A - PH','1','2025-03-30 16:43:17','2025-03-30 16:46:10','3.0826877,101.7001353','Performed a thorough patrol on Level 37, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56199','1500','4702','Patrolling Block A - PH','1','2025-03-30 16:46:12','2025-03-30 16:48:08','3.0817627,101.6994796','Performed a thorough patrol on Level 36, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56200','1500','4703','Patrolling Block A - PH','1','2025-03-30 16:48:12','2025-03-30 16:49:46','3.0770681,101.6974585','Performed a thorough patrol on Level 35, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56201','1500','4704','Patrolling Block A - PH','1','2025-03-30 16:50:25','2025-03-30 16:51:24','3.0827729,101.6999637','Performed a thorough patrol on Level 34, no incidents were reported and no issues were found.\r\n','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56202','1500','4705','Patrolling Block A - PH','1','2025-03-30 16:51:25','2025-03-30 16:53:01','3.0828121,101.6999763','Performed a thorough patrol on Level 33, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56203','1500','4706','Patrolling Block A - PH','1','2025-03-30 16:53:29','2025-03-30 16:54:50','3.0828291,101.6999905','Performed a thorough patrol on Level 32, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56204','1500','4707','Patrolling Block A - PH','1','2025-03-30 16:55:36','2025-03-30 16:57:10','3.0768904,101.6971442','Performed a thorough patrol on Level 31, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56205','1500','4708','Patrolling Block A - PH','1','2025-03-30 16:57:57','2025-03-30 16:59:15','3.0828904,101.6998966','Performed a thorough patrol on Level 30, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56206','1500','4709','Patrolling Block A - PH','1','2025-03-30 16:59:38','2025-03-30 17:00:12','3.0832041,101.7007549','','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56207','1500','4710','Patrolling Block A - PH','1','2025-03-30 17:00:14','2025-03-30 17:02:38','3.0783543,101.6960664','Performed a thorough patrol on Level 28, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56220','1501','4941','Level 8','1','2025-03-30 20:18:21','2025-03-30 20:20:21','3.085338,101.6998307','Handover & Inventory Check:\r\nWalkie-Talkie (1)\r\nBaton (1)\r\nAccess Card (1)\r\nBodycam (1)\r\nGym Pass (11)','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56221','1501','5041','Real-Time Report','1','2025-03-30 20:02:59','2025-03-30 20:03:28','3.0819891,101.7008526','Report Duty at 08 00 pm ','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56222','1501','5042','Real-Time Report','1','2025-03-31 08:01:11','2025-03-31 08:01:39','3.0826443,101.7008343','Off Duty at 08:00 am ','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56223','1501','5043','Real-Time Report','1','2025-03-30 22:11:43','2025-03-30 22:11:59','3.082415,101.7006026','Hourly report submitted at 10:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56224','1501','5044','Real-Time Report','1','2025-03-30 23:05:50','2025-03-30 23:06:07','3.0834156,101.7004501','Hourly report submitted at 11:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56225','1501','5045','Real-Time Report','1','2025-03-31 00:05:17','2025-03-31 00:05:40','3.0823649,101.7004999','Hourly report submitted at 12:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56226','1501','5046','Real-Time Report','1','2025-03-31 01:04:55','2025-03-31 01:05:15','3.0824848,101.7003463','Hourly report submitted at 01:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56227','1501','5047','Real-Time Report','1','2025-03-31 02:02:54','2025-03-31 02:03:15','3.0823657,101.7004967','Hourly report submitted 02:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56228','1501','5048','Real-Time Report','1','2025-03-31 03:10:40','2025-03-31 03:12:14','3.0823699,101.7004877','Hourly report submitted at 03:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56229','1501','5049','Real-Time Report','1','2025-03-31 04:01:07','2025-03-31 04:02:25','3.0823651,101.700477','Hourly report submitted at 04:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56230','1501','5050','Real-Time Report','1','2025-03-31 05:04:48','2025-03-31 05:05:12','3.0823656,101.7004949','Hourly report submitted at 05:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56231','1501','5051','Real-Time Report','1','2025-03-31 06:03:01','2025-03-31 06:03:28','3.0828226,101.7008108','Hourly report submitted at 06:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56232','1501','5052','Real-Time Report','1','2025-03-31 07:11:19','2025-03-31 07:11:39','3.084748,101.701231','Hourly report submitted at 07:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56233','1501','5053','Real-Time Report','1','2025-03-30 21:09:50','2025-03-30 21:10:09','3.0825597,101.7003228','Hourly report submitted at 9:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56234','1501','5177','Static Guard 3','1','2025-03-30 20:30:46','2025-03-30 20:35:52','3.0841923,101.7008652','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56235','1501','5178','Static Guard 3','1','2025-03-30 21:28:15','2025-03-30 21:32:08','3.0857703,101.7002733','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56236','1501','5179','Static Guard 3','1','2025-03-30 22:37:44','2025-03-30 22:43:19','3.0826741,101.7004271','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56237','1501','5180','Static Guard 3','1','2025-03-30 23:37:25','2025-03-30 23:42:15','3.0834076,101.6998135','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56238','1501','5181','Static Guard 3','1','2025-03-31 06:42:43','2025-03-31 06:47:30','3.0855128,101.7004401','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56239','1501','5182','Static Guard 3','1','2025-03-31 07:31:06','2025-03-31 07:37:49','3.0838585,101.7015052','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56241','1501','5184','Static Guard 3','1','2025-03-31 00:00:26','2025-03-31 00:01:36','3.0851001,101.7005889','Areas Checked:\r\n1. Gym Room: Checked & Secured\r\n2. Toilets: Checked & Secured\r\n3. Swimming Pool Area: Checked & Secured\r\n4. Multi-Purpose Room: Checked & Secured\r\n5. Library & BBQ Area: Checked & Secured\r\n\r\nLevel 8 is closed and no one was found in the perimeter. All doors are locked.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56275','1501','5218','Static Guard 3','1','2025-03-31 02:35:15','2025-03-31 02:36:25','3.0823827,101.7005493','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56276','1501','5219','Static Guard 3','1','2025-03-31 03:33:44','2025-03-31 03:35:05','3.0823323,101.70054','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56277','1501','5220','Static Guard 3','1','2025-03-31 04:33:45','2025-03-31 04:34:57','3.082365,101.7004971','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56278','1501','5221','Static Guard 3','1','2025-03-31 05:40:12','2025-03-31 05:41:17','3.0823433,101.7005362','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56327','1503','821','Roll Call','1','2025-03-30 20:11:15','2025-03-30 20:14:54','','1-Durga\r\n2-Brataman\r\n3-hasta\r\n4-Dipak\r\n5 Judda on duty night shift','1','People not ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56328','1503','5041','Real-Time Report','1','2025-03-30 20:05:21','2025-03-30 20:07:46','','Report Duty at 20:08:08pm','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56329','1503','5042','Real-Time Report','1','2025-03-31 08:06:18','2025-03-31 08:07:48','','Off Duty at 08;07am','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56330','1503','5043','Real-Time Report','1','2025-03-30 22:10:35','2025-03-30 22:10:56','','Hourly report submitted at 10:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56331','1503','5044','Real-Time Report','1','2025-03-30 23:00:14','2025-03-30 23:01:08','','Hourly report submitted at 11:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56332','1503','5045','Real-Time Report','1','2025-03-31 00:19:05','2025-03-31 00:19:26','','Hourly report submitted at 12:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56333','1503','5046','Real-Time Report','1','2025-03-31 01:01:24','2025-03-31 01:01:47','','Hourly report submitted at 01:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56334','1503','5047','Real-Time Report','1','2025-03-31 01:58:09','2025-03-31 02:06:15','','Hourly report submitted 02:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56335','1503','5048','Real-Time Report','1','2025-03-31 03:01:18','2025-03-31 03:01:39','','Hourly report submitted at 03:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56336','1503','5049','Real-Time Report','1','2025-03-31 04:02:25','2025-03-31 04:02:49','','Hourly report submitted at 04:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56337','1503','5050','Real-Time Report','1','2025-03-31 05:02:13','2025-03-31 05:02:36','','Hourly report submitted at 05:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56338','1503','5051','Real-Time Report','1','2025-03-31 06:03:24','2025-03-31 06:03:51','','Hourly report submitted at 06:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56339','1503','5052','Real-Time Report','1','2025-03-31 07:03:29','2025-03-31 07:03:57','','Hourly report submitted at 07:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56340','1503','5053','Real-Time Report','1','2025-03-30 21:04:05','2025-03-30 21:04:46','','Hourly report submitted at 9:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56353','1504','5041','Real-Time Report','1','2025-03-30 21:58:46','2025-03-31 09:54:05','','','1','nil','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56354','1504','5042','Real-Time Report','1','2025-03-31 09:57:44','2025-03-31 09:57:49','','','1','nil','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56355','1504','5043','Real-Time Report','1','2025-03-31 09:54:22','2025-03-31 09:54:27','','','1','nil','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56356','1504','5044','Real-Time Report','1','2025-03-31 09:54:34','2025-03-31 09:54:38','','','1','nil','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56357','1504','5045','Real-Time Report','1','2025-03-31 09:54:45','2025-03-31 09:54:51','','','1','nil','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56358','1504','5046','Real-Time Report','1','2025-03-31 09:54:58','2025-03-31 09:55:02','','','1','nil','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56359','1504','5047','Real-Time Report','1','2025-03-31 09:55:08','2025-03-31 09:55:12','','','1','nil','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56360','1504','5048','Real-Time Report','1','2025-03-31 09:55:18','2025-03-31 09:55:22','','','1','nil','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56361','1504','5049','Real-Time Report','1','2025-03-31 09:56:14','2025-03-31 09:56:20','','','1','nil','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56362','1504','5050','Real-Time Report','1','2025-03-31 09:56:27','2025-03-31 09:56:32','','','1','nil','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56363','1504','5051','Real-Time Report','1','2025-03-31 09:56:39','2025-03-31 09:56:43','','','1','nil','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56364','1504','5052','Real-Time Report','1','2025-03-31 09:57:33','2025-03-31 09:57:36','','','1','nil','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56365','1504','5053','Real-Time Report','1','2025-03-31 09:54:11','2025-03-31 09:54:16','','','1','nil','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56878','1520','43','Roll Call','1','2025-03-31 08:58:03','2025-03-31 09:12:07','3.0822241,101.699162','','1','Tadi dah syetam masala ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56886','1520','4843','Supervisor','1','2025-03-31 11:39:14','2025-03-31 11:52:14','3.0831071,101.7009694','Routine rounds of the guardhouse and its perimeter were conducted with no issues identified. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56887','1520','4844','Supervisor','1','2025-03-31 12:39:55','2025-03-31 12:41:42','3.0828939,101.70076','Routine rounds of the guardhouse and its perimeter were conducted with no issues identified. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56890','1520','4854','Car Park Patrolling','1','2025-03-31 16:34:38','2025-03-31 18:02:17','','Performed a thorough patrol on Level 7, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56891','1520','4855','Car Park Patrolling','1','2025-03-31 18:04:43','2025-03-31 18:06:00','','Performed a thorough patrol on Level 5, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56892','1520','4856','Car Park Patrolling','1','2025-03-31 18:07:00','2025-03-31 18:08:16','','Performed a thorough patrol on Level 4, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56893','1520','4857','Car Park Patrolling','1','2025-03-31 18:02:59','2025-03-31 18:04:42','','Performed a thorough patrol on Level 6, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56894','1520','4858','Car Park Patrolling','1','2025-03-31 18:08:17','2025-03-31 18:09:35','','Performed a thorough patrol on Level 3, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56895','1520','4859','Car Park Patrolling','1','2025-03-31 18:10:57','2025-03-31 18:12:05','','Performed a thorough patrol on Level 1, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56896','1520','4860','Car Park Patrolling','1','2025-03-31 18:12:09','2025-03-31 18:14:56','','Performed a thorough patrol on GF, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56897','1520','4861','Car Park Patrolling','1','2025-03-31 18:09:38','2025-03-31 18:10:56','','Performed a thorough patrol on Level 2, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56898','1520','4862','Car Park Patrolling','1','2025-03-31 18:15:00','2025-03-31 18:17:10','','Performed a thorough patrol on Basement, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56905','1520','5000','Real-Time Report - OT Guard 1st','1','2025-03-31 20:23:31','2025-03-31 20:26:25','3.0822366,101.7007132','Report Duty at 20:20 pm','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56906','1520','5001','Real-Time Report - OT Guard 1st','1','2025-04-01 01:29:46','2025-04-01 02:04:55','','Off Duty at 02:04 am','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56907','1520','5002','Real-Time Report - OT Guard 1st','1','2025-03-31 22:03:32','2025-03-31 22:03:49','','Hourly report submitted at 10:00 PM','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56908','1520','5003','Real-Time Report - OT Guard 1st','1','2025-03-31 23:12:12','2025-03-31 23:12:28','','Hourly report submitted at 11:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56909','1520','5004','Real-Time Report - OT Guard 1st','1','2025-04-01 00:01:17','2025-04-01 00:01:51','','Hourly report submitted at 12:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56910','1520','5005','Real-Time Report - OT Guard 1st','1','2025-04-01 01:00:12','2025-04-01 01:00:29','','Hourly report submitted at 01:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56911','1520','5006','Real-Time Report - OT Guard 1st','1','2025-03-31 21:09:14','2025-03-31 21:09:36','','Hourly report submitted at 9:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56912','1520','5028','Real-Time Report','1','2025-03-31 10:06:52','2025-03-31 10:07:23','3.082252,101.6991608','Hourly report submitted at 10:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56913','1520','5029','Real-Time Report','1','2025-03-31 11:11:05','2025-03-31 11:11:50','3.0822038,101.698956','Hourly report submitted at 11:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56914','1520','5030','Real-Time Report','1','2025-03-31 14:12:40','2025-03-31 14:13:38','3.0823236,101.7005494','Hourly report submitted at 02:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56915','1520','5031','Real-Time Report','1','2025-03-31 15:00:30','2025-03-31 15:00:56','','Hourly report submitted at 03:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56916','1520','5032','Real-Time Report','1','2025-03-31 16:17:40','2025-03-31 16:18:33','3.082419,101.7002468','Hourly report submitted at 04:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56917','1520','5033','Real-Time Report','1','2025-03-31 17:34:10','2025-03-31 18:06:31','','Hourly report submitted at 05:00 PM.','1','Hourly report submitted at 05:00 PM.','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56918','1520','5034','Real-Time Report','1','2025-03-31 18:06:35','2025-03-31 18:06:58','','Hourly report submitted at 06:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56919','1520','5035','Real-Time Report','1','2025-03-31 19:01:41','2025-03-31 19:02:02','','Hourly report submitted at 07:00 PM','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56920','1520','5036','Real-Time Report','1','2025-03-31 08:56:51','2025-03-31 08:57:58','3.0817968,101.7009584','Report Duty at 08:05 AM ','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56921','1520','5037','Real-Time Report','1','2025-03-31 20:26:53','2025-03-31 20:30:00','3.0825415,101.6990301','Off Duty at 20:18 pm ','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56922','1520','5038','Real-Time Report','1','2025-03-31 09:07:38','2025-03-31 09:08:20','3.0795001,101.703931','Hourly report submitted at 09:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56923','1520','5039','Real-Time Report','1','2025-03-31 13:03:51','2025-03-31 13:04:40','3.0817138,101.6991258','Hourly report submitted at 01:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56924','1520','5040','Real-Time Report','1','2025-03-31 12:00:30','2025-03-31 12:01:15','3.0821487,101.6994309','Hourly report submitted at 12:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56925','1521','4562','Patrolling Block B','1','2025-03-31 12:52:23','2025-03-31 12:53:03','','Performed a thorough patrol on Level 10, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56926','1521','4563','Patrolling Block B','1','2025-03-31 12:44:35','2025-03-31 12:46:36','','Performed a thorough patrol on Level 15, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56927','1521','4564','Patrolling Block B','1','2025-03-31 12:44:37','2025-03-31 12:45:25','','Performed a thorough patrol on Level 16, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56928','1521','4565','Patrolling Block B','1','2025-03-31 12:43:00','2025-03-31 12:43:47','','Performed a thorough patrol on Level 17, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56929','1521','4566','Patrolling Block B','1','2025-03-31 08:53:04','2025-03-31 12:42:31','','Performed a thorough patrol on Level 18, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56930','1521','4567','Patrolling Block B','1','2025-03-31 12:40:06','2025-03-31 12:40:54','','Performed a thorough patrol on Level 19, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56931','1521','4568','Patrolling Block B','1','2025-03-31 12:38:44','2025-03-31 12:39:27','','Performed a thorough patrol on Level 20, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56932','1521','4569','Patrolling Block B','1','2025-03-31 12:36:48','2025-03-31 12:37:34','','Performed a thorough patrol on Level 21, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56933','1521','4570','Patrolling Block B','1','2025-03-31 12:29:05','2025-03-31 12:29:56','','Performed a thorough patrol on Level 27, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56934','1521','4571','Patrolling Block B','1','2025-03-31 12:46:56','2025-03-31 12:47:40','','Performed a thorough patrol on Level 14, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56935','1521','4572','Patrolling Block B','1','2025-03-31 11:31:27','2025-03-31 11:32:17','','Performed a thorough patrol on Level 38, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56936','1521','4573','Patrolling Block B','1','2025-03-31 11:29:17','2025-03-31 11:30:16','','Performed a thorough patrol on Level 39, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56937','1521','4574','Patrolling Block B','1','2025-03-31 12:48:11','2025-03-31 12:48:53','','Performed a thorough patrol on Level 13, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56938','1521','4575','Patrolling Block B','1','2025-03-31 08:56:07','2025-03-31 11:28:31','','Performed a thorough patrol on Level 40, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56939','1521','4576','Patrolling Block B','1','2025-03-31 11:25:48','2025-03-31 11:26:34','','Performed a thorough patrol on Level 41, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56940','1521','4577','Patrolling Block B','1','2025-03-31 12:53:44','2025-03-31 12:54:30','','Performed a thorough patrol on Level 9, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56941','1521','4578','Patrolling Block B','1','2025-03-31 12:49:22','2025-03-31 12:50:14','','Performed a thorough patrol on Level 12, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56942','1521','4579','Patrolling Block B','1','2025-03-31 12:51:02','2025-03-31 12:51:45','','Performed a thorough patrol on Level 11, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56943','1521','4580','Patrolling Block B','1','2025-03-31 12:30:27','2025-03-31 12:31:15','','Performed a thorough patrol on Level 26, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56944','1521','4581','Patrolling Block B','1','2025-03-31 12:31:43','2025-03-31 12:32:22','','Performed a thorough patrol on Level 25, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56945','1521','4582','Patrolling Block B','1','2025-03-31 12:32:58','2025-03-31 12:33:44','','Performed a thorough patrol on Level 24, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56946','1521','4583','Patrolling Block B','1','2025-03-31 12:34:13','2025-03-31 12:34:53','','Performed a thorough patrol on Level 23, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56947','1521','4584','Patrolling Block B','1','2025-03-31 12:35:28','2025-03-31 12:36:14','','Performed a thorough patrol on Level 22, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56948','1521','4585','Patrolling Block B','1','2025-03-31 11:33:40','2025-03-31 11:34:32','','Performed a thorough patrol on Level 37, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56949','1521','4586','Patrolling Block B','1','2025-03-31 11:36:27','2025-03-31 11:37:26','','Performed a thorough patrol on Level 36, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56950','1521','4587','Patrolling Block B','1','2025-03-31 11:38:19','2025-03-31 11:39:08','','Performed a thorough patrol on Level 35, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56951','1521','4588','Patrolling Block B','1','2025-03-31 11:40:37','2025-03-31 11:41:52','','Performed a thorough patrol on Level 34, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56952','1521','4589','Patrolling Block B','1','2025-03-31 11:43:06','2025-03-31 11:43:59','','Performed a thorough patrol on Level 33, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56953','1521','4590','Patrolling Block B','1','2025-03-31 11:45:02','2025-03-31 11:45:58','','Performed a thorough patrol on Level 32, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56954','1521','4591','Patrolling Block B','1','2025-03-31 11:46:53','2025-03-31 11:47:53','','Performed a thorough patrol on Level 31, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56955','1521','4592','Patrolling Block B','1','2025-03-31 11:48:44','2025-03-31 11:49:48','','Performed a thorough patrol on Level 30, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56956','1521','4593','Patrolling Block B','1','2025-03-31 12:26:06','2025-03-31 12:26:55','','Performed a thorough patrol on Level 29, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56957','1521','4594','Patrolling Block B','1','2025-03-31 12:27:52','2025-03-31 12:28:35','','Performed a thorough patrol on Level 28, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56958','1521','4744','Parcel Collection / Arrangement','1','2025-03-31 08:55:54','2025-03-31 13:04:05','','Each parcel has been checked and labeled with today’s date. All parcels have been collected from the delivery area and arranged in the mailbox area.\r\nNumber of parcels that are damaged or opened:','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56959','1521','4757','Parcel Collection / Arrangement','1','2025-03-31 08:55:58','2025-03-31 15:16:38','','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56960','1521','4758','Parcel Collection / Arrangement','1','2025-03-31 08:56:34','2025-03-31 18:41:06','','Each parcel has been checked and labeled with today’s date. All parcels have been collected from the delivery area and arranged in the mailbox area.\r\nNumber of parcels that are damaged or opened:','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56961','1521','4760','Parcel Collection / Arrangement','1','2025-03-31 12:53:41','2025-03-31 18:39:56','','Each parcel has been checked and labeled with today’s date. All parcels have been collected from the delivery area and arranged in the mailbox area.\r\nNumber of parcels that are damaged or opened:','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56962','1521','4761','Parcel Collection / Arrangement','1','2025-03-31 11:17:12','2025-03-31 15:17:11','','','1','System problem ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56963','1521','4762','Parcel Collection / Arrangement','1','2025-03-31 08:52:01','2025-03-31 18:42:04','','Each parcel has been checked and labeled with today’s date. All parcels have been collected from the delivery area and arranged in the mailbox area.\r\nNumber of parcels that are damaged or opened:','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56964','1521','4814','Static Guard 4','1','2025-03-31 13:14:36','2025-03-31 13:40:13','','\r\nRoutine rounds of the guardhouse and its perimeter were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56965','1521','4815','Static Guard 4','1','2025-03-31 14:32:33','2025-03-31 14:36:30','','Cove, level 8.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56966','1521','4816','Static Guard 4','1','2025-03-31 15:33:07','2025-03-31 15:33:51','','Routine rounds of the guardhouse and its perimeter were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56967','1521','4817','Static Guard 4','1','2025-03-31 16:38:40','2025-03-31 16:40:03','','Routine rounds of the guardhouse and its perimeter were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56968','1521','4818','Static Guard 4','1','2025-03-31 18:32:36','2025-03-31 18:33:16','','Routine rounds of the guardhouse and its perimeter were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56969','1521','4819','Static Guard 4','1','2025-03-31 19:31:59','2025-03-31 19:32:46','','Routine rounds of the guardhouse and its perimeter were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56970','1521','4821','Static Guard 4','1','2025-03-31 09:35:02','2025-03-31 09:36:58','','Routine rounds of the guardhouse and its perimeter were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56971','1521','4822','Static Guard 4','1','2025-03-31 08:54:12','2025-03-31 08:55:37','','Routine rounds of the guardhouse and its perimeter were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56972','1521','4823','Static Guard 4','1','2025-03-31 10:29:59','2025-03-31 10:33:48','','Routine rounds of the guardhouse and its perimeter were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56973','1521','4824','Static Guard 4','1','2025-03-31 17:33:54','2025-03-31 17:34:31','','Routine rounds of the guardhouse and its perimeter were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56974','1521','5028','Real-Time Report','1','2025-03-31 10:07:07','2025-03-31 10:07:39','','Hourly report submitted at 10:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56975','1521','5029','Real-Time Report','1','2025-03-31 11:00:13','2025-03-31 11:00:34','','Hourly report submitted at 11:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56976','1521','5030','Real-Time Report','1','2025-03-31 14:19:12','2025-03-31 14:19:28','','Hourly report submitted at 02:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56977','1521','5031','Real-Time Report','1','2025-03-31 15:03:31','2025-03-31 15:03:52','','Hourly report submitted at 03:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56978','1521','5032','Real-Time Report','1','2025-03-31 16:13:29','2025-03-31 16:13:49','','Hourly report submitted at 04:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56979','1521','5033','Real-Time Report','1','2025-03-31 17:01:18','2025-03-31 17:01:41','','Hourly report submitted at 05:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56980','1521','5034','Real-Time Report','1','2025-03-31 18:04:05','2025-03-31 18:04:30','','Hourly report submitted at 06:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56981','1521','5035','Real-Time Report','1','2025-03-31 19:00:52','2025-03-31 19:01:15','','Hourly report submitted at 07:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56982','1521','5036','Real-Time Report','1','2025-03-31 08:53:13','2025-03-31 08:54:07','','Report Duty at 08:00 am','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56983','1521','5037','Real-Time Report','1','2025-03-31 20:14:34','2025-03-31 20:23:02','','Off Duty at 20:22 pm','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56984','1521','5038','Real-Time Report','1','2025-03-31 09:05:35','2025-03-31 09:07:34','','Hourly report submitted at 09:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56985','1521','5039','Real-Time Report','1','2025-03-31 13:04:35','2025-03-31 13:04:52','','Hourly report submitted at 01:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56986','1521','5040','Real-Time Report','1','2025-03-31 12:27:31','2025-03-31 12:27:47','','Hourly report submitted at 12:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('56989','1521','5056','Real-Time Report MO-OT','1','2025-03-31 22:08:39','2025-03-31 22:09:22','','Hourly report submitted at 10:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57025','1521','5092','MO-OT','1','2025-03-31 20:30:23','2025-03-31 20:32:19','','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57026','1521','5093','MO-OT','1','2025-03-31 21:45:05','2025-03-31 21:47:34','','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57241','1525','4765','Lobby','1','2025-03-31 09:53:47','2025-03-31 09:54:20','3.0823542,101.7005254','Info:\r\nHandover & Inventory Check:\r\nWalkie-Talkie (1)\r\nBaton (1)\r\nAccess Card (1)\r\nBodycam (1)\r\nTraffic Control Light (1)','1','System issues ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57242','1525','4766','Static Guard 1','1','2025-03-31 15:33:25','2025-03-31 15:37:49','3.083523,101.701604','Info:\r\nRoutine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57243','1525','4767','Static Guard 1','1','2025-03-31 16:32:25','2025-03-31 16:36:11','3.0829252,101.7006453','Info:\r\nRoutine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57244','1525','4768','Static Guard 1','1','2025-03-31 17:38:11','2025-03-31 17:41:33','3.0827334,101.7002862','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57245','1525','4769','Static Guard 1','1','2025-03-31 18:33:56','2025-03-31 18:37:14','3.0837812,101.7011497','Info:\r\nRoutine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57246','1525','4770','Static Guard 1','1','2025-03-31 19:32:16','2025-03-31 19:35:10','3.0832876,101.7014521','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57247','1525','4771','Static Guard 1','1','2025-03-31 09:54:27','2025-03-31 09:54:57','3.082355,101.7005178','Info:\r\nRoutine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','1','System issues ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57248','1525','4772','Static Guard 1','1','2025-03-31 09:56:35','2025-03-31 09:57:29','3.0823984,101.7005085','Info:\r\nRoutine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57249','1525','4773','Static Guard 1','1','2025-03-31 10:33:39','2025-03-31 10:35:04','3.0823914,101.7005208','Info:\r\nRoutine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57250','1525','4774','Static Guard 1','1','2025-03-31 12:32:52','2025-03-31 12:34:10','3.0824174,101.7005292','Info:\r\nRoutine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57251','1525','4775','Static Guard 1','1','2025-03-31 11:30:24','2025-03-31 11:31:33','3.0823379,101.7005368','Info:\r\nRoutine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57252','1525','4776','Static Guard 1','1','2025-03-31 13:34:04','2025-03-31 13:35:21','3.0823456,101.700529','Info:\r\nRoutine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57253','1525','4777','Static Guard 1','1','2025-03-31 14:36:32','2025-03-31 14:37:41','3.0823604,101.7004974','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57254','1525','5028','Real-Time Report','1','2025-03-31 10:07:19','2025-03-31 10:07:47','3.0824135,101.7005271','Hourly report submitted at 10:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57255','1525','5029','Real-Time Report','1','2025-03-31 11:04:01','2025-03-31 11:04:13','3.0823392,101.7005287','Hourly report submitted at 11:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57256','1525','5030','Real-Time Report','1','2025-03-31 14:06:59','2025-03-31 14:07:13','3.0823566,101.7005097','Hourly report submitted at 02:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57257','1525','5031','Real-Time Report','1','2025-03-31 15:10:47','2025-03-31 15:10:58','3.0842797,101.6996891','Hourly report submitted at 03:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57258','1525','5032','Real-Time Report','1','2025-03-31 16:09:28','2025-03-31 16:09:40','3.0828697,101.700529','Hourly report submitted at 04:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57259','1525','5033','Real-Time Report','1','2025-03-31 17:10:11','2025-03-31 17:10:28','3.0824459,101.7005014','Hourly report submitted at 05:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57260','1525','5034','Real-Time Report','1','2025-03-31 18:08:43','2025-03-31 18:08:57','3.0853109,101.6996328','Hourly report submitted at 06:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57261','1525','5035','Real-Time Report','1','2025-03-31 19:09:26','2025-03-31 19:09:43','3.0824225,101.700518','Hourly report submitted at 07:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57262','1525','5036','Real-Time Report','1','2025-03-31 09:52:52','2025-03-31 09:53:43','3.0797834,101.7040415','Report Duty at on 7:55 am','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57263','1525','5037','Real-Time Report','1','2025-03-31 20:20:10','2025-03-31 20:21:23','3.0852309,101.7010291','Off Duty at 8:21 pm','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57264','1525','5038','Real-Time Report','1','2025-03-31 09:54:58','2025-03-31 09:55:21','3.0795653,101.7039032','Hourly report submitted at 09:00 AM.','1','System issues ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57265','1525','5039','Real-Time Report','1','2025-03-31 13:12:37','2025-03-31 13:13:03','3.0823865,101.7005282','Hourly report submitted at 01:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57266','1525','5040','Real-Time Report','1','2025-03-31 12:02:42','2025-03-31 12:03:01','3.0823374,101.7005354','Hourly report submitted at 12:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57267','1526','4472','Patrolling Block A','1','2025-03-31 10:13:30','2025-03-31 10:13:35','3.08224,101.6994719','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57268','1526','4473','Patrolling Block A','1','2025-03-31 10:12:40','2025-03-31 10:12:45','3.08224,101.6994719','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57269','1526','4474','Patrolling Block A','1','2025-03-31 10:12:32','2025-03-31 10:12:38','3.08224,101.6994719','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57270','1526','4475','Patrolling Block A','1','2025-03-31 10:12:26','2025-03-31 10:12:30','3.08224,101.6994719','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57271','1526','4476','Patrolling Block A','1','2025-03-31 10:12:18','2025-03-31 10:12:24','3.08224,101.6994719','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57272','1526','4477','Patrolling Block A','1','2025-03-31 10:12:12','2025-03-31 10:12:17','3.08224,101.6994719','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57273','1526','4478','Patrolling Block A','1','2025-03-31 10:12:05','2025-03-31 10:12:10','3.08224,101.6994719','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57274','1526','4479','Patrolling Block A','1','2025-03-31 10:11:58','2025-03-31 10:12:03','3.08224,101.6994719','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57275','1526','4480','Patrolling Block A','1','2025-03-31 10:11:15','2025-03-31 10:11:20','3.08224,101.6994719','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57276','1526','4481','Patrolling Block A','1','2025-03-31 10:12:47','2025-03-31 10:12:52','3.08224,101.6994719','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57277','1526','4482','Patrolling Block A','1','2025-03-31 10:07:59','2025-03-31 10:09:57','3.08224,101.6994719','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57278','1526','4483','Patrolling Block A','1','2025-03-31 10:09:15','2025-03-31 10:09:47','3.0822252,101.6994891','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57279','1526','4484','Patrolling Block A','1','2025-03-31 10:12:54','2025-03-31 10:12:59','3.08224,101.6994719','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57280','1526','4485','Patrolling Block A','1','2025-03-31 10:09:04','2025-03-31 10:09:13','3.0822252,101.6994891','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57281','1526','4486','Patrolling Block A','1','2025-03-31 10:08:06','2025-03-31 10:09:02','3.0822252,101.6994891','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57282','1526','4487','Patrolling Block A','1','2025-03-31 10:04:05','2025-03-31 10:13:44','3.08224,101.6994719','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57283','1526','4488','Patrolling Block A','1','2025-03-31 10:13:05','2025-03-31 10:13:11','3.08224,101.6994719','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57284','1526','4489','Patrolling Block A','1','2025-03-31 10:13:13','2025-03-31 10:13:28','3.08224,101.6994719','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57285','1526','4490','Patrolling Block A','1','2025-03-31 10:11:22','2025-03-31 10:11:27','3.08224,101.6994719','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57286','1526','4491','Patrolling Block A','1','2025-03-31 10:11:28','2025-03-31 10:11:33','3.08224,101.6994719','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57287','1526','4492','Patrolling Block A','1','2025-03-31 10:11:36','2025-03-31 10:11:42','3.08224,101.6994719','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57288','1526','4493','Patrolling Block A','1','2025-03-31 10:11:45','2025-03-31 10:11:50','3.08224,101.6994719','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57289','1526','4494','Patrolling Block A','1','2025-03-31 10:11:52','2025-03-31 10:11:56','3.08224,101.6994719','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57290','1526','4495','Patrolling Block A','1','2025-03-31 10:10:01','2025-03-31 10:10:07','3.08224,101.6994719','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57291','1526','4496','Patrolling Block A','1','2025-03-31 10:10:09','2025-03-31 10:10:15','3.08224,101.6994719','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57292','1526','4497','Patrolling Block A','1','2025-03-31 10:10:16','2025-03-31 10:10:21','3.08224,101.6994719','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57293','1526','4498','Patrolling Block A','1','2025-03-31 10:10:23','2025-03-31 10:10:29','3.08224,101.6994719','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57294','1526','4499','Patrolling Block A','1','2025-03-31 10:10:31','2025-03-31 10:10:36','3.08224,101.6994719','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57295','1526','4500','Patrolling Block A','1','2025-03-31 10:10:37','2025-03-31 10:10:43','3.08224,101.6994719','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57296','1526','4501','Patrolling Block A','1','2025-03-31 10:10:44','2025-03-31 10:10:51','3.08224,101.6994719','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57297','1526','4502','Patrolling Block A','1','2025-03-31 10:10:53','2025-03-31 10:10:58','3.08224,101.6994719','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57298','1526','4503','Patrolling Block A','1','2025-03-31 10:11:01','2025-03-31 10:11:06','3.08224,101.6994719','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57299','1526','4504','Patrolling Block A','1','2025-03-31 10:11:08','2025-03-31 10:11:13','3.08224,101.6994719','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57300','1526','4711','Patrolling Block B - PH','1','2025-03-31 19:20:19','2025-03-31 19:21:57','3.081913,101.7007487','Performed a thorough patrol on Level 10, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57301','1526','4712','Patrolling Block B - PH','1','2025-03-31 19:12:11','2025-03-31 19:13:35','3.0805263,101.6966242','Performed a thorough patrol on Level 15, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57302','1526','4713','Patrolling Block B - PH','1','2025-03-31 19:10:12','2025-03-31 19:12:07','3.0821129,101.6996158','Performed a thorough patrol on Level 16,  no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57303','1526','4714','Patrolling Block B - PH','1','2025-03-31 19:08:41','2025-03-31 19:10:10','3.0821129,101.6996158','Performed a thorough patrol on Level 17, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57304','1526','4715','Patrolling Block B - PH','1','2025-03-31 19:06:31','2025-03-31 19:08:39','3.0830811,101.7006379','Performed a thorough patrol on Level 18, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57305','1526','4716','Patrolling Block B - PH','1','2025-03-31 19:04:54','2025-03-31 19:06:29','3.0816345,101.6982926','Performed a thorough patrol on Level 19, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57306','1526','4717','Patrolling Block B - PH','1','2025-03-31 19:03:08','2025-03-31 19:04:52','3.0799128,101.6966372','Performed a thorough patrol on Level 20, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57307','1526','4718','Patrolling Block B - PH','1','2025-03-31 19:01:26','2025-03-31 19:03:06','3.0827212,101.7005481','Performed a thorough patrol on Level 21, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57308','1526','4719','Patrolling Block B - PH','1','2025-03-31 18:50:03','2025-03-31 18:51:21','3.0828466,101.7009728','\r\nPerformed a thorough patrol on Level 27, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57309','1526','4720','Patrolling Block B - PH','1','2025-03-31 19:13:38','2025-03-31 19:15:08','3.0790615,101.6997138','Performed a thorough patrol on Level 14, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57310','1526','4721','Patrolling Block B - PH','1','2025-03-31 18:29:04','2025-03-31 18:31:18','3.0826203,101.7004271','Performed a thorough patrol on Level 38, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57311','1526','4722','Patrolling Block B - PH','1','2025-03-31 18:27:15','2025-03-31 18:29:00','3.0826448,101.7003281','Performed a thorough patrol on Level 39, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57312','1526','4723','Patrolling Block B - PH','1','2025-03-31 19:15:13','2025-03-31 19:16:45','3.0790615,101.6997138','Performed a thorough patrol on Level 13, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57313','1526','4724','Patrolling Block B - PH','1','2025-03-31 18:25:24','2025-03-31 18:27:10','3.0825636,101.7003541','Performed a thorough patrol on Level 40, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57314','1526','4725','Patrolling Block B - PH','1','2025-03-31 17:11:32','2025-03-31 18:25:16','3.0826074,101.7003441','Performed a thorough patrol on Level 41, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57315','1526','4726','Patrolling Block B - PH','1','2025-03-31 17:11:24','2025-03-31 19:23:27','3.081913,101.7007487','Performed a thorough patrol on Level 9, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57316','1526','4727','Patrolling Block B - PH','1','2025-03-31 19:16:46','2025-03-31 19:18:32','3.0824879,101.7003487','Performed a thorough patrol on Level 12, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57317','1526','4728','Patrolling Block B - PH','1','2025-03-31 19:18:35','2025-03-31 19:20:16','3.0824082,101.7002515','Performed a thorough patrol on Level 11, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57318','1526','4729','Patrolling Block B - PH','1','2025-03-31 18:51:23','2025-03-31 18:53:09','3.0824672,101.700369','Performed a thorough patrol on Level 26, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57319','1526','4730','Patrolling Block B - PH','1','2025-03-31 18:53:10','2025-03-31 18:55:06','3.0824878,101.7004386','Performed a thorough patrol on Level 25, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57320','1526','4731','Patrolling Block B - PH','1','2025-03-31 18:55:08','2025-03-31 18:57:26','3.0824149,101.7003021','Performed a thorough patrol on Level 24, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57321','1526','4732','Patrolling Block B - PH','1','2025-03-31 18:57:28','2025-03-31 18:59:35','3.0769056,101.6975707','Performed a thorough patrol on Level 23, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57322','1526','4733','Patrolling Block B - PH','1','2025-03-31 18:59:42','2025-03-31 19:01:24','3.0827212,101.7005481','Performed a thorough patrol on Level 22, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57323','1526','4734','Patrolling Block B - PH','1','2025-03-31 18:31:20','2025-03-31 18:33:28','3.0833948,101.700773','Performed a thorough patrol on Level 37, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57324','1526','4735','Patrolling Block B - PH','1','2025-03-31 18:35:01','2025-03-31 18:36:17','3.0825578,101.7004343','Performed a thorough patrol on Level 36, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57325','1526','4736','Patrolling Block B - PH','1','2025-03-31 18:36:19','2025-03-31 18:37:49','3.0825263,101.700305','Performed a thorough patrol on Level 35, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57326','1526','4737','Patrolling Block B - PH','1','2025-03-31 18:37:51','2025-03-31 18:39:37','3.0824586,101.6997573','Performed a thorough patrol on Level 34, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57327','1526','4738','Patrolling Block B - PH','1','2025-03-31 18:39:39','2025-03-31 18:41:20','3.079474,101.6973123','Performed a thorough patrol on Level 33, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57328','1526','4739','Patrolling Block B - PH','1','2025-03-31 18:41:22','2025-03-31 18:42:46','3.0825779,101.7001648','Performed a thorough patrol on Level 32, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57329','1526','4740','Patrolling Block B - PH','1','2025-03-31 18:42:48','2025-03-31 18:44:40','3.0830977,101.7013954','Performed a thorough patrol on Level 31, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57330','1526','4741','Patrolling Block B - PH','1','2025-03-31 18:44:46','2025-03-31 18:46:25','3.0804717,101.6961751','Performed a thorough patrol on Level 30, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57331','1526','4742','Patrolling Block B - PH','1','2025-03-31 18:46:27','2025-03-31 18:48:30','3.0828411,101.7010151','Performed a thorough patrol on Level 29, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57332','1526','4743','Patrolling Block B - PH','1','2025-03-31 18:48:35','2025-03-31 18:49:56','3.0828466,101.7009728','Performed a thorough patrol on Level 28, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57333','1526','4804','Static Guard 3','1','2025-03-31 10:13:50','2025-03-31 10:38:45','3.0823866,101.7005491','Routine rounds of the guardhouse and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57334','1526','4805','Static Guard 3','1','2025-03-31 12:34:11','2025-03-31 12:35:12','3.0816602,101.6994917','Routine rounds of the guardhouse and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57335','1526','4806','Static Guard 3','1','2025-03-31 11:40:32','2025-03-31 11:42:50','3.0820508,101.7000134','Routine rounds of the guardhouse and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57336','1526','4807','Static Guard 3','1','2025-03-31 13:37:18','2025-03-31 13:38:42','3.0823231,101.7005202','Routine rounds of the guardhouse and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57337','1526','4808','Static Guard 3','1','2025-03-31 14:37:29','2025-03-31 14:38:22','3.0821983,101.6999287','Routine rounds of the guardhouse and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57338','1526','4809','Static Guard 3','1','2025-03-31 16:34:39','2025-03-31 16:35:48','3.0823281,101.7002963','Routine rounds of the guardhouse and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57339','1526','4810','Static Guard 3','1','2025-03-31 18:05:49','2025-03-31 18:07:15','3.0823481,101.7005311','Routine rounds of the guardhouse and its perimeter were conducted, with no issues found. Everything is in proper order.','1','Lambbat ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57340','1526','4811','Static Guard 3','1','2025-03-31 18:33:37','2025-03-31 18:34:59','3.0793902,101.6966556','Routine rounds of the guardhouse and its perimeter were conducted, with no issues found. Everything is in proper order.','1','Black B petroling ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57341','1526','4812','Static Guard 3','1','2025-03-31 19:32:25','2025-03-31 19:33:13','3.0825547,101.7000101','Routine rounds of the guardhouse and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57342','1526','4813','Static Guard 3','1','2025-03-31 15:32:01','2025-03-31 15:33:29','3.0824042,101.6988895','Routine rounds of the guardhouse and its perimeter were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57343','1526','5028','Real-Time Report','1','2025-03-31 10:06:05','2025-03-31 10:07:20','3.0822252,101.6994891','Hourly report submitted at 10:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57344','1526','5029','Real-Time Report','1','2025-03-31 11:03:43','2025-03-31 11:04:10','3.0819963,101.6992924','Hourly report submitted at 11:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57345','1526','5030','Real-Time Report','1','2025-03-31 14:04:32','2025-03-31 14:04:56','3.0823469,101.6999652','Hourly report submitted at 02:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57346','1526','5031','Real-Time Report','1','2025-03-31 15:00:35','2025-03-31 15:01:04','3.0822949,101.698952','Hourly report submitted at 03:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57347','1526','5032','Real-Time Report','1','2025-03-31 16:01:28','2025-03-31 16:02:07','3.0824962,101.6988879','Hourly report submitted at 04:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57348','1526','5033','Real-Time Report','1','2025-03-31 17:10:39','2025-03-31 17:11:13','3.082554,101.6991603','Hourly report submitted at 05:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57349','1526','5034','Real-Time Report','1','2025-03-31 18:07:43','2025-03-31 18:08:05','3.0823481,101.7005311','Hourly report submitted at 06:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57350','1526','5035','Real-Time Report','1','2025-03-31 19:23:32','2025-03-31 19:23:58','3.0824918,101.7002855','Hourly report submitted at 07:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57351','1526','5036','Real-Time Report','1','2025-03-31 10:01:04','2025-03-31 10:03:48','3.0822252,101.6994891','Report Duty at 06:05am','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57352','1526','5037','Real-Time Report','1','2025-03-31 11:30:15','2025-03-31 20:18:31','3.0823595,101.7004081','Off Duty at 20:17PM','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57353','1526','5038','Real-Time Report','1','2025-03-31 10:05:55','2025-03-31 10:07:57','3.0822252,101.6994891','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57354','1526','5039','Real-Time Report','1','2025-03-31 13:03:57','2025-03-31 13:04:25','3.0822732,101.700682','Hourly report submitted at 01:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57355','1526','5040','Real-Time Report','1','2025-03-31 12:10:43','2025-03-31 12:11:29','3.0816602,101.6994917','Hourly report submitted at 12:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57356','1527','4941','Level 8','1','2025-03-31 20:27:04','2025-03-31 20:27:44','3.082415,101.7006026','Handover & Inventory Check:\r\nWalkie-Talkie (1)\r\nBaton (1)\r\nAccess Card (1)\r\nBodycam (1)\r\nGym Pass (11)','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57357','1527','5041','Real-Time Report','1','2025-03-31 20:10:13','2025-03-31 20:10:39','3.0822319,101.7006662','Report Duty at 08:07am ','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57358','1527','5042','Real-Time Report','1','2025-04-01 08:03:41','2025-04-01 08:08:04','3.0827673,101.7003804','Off Duty at 08:08 am ','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57359','1527','5043','Real-Time Report','1','2025-03-31 22:13:10','2025-03-31 22:13:29','3.0829801,101.7001088','Hourly report submitted at 10:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57360','1527','5044','Real-Time Report','1','2025-03-31 23:03:55','2025-03-31 23:04:11','3.0831124,101.7005649','Hourly report submitted at 11:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57361','1527','5045','Real-Time Report','1','2025-04-01 00:02:15','2025-04-01 00:02:29','3.0823875,101.700537','Hourly report submitted at 12:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57362','1527','5046','Real-Time Report','1','2025-04-01 01:08:01','2025-04-01 01:08:22','3.082245,101.6997341','Hourly report submitted at 01:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57363','1527','5047','Real-Time Report','1','2025-04-01 02:08:33','2025-04-01 02:09:31','3.0823662,101.7004961','Hourly report submitted 02:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57364','1527','5048','Real-Time Report','1','2025-04-01 03:04:04','2025-04-01 03:04:31','3.0823653,101.7005009','Hourly report submitted at 03:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57365','1527','5049','Real-Time Report','1','2025-04-01 04:09:20','2025-04-01 04:09:41','3.082365,101.7005004','Hourly report submitted at 04:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57366','1527','5050','Real-Time Report','1','2025-04-01 05:02:56','2025-04-01 05:03:34','3.0823443,101.7005451','Hourly report submitted at 05:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57367','1527','5051','Real-Time Report','1','2025-04-01 06:23:10','2025-04-01 06:23:29','3.0838102,101.700735','Hourly report submitted at 06:00 AM','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57368','1527','5052','Real-Time Report','1','2025-04-01 07:07:54','2025-04-01 07:08:36','3.0832791,101.7012661','Hourly report submitted at 07:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57369','1527','5053','Real-Time Report','1','2025-03-31 21:12:11','2025-03-31 21:12:32','3.0825664,101.7003914','Hourly report submitted at 9:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57370','1527','5177','Static Guard 3','1','2025-03-31 20:29:45','2025-03-31 20:34:46','3.0827972,101.7002534','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57371','1527','5178','Static Guard 3','1','2025-03-31 21:29:58','2025-03-31 21:34:10','3.0833555,101.7015387','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57372','1527','5179','Static Guard 3','1','2025-03-31 22:47:57','2025-03-31 22:51:32','3.0831192,101.7006895','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57373','1527','5180','Static Guard 3','1','2025-03-31 23:30:52','2025-03-31 23:34:23','3.0853308,101.7000974','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57374','1527','5181','Static Guard 3','1','2025-04-01 06:34:21','2025-04-01 06:45:41','3.0833518,101.7004706','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.\r\n','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57375','1527','5182','Static Guard 3','1','2025-04-01 07:35:26','2025-04-01 07:39:49','3.084989,101.7011504','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57377','1527','5184','Static Guard 3','1','2025-03-31 23:57:52','2025-04-01 00:01:57','3.0823691,101.700493','Areas Checked:\r\n1. Gym Room: Checked & Secured\r\n2. Toilets: Checked & Secured\r\n3. Swimming Pool Area: Checked & Secured\r\n4. Multi-Purpose Room: Checked & Secured\r\n5. Library & BBQ Area: Checked & Secured\r\n\r\nLevel 8 is closed and no one was found in the perimeter. All doors are locked','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57378','1527','5218','Static Guard 3','1','2025-04-01 02:38:27','2025-04-01 02:39:37','3.082415,101.7006026','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57379','1527','5219','Static Guard 3','1','2025-04-01 03:32:36','2025-04-01 03:34:00','3.0830807,101.7005601','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57380','1527','5220','Static Guard 3','1','2025-04-01 04:38:07','2025-04-01 04:39:28','3.0823302,101.7005214','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57381','1527','5221','Static Guard 3','1','2025-04-01 05:32:40','2025-04-01 05:33:50','3.0823648,101.700492','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57382','1527','5312','Water Riser Block B','1','2025-04-01 01:38:43','2025-04-01 01:38:59','3.0826058,101.7000155','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57383','1527','5313','Water Riser Block B','1','2025-04-01 01:27:28','2025-04-01 01:27:45','3.0822081,101.6996061','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57384','1527','5314','Water Riser Block B','1','2025-04-01 01:26:29','2025-04-01 01:27:26','3.0835079,101.7008996','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57385','1527','5315','Water Riser Block B','1','2025-04-01 01:22:39','2025-04-01 01:22:57','3.0829729,101.7008524','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57386','1527','5316','Water Riser Block B','1','2025-04-01 01:21:56','2025-04-01 01:22:37','3.0830446,101.7009739','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57387','1527','5317','Water Riser Block B','1','2025-04-01 01:17:37','2025-04-01 01:17:58','3.0830625,101.7005305','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57388','1527','5318','Water Riser Block B','1','2025-04-01 01:16:39','2025-04-01 01:17:34','3.0823333,101.7006583','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57389','1527','5319','Water Riser Block B','1','2025-04-01 01:05:17','2025-04-01 01:05:39','3.0814315,101.6998278','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57390','1527','5320','Water Riser Block B','1','2025-04-01 00:50:46','2025-04-01 00:51:05','3.0831048,101.7010888','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57391','1527','5321','Water Riser Block B','1','2025-04-01 01:31:24','2025-04-01 01:32:04','3.083234,101.7008392','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57392','1527','5322','Water Riser Block B','1','2025-04-01 00:13:39','2025-04-01 00:14:13','3.0827061,101.7003038','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57393','1527','5323','Water Riser Block B','1','2025-04-01 00:12:57','2025-04-01 00:13:35','3.072368,101.6927751','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57394','1527','5324','Water Riser Block B','1','2025-04-01 01:33:48','2025-04-01 01:34:32','3.0825164,101.7003456','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57395','1527','5325','Water Riser Block B','1','2025-04-01 00:10:41','2025-04-01 00:11:20','3.0789395,101.69672','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57396','1527','5326','Water Riser Block B','1','2025-03-31 22:52:34','2025-04-01 00:09:17','3.0833508,101.7012148','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57397','1527','5327','Water Riser Block B','1','2025-04-01 01:41:40','2025-04-01 01:42:14','3.0832262,101.7009765','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57398','1527','5328','Water Riser Block B','1','2025-04-01 01:34:36','2025-04-01 01:34:53','3.0831243,101.7007147','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57399','1527','5329','Water Riser Block B','1','2025-04-01 01:38:13','2025-04-01 01:38:41','3.0826191,101.7001836','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57400','1527','5330','Water Riser Block B','1','2025-04-01 00:54:35','2025-04-01 00:55:19','3.083492,101.7006856','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57401','1527','5331','Water Riser Block B','1','2025-04-01 00:55:25','2025-04-01 00:55:45','3.0834948,101.700688','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57402','1527','5332','Water Riser Block B','1','2025-04-01 00:59:22','2025-04-01 01:00:41','3.0826654,101.7011149','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57403','1527','5333','Water Riser Block B','1','2025-04-01 01:00:44','2025-04-01 01:01:06','3.0827497,101.7013262','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57404','1527','5334','Water Riser Block B','1','2025-04-01 01:04:36','2025-04-01 01:05:15','3.0821411,101.7003348','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57405','1527','5335','Water Riser Block B','1','2025-04-01 00:18:06','2025-04-01 00:19:17','3.0825185,101.7004093','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57406','1527','5336','Water Riser Block B','1','2025-04-01 00:19:21','2025-04-01 00:19:54','3.0825185,101.7004093','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57407','1527','5337','Water Riser Block B','1','2025-04-01 00:28:51','2025-04-01 00:29:30','3.0826092,101.7002928','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57408','1527','5338','Water Riser Block B','1','2025-04-01 00:29:33','2025-04-01 00:29:52','3.0826078,101.7003034','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57409','1527','5339','Water Riser Block B','1','2025-04-01 00:34:39','2025-04-01 00:35:16','3.0826146,101.7001209','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57410','1527','5340','Water Riser Block B','1','2025-04-01 00:36:58','2025-04-01 00:37:43','3.082595,101.7001895','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57411','1527','5341','Water Riser Block B','1','2025-04-01 00:37:46','2025-04-01 00:38:05','3.0831062,101.7004089','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57412','1527','5342','Water Riser Block B','1','2025-04-01 00:42:25','2025-04-01 00:43:16','3.082533,101.7001603','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57413','1527','5343','Water Riser Block B','1','2025-04-01 00:43:19','2025-04-01 00:43:36','3.0825517,101.7002011','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57414','1527','5344','Water Riser Block B','1','2025-04-01 00:49:37','2025-04-01 00:50:43','3.0830024,101.7011556','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57415','1527','5583','Patrolling Block B','1','2025-04-01 01:39:00','2025-04-01 01:40:07','3.0822694,101.7003343','Performed a thorough patrol on Level 10, no incidents were reported and no issues were found.\r\n','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57416','1527','5584','Patrolling Block B','1','2025-04-01 01:22:59','2025-04-01 01:24:25','3.0828222,101.7010059','Performed a thorough patrol on Level 17, no incidents were reported and no issues were found.\r\n','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57417','1527','5585','Patrolling Block B','1','2025-04-01 01:08:28','2025-04-01 01:12:12','3.0833074,101.7014767','Performed a thorough patrol on Level 21, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57418','1527','5586','Patrolling Block B','1','2025-04-01 00:11:32','2025-04-01 00:12:54','3.0835419,101.7010192','Performed a thorough patrol on Level 39, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57419','1527','5587','Patrolling Block B','1','2025-04-01 00:09:21','2025-04-01 00:10:38','3.0823096,101.6991466','Performed a thorough patrol on Level 40, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57420','1527','5588','Patrolling Block B','1','2025-04-01 01:40:10','2025-04-01 01:41:36','3.0825268,101.7004967','Performed a thorough patrol on Level 9, no incidents were reported and no issues were found.\r\n','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57421','1527','5589','Patrolling Block B','1','2025-04-01 01:36:35','2025-04-01 01:38:11','3.0823643,101.7005251','Performed a thorough patrol on Level 11, no incidents were reported and no issues were found.\r\n','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57422','1527','5590','Patrolling Block B','1','2025-04-01 00:52:37','2025-04-01 00:54:32','3.083482,101.700681','Performed a thorough patrol on Level 26, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57423','1527','5591','Patrolling Block B','1','2025-04-01 00:55:47','2025-04-01 00:57:15','3.0825142,101.7004202','Performed a thorough patrol on Level 25, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57424','1527','5592','Patrolling Block B','1','2025-04-01 00:57:20','2025-04-01 00:59:20','3.0825671,101.7005398','Performed a thorough patrol on Level 24, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57425','1527','5593','Patrolling Block B','1','2025-04-01 01:01:08','2025-04-01 01:02:38','3.0832022,101.7008103','Performed a thorough patrol on Level 23, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57426','1527','5594','Patrolling Block B','1','2025-04-01 01:02:41','2025-04-01 01:04:33','3.0833711,101.701376','Performed a thorough patrol on Level 22, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57427','1527','5595','Patrolling Block B','1','2025-04-01 00:20:05','2025-04-01 00:21:06','3.0825185,101.7004093','Performed a thorough patrol on Level 36, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57428','1527','5596','Patrolling Block B','1','2025-04-01 00:21:11','2025-04-01 00:28:44','3.0824539,101.7005753','Performed a thorough patrol on Level 35, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57429','1527','5597','Patrolling Block B','1','2025-04-01 00:33:09','2025-04-01 00:34:35','3.0824945,101.7005082','Performed a thorough patrol on Level 33, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57430','1527','5598','Patrolling Block B','1','2025-04-01 00:35:20','2025-04-01 00:36:56','3.0824487,101.7005634','Performed a thorough patrol on Level 32, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57431','1527','5599','Patrolling Block B','1','2025-04-01 00:38:08','2025-04-01 00:39:41','3.0824701,101.7005643','Performed a thorough patrol on Level 31, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57432','1527','5600','Patrolling Block B','1','2025-04-01 00:43:39','2025-04-01 00:45:57','3.0825064,101.7006415','Performed a thorough patrol on Level 29, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57433','1527','5601','Patrolling Block B','1','2025-04-01 00:47:27','2025-04-01 00:49:33','3.0824611,101.7005977','Performed a thorough patrol on Level 28, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57434','1527','5602','Patrolling Block B','1','2025-04-01 01:27:50','2025-04-01 01:29:10','3.0830656,101.7008316','Performed a thorough patrol on Level 15, no incidents were reported and no issues were found.\r\n','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57435','1527','5603','Patrolling Block B','1','2025-04-01 01:24:29','2025-04-01 01:26:19','3.0823377,101.7005311','Performed a thorough patrol on Level 16, no incidents were reported and no issues were found.\r\n','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57436','1527','5604','Patrolling Block B','1','2025-04-01 01:19:53','2025-04-01 01:21:52','3.0828146,101.7009354','Performed a thorough patrol on Level 18, no incidents were reported and no issues were found.\r\n','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57437','1527','5605','Patrolling Block B','1','2025-04-01 01:18:00','2025-04-01 01:19:36','3.0828137,101.700721','Performed a thorough patrol on Level 19, no incidents were reported and no issues were found.\r\n','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57438','1527','5606','Patrolling Block B','1','2025-04-01 01:12:27','2025-04-01 01:15:46','3.0817968,101.7009584','Performed a thorough patrol on Level 20, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57439','1527','5607','Patrolling Block B','1','2025-04-01 00:51:11','2025-04-01 00:52:32','3.0826222,101.7004043','Performed a thorough patrol on Level 27, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57440','1527','5608','Patrolling Block B','1','2025-04-01 01:29:13','2025-04-01 01:31:22','3.0824332,101.7007031','Performed a thorough patrol on Level 14, no incidents were reported and no issues were found.\r\n','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57441','1527','5609','Patrolling Block B','1','2025-04-01 00:14:17','2025-04-01 00:15:34','3.0835273,101.7009205','Performed a thorough patrol on Level 38, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57442','1527','5610','Patrolling Block B','1','2025-04-01 01:32:08','2025-04-01 01:33:44','3.0831276,101.7010355','Performed a thorough patrol on Level 13, no incidents were reported and no issues were found.\r\n','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57443','1527','5611','Patrolling Block B','1','2025-04-01 00:06:25','2025-04-01 00:08:12','3.0807032,101.6995039','Performed a thorough patrol on Level 41, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57444','1527','5612','Patrolling Block B','1','2025-04-01 01:34:55','2025-04-01 01:36:32','3.0830657,101.7009268','Performed a thorough patrol on Level 12, no incidents were reported and no issues were found.\r\n','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57445','1527','5613','Patrolling Block B','1','2025-04-01 00:16:15','2025-04-01 00:18:04','3.0839897,101.7014057','Performed a thorough patrol on Level 37, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57446','1527','5614','Patrolling Block B','1','2025-04-01 00:29:58','2025-04-01 00:32:06','3.082437,101.7008932','Performed a thorough patrol on Level 34, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57447','1527','5615','Patrolling Block B','1','2025-04-01 00:39:45','2025-04-01 00:42:22','3.0824509,101.7005588','Performed a thorough patrol on Level 30, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57448','1528','821','Roll Call','1','2025-03-31 20:15:55','2025-03-31 20:19:20','','1-Dutga\r\n2-hasta\r\n3-Dipak\r\n4-Judda\r\n5 Bratan on duty night shift','1','Comong time ran','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57449','1528','4940','Guard House','1','2025-03-31 20:19:23','2025-03-31 20:24:46','','Handover & Inventory Check:\r\nWalkie-Talkie (2) & Charger Set (4)\r\nBaton (3)\r\nAccess Card (2)\r\nRain-Coat (3)\r\nHandphone (1)\r\nFire Blanket (2)\r\nFirst-Aid Box (1)\r\nWheelchair (1)\r\nBodycam (5)\r\ne-Bike & Charger Set (1)\r\nTraffic Control Light (1)','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57450','1528','5041','Real-Time Report','1','2025-03-31 20:12:24','2025-03-31 20:13:26','','Off Duty at 20:13pm','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57451','1528','5042','Real-Time Report','1','2025-04-01 08:09:53','2025-04-01 08:10:23','','Off Duty at08:10am','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57452','1528','5043','Real-Time Report','1','2025-03-31 21:59:58','2025-03-31 22:00:23','','Hourly report submitted at 10:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57453','1528','5044','Real-Time Report','1','2025-03-31 23:13:13','2025-03-31 23:13:42','','Hourly report submitted at 11:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57454','1528','5045','Real-Time Report','1','2025-04-01 00:18:08','2025-04-01 00:18:32','','Hourly report submitted at 12:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57455','1528','5046','Real-Time Report','1','2025-04-01 01:11:38','2025-04-01 01:12:07','','Hourly report submitted at 01:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57456','1528','5047','Real-Time Report','1','2025-04-01 02:11:58','2025-04-01 02:12:25','','Hourly report submitted 02:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57457','1528','5048','Real-Time Report','1','2025-04-01 03:01:49','2025-04-01 03:02:11','','Hourly report submitted at 03:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57458','1528','5049','Real-Time Report','1','2025-04-01 04:09:25','2025-04-01 04:09:46','','Hourly report submitted at 04:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57459','1528','5050','Real-Time Report','1','2025-04-01 05:06:48','2025-04-01 05:07:13','','Hourly report submitted at 05:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57460','1528','5051','Real-Time Report','1','2025-04-01 06:05:10','2025-04-01 06:05:35','','Hourly report submitted at 06:00 AM','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57461','1528','5052','Real-Time Report','1','2025-04-01 07:11:57','2025-04-01 07:12:17','','Hourly report submitted at 07:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57462','1528','5053','Real-Time Report','1','2025-03-31 21:01:31','2025-03-31 21:02:08','','Hourly report submitted at 9:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57474','1528','5466','Water Tank / Water Pump','1','2025-04-01 00:46:07','2025-04-01 00:57:38','','Conducted regular checks of the water pump and water tank to ensure proper function and level readings.\r\nWater Pump Check: The water pump is functioning properly with no signs of damage or unusual noises.\r\nWater Tank (1) Reading:240\r\nWater Tank (2) Reading:240\r\nWater Tank (3) Reading:0','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57475','1528','5467','Water Tank / Water Pump','1','2025-04-01 01:04:28','2025-04-01 01:11:33','','Conducted regular checks of the water pump and water tank to ensure proper function and level readings.\r\nWater Pump Check: The water pump is functioning properly with no signs of damage or unusual noises.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57528','1530','4765','Lobby','1','2025-04-01 08:19:35','2025-04-01 08:20:10','3.0796037,101.7033394','Info:\r\nHandover & Inventory Check:\r\nWalkie-Talkie (1)\r\nBaton (1)\r\nAccess Card (1)\r\nBodycam (1)\r\nTraffic Control Light (1)','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57529','1530','4766','Static Guard 1','1','2025-04-01 15:39:14','2025-04-01 15:42:52','3.0833264,101.7013067','Info:\r\nRoutine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57530','1530','4767','Static Guard 1','1','2025-04-01 16:35:04','2025-04-01 16:38:09','3.0849463,101.700764','Info:\r\nRoutine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57531','1530','4768','Static Guard 1','1','2025-04-01 17:34:57','2025-04-01 17:38:40','3.0846197,101.7006453','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57532','1530','4769','Static Guard 1','1','2025-04-01 18:28:36','2025-04-01 18:32:07','3.0827473,101.7001264','Info:\r\nRoutine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57533','1530','4770','Static Guard 1','1','2025-04-01 19:30:00','2025-04-01 19:33:12','3.085345,101.7001388','Info:\r\nRoutine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57534','1530','4771','Static Guard 1','1','2025-04-01 08:33:25','2025-04-01 08:34:20','3.0817968,101.7009584','Info:\r\nRoutine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57535','1530','4772','Static Guard 1','1','2025-04-01 09:30:39','2025-04-01 09:32:02','3.0823549,101.7005023','Info:\r\nRoutine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57536','1530','4773','Static Guard 1','1','2025-04-01 10:39:48','2025-04-01 10:40:56','3.0823849,101.7005628','Info:\r\nRoutine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57537','1530','4774','Static Guard 1','1','2025-04-01 12:36:08','2025-04-01 12:37:24','3.0823842,101.7005733','Info:\r\nRoutine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57538','1530','4775','Static Guard 1','1','2025-04-01 11:39:48','2025-04-01 11:40:54','3.0823442,101.7005362','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57539','1530','4776','Static Guard 1','1','2025-04-01 13:27:26','2025-04-01 13:31:26','3.0797929,101.7040128','Info:\r\nRoutine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57540','1530','4777','Static Guard 1','1','2025-04-01 14:36:55','2025-04-01 14:38:00','3.0823345,101.7005409','Info:\r\nRoutine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57541','1530','5028','Real-Time Report','1','2025-04-01 10:06:58','2025-04-01 10:07:13','3.0805862,101.7034984','Hourly report submitted at 10:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57542','1530','5029','Real-Time Report','1','2025-04-01 11:05:09','2025-04-01 11:05:23','3.0823575,101.7004908','Hourly report submitted at 11:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57543','1530','5030','Real-Time Report','1','2025-04-01 14:03:13','2025-04-01 14:03:42','3.079781,101.7036741','Hourly report submitted at 02:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57544','1530','5031','Real-Time Report','1','2025-04-01 15:15:59','2025-04-01 15:16:17','3.0853547,101.6997705','Hourly report submitted at 03:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57545','1530','5032','Real-Time Report','1','2025-04-01 16:02:28','2025-04-01 16:02:51','3.0824731,101.7005114','Hourly report submitted at 04:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57546','1530','5033','Real-Time Report','1','2025-04-01 17:04:03','2025-04-01 17:04:22','3.084125,101.7008724','Hourly report submitted at 05:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57547','1530','5034','Real-Time Report','1','2025-04-01 18:06:26','2025-04-01 18:06:45','3.0832221,101.7001486','Hourly report submitted at 06:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57548','1530','5035','Real-Time Report','1','2025-04-01 19:06:53','2025-04-01 19:07:09','3.0825171,101.7003494','Hourly report submitted at 07:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57549','1530','5036','Real-Time Report','1','2025-04-01 07:59:09','2025-04-01 08:00:03','3.0822236,101.700653','Report Duty at on 7:59 am','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57550','1530','5037','Real-Time Report','1','2025-04-01 20:08:21','2025-04-01 20:09:24','3.0795733,101.7039572','Info:\r\nOff Duty at on 8:09 pm','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57551','1530','5038','Real-Time Report','1','2025-04-01 09:01:33','2025-04-01 09:01:54','3.0823567,101.700272','Hourly report submitted at 09:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57552','1530','5039','Real-Time Report','1','2025-04-01 13:08:56','2025-04-01 13:09:15','3.0823437,101.7005006','Hourly report submitted at 01:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57553','1530','5040','Real-Time Report','1','2025-04-01 12:13:44','2025-04-01 12:13:58','3.0803143,101.7037125','Hourly report submitted at 12:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57554','1531','43','Roll Call','1','2025-04-01 08:11:16','2025-04-01 08:19:46','','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.laxuman\r\n5.durga','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57555','1531','4763','Guard House','1','2025-04-01 08:19:49','2025-04-01 08:28:45','','Handover & Inventory Check:\r\nWalkie-Talkie (2) & Charger Set (4)\r\nBaton (3)\r\nAccess Card (2)\r\nRain-Coat (3)\r\nHandphone (1)\r\nFire Blanket (2)\r\nFirst-Aid Box (1)\r\nWheelchair (1)\r\nBodycam (5)\r\ne-Bike & Charger Set (1)\r\nTraffic Control Light (1)','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57563','1531','4843','Supervisor','1','2025-04-01 11:39:59','2025-04-01 11:41:17','','Routine rounds of the guardhouse and its perimeter were conducted with no issues identified. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57564','1531','4844','Supervisor','1','2025-04-01 12:34:50','2025-04-01 12:36:05','','Routine rounds of the guardhouse and its perimeter were conducted with no issues identified. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57567','1531','4854','Car Park Patrolling','1','2025-04-01 15:04:00','2025-04-01 16:54:45','','Performed a thorough patrol on Level 7, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57568','1531','4855','Car Park Patrolling','1','2025-04-01 16:59:04','2025-04-01 17:03:49','','Performed a thorough patrol on Level 5, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57569','1531','4856','Car Park Patrolling','1','2025-04-01 17:03:52','2025-04-01 17:08:47','','Performed a thorough patrol on Level 4, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57570','1531','4857','Car Park Patrolling','1','2025-04-01 16:54:49','2025-04-01 16:59:02','','Performed a thorough patrol on Level 6, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57571','1531','4858','Car Park Patrolling','1','2025-04-01 17:08:50','2025-04-01 17:13:19','','Performed a thorough patrol on Level 3, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57572','1531','4859','Car Park Patrolling','1','2025-04-01 17:18:07','2025-04-01 17:22:21','','Performed a thorough patrol on Level 1, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57573','1531','4860','Car Park Patrolling','1','2025-04-01 17:22:53','2025-04-01 17:26:47','','Performed a thorough patrol on GF, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57574','1531','4861','Car Park Patrolling','1','2025-04-01 17:13:22','2025-04-01 17:18:04','','Performed a thorough patrol on Level 2, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57575','1531','4862','Car Park Patrolling','1','2025-04-01 17:26:49','2025-04-01 17:32:04','','Performed a thorough patrol on Basement, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57576','1531','5028','Real-Time Report','1','2025-04-01 10:06:24','2025-04-01 10:06:45','','Hourly report submitted at 10:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57577','1531','5029','Real-Time Report','1','2025-04-01 11:05:00','2025-04-01 11:05:25','','Hourly report submitted at 11:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57578','1531','5030','Real-Time Report','1','2025-04-01 14:07:06','2025-04-01 14:07:33','','Hourly report submitted at 02:00 PM','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57579','1531','5031','Real-Time Report','1','2025-04-01 15:01:58','2025-04-01 15:02:22','','Hourly report submitted at 03:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57580','1531','5032','Real-Time Report','1','2025-04-01 16:01:35','2025-04-01 16:01:55','','Hourly report submitted at 04:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57581','1531','5033','Real-Time Report','1','2025-04-01 17:22:26','2025-04-01 17:22:50','','Hourly report submitted at 05:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57582','1531','5034','Real-Time Report','1','2025-04-01 18:21:20','2025-04-01 18:21:47','','Hourly report submitted at 06:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57583','1531','5035','Real-Time Report','1','2025-04-01 19:05:49','2025-04-01 19:06:12','','Hourly report submitted at 07:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57584','1531','5036','Real-Time Report','1','2025-04-01 08:05:00','2025-04-01 08:05:57','','Report Duty at 08:04 am','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57585','1531','5037','Real-Time Report','1','2025-04-01 20:14:08','2025-04-01 20:15:24','','Off Duty at 20:15 PM ','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57586','1531','5038','Real-Time Report','1','2025-04-01 09:05:41','2025-04-01 09:06:01','','Hourly report submitted at 09:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57587','1531','5039','Real-Time Report','1','2025-04-01 13:00:39','2025-04-01 13:02:20','','Hourly report submitted at 01:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57588','1531','5040','Real-Time Report','1','2025-04-01 12:21:09','2025-04-01 12:21:39','','Hourly report submitted at 12:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57589','1532','4562','Patrolling Block B','1','2025-04-01 16:16:44','2025-04-01 16:17:25','','Performed a thorough patrol on Level 10, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57590','1532','4563','Patrolling Block B','1','2025-04-01 16:08:35','2025-04-01 16:09:12','','Performed a thorough patrol on Level 15, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57591','1532','4564','Patrolling Block B','1','2025-04-01 16:07:26','2025-04-01 16:08:08','','Performed a thorough patrol on Level 16, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57592','1532','4565','Patrolling Block B','1','2025-04-01 16:06:12','2025-04-01 16:07:00','','Performed a thorough patrol on Level 17, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57593','1532','4566','Patrolling Block B','1','2025-04-01 16:04:55','2025-04-01 16:05:36','','Performed a thorough patrol on Level 18, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57594','1532','4567','Patrolling Block B','1','2025-04-01 16:03:36','2025-04-01 16:04:28','','Performed a thorough patrol on Level 19, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57595','1532','4568','Patrolling Block B','1','2025-04-01 16:02:14','2025-04-01 16:03:02','','Performed a thorough patrol on Level 20, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57596','1532','4569','Patrolling Block B','1','2025-04-01 16:00:33','2025-04-01 16:01:11','','Performed a thorough patrol on Level 21, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57597','1532','4570','Patrolling Block B','1','2025-04-01 15:51:58','2025-04-01 15:52:47','','Performed a thorough patrol on Level 27, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57598','1532','4571','Patrolling Block B','1','2025-04-01 16:10:04','2025-04-01 16:10:41','','Performed a thorough patrol on Level 14, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57599','1532','4572','Patrolling Block B','1','2025-04-01 15:35:57','2025-04-01 15:36:47','','Performed a thorough patrol on Level 38, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57600','1532','4573','Patrolling Block B','1','2025-04-01 15:34:21','2025-04-01 15:35:15','','Performed a thorough patrol on Level 39, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57601','1532','4574','Patrolling Block B','1','2025-04-01 15:19:32','2025-04-01 16:11:54','','Performed a thorough patrol on Level 13, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57602','1532','4575','Patrolling Block B','1','2025-04-01 15:19:21','2025-04-01 15:33:31','','Performed a thorough patrol on Level 40, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57603','1532','4576','Patrolling Block B','1','2025-04-01 15:19:13','2025-04-01 15:29:42','','Performed a thorough patrol on Level 41, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57604','1532','4577','Patrolling Block B','1','2025-04-01 16:18:15','2025-04-01 16:19:00','','Performed a thorough patrol on Level 9, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57605','1532','4578','Patrolling Block B','1','2025-04-01 16:12:35','2025-04-01 16:13:29','','Performed a thorough patrol on Level 12, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57606','1532','4579','Patrolling Block B','1','2025-04-01 16:15:26','2025-04-01 16:16:04','','Performed a thorough patrol on Level 11, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57607','1532','4580','Patrolling Block B','1','2025-04-01 15:53:11','2025-04-01 15:53:57','','Performed a thorough patrol on Level 26, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57608','1532','4581','Patrolling Block B','1','2025-04-01 15:54:32','2025-04-01 15:55:34','','Performed a thorough patrol on Level 25, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57609','1532','4582','Patrolling Block B','1','2025-04-01 15:56:27','2025-04-01 15:57:22','','Performed a thorough patrol on Level 24, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57610','1532','4583','Patrolling Block B','1','2025-04-01 15:57:58','2025-04-01 15:58:47','','Performed a thorough patrol on Level 23, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57611','1532','4584','Patrolling Block B','1','2025-04-01 15:59:07','2025-04-01 15:59:51','','Performed a thorough patrol on Level 22, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57612','1532','4585','Patrolling Block B','1','2025-04-01 15:37:18','2025-04-01 15:38:04','','Performed a thorough patrol on Level 37, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57613','1532','4586','Patrolling Block B','1','2025-04-01 15:38:38','2025-04-01 15:39:24','','Performed a thorough patrol on Level 36, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57614','1532','4587','Patrolling Block B','1','2025-04-01 15:39:54','2025-04-01 15:40:40','','Performed a thorough patrol on Level 35, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57615','1532','4588','Patrolling Block B','1','2025-04-01 15:41:31','2025-04-01 15:42:28','','Performed a thorough patrol on Level 34, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57616','1532','4589','Patrolling Block B','1','2025-04-01 15:43:30','2025-04-01 15:44:13','','Performed a thorough patrol on Level 33, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57617','1532','4590','Patrolling Block B','1','2025-04-01 15:44:54','2025-04-01 15:45:40','','Performed a thorough patrol on Level 32, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57618','1532','4591','Patrolling Block B','1','2025-04-01 15:46:21','2025-04-01 15:47:01','','Performed a thorough patrol on Level 31, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57619','1532','4592','Patrolling Block B','1','2025-04-01 15:47:48','2025-04-01 15:48:26','','Performed a thorough patrol on Level 30, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57620','1532','4593','Patrolling Block B','1','2025-04-01 15:49:20','2025-04-01 15:50:14','','Performed a thorough patrol on Level 29, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57621','1532','4594','Patrolling Block B','1','2025-04-01 15:50:49','2025-04-01 15:51:30','','Performed a thorough patrol on Level 28, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57622','1532','4744','Parcel Collection / Arrangement','1','2025-04-01 08:34:37','2025-04-01 15:28:35','','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57623','1532','4757','Parcel Collection / Arrangement','1','2025-04-01 08:34:40','2025-04-01 15:28:46','','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57624','1532','4758','Parcel Collection / Arrangement','1','2025-04-01 08:34:52','2025-04-01 17:56:23','3.082359,101.7004928','Each parcel has been checked and labeled with today’s date. All parcels have been collected from the delivery area and arranged in the mailbox area.\r\nNumber of parcels that are damaged or opened:','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57625','1532','4760','Parcel Collection / Arrangement','1','2025-04-01 08:34:49','2025-04-01 17:53:38','3.0829356,101.7002852','Each parcel has been checked and labeled with today’s date. All parcels have been collected from the delivery area and arranged in the mailbox area.\r\nNumber of parcels that are damaged or opened','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57626','1532','4761','Parcel Collection / Arrangement','1','2025-04-01 14:54:48','2025-04-01 15:28:57','','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57627','1532','4762','Parcel Collection / Arrangement','1','2025-04-01 14:55:09','2025-04-01 17:55:32','3.083266,101.7002116','Each parcel has been checked and labeled with today’s date. All parcels have been collected from the delivery area and arranged in the mailbox area.\r\nNumber of parcels that are damaged or opened:','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57628','1532','4814','Static Guard 4','1','2025-04-01 13:41:24','2025-04-01 13:46:34','','Cover at level 8 ','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57629','1532','4815','Static Guard 4','1','2025-04-01 14:44:44','2025-04-01 14:49:38','','Cover at level 8 ','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57630','1532','4816','Static Guard 4','1','2025-04-01 15:30:02','2025-04-01 15:32:27','','Now,Block B petroling.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57631','1532','4817','Static Guard 4','1','2025-04-01 16:40:47','2025-04-01 16:41:54','','Routine rounds of the guardhouse and its perimeter were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57632','1532','4818','Static Guard 4','1','2025-04-01 18:30:41','2025-04-01 18:32:13','','Routine rounds of the guardhouse and its perimeter were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57633','1532','4819','Static Guard 4','1','2025-04-01 19:39:38','2025-04-01 19:40:25','','Routine rounds of the guardhouse and its perimeter were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57634','1532','4821','Static Guard 4','1','2025-04-01 09:49:52','2025-04-01 09:55:41','','Cover, at level 8','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57635','1532','4822','Static Guard 4','1','2025-04-01 08:27:50','2025-04-01 08:34:31','','Cover at level 8,','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57636','1532','4823','Static Guard 4','1','2025-04-01 10:33:28','2025-04-01 10:37:27','','Cover at level 8 ','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57637','1532','4824','Static Guard 4','1','2025-04-01 17:31:28','2025-04-01 17:33:06','','Routine rounds of the guardhouse and its perimeter were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57638','1532','5028','Real-Time Report','1','2025-04-01 10:32:56','2025-04-01 10:33:17','','Hourly report submitted at 10:00 AM.','1','Hourly report submitted at 10:00 AM.','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57639','1532','5029','Real-Time Report','1','2025-04-01 11:04:05','2025-04-01 11:04:30','','Hourly report submitted at 11:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57640','1532','5030','Real-Time Report','1','2025-04-01 13:30:02','2025-04-01 14:30:48','','Hourly report submitted at 02:00 PM.','1','Hourly report submitted at 02:00 PM.','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57641','1532','5031','Real-Time Report','1','2025-04-01 15:19:40','2025-04-01 15:20:13','','Hourly report submitted at 03:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57642','1532','5032','Real-Time Report','1','2025-04-01 16:01:58','2025-04-01 16:02:12','','Hourly report submitted at 04:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57643','1532','5033','Real-Time Report','1','2025-04-01 17:14:46','2025-04-01 17:17:49','','Hourly report submitted at 05:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57644','1532','5034','Real-Time Report','1','2025-04-01 18:04:15','2025-04-01 18:04:33','','Hourly report submitted at 06:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57645','1532','5035','Real-Time Report','1','2025-04-01 19:01:02','2025-04-01 19:01:25','','Hourly report submitted at 07:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57646','1532','5036','Real-Time Report','1','2025-04-01 08:06:21','2025-04-01 08:06:55','','Report Duty at 08:00 am','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57647','1532','5037','Real-Time Report','1','2025-04-01 20:10:54','2025-04-01 20:11:56','','Off Duty at 20:10 pm','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57648','1532','5038','Real-Time Report','1','2025-04-01 09:20:44','2025-04-01 09:21:27','','Hourly report submitted at 09:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57649','1532','5039','Real-Time Report','1','2025-04-01 13:30:34','2025-04-01 13:31:00','','Hourly report submitted at 01:00 PM.','1','Hourly report submitted at 01:00 PM.','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57650','1532','5040','Real-Time Report','1','2025-04-01 12:31:23','2025-04-01 12:31:49','','Hourly report submitted at 12:00 PM.','1','Hourly report submitted at 12:00 PM.','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57724','1533','4472','Patrolling Block A','1','2025-04-01 09:50:53','2025-04-01 09:52:18','3.0827222,101.7001039','Performed a thorough patrol on Level 10, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57725','1533','4473','Patrolling Block A','1','2025-04-01 09:42:54','2025-04-01 09:44:43','3.0823466,101.6996446','Performed a thorough patrol on Level 15, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57726','1533','4474','Patrolling Block A','1','2025-04-01 09:40:55','2025-04-01 09:42:52','3.0823466,101.6996446','Performed a thorough patrol on Level 16, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57727','1533','4475','Patrolling Block A','1','2025-04-01 09:38:31','2025-04-01 09:40:53','3.0823466,101.6996446','Performed a thorough patrol on Level 17, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57728','1533','4476','Patrolling Block A','1','2025-04-01 09:36:26','2025-04-01 09:38:20','3.0826943,101.7000782','Performed a thorough patrol on Level 18, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57729','1533','4477','Patrolling Block A','1','2025-04-01 09:33:32','2025-04-01 09:36:23','3.0790055,101.6966879','Performed a thorough patrol on Level 19, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57730','1533','4478','Patrolling Block A','1','2025-04-01 09:31:31','2025-04-01 09:33:27','3.0828216,101.7001648','Performed a thorough patrol on Level 20, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57731','1533','4479','Patrolling Block A','1','2025-04-01 09:29:24','2025-04-01 09:31:28','3.0782834,101.6961645','Performed a thorough patrol on Level 21, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57732','1533','4480','Patrolling Block A','1','2025-04-01 09:17:18','2025-04-01 09:18:58','3.0830374,101.7003279','Performed a thorough patrol on Level 27, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57733','1533','4481','Patrolling Block A','1','2025-04-01 09:44:45','2025-04-01 09:46:21','3.0772677,101.6980405','Performed a thorough patrol on Level 14, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57734','1533','4482','Patrolling Block A','1','2025-04-01 08:56:52','2025-04-01 08:58:47','3.0826877,101.700151','Performed a thorough patrol on Level 38, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57735','1533','4483','Patrolling Block A','1','2025-04-01 08:55:43','2025-04-01 08:56:50','3.0826993,101.7001254','Performed a thorough patrol on Level 39, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57736','1533','4484','Patrolling Block A','1','2025-04-01 09:46:23','2025-04-01 09:47:54','3.0784153,101.6976395','Performed a thorough patrol on Level 13, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57737','1533','4485','Patrolling Block A','1','2025-04-01 08:43:59','2025-04-01 08:45:44','3.0828392,101.700445','Performed a thorough patrol on Level 40, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57738','1533','4486','Patrolling Block A','1','2025-04-01 08:42:36','2025-04-01 08:43:56','3.0828774,101.7003234','Performed a thorough patrol on Level 41, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57739','1533','4487','Patrolling Block A','1','2025-04-01 09:52:20','2025-04-01 09:53:45','3.0826634,101.7001475','Performed a thorough patrol on Level 9, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57740','1533','4488','Patrolling Block A','1','2025-04-01 09:47:55','2025-04-01 09:49:24','3.0827235,101.7001745','Performed a thorough patrol on Level 12, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57741','1533','4489','Patrolling Block A','1','2025-04-01 09:49:26','2025-04-01 09:50:51','3.0827222,101.7001039','Performed a thorough patrol on Level 11, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57742','1533','4490','Patrolling Block A','1','2025-04-01 09:19:00','2025-04-01 09:20:45','3.0770015,101.6973217','Performed a thorough patrol on Level 26, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57743','1533','4491','Patrolling Block A','1','2025-04-01 09:20:47','2025-04-01 09:23:27','3.0829877,101.7002972','Performed a thorough patrol on Level 25, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57744','1533','4492','Patrolling Block A','1','2025-04-01 09:23:29','2025-04-01 09:25:30','3.0830383,101.700374','Performed a thorough patrol on Level 24, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57745','1533','4493','Patrolling Block A','1','2025-04-01 09:25:33','2025-04-01 09:27:34','3.0829283,101.700169','Performed a thorough patrol on Level 23, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57746','1533','4494','Patrolling Block A','1','2025-04-01 09:27:36','2025-04-01 09:29:22','3.0831831,101.7007367','Performed a thorough patrol on Level 22, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57747','1533','4495','Patrolling Block A','1','2025-04-01 08:58:50','2025-04-01 09:00:26','3.0826877,101.700151','Performed a thorough patrol on Level 37, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57748','1533','4496','Patrolling Block A','1','2025-04-01 09:00:27','2025-04-01 09:02:42','3.0827403,101.7001277','\r\nPerformed a thorough patrol on Level 36, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57749','1533','4497','Patrolling Block A','1','2025-04-01 09:03:43','2025-04-01 09:04:49','3.077512,101.6962359','Performed a thorough patrol on Level 35, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57750','1533','4498','Patrolling Block A','1','2025-04-01 09:04:51','2025-04-01 09:06:47','3.0826592,101.700105','Performed a thorough patrol on Level 34, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57751','1533','4499','Patrolling Block A','1','2025-04-01 09:06:49','2025-04-01 09:08:58','3.0826592,101.700105','Performed a thorough patrol on Level 33, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57752','1533','4500','Patrolling Block A','1','2025-04-01 09:09:00','2025-04-01 09:10:38','3.0791945,101.6966089','Performed a thorough patrol on Level 32, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57753','1533','4501','Patrolling Block A','1','2025-04-01 09:10:40','2025-04-01 09:12:04','3.070502,101.6949098','Performed a thorough patrol on Level 31, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57754','1533','4502','Patrolling Block A','1','2025-04-01 09:12:06','2025-04-01 09:13:27','3.0825271,101.6999372','Performed a thorough patrol on Level 30, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57755','1533','4503','Patrolling Block A','1','2025-04-01 09:13:29','2025-04-01 09:14:49','3.0825271,101.6999372','Performed a thorough patrol on Level 29, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57756','1533','4504','Patrolling Block A','1','2025-04-01 09:14:51','2025-04-01 09:17:14','3.0830374,101.7003279','Performed a thorough patrol on Level 28, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57757','1533','4678','Patrolling Block A - PH','1','2025-04-01 18:35:58','2025-04-01 19:10:03','3.0830355,101.7001536','Performed a thorough patrol on Level 10, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57758','1533','4679','Patrolling Block A - PH','1','2025-04-01 18:58:03','2025-04-01 18:59:53','3.0829289,101.7001779','Performed a thorough patrol on Level 15, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57759','1533','4680','Patrolling Block A - PH','1','2025-04-01 18:56:47','2025-04-01 18:58:01','3.0829747,101.6997709','Performed a thorough patrol on Level 16, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57760','1533','4681','Patrolling Block A - PH','1','2025-04-01 18:54:00','2025-04-01 18:55:56','3.0830559,101.6999425','Performed a thorough patrol on Level 17, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57761','1533','4682','Patrolling Block A - PH','1','2025-04-01 18:52:12','2025-04-01 18:53:55','3.0828112,101.6998768','Performed a thorough patrol on Level 18, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57762','1533','4683','Patrolling Block A - PH','1','2025-04-01 18:50:42','2025-04-01 18:52:10','3.0827351,101.6998836','Performed a thorough patrol on Level 19, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57763','1533','4684','Patrolling Block A - PH','1','2025-04-01 18:48:39','2025-04-01 18:50:41','3.0827311,101.7002071','Performed a thorough patrol on Level 20, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57764','1533','4685','Patrolling Block A - PH','1','2025-04-01 18:47:23','2025-04-01 18:48:18','3.08267,101.6999414','Performed a thorough patrol on Level 21, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57765','1533','4686','Patrolling Block A - PH','1','2025-04-01 18:35:43','2025-04-01 18:37:26','3.0829658,101.7001107','Performed a thorough patrol on Level 27, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57766','1533','4687','Patrolling Block A - PH','1','2025-04-01 18:59:54','2025-04-01 19:02:43','3.0829301,101.7000967','Performed a thorough patrol on Level 14, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57767','1533','4688','Patrolling Block A - PH','1','2025-04-01 18:13:14','2025-04-01 18:14:23','3.0828024,101.699992','Performed a thorough patrol on Level 38, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57768','1533','4689','Patrolling Block A - PH','1','2025-04-01 18:10:15','2025-04-01 18:13:10','3.0778776,101.6974257','Performed a thorough patrol on Level 39, no incidents were reported and no issues were found','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57769','1533','4690','Patrolling Block A - PH','1','2025-04-01 19:02:55','2025-04-01 19:04:22','3.0829576,101.7001477','Performed a thorough patrol on Level 13, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57770','1533','4691','Patrolling Block A - PH','1','2025-04-01 18:08:09','2025-04-01 18:10:13','3.0827785,101.7003236','Performed a thorough patrol on Level 40, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57771','1533','4692','Patrolling Block A - PH','1','2025-04-01 15:01:22','2025-04-01 18:08:07','3.0847808,101.7013492','Performed a thorough patrol on Level 41, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57772','1533','4693','Patrolling Block A - PH','1','2025-04-01 18:35:53','2025-04-01 19:13:51','3.0827892,101.7000959','Performed a thorough patrol on Level 9, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57773','1533','4694','Patrolling Block A - PH','1','2025-04-01 19:04:24','2025-04-01 19:07:17','3.0827217,101.7001853','Performed a thorough patrol on Level 12, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57774','1533','4695','Patrolling Block A - PH','1','2025-04-01 19:07:23','2025-04-01 19:08:12','3.0828452,101.7000304','Performed a thorough patrol on Level 11, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57775','1533','4696','Patrolling Block A - PH','1','2025-04-01 18:37:27','2025-04-01 18:39:17','3.0828104,101.7000643','Performed a thorough patrol on Level 26, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57776','1533','4697','Patrolling Block A - PH','1','2025-04-01 18:39:21','2025-04-01 18:41:07','3.0828356,101.7000008','Performed a thorough patrol on Level 25, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57777','1533','4698','Patrolling Block A - PH','1','2025-04-01 18:41:09','2025-04-01 18:42:53','3.0829245,101.7001032','Performed a thorough patrol on Level 24, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57778','1533','4699','Patrolling Block A - PH','1','2025-04-01 18:42:54','2025-04-01 18:44:44','3.0831454,101.7004861','Performed a thorough patrol on Level 23, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57779','1533','4700','Patrolling Block A - PH','1','2025-04-01 18:44:46','2025-04-01 18:46:30','3.0828531,101.7000928','Performed a thorough patrol on Level 22 no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57780','1533','4701','Patrolling Block A - PH','1','2025-04-01 18:14:25','2025-04-01 18:16:18','3.082785,101.700012','Performed a thorough patrol on Level 37, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57781','1533','4702','Patrolling Block A - PH','1','2025-04-01 18:16:22','2025-04-01 18:18:33','3.0828052,101.7000212','Performed a thorough patrol on Level 36, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57782','1533','4703','Patrolling Block A - PH','1','2025-04-01 18:18:37','2025-04-01 18:20:46','3.0827501,101.7000677','Performed a thorough patrol on Level 35, no incidents were reported and no issues were found','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57783','1533','4704','Patrolling Block A - PH','1','2025-04-01 18:20:50','2025-04-01 18:22:32','3.0828045,101.7000067','Performed a thorough patrol on Level 34, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57784','1533','4705','Patrolling Block A - PH','1','2025-04-01 18:22:38','2025-04-01 18:24:21','3.0828138,101.6999611','Performed a thorough patrol on Level 33, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57785','1533','4706','Patrolling Block A - PH','1','2025-04-01 18:24:23','2025-04-01 18:26:23','3.0828,101.6999718','Performed a thorough patrol on Level 32, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57786','1533','4707','Patrolling Block A - PH','1','2025-04-01 18:26:26','2025-04-01 18:28:13','3.0828718,101.6999644','Performed a thorough patrol on Level 31, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57787','1533','4708','Patrolling Block A - PH','1','2025-04-01 18:28:22','2025-04-01 18:30:20','3.0828712,101.699943','Performed a thorough patrol on Level 30, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57788','1533','4709','Patrolling Block A - PH','1','2025-04-01 18:30:21','2025-04-01 18:31:55','3.0828286,101.699943','Performed a thorough patrol on Level 29, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57789','1533','4710','Patrolling Block A - PH','1','2025-04-01 18:31:58','2025-04-01 18:35:19','3.0831307,101.7001509','Performed a thorough patrol on Level 28, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57790','1533','4804','Static Guard 3','1','2025-04-01 10:42:03','2025-04-01 10:44:23','3.0819646,101.6998365','Routine rounds of the guardhouse and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57791','1533','4805','Static Guard 3','1','2025-04-01 12:34:21','2025-04-01 12:35:01','3.0817284,101.6990427','Routine rounds of the guardhouse and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57792','1533','4806','Static Guard 3','1','2025-04-01 11:39:23','2025-04-01 11:41:06','3.0825074,101.6992327','Routine rounds of the guardhouse and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57793','1533','4807','Static Guard 3','1','2025-04-01 13:39:44','2025-04-01 13:40:51','3.0822591,101.7003927','Routine rounds of the guardhouse and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57794','1533','4808','Static Guard 3','1','2025-04-01 14:34:39','2025-04-01 14:35:33','3.0822827,101.6992978','Routine rounds of the guardhouse and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57795','1533','4809','Static Guard 3','1','2025-04-01 16:31:49','2025-04-01 16:33:48','3.0823222,101.7005011','Routine rounds of the guardhouse and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57796','1533','4810','Static Guard 3','1','2025-04-01 17:32:12','2025-04-01 17:34:19','3.0823475,101.7005303','Routine rounds of the guardhouse and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57797','1533','4811','Static Guard 3','1','2025-04-01 18:33:39','2025-04-01 18:35:41','3.0822913,101.7001876','Routine rounds of the guardhouse and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57798','1533','4812','Static Guard 3','1','2025-04-01 19:33:09','2025-04-01 19:35:01','3.0824258,101.6990885','Routine rounds of the guardhouse and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57799','1533','4813','Static Guard 3','1','2025-04-01 15:30:51','2025-04-01 15:33:05','3.0814897,101.7009584','Routine rounds of the guardhouse and its perimeter were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57800','1533','5028','Real-Time Report','1','2025-04-01 10:03:08','2025-04-01 10:03:43','3.0795208,101.7032892','Hourly report submitted at 10:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57801','1533','5029','Real-Time Report','1','2025-04-01 11:05:43','2025-04-01 11:06:18','3.0816557,101.6990631','Hourly report submitted at 11:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57802','1533','5030','Real-Time Report','1','2025-04-01 14:07:49','2025-04-01 14:08:11','3.0822591,101.7003927','Hourly report submitted at 02:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57803','1533','5031','Real-Time Report','1','2025-04-01 15:01:46','2025-04-01 15:02:23','3.0824958,101.6990343','Hourly report submitted at 03:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57804','1533','5032','Real-Time Report','1','2025-04-01 16:01:18','2025-04-01 16:02:02','3.0823475,101.7005303','Hourly report submitted at 04:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57805','1533','5033','Real-Time Report','1','2025-04-01 17:01:29','2025-04-01 17:02:05','3.0823176,101.7004715','Hourly report submitted at 05:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57806','1533','5034','Real-Time Report','1','2025-04-01 18:01:23','2025-04-01 18:01:52','3.0823433,101.7005295','Hourly report submitted at 06:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57807','1533','5035','Real-Time Report','1','2025-04-01 19:01:54','2025-04-01 19:02:22','3.0799755,101.7034718','Hourly report submitted at 07:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57808','1533','5036','Real-Time Report','1','2025-04-01 08:01:20','2025-04-01 08:02:03','3.0824012,101.7004513','Report Duty at:08:00am','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57809','1533','5037','Real-Time Report','1','2025-04-01 20:06:58','2025-04-01 20:08:01','3.0824157,101.6988957','Off Duty at:20:06pm','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57810','1533','5038','Real-Time Report','1','2025-04-01 09:02:51','2025-04-01 09:03:41','3.0827403,101.7001277','Hourly report submitted at 09:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57811','1533','5039','Real-Time Report','1','2025-04-01 13:00:31','2025-04-01 13:00:51','3.0821654,101.7007162','Hourly report submitted at 01:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57812','1533','5040','Real-Time Report','1','2025-04-01 12:13:50','2025-04-01 12:14:28','3.0817284,101.6990427','Hourly report submitted at 12:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57920','1535','4941','Level 8','1','2025-04-01 20:18:19','2025-04-01 20:20:58','3.0828692,101.7001473','Handover & Inventory Check:\r\nWalkie-Talkie (1)\r\nBaton (1)\r\nAccess Card (1)\r\nBodycam (1)\r\nGym Pass (11)','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57921','1535','5041','Real-Time Report','1','2025-04-01 20:02:39','2025-04-01 20:03:11','3.0822798,101.7006077','On Duty 08 00 pm ','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57922','1535','5042','Real-Time Report','1','2025-04-02 08:10:03','2025-04-02 08:10:42','3.0854365,101.6997095','Off Duty at 08:08 am ','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57923','1535','5043','Real-Time Report','1','2025-04-01 20:03:12','2025-04-01 22:04:53','3.0826107,101.7003905','Hourly report submitted at 10:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57924','1535','5044','Real-Time Report','1','2025-04-01 23:07:29','2025-04-01 23:07:55','3.082415,101.7006026','Hourly report submitted at 11:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57925','1535','5045','Real-Time Report','1','2025-04-02 00:03:25','2025-04-02 00:04:03','3.082368,101.7004981','Hourly report submitted at 12:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57926','1535','5046','Real-Time Report','1','2025-04-02 01:06:23','2025-04-02 01:06:42','3.082424,101.699911','Hourly report submitted at 01:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57927','1535','5047','Real-Time Report','1','2025-04-02 02:02:48','2025-04-02 02:03:11','3.0823592,101.7004917','Hourly report submitted 02:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57928','1535','5048','Real-Time Report','1','2025-04-02 03:02:02','2025-04-02 03:02:52','3.0822606,101.7008681','Hourly report submitted at 03:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57929','1535','5049','Real-Time Report','1','2025-04-02 04:08:00','2025-04-02 04:08:23','3.0823612,101.7004875','Hourly report submitted at 04:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57930','1535','5050','Real-Time Report','1','2025-04-02 05:04:05','2025-04-02 05:04:24','','Hourly report submitted at 05:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57931','1535','5051','Real-Time Report','1','2025-04-02 06:03:42','2025-04-02 06:04:11','3.0839927,101.6996659','Hourly report submitted at 06:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57932','1535','5052','Real-Time Report','1','2025-04-02 07:10:47','2025-04-02 07:11:16','3.082415,101.7006026','Hourly report submitted at 07:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57933','1535','5053','Real-Time Report','1','2025-04-01 21:03:51','2025-04-01 21:04:35','3.085227,101.7000857','Hourly report submitted at 9:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57934','1535','5177','Static Guard 3','1','2025-04-01 19:12:59','2025-04-01 20:39:41','3.082415,101.7006026','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57935','1535','5178','Static Guard 3','1','2025-04-01 21:31:45','2025-04-01 21:35:57','3.0823739,101.7004789','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57936','1535','5179','Static Guard 3','1','2025-04-01 22:33:27','2025-04-01 22:37:33','3.0826837,101.7003551','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57937','1535','5180','Static Guard 3','1','2025-04-01 23:31:26','2025-04-01 23:35:06','3.082415,101.7006026','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57938','1535','5181','Static Guard 3','1','2025-04-02 06:44:51','2025-04-02 06:49:26','3.0849003,101.7012076','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57939','1535','5182','Static Guard 3','1','2025-04-02 07:35:45','2025-04-02 07:42:17','3.0792596,101.7032033','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57941','1535','5184','Static Guard 3','1','2025-04-01 23:58:52','2025-04-02 00:03:09','3.082415,101.7006026','Areas Checked:\r\n1. Gym Room: Checked & Secured\r\n2. Toilets: Checked & Secured\r\n3. Swimming Pool Area: Checked & Secured\r\n4. Multi-Purpose Room: Checked & Secured\r\n5. Library & BBQ Area: Checked & Secured\r\n\r\nLevel 8 is closed and no one was found in the perimeter. All doors are locked','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57942','1535','5218','Static Guard 3','1','2025-04-02 02:34:43','2025-04-02 02:35:54','3.0821979,101.7006236','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57943','1535','5219','Static Guard 3','1','2025-04-02 03:41:36','2025-04-02 03:42:42','3.0823345,101.7005409','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57944','1535','5220','Static Guard 3','1','2025-04-02 04:34:11','2025-04-02 04:35:30','3.0829354,101.7004071','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57945','1535','5221','Static Guard 3','1','2025-04-02 05:32:53','2025-04-02 05:33:54','3.0823618,101.7004831','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57946','1535','5312','Water Riser Block B','1','2025-04-02 01:28:50','2025-04-02 01:29:29','3.0827053,101.7001197','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57947','1535','5313','Water Riser Block B','1','2025-04-02 01:15:47','2025-04-02 01:16:03','3.0821572,101.6996724','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57948','1535','5314','Water Riser Block B','1','2025-04-02 01:14:51','2025-04-02 01:15:45','3.0823473,101.7004516','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57949','1535','5315','Water Riser Block B','1','2025-04-02 01:10:40','2025-04-02 01:10:59','3.0829804,101.7009495','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57950','1535','5316','Water Riser Block B','1','2025-04-02 01:09:09','2025-04-02 01:10:37','3.0829203,101.7009242','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57951','1535','5317','Water Riser Block B','1','2025-04-02 01:02:52','2025-04-02 01:03:11','3.0826275,101.7000165','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57952','1535','5318','Water Riser Block B','1','2025-04-02 01:02:00','2025-04-02 01:02:49','3.081802,101.6989015','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57953','1535','5319','Water Riser Block B','1','2025-04-02 00:54:58','2025-04-02 00:55:35','3.0824387,101.6999497','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57954','1535','5320','Water Riser Block B','1','2025-04-02 00:40:49','2025-04-02 00:41:06','3.0824737,101.7001938','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57955','1535','5321','Water Riser Block B','1','2025-04-02 01:19:19','2025-04-02 01:20:04','3.0778282,101.6988236','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57956','1535','5322','Water Riser Block B','1','2025-04-02 00:14:20','2025-04-02 00:14:54','3.08457,101.7003254','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57957','1535','5323','Water Riser Block B','1','2025-04-02 00:13:33','2025-04-02 00:14:15','3.0830014,101.701065','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57958','1535','5324','Water Riser Block B','1','2025-04-02 01:21:37','2025-04-02 01:22:20','3.082978,101.7005238','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57959','1535','5325','Water Riser Block B','1','2025-04-02 00:11:10','2025-04-02 00:12:00','3.0832811,101.700581','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57960','1535','5326','Water Riser Block B','1','2025-04-02 00:08:10','2025-04-02 00:09:06','3.0824489,101.7002226','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57961','1535','5327','Water Riser Block B','1','2025-04-02 01:39:39','2025-04-02 01:40:23','3.0825182,101.7003366','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57962','1535','5328','Water Riser Block B','1','2025-04-02 01:22:53','2025-04-02 01:23:09','3.0805644,101.7013142','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57963','1535','5329','Water Riser Block B','1','2025-04-02 01:26:59','2025-04-02 01:28:48','3.0826953,101.7001309','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57964','1535','5330','Water Riser Block B','1','2025-04-02 00:44:28','2025-04-02 00:45:13','3.0827573,101.7005342','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57965','1535','5331','Water Riser Block B','1','2025-04-02 00:45:15','2025-04-02 00:45:34','3.0834144,101.7006972','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57966','1535','5332','Water Riser Block B','1','2025-04-02 00:49:18','2025-04-02 00:50:08','3.08254,101.7009316','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57967','1535','5333','Water Riser Block B','1','2025-04-02 00:50:11','2025-04-02 00:50:28','3.0826356,101.7015788','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57968','1535','5334','Water Riser Block B','1','2025-04-02 00:54:08','2025-04-02 00:54:54','3.0817939,101.7001302','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57969','1535','5335','Water Riser Block B','1','2025-04-02 00:18:32','2025-04-02 00:19:23','3.0825187,101.7003454','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57970','1535','5336','Water Riser Block B','1','2025-04-02 00:19:26','2025-04-02 00:19:46','3.0826146,101.7003548','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57971','1535','5337','Water Riser Block B','1','2025-04-02 00:23:05','2025-04-02 00:23:46','3.0825328,101.7003666','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57972','1535','5338','Water Riser Block B','1','2025-04-02 00:23:49','2025-04-02 00:24:08','3.0825686,101.700198','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57973','1535','5339','Water Riser Block B','1','2025-04-02 00:27:59','2025-04-02 00:28:49','3.0826022,101.70016','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57974','1535','5340','Water Riser Block B','1','2025-04-02 00:30:19','2025-04-02 00:31:06','3.0825666,101.700169','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57975','1535','5341','Water Riser Block B','1','2025-04-02 00:31:09','2025-04-02 00:31:27','3.0825668,101.7001688','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57976','1535','5342','Water Riser Block B','1','2025-04-02 00:35:06','2025-04-02 00:35:56','3.0827339,101.7002072','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57977','1535','5343','Water Riser Block B','1','2025-04-02 00:35:58','2025-04-02 00:36:22','3.0827566,101.7002347','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57978','1535','5344','Water Riser Block B','1','2025-04-02 00:40:10','2025-04-02 00:40:46','3.0824646,101.7001816','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57979','1535','5583','Patrolling Block B','1','2025-04-02 01:29:55','2025-04-02 01:37:26','3.082363,101.7005978','Performed a thorough patrol on Level 10, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57980','1535','5584','Patrolling Block B','1','2025-04-02 01:11:02','2025-04-02 01:12:43','3.0823686,101.7005204','Performed a thorough patrol on Level 17, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57981','1535','5585','Patrolling Block B','1','2025-04-02 00:55:37','2025-04-02 00:57:10','3.0832541,101.7014603','Performed a thorough patrol on Level 21, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57982','1535','5586','Patrolling Block B','1','2025-04-02 00:12:06','2025-04-02 00:13:31','3.0835035,101.701209','Performed a thorough patrol on Level 39, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57983','1535','5587','Patrolling Block B','1','2025-04-02 00:09:09','2025-04-02 00:11:07','3.0830675,101.7006504','Performed a thorough patrol on Level 40, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57984','1535','5588','Patrolling Block B','1','2025-04-02 01:37:28','2025-04-02 01:39:34','3.0824279,101.7004366',' Performed a thorough patrol on Level 9, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57985','1535','5589','Patrolling Block B','1','2025-04-02 01:24:47','2025-04-02 01:26:57','3.0805644,101.7013142','Performed a thorough patrol on Level 11, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57986','1535','5590','Patrolling Block B','1','2025-04-02 00:42:31','2025-04-02 00:44:26','3.0825527,101.7005131','Performed a thorough patrol on Level 26, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57987','1535','5591','Patrolling Block B','1','2025-04-02 00:45:40','2025-04-02 00:47:15','3.0825248,101.7005129','Performed a thorough patrol on Level 25, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57988','1535','5592','Patrolling Block B','1','2025-04-02 00:47:17','2025-04-02 00:49:16','3.0833367,101.7011289','Performed a thorough patrol on Level 24, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57989','1535','5593','Patrolling Block B','1','2025-04-02 00:50:32','2025-04-02 00:52:10','3.0831569,101.700797','Performed a thorough patrol on Level 23, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57990','1535','5594','Patrolling Block B','1','2025-04-02 00:52:20','2025-04-02 00:54:06','3.0833484,101.7013559','Performed a thorough patrol on Level 22, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57991','1535','5595','Patrolling Block B','1','2025-04-02 00:19:48','2025-04-02 00:21:08','3.0824695,101.7006171','Performed a thorough patrol on Level 36, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57992','1535','5596','Patrolling Block B','1','2025-04-02 00:21:10','2025-04-02 00:22:58','3.0824591,101.7005401','Performed a thorough patrol on Level 35, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57993','1535','5597','Patrolling Block B','1','2025-04-02 00:25:47','2025-04-02 00:27:57','3.0824965,101.7006096','Performed a thorough patrol on Level 33, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57994','1535','5598','Patrolling Block B','1','2025-04-02 00:28:56','2025-04-02 00:30:15','3.0824679,101.7005071','Performed a thorough patrol on Level 32, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57995','1535','5599','Patrolling Block B','1','2025-04-02 00:31:29','2025-04-02 00:32:59','3.081893,101.7003904','Performed a thorough patrol on Level 31, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57996','1535','5600','Patrolling Block B','1','2025-04-02 00:36:26','2025-04-02 00:37:49','3.0824123,101.7006025','Performed a thorough patrol on Level 29, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57997','1535','5601','Patrolling Block B','1','2025-04-02 00:37:52','2025-04-02 00:40:00','3.0824571,101.7005299','Performed a thorough patrol on Level 28, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57998','1535','5602','Patrolling Block B','1','2025-04-02 01:16:05','2025-04-02 01:17:29','3.082401,101.7004896','Performed a thorough patrol on Level 15, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('57999','1535','5603','Patrolling Block B','1','2025-04-02 01:12:47','2025-04-02 01:14:47','3.0823941,101.7004833','Performed a thorough patrol on Level 16, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58000','1535','5604','Patrolling Block B','1','2025-04-02 01:05:35','2025-04-02 01:09:04','3.0825583,101.7005673','Performed a thorough patrol on Level 18, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58001','1535','5605','Patrolling Block B','1','2025-04-02 01:03:15','2025-04-02 01:05:30','3.0822361,101.7000041','Performed a thorough patrol on Level 19, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58002','1535','5606','Patrolling Block B','1','2025-04-02 00:57:42','2025-04-02 01:01:56','3.0835286,101.701391','Performed a thorough patrol on Level 20, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58003','1535','5607','Patrolling Block B','1','2025-04-02 00:41:09','2025-04-02 00:42:29','3.0824178,101.7004819','Performed a thorough patrol on Level 27, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58004','1535','5608','Patrolling Block B','1','2025-04-02 01:17:31','2025-04-02 01:19:17','3.0824302,101.7008384','Performed a thorough patrol on Level 14, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58005','1535','5609','Patrolling Block B','1','2025-04-02 00:15:05','2025-04-02 00:16:08','3.0835274,101.7010891','Performed a thorough patrol on Level 38, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58006','1535','5610','Patrolling Block B','1','2025-04-02 01:20:06','2025-04-02 01:21:35','3.0824103,101.7004687','Performed a thorough patrol on Level 13, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58007','1535','5611','Patrolling Block B','1','2025-04-02 00:05:03','2025-04-02 00:08:07','3.0824408,101.7005','Performed a thorough patrol on Level 41, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58008','1535','5612','Patrolling Block B','1','2025-04-02 01:23:11','2025-04-02 01:24:45','3.0805644,101.7013142','Performed a thorough patrol on Level 12, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58009','1535','5613','Patrolling Block B','1','2025-04-02 00:16:18','2025-04-02 00:18:30','3.0836336,101.7013119','Performed a thorough patrol on Level 37, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58010','1535','5614','Patrolling Block B','1','2025-04-02 00:24:13','2025-04-02 00:25:40','3.0823816,101.7008154','Performed a thorough patrol on Level 34, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58011','1535','5615','Patrolling Block B','1','2025-04-02 00:33:06','2025-04-02 00:34:56','3.0824391,101.7005617','Performed a thorough patrol on Level 30, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58012','1536','821','Roll Call','1','2025-04-01 20:08:24','2025-04-01 20:11:15','','1-Durga\r\n2-hasta\r\n3-Brataman\r\n4-Laxman\r\n5-Anit on duty nigst shoft','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58013','1536','4940','Guard House','1','2025-04-01 20:11:34','2025-04-01 20:16:13','','Handover & Inventory Check:\r\nWalkie-Talkie (2) & Charger Set (4)\r\nBaton (3)\r\nAccess Card (2)\r\nRain-Coat (3)\r\nHandphone (1)\r\nFire Blanket (2)\r\nFirst-Aid Box (1)\r\nWheelchair (1)\r\nBodycam (5)\r\ne-Bike & Charger Set (1)\r\nTraffic Control Light (1)','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58014','1536','5041','Real-Time Report','1','2025-04-01 20:03:46','2025-04-01 20:05:29','','Report Duty at 20:05pm','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58015','1536','5042','Real-Time Report','1','2025-04-02 08:03:38','2025-04-02 08:04:17','','Off Duty at 08:00am','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58016','1536','5043','Real-Time Report','1','2025-04-01 22:06:07','2025-04-01 22:06:35','','Hourly report submitted at 10:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58017','1536','5044','Real-Time Report','1','2025-04-01 23:01:49','2025-04-01 23:02:14','','Hourly report submitted at 11:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58018','1536','5045','Real-Time Report','1','2025-04-02 00:14:55','2025-04-02 00:15:16','','Hourly report submitted at 12:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58019','1536','5046','Real-Time Report','1','2025-04-02 01:15:57','2025-04-02 01:16:28','','Hourly report submitted at 01:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58020','1536','5047','Real-Time Report','1','2025-04-02 00:16:29','2025-04-02 02:04:19','','Hourly report submitted 02:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58021','1536','5048','Real-Time Report','1','2025-04-02 03:01:31','2025-04-02 03:01:58','','Hourly report submitted at 03:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58022','1536','5049','Real-Time Report','1','2025-04-02 04:06:39','2025-04-02 04:07:00','','Hourly report submitted at 04:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58023','1536','5050','Real-Time Report','1','2025-04-02 05:02:24','2025-04-02 05:02:53','','Hourly report submitted at 05:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58024','1536','5051','Real-Time Report','1','2025-04-02 06:06:58','2025-04-02 06:07:23','','Hourly report submitted at 06:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58025','1536','5052','Real-Time Report','1','2025-04-02 07:04:30','2025-04-02 07:04:50','','Hourly report submitted at 07:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58026','1536','5053','Real-Time Report','1','2025-04-01 20:23:10','2025-04-01 21:00:24','','Hourly report submitted at 9:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58038','1536','5466','Water Tank / Water Pump','1','2025-04-02 00:32:05','2025-04-02 00:52:55','','Conducted regular checks of the water pump and water tank to ensure proper function and level readings.\r\nWater Pump Check: The water pump is functioning properly with no signs of damage or unusual noises.\r\nWater Tank (1) Reading:240\r\nWater Tank (2) Reading:240\r\nWater Tank (3) Reading:0','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58039','1536','5467','Water Tank / Water Pump','1','2025-04-02 01:03:12','2025-04-02 01:15:54','','Conducted regular checks of the water pump and water tank to ensure proper function and level readings.\r\nWater Pump Check: The water pump is functioning properly with no signs of damage or unusual noises.','1','Water pump room label basement taking picture but no network thank you','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58212','1540','4678','Patrolling Block A - PH','1','2025-04-01 22:22:07','2025-04-02 00:08:39','3.0822978,101.6995145','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58213','1540','4679','Patrolling Block A - PH','1','2025-04-02 00:07:59','2025-04-02 00:08:05','3.0822978,101.6995145','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58214','1540','4680','Patrolling Block A - PH','1','2025-04-02 00:07:25','2025-04-02 00:07:51','3.0822978,101.6995145','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58215','1540','4681','Patrolling Block A - PH','1','2025-04-02 00:06:25','2025-04-02 00:07:22','3.0822978,101.6995145','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58216','1540','4682','Patrolling Block A - PH','1','2025-04-02 00:06:17','2025-04-02 00:06:23','3.0822893,101.6995472','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58217','1540','4683','Patrolling Block A - PH','1','2025-04-02 00:06:11','2025-04-02 00:06:15','3.0822893,101.6995472','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58218','1540','4684','Patrolling Block A - PH','1','2025-04-02 00:06:04','2025-04-02 00:06:09','3.0822893,101.6995472','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58219','1540','4685','Patrolling Block A - PH','1','2025-04-02 00:05:56','2025-04-02 00:06:03','3.0822893,101.6995472','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58220','1540','4686','Patrolling Block A - PH','1','2025-04-02 00:04:34','2025-04-02 00:04:40','3.0822893,101.6995472','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58221','1540','4687','Patrolling Block A - PH','1','2025-04-02 00:08:07','2025-04-02 00:08:12','3.0822978,101.6995145','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58222','1540','4688','Patrolling Block A - PH','1','2025-04-02 00:02:55','2025-04-02 00:03:00','3.0822893,101.6995472','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58223','1540','4689','Patrolling Block A - PH','1','2025-04-02 00:02:46','2025-04-02 00:02:53','3.0822893,101.6995472','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58224','1540','4690','Patrolling Block A - PH','1','2025-04-02 00:08:13','2025-04-02 00:08:18','3.0822978,101.6995145','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58225','1540','4691','Patrolling Block A - PH','1','2025-04-01 17:48:53','2025-04-02 00:02:44','3.0822893,101.6995472','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58226','1540','4692','Patrolling Block A - PH','1','2025-04-02 00:02:08','2025-04-02 00:02:36','3.0822893,101.6995472','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58227','1540','4693','Patrolling Block A - PH','1','2025-04-01 20:23:45','2025-04-02 00:08:45','3.0822978,101.6995145','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58228','1540','4694','Patrolling Block A - PH','1','2025-04-02 00:08:20','2025-04-02 00:08:25','3.0822978,101.6995145','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58229','1540','4695','Patrolling Block A - PH','1','2025-04-01 20:23:49','2025-04-02 00:08:31','3.0822978,101.6995145','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58230','1540','4696','Patrolling Block A - PH','1','2025-04-02 00:04:42','2025-04-02 00:04:47','3.0822893,101.6995472','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58231','1540','4697','Patrolling Block A - PH','1','2025-04-02 00:04:48','2025-04-02 00:04:53','3.0822893,101.6995472','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58232','1540','4698','Patrolling Block A - PH','1','2025-04-02 00:04:55','2025-04-02 00:05:12','3.0822893,101.6995472','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58233','1540','4699','Patrolling Block A - PH','1','2025-04-02 00:05:40','2025-04-02 00:05:45','3.0822893,101.6995472','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58234','1540','4700','Patrolling Block A - PH','1','2025-04-02 00:05:47','2025-04-02 00:05:54','3.0822893,101.6995472','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58235','1540','4701','Patrolling Block A - PH','1','2025-04-02 00:03:08','2025-04-02 00:03:14','3.0822893,101.6995472','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58236','1540','4702','Patrolling Block A - PH','1','2025-04-02 00:03:16','2025-04-02 00:03:20','3.0822893,101.6995472','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58237','1540','4703','Patrolling Block A - PH','1','2025-04-02 00:03:23','2025-04-02 00:03:30','3.0822893,101.6995472','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58238','1540','4704','Patrolling Block A - PH','1','2025-04-02 00:03:32','2025-04-02 00:03:38','3.0822893,101.6995472','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58239','1540','4705','Patrolling Block A - PH','1','2025-04-02 00:03:39','2025-04-02 00:03:45','3.0822893,101.6995472','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58240','1540','4706','Patrolling Block A - PH','1','2025-04-02 00:03:49','2025-04-02 00:03:54','3.0822893,101.6995472','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58241','1540','4707','Patrolling Block A - PH','1','2025-04-02 00:03:56','2025-04-02 00:04:04','3.0822893,101.6995472','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58242','1540','4708','Patrolling Block A - PH','1','2025-04-02 00:04:06','2025-04-02 00:04:11','3.0822893,101.6995472','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58243','1540','4709','Patrolling Block A - PH','1','2025-04-01 20:24:44','2025-04-02 00:04:18','3.0822893,101.6995472','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58244','1540','4710','Patrolling Block A - PH','1','2025-04-02 00:04:21','2025-04-02 00:04:29','3.0822893,101.6995472','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58245','1540','5056','Real-Time Report MO-OT','1','2025-04-01 22:02:17','2025-04-01 22:02:42','3.082616,101.6999155','Hourly report submitted at 10:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58246','1540','5092','MO-OT','1','2025-04-01 20:36:49','2025-04-01 20:37:56','3.0836201,101.7008432','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58247','1540','5093','MO-OT','1','2025-04-01 21:37:46','2025-04-01 21:38:49','3.0821829,101.6991669','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58248','1540','5902','MO-OT','1','2025-04-02 00:14:22','2025-04-02 00:14:47','3.0822978,101.6995145','','1','System issue ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58249','1540','5911','MO-OT','1','2025-04-01 23:10:30','2025-04-01 23:11:26','3.0827414,101.7002153','Performed a thorough patrol on Level 10, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58250','1540','5912','MO-OT','1','2025-04-01 23:00:06','2025-04-01 23:01:11','3.0827532,101.7001856','Performed a thorough patrol on Level 15, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58251','1540','5913','MO-OT','1','2025-04-01 22:57:58','2025-04-01 22:58:54','3.0821308,101.6995305','Performed a thorough patrol on Level 16, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58252','1540','5914','MO-OT','1','2025-04-01 22:56:02','2025-04-01 22:57:00','3.0845688,101.7002468','Performed a thorough patrol on Level 17, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58253','1540','5915','MO-OT','1','2025-04-01 22:53:59','2025-04-01 22:54:59','3.0823716,101.6998193','Performed a thorough patrol on Level 18, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58254','1540','5916','MO-OT','1','2025-04-01 22:51:53','2025-04-01 22:52:53','3.0823479,101.6999195','\r\nPerformed a thorough patrol on Level 19, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58255','1540','5917','MO-OT','1','2025-04-01 22:35:14','2025-04-01 22:36:14','3.0831856,101.7003549','Performed a thorough patrol on Level 27, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58256','1540','5918','MO-OT','1','2025-04-01 23:02:16','2025-04-01 23:03:12','3.0827228,101.7001919','Performed a thorough patrol on Level 14, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58257','1540','5919','MO-OT','1','2025-04-01 22:10:45','2025-04-01 22:12:03','3.082855,101.7001071','Performed a thorough patrol on Level 38, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58258','1540','5920','MO-OT','1','2025-04-01 23:04:11','2025-04-01 23:05:00','3.082616,101.699986','Performed a thorough patrol on Level 13, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58259','1540','5921','MO-OT','1','2025-04-01 22:05:26','2025-04-01 22:06:41','3.0826653,101.700138','Performed a thorough patrol on Level 40, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58260','1540','5922','MO-OT','1','2025-04-01 22:02:52','2025-04-01 22:04:01','3.0824845,101.6996999','Performed a thorough patrol on Level 41, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58261','1540','5923','MO-OT','1','2025-04-01 23:12:22','2025-04-01 23:13:12','3.0828088,101.7001166','Performed a thorough patrol on Level 9, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58262','1540','5924','MO-OT','1','2025-04-01 23:05:57','2025-04-01 23:06:52','3.0827049,101.700158','\r\nPerformed a thorough patrol on Level 12, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58263','1540','5925','MO-OT','1','2025-04-01 23:08:24','2025-04-01 23:09:32','3.0827414,101.7002153','\r\nPerformed a thorough patrol on Level 11, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58264','1540','5926','MO-OT','1','2025-04-01 22:37:23','2025-04-01 22:38:16','3.082752,101.7000559','Performed a thorough patrol on Level 26, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58265','1540','5927','MO-OT','1','2025-04-01 22:38:19','2025-04-01 22:40:22','3.0828825,101.7002587','Performed a thorough patrol on Level 25, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58266','1540','5928','MO-OT','1','2025-04-01 22:45:51','2025-04-01 22:46:50','3.0827685,101.7001013','Performed a thorough patrol on Level 22, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58267','1540','5929','MO-OT','1','2025-04-01 22:13:15','2025-04-01 22:14:17','3.082686,101.7001715','Performed a thorough patrol on Level 37, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58268','1540','5930','MO-OT','1','2025-04-01 22:15:08','2025-04-01 22:16:35','3.0827002,101.7002152','Performed a thorough patrol on Level 36, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58269','1540','5931','MO-OT','1','2025-04-01 22:17:30','2025-04-01 22:18:49','3.0826812,101.7001403','\r\nPerformed a thorough patrol on Level 35, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58270','1540','5932','MO-OT','1','2025-04-01 22:22:07','2025-04-01 22:23:05','3.0827462,101.7001025','Performed a thorough patrol on Level 33, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58271','1540','5933','MO-OT','1','2025-04-01 22:24:21','2025-04-01 22:25:29','3.0826812,101.7001336','Performed a thorough patrol on Level 32, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58272','1540','5934','MO-OT','1','2025-04-01 22:26:55','2025-04-01 22:27:52','3.0825613,101.7000871','Performed a thorough patrol on Level 31, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58273','1540','5935','MO-OT','1','2025-04-01 22:29:03','2025-04-01 22:29:55','3.0827511,101.7000386','Performed a thorough patrol on Level 30, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58274','1540','5936','MO-OT','1','2025-04-01 22:30:41','2025-04-01 22:31:55','3.0831669,101.7004644','Performed a thorough patrol on Level 29, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58275','1540','5937','MO-OT','1','2025-04-01 22:33:06','2025-04-01 22:34:02','3.0831293,101.7001473','Performed a thorough patrol on Level 28, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58276','1540','5938','MO-OT','1','2025-04-01 22:07:57','2025-04-01 22:09:34','3.0687582,101.6860155','Performed a thorough patrol on Level 39, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58277','1540','5939','MO-OT','1','2025-04-01 22:49:58','2025-04-01 22:50:54','3.0827694,101.7002541','Performed a thorough patrol on Level 20, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58278','1540','5940','MO-OT','1','2025-04-01 22:47:51','2025-04-01 22:48:50','3.0827694,101.7002541','Performed a thorough patrol on Level 21, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58279','1540','5941','MO-OT','1','2025-04-01 22:41:25','2025-04-01 22:42:34','3.0827711,101.7001379','Performed a thorough patrol on Level 24, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58280','1540','5942','MO-OT','1','2025-04-01 22:43:49','2025-04-01 22:44:40','3.0828208,101.7001646','Performed a thorough patrol on Level 23, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58281','1540','5943','MO-OT','1','2025-04-01 22:19:56','2025-04-01 22:21:00','3.0826709,101.7001247','Performed a thorough patrol on Level 34, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58282','1540','5944','MO-OT','1','2025-04-01 22:50:58','2025-04-01 22:51:31','3.0823479,101.6999195','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58283','1540','5945','MO-OT','1','2025-04-01 22:48:54','2025-04-01 22:49:33','3.0827694,101.7002541','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58284','1540','5946','MO-OT','1','2025-04-01 22:09:40','2025-04-01 22:10:24','3.0826555,101.7000915','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58285','1540','5947','MO-OT','1','2025-04-01 22:42:42','2025-04-01 22:43:19','3.0825433,101.7000678','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58286','1540','5948','MO-OT','1','2025-04-01 22:44:45','2025-04-01 22:45:25','3.0828208,101.7001646','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58287','1540','5949','MO-OT','1','2025-04-01 22:21:05','2025-04-01 22:21:44','3.0826709,101.7001247','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58288','1540','5950','MO-OT','1','2025-04-01 23:01:17','2025-04-01 23:01:53','3.0827609,101.7001868','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58289','1540','5951','MO-OT','1','2025-04-01 22:57:04','2025-04-01 22:57:37','3.0825885,101.7000305','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58290','1540','5952','MO-OT','1','2025-04-01 22:55:04','2025-04-01 22:55:57','3.0823499,101.6997689','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58291','1540','5953','MO-OT','1','2025-04-01 22:52:58','2025-04-01 22:53:33','3.0823716,101.6998193','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58292','1540','5954','MO-OT','1','2025-04-01 22:36:18','2025-04-01 22:36:55','3.0827239,101.7000326','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58293','1540','5955','MO-OT','1','2025-04-01 23:03:17','2025-04-01 23:03:49','3.0827228,101.7001919','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58294','1540','5956','MO-OT','1','2025-04-01 23:05:04','2025-04-01 23:05:36','3.082616,101.699986','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58295','1540','5957','MO-OT','1','2025-04-01 23:13:15','2025-04-01 23:13:53','3.0828088,101.7001166','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58296','1540','5958','MO-OT','1','2025-04-01 23:07:20','2025-04-01 23:08:05','3.0826788,101.7002673','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58297','1540','5959','MO-OT','1','2025-04-01 23:09:36','2025-04-01 23:10:14','3.0827414,101.7002153','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58298','1540','5960','MO-OT','1','2025-04-01 22:46:53','2025-04-01 22:47:28','3.0778655,101.6973861','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58299','1540','5961','MO-OT','1','2025-04-01 22:16:39','2025-04-01 22:17:24','3.0826812,101.7001403','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58300','1540','5962','MO-OT','1','2025-04-01 22:18:53','2025-04-01 22:19:31','3.082688,101.7001367','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58301','1540','5963','MO-OT','1','2025-04-01 23:11:29','2025-04-01 23:12:02','3.0827947,101.7001373','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58302','1540','5964','MO-OT','1','2025-04-01 22:04:09','2025-04-01 22:05:05','3.0825851,101.6997051','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58303','1540','5965','MO-OT','1','2025-04-01 22:38:24','2025-04-01 22:39:02','3.082752,101.7000559','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58304','1540','5966','MO-OT','1','2025-04-01 22:25:34','2025-04-01 22:26:26','3.0826481,101.7001387','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58305','1540','5967','MO-OT','1','2025-04-01 22:29:59','2025-04-01 22:30:35','3.0826335,101.7001894','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58306','1540','5968','MO-OT','1','2025-04-01 22:32:00','2025-04-01 22:32:39','3.0725255,101.6785449','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58307','1540','5969','MO-OT','1','2025-04-01 22:34:05','2025-04-01 22:34:47','3.0831293,101.7001473','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58308','1540','5970','MO-OT','1','2025-04-01 22:58:58','2025-04-01 22:59:31','3.0821308,101.6995305','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58309','1540','5971','MO-OT','1','2025-04-01 22:06:47','2025-04-01 22:07:35','3.082702,101.7001997','\r\nWater meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58310','1540','5972','MO-OT','1','2025-04-01 22:23:11','2025-04-01 22:23:49','3.0826812,101.7001336','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58311','1540','5973','MO-OT','1','2025-04-01 22:27:57','2025-04-01 22:28:43','3.0822616,101.6993357','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58312','1540','5974','MO-OT','1','2025-04-01 22:12:10','2025-04-01 22:12:51','3.0826663,101.700108','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58313','1540','5975','MO-OT','1','2025-04-01 22:40:26','2025-04-01 22:41:01','3.0828251,101.7000147','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58314','1540','5976','MO-OT','1','2025-04-01 22:14:22','2025-04-01 22:15:01','3.0826781,101.7001354','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58315','1540','5977','Real-Time Report MO-OT','1','2025-04-01 20:25:00','2025-04-01 20:25:49','3.0821129,101.6991223','Report Duty at:20:24pm','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58316','1540','5978','Real-Time Report MO-OT','1','2025-04-02 00:09:22','2025-04-02 00:15:30','3.0821779,101.6998349','Off Duty at 00:15am','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58317','1540','5979','Real-Time Report MO-OT','1','2025-04-01 23:06:59','2025-04-01 23:07:17','3.0826788,101.7002673','Hourly report submitted at 11:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58318','1540','5980','Real-Time Report MO-OT','1','2025-04-01 20:23:23','2025-04-02 00:09:10','3.0822978,101.6995145','Hourly report submitted at 12:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58319','1540','5981','Real-Time Report MO-OT','1','2025-04-01 21:13:05','2025-04-01 21:13:36','3.0821829,101.6991669','Hourly report submitted at 9:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58728','1547','4472','Patrolling Block A','1','2025-04-02 09:49:38','2025-04-02 09:51:41','3.0828667,101.7001194','Info:\r\nPerformed a thorough patrol on Level 10, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58729','1547','4473','Patrolling Block A','1','2025-04-02 09:40:23','2025-04-02 09:42:04','3.082923,101.7001915','Info:\r\nPerformed a thorough patrol on Level 15, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58730','1547','4474','Patrolling Block A','1','2025-04-02 09:38:46','2025-04-02 09:40:16','3.0829142,101.7001377','Info:\r\nPerformed a thorough patrol on Level 16, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58731','1547','4475','Patrolling Block A','1','2025-04-02 09:37:02','2025-04-02 09:38:28','3.0830302,101.6998298','Info:\r\nPerformed a thorough patrol on Level 17, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58732','1547','4476','Patrolling Block A','1','2025-04-02 09:35:54','2025-04-02 09:36:42','3.0824008,101.6997906','Info:\r\nPerformed a thorough patrol on Level 18, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58733','1547','4477','Patrolling Block A','1','2025-04-02 09:33:45','2025-04-02 09:35:09','3.0778381,101.6984388','Info:\r\nPerformed a thorough patrol on Level 19, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58734','1547','4478','Patrolling Block A','1','2025-04-02 09:31:46','2025-04-02 09:33:10','3.0818029,101.6989094','Info:\r\nPerformed a thorough patrol on Level 20, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58735','1547','4479','Patrolling Block A','1','2025-04-02 09:28:37','2025-04-02 09:30:35','3.0827429,101.699997','Info:\r\nPerformed a thorough patrol on Level 21, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58736','1547','4480','Patrolling Block A','1','2025-04-02 09:08:31','2025-04-02 09:10:01','3.0828712,101.6999611','Performed a thorough patrol on Level 27, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58737','1547','4481','Patrolling Block A','1','2025-04-02 09:42:24','2025-04-02 09:44:18','3.0829094,101.7001646','Info:\r\nPerformed a thorough patrol on Level 14, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58738','1547','4482','Patrolling Block A','1','2025-04-02 08:38:28','2025-04-02 08:41:13','3.0828255,101.7000554','Info:\r\nPerformed a thorough patrol on Level 38, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58739','1547','4483','Patrolling Block A','1','2025-04-02 08:36:29','2025-04-02 08:38:00','3.0828073,101.6999357','Info:\r\nPerformed a thorough patrol on Level 39, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58740','1547','4484','Patrolling Block A','1','2025-04-02 09:44:33','2025-04-02 09:46:05','3.0827963,101.6999865','Info:\r\nPerformed a thorough patrol on Level 13, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58741','1547','4485','Patrolling Block A','1','2025-04-02 08:34:48','2025-04-02 08:35:48','3.0828693,101.7003613','Info:\r\nPerformed a thorough patrol on Level 40, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58742','1547','4486','Patrolling Block A','1','2025-04-02 08:32:32','2025-04-02 08:33:47','3.0827673,101.6998781','Info:\r\nPerformed a thorough patrol on Level 41, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58743','1547','4487','Patrolling Block A','1','2025-04-02 09:46:35','2025-04-02 09:53:26','3.0827461,101.6999249','Info:\r\nPerformed a thorough patrol on Level 9, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58744','1547','4488','Patrolling Block A','1','2025-04-02 09:46:07','2025-04-02 09:47:43','3.0829092,101.6999361','Info:\r\nPerformed a thorough patrol on Level 12, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58745','1547','4489','Patrolling Block A','1','2025-04-02 09:48:07','2025-04-02 09:49:35','3.0828543,101.7000725','Info:\r\nPerformed a thorough patrol on Level 11, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58746','1547','4490','Patrolling Block A','1','2025-04-02 09:12:59','2025-04-02 09:14:00','3.0828728,101.7000087','Info:\r\nPerformed a thorough patrol on Level 26, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58747','1547','4491','Patrolling Block A','1','2025-04-02 09:16:01','2025-04-02 09:17:26','3.0828375,101.699976','Info:\r\nPerformed a thorough patrol on Level 25, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58748','1547','4492','Patrolling Block A','1','2025-04-02 09:20:24','2025-04-02 09:21:06','3.0827241,101.6999096','Info:\r\nPerformed a thorough patrol on Level 24, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58749','1547','4493','Patrolling Block A','1','2025-04-02 09:25:12','2025-04-02 09:26:23','3.0828891,101.6999264','Info:\r\nPerformed a thorough patrol on Level 23, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58750','1547','4494','Patrolling Block A','1','2025-04-02 09:26:26','2025-04-02 09:28:22','3.0828842,101.7001289','Info:\r\nPerformed a thorough patrol on Level 22, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58751','1547','4495','Patrolling Block A','1','2025-04-02 08:41:26','2025-04-02 08:44:27','3.0826824,101.7001789','Info:\r\nPerformed a thorough patrol on Level 37, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58752','1547','4496','Patrolling Block A','1','2025-04-02 08:45:04','2025-04-02 08:47:03','3.0827843,101.7000541','Info:\r\nPerformed a thorough patrol on Level 36, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58753','1547','4497','Patrolling Block A','1','2025-04-02 08:47:08','2025-04-02 08:49:20','3.0827795,101.7000781','Info:\r\nPerformed a thorough patrol on Level 35, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58754','1547','4498','Patrolling Block A','1','2025-04-02 08:49:53','2025-04-02 08:51:40','3.0828081,101.7000093',':\r\nPerformed a thorough patrol on Level 34, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58755','1547','4499','Patrolling Block A','1','2025-04-02 08:52:07','2025-04-02 08:53:52','3.0827975,101.7001787','Info:\r\nPerformed a thorough patrol on Level 33, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58756','1547','4500','Patrolling Block A','1','2025-04-02 08:57:00','2025-04-02 08:58:47','3.0826939,101.7000981','','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58757','1547','4501','Patrolling Block A','1','2025-04-02 08:59:09','2025-04-02 09:00:11','3.0829061,101.6999413','Info:\r\nPerformed a thorough patrol on Level 31, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58758','1547','4502','Patrolling Block A','1','2025-04-02 09:00:46','2025-04-02 09:02:15','3.0828921,101.6999236','Info:\r\nPerformed a thorough patrol on Level 30, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58759','1547','4503','Patrolling Block A','1','2025-04-02 09:03:09','2025-04-02 09:05:26','3.0827699,101.6999154','Info:\r\nPerformed a thorough patrol on Level 29, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58760','1547','4504','Patrolling Block A','1','2025-04-02 09:06:12','2025-04-02 09:07:41','3.083073,101.6996568','Info:\r\nPerformed a thorough patrol on Level 28, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58761','1547','4678','Patrolling Block A - PH','1','2025-04-02 15:30:36','2025-04-02 15:32:07','3.0829021,101.7003023','Info:\r\nPerformed a thorough patrol on Level 10, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58762','1547','4679','Patrolling Block A - PH','1','2025-04-02 15:20:21','2025-04-02 15:21:56','3.0829131,101.7001652','Info:\r\nPerformed a thorough patrol on Level 15, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58763','1547','4680','Patrolling Block A - PH','1','2025-04-02 15:18:37','2025-04-02 15:20:19','3.0829331,101.7001553','Info:\r\nPerformed a thorough patrol on Level 16, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58764','1547','4681','Patrolling Block A - PH','1','2025-04-02 15:17:10','2025-04-02 15:18:36','3.0829755,101.6998746','Info:\r\nPerformed a thorough patrol on Level 17, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58765','1547','4682','Patrolling Block A - PH','1','2025-04-02 15:15:22','2025-04-02 15:17:08','3.082748,101.7004539','Info:\r\nPerformed a thorough patrol on Level 18, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58766','1547','4683','Patrolling Block A - PH','1','2025-04-02 15:08:30','2025-04-02 15:11:50','3.0829137,101.6999472','Info:\r\nPerformed a thorough patrol on Level 19, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58767','1547','4684','Patrolling Block A - PH','1','2025-04-02 15:06:41','2025-04-02 15:08:15','3.0828437,101.7001757',':\r\nPerformed a thorough patrol on Level 20, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58768','1547','4685','Patrolling Block A - PH','1','2025-04-02 15:05:06','2025-04-02 15:06:25','3.0827859,101.7000853',':\r\nPerformed a thorough patrol on Level 21, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58769','1547','4686','Patrolling Block A - PH','1','2025-04-02 14:47:27','2025-04-02 14:48:40','3.0828569,101.6999866','Info:\r\nPerformed a thorough patrol on Level 27, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58770','1547','4687','Patrolling Block A - PH','1','2025-04-02 15:21:57','2025-04-02 15:23:28','3.0829319,101.7000927','Info:\r\nPerformed a thorough patrol on Level 14, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58771','1547','4688','Patrolling Block A - PH','1','2025-04-02 14:22:12','2025-04-02 14:23:17','3.0827573,101.699963','Info:\r\nPerformed a thorough patrol on Level 38, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58772','1547','4689','Patrolling Block A - PH','1','2025-04-02 14:20:09','2025-04-02 14:21:21','3.0831942,101.7004934','Info:\r\nPerformed a thorough patrol on Level 39, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58773','1547','4690','Patrolling Block A - PH','1','2025-04-02 15:23:51','2025-04-02 15:25:04','3.0828329,101.6999889','Info:\r\nPerformed a thorough patrol on Level 13, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58774','1547','4691','Patrolling Block A - PH','1','2025-04-02 14:17:10','2025-04-02 14:18:59','3.0833322,101.7005804','Info:\r\nPerformed a thorough patrol on Level 40, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58775','1547','4692','Patrolling Block A - PH','1','2025-04-02 13:29:24','2025-04-02 14:17:08','3.0827605,101.6998904','Info:\r\nPerformed a thorough patrol on Level 41, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58776','1547','4693','Patrolling Block A - PH','1','2025-04-02 15:32:37','2025-04-02 15:33:40','3.0829057,101.6999805','Info:\r\nPerformed a thorough patrol on Level 9, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58777','1547','4694','Patrolling Block A - PH','1','2025-04-02 15:26:23','2025-04-02 15:27:24','3.0828113,101.6999784','Info:\r\nPerformed a thorough patrol on Level 12, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58778','1547','4695','Patrolling Block A - PH','1','2025-04-02 15:27:28','2025-04-02 15:30:26','3.0828689,101.7001323','Info:\r\nPerformed a thorough patrol on Level 11, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58779','1547','4696','Patrolling Block A - PH','1','2025-04-02 14:48:59','2025-04-02 14:50:50','3.0827752,101.7000547','Info:\r\nPerformed a thorough patrol on Level 26, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58780','1547','4697','Patrolling Block A - PH','1','2025-04-02 14:51:14','2025-04-02 14:53:20','3.0829075,101.70002','Info:\r\nPerformed a thorough patrol on Level 25, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58781','1547','4698','Patrolling Block A - PH','1','2025-04-02 14:58:54','2025-04-02 15:01:12','3.0827106,101.6998704','Info:\r\nPerformed a thorough patrol on Level 24, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58782','1547','4699','Patrolling Block A - PH','1','2025-04-02 15:01:14','2025-04-02 15:03:08','3.0828541,101.6999571','Performed a thorough patrol on Level 23, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58783','1547','4700','Patrolling Block A - PH','1','2025-04-02 15:03:10','2025-04-02 15:05:03','3.0828404,101.7001676','Info:\r\nPerformed a thorough patrol on Level 22, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58784','1547','4701','Patrolling Block A - PH','1','2025-04-02 14:23:33','2025-04-02 14:24:56','3.0828041,101.7000111','Info:\r\nPerformed a thorough patrol on Level 37, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58785','1547','4702','Patrolling Block A - PH','1','2025-04-02 14:25:27','2025-04-02 14:26:57','3.0828163,101.7000153','Info:\r\nPerformed a thorough patrol on Level 36, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58786','1547','4703','Patrolling Block A - PH','1','2025-04-02 14:27:33','2025-04-02 14:30:41','3.0827869,101.7000481','Info:\r\nPerformed a thorough patrol on Level 35, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58787','1547','4704','Patrolling Block A - PH','1','2025-04-02 14:30:54','2025-04-02 14:33:37','3.0826839,101.7000833','Info:\r\nPerformed a thorough patrol on Level 34, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58788','1547','4705','Patrolling Block A - PH','1','2025-04-02 14:33:44','2025-04-02 14:36:06','3.082862,101.700067','Info:\r\nPerformed a thorough patrol on Level 33, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58789','1547','4706','Patrolling Block A - PH','1','2025-04-02 14:36:23','2025-04-02 14:37:50','3.0828323,101.6999643','Info:\r\nPerformed a thorough patrol on Level 32, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58790','1547','4707','Patrolling Block A - PH','1','2025-04-02 14:38:35','2025-04-02 14:40:25','3.082718,101.7000889','Info:\r\nPerformed a thorough patrol on Level 31, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58791','1547','4708','Patrolling Block A - PH','1','2025-04-02 14:40:28','2025-04-02 14:42:18','3.0828834,101.6999491','Performed a thorough patrol on Level 30, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58792','1547','4709','Patrolling Block A - PH','1','2025-04-02 14:42:48','2025-04-02 14:44:17','3.0834373,101.7007791','Info:\r\nPerformed a thorough patrol on Level 29, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58793','1547','4710','Patrolling Block A - PH','1','2025-04-02 14:44:34','2025-04-02 14:46:48','3.0829624,101.6999829','Info:\r\nPerformed a thorough patrol on Level 28, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58794','1547','4804','Static Guard 3','1','2025-04-02 10:36:47','2025-04-02 10:38:07','3.0826787,101.6993193','Info:\r\nRoutine rounds of the guardhouse and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58795','1547','4805','Static Guard 3','1','2025-04-02 12:30:49','2025-04-02 12:51:59','3.0828789,101.7004908','Info:\r\nRoutine rounds of the guardhouse and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58796','1547','4806','Static Guard 3','1','2025-04-02 11:31:26','2025-04-02 11:32:30','3.0824809,101.6994199','Info:\r\nRoutine rounds of the guardhouse and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58797','1547','4807','Static Guard 3','1','2025-04-02 13:54:08','2025-04-02 13:55:01','3.0821521,101.7008794','Info:\r\nRoutine rounds of the guardhouse and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58798','1547','4808','Static Guard 3','1','2025-04-02 15:11:54','2025-04-02 15:15:16','3.0825658,101.6998381','Info:\r\nRoutine rounds of the guardhouse and its perimeter were conducted, with no issues found. Everything is in proper order.','1','Saya pertaining luppa','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58799','1547','4809','Static Guard 3','1','2025-04-02 16:35:35','2025-04-02 16:36:34','3.0822358,101.7008442','Info:\r\nRoutine rounds of the guardhouse and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58800','1547','4810','Static Guard 3','1','2025-04-02 17:34:20','2025-04-02 17:35:15','3.0825252,101.6999615','Info:\r\nRoutine rounds of the guardhouse and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58801','1547','4811','Static Guard 3','1','2025-04-02 18:36:09','2025-04-02 18:37:33','3.0830354,101.7005638','Info:\r\nRoutine rounds of the guardhouse and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58802','1547','4812','Static Guard 3','1','2025-04-02 19:35:48','2025-04-02 19:36:45','3.0823185,101.7005146','Info:\r\nRoutine rounds of the guardhouse and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58803','1547','4813','Static Guard 3','1','2025-04-02 15:38:46','2025-04-02 15:39:52','3.0824098,101.7005795','Info:\r\nRoutine rounds of the guardhouse and its perimeter were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58804','1547','5007','Real-Time Report - OT Guard 2nd','1','2025-04-02 08:16:59','2025-04-02 08:17:30','3.082218,101.7005555','','1','Not come work morning ot','0',NULL,NULL,NULL,'','','05:30','30');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58805','1547','5008','Real-Time Report - OT Guard 2nd','1','2025-04-02 08:15:24','2025-04-02 08:32:25','3.0825194,101.6997284','','1','system issues ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58809','1547','5012','Real-Time Report - OT Guard 2nd','1','2025-04-02 08:17:38','2025-04-03 06:17:07','3.0822872,101.7006568','Hourly report submitted at 06:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58810','1547','5013','Real-Time Report - OT Guard 2nd','1','2025-04-02 08:09:59','2025-04-02 08:16:23','3.0822003,101.6997764','','1','Not come morning ot','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58811','1547','5028','Real-Time Report','1','2025-04-02 10:02:42','2025-04-02 10:03:09','3.0822168,101.7004324','Hourly report submitted at 10:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58812','1547','5029','Real-Time Report','1','2025-04-02 11:02:00','2025-04-02 11:02:20','3.0822247,101.7007229','Hourly report submitted at 11:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58813','1547','5030','Real-Time Report','1','2025-04-02 13:29:21','2025-04-02 14:04:05','3.0821403,101.7004891','Hourly report submitted at 02:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58814','1547','5031','Real-Time Report','1','2025-04-02 15:09:40','2025-04-02 15:09:53','3.0827515,101.7002539','Hourly report submitted at 03:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58815','1547','5032','Real-Time Report','1','2025-04-02 16:09:07','2025-04-02 16:09:23','3.0822334,101.7004068','Hourly report submitted at 04:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58816','1547','5033','Real-Time Report','1','2025-04-02 17:02:49','2025-04-02 17:03:01','3.0823641,101.7004888','Hourly report submitted at 05:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58817','1547','5034','Real-Time Report','1','2025-04-02 18:03:13','2025-04-02 18:03:28','3.0822723,101.7004851','Hourly report submitted at 06:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58818','1547','5035','Real-Time Report','1','2025-04-02 19:09:09','2025-04-02 19:09:22','3.0821333,101.6989579','Hourly report submitted at 07:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58819','1547','5036','Real-Time Report','1','2025-04-02 08:11:50','2025-04-02 08:12:53','3.0822882,101.7005815','Report Duty at on:8:10 am','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58820','1547','5037','Real-Time Report','1','2025-04-02 20:16:35','2025-04-02 20:17:13','3.0829979,101.7002629','Off Duty at 8:15 pm','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58821','1547','5038','Real-Time Report','1','2025-04-02 09:17:54','2025-04-02 09:18:07','3.079232,101.6966793','Hourly report submitted at 09:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58822','1547','5039','Real-Time Report','1','2025-04-02 13:05:05','2025-04-02 13:05:18','3.0822654,101.7004482','Hourly report submitted at 01:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58823','1547','5040','Real-Time Report','1','2025-04-02 12:09:45','2025-04-02 12:09:57','3.0821942,101.7009592','Hourly report submitted at 12:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58824','1547','5889','OT SG 1 - 2nd','1','2025-04-02 08:28:18','2025-04-03 06:35:25','3.0832369,101.7003584','Info:\r\nRoutine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58825','1547','5890','OT SG 1 - 2nd','1','2025-04-02 08:10:57','2025-04-02 08:16:54','3.0822196,101.7005328','','1','Not come work morning ot','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58830','1548','43','Roll Call','1','2025-04-02 08:17:37','2025-04-02 08:21:35','','Security Personnel On-Duty Report:\r\n1.judda\r\n2.dipak\r\n3.anit\r\n4.laxuman\r\n5.durga','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58831','1548','4763','Guard House','1','2025-04-02 08:21:38','2025-04-02 08:28:29','','Handover & Inventory Check:\r\nWalkie-Talkie (2) & Charger Set (4)\r\nBaton (3)\r\nAccess Card (2)\r\nRain-Coat (3)\r\nHandphone (1)\r\nFire Blanket (2)\r\nFirst-Aid Box (1)\r\nWheelchair (1)\r\nBodycam (5)\r\ne-Bike & Charger Set (1)\r\nTraffic Control Light (1)','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58839','1548','4843','Supervisor','1','2025-04-02 11:40:16','2025-04-02 11:41:23','','Routine rounds of the guardhouse and its perimeter were conducted with no issues identified. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58840','1548','4844','Supervisor','1','2025-04-02 12:36:40','2025-04-02 12:37:55','','Routine rounds of the guardhouse and its perimeter were conducted with no issues identified. Everything is in proper order','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58843','1548','4854','Car Park Patrolling','1','2025-04-02 16:15:54','2025-04-02 16:21:02','','Performed a thorough patrol on Level 7, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58844','1548','4855','Car Park Patrolling','1','2025-04-02 16:25:53','2025-04-02 16:31:01','','Performed a thorough patrol on Level 5, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58845','1548','4856','Car Park Patrolling','1','2025-04-02 16:31:04','2025-04-02 16:36:01','','Performed a thorough patrol on Level 4, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58846','1548','4857','Car Park Patrolling','1','2025-04-02 16:21:05','2025-04-02 16:25:51','','Performed a thorough patrol on Level 6, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58847','1548','4858','Car Park Patrolling','1','2025-04-02 16:36:06','2025-04-02 16:40:46','','Performed a thorough patrol on Level 3, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58848','1548','4859','Car Park Patrolling','1','2025-04-02 16:45:44','2025-04-02 16:50:30','','Performed a thorough patrol on Level 1, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58849','1548','4860','Car Park Patrolling','1','2025-04-02 16:50:34','2025-04-02 16:55:16','','Performed a thorough patrol on GF, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58850','1548','4861','Car Park Patrolling','1','2025-04-02 16:40:52','2025-04-02 16:45:41','','Performed a thorough patrol on Level 2, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58851','1548','4862','Car Park Patrolling','1','2025-04-02 16:55:17','2025-04-02 17:00:50','','Performed a thorough patrol on Basement, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58852','1548','5028','Real-Time Report','1','2025-04-02 10:05:51','2025-04-02 10:06:05','','Hourly report submitted at 10:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58853','1548','5029','Real-Time Report','1','2025-04-02 11:03:21','2025-04-02 11:03:39','','Hourly report submitted at 11:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58854','1548','5030','Real-Time Report','1','2025-04-02 14:12:03','2025-04-02 14:13:18','3.0822997,101.6998108','Hourly report submitted at 02:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58855','1548','5031','Real-Time Report','1','2025-04-02 15:05:05','2025-04-02 15:05:44','3.0814858,101.7013142','Hourly report submitted at 03:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58856','1548','5032','Real-Time Report','1','2025-04-02 16:08:34','2025-04-02 16:09:02','3.0817968,101.7009584','Hourly report submitted at 04:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58857','1548','5033','Real-Time Report','1','2025-04-02 17:00:57','2025-04-02 17:01:23','','Hourly report submitted at 05:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58858','1548','5034','Real-Time Report','1','2025-04-02 18:01:14','2025-04-02 18:01:37','3.0822942,101.7005839','Hourly report submitted at 06:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58859','1548','5035','Real-Time Report','1','2025-04-02 19:02:36','2025-04-02 19:02:55','','Hourly report submitted at 07:00 PM','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58860','1548','5036','Real-Time Report','1','2025-04-02 08:11:03','2025-04-02 08:11:44','','Report Duty at 08:06','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58861','1548','5037','Real-Time Report','1','2025-04-02 20:05:16','2025-04-02 20:05:57','3.082278333333333,101.69951333333331','Off Duty at 20:05 PM ','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58862','1548','5038','Real-Time Report','1','2025-04-02 09:00:16','2025-04-02 09:00:37','','Hourly report submitted at 09:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58863','1548','5039','Real-Time Report','1','2025-04-02 13:02:38','2025-04-02 13:03:12','','Hourly report submitted at 01:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58864','1548','5040','Real-Time Report','1','2025-04-02 12:01:46','2025-04-02 12:02:17','','Hourly report submitted at 12:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58865','1548','5056','Real-Time Report MO-OT','1','2025-04-02 21:59:55','2025-04-02 22:00:24','','Hourly report submitted at 10:00 PM','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58866','1548','5092','MO-OT','1','2025-04-02 20:18:17','2025-04-02 20:33:02','3.0823034,101.7004341','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58867','1548','5093','MO-OT','1','2025-04-02 21:30:05','2025-04-02 21:33:34','3.0824166,101.7004162','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58868','1548','5902','MO-OT','1','2025-04-02 23:56:48','2025-04-03 00:33:06','','Routine rounds of the guardhouse and its perimeter were conducted, with no issues identified. Everything is in proper order','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58869','1548','5911','MO-OT','1','2025-04-02 23:08:07','2025-04-02 23:10:15','','Performed a thorough patrol on Level 10, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58870','1548','5912','MO-OT','1','2025-04-02 22:58:08','2025-04-02 22:59:46','','Performed a thorough patrol on Level 15, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58871','1548','5913','MO-OT','1','2025-04-02 22:56:21','2025-04-02 22:58:00','','Performed a thorough patrol on Level 16, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58872','1548','5914','MO-OT','1','2025-04-02 22:54:21','2025-04-02 22:56:14','','Performed a thorough patrol on Level 17, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58873','1548','5915','MO-OT','1','2025-04-02 22:52:40','2025-04-02 22:54:16','','Performed a thorough patrol on Level 18, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58874','1548','5916','MO-OT','1','2025-04-02 22:50:50','2025-04-02 22:52:35','','Performed a thorough patrol on Level 19, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58875','1548','5917','MO-OT','1','2025-04-02 22:29:28','2025-04-02 22:31:03','','Performed a thorough patrol on Level 27, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58876','1548','5918','MO-OT','1','2025-04-02 22:59:53','2025-04-02 23:01:52','','Performed a thorough patrol on Level 14, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58877','1548','5919','MO-OT','1','2025-04-02 22:06:12','2025-04-02 22:07:42','','Performed a thorough patrol on Level 38, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58878','1548','5920','MO-OT','1','2025-04-02 23:02:01','2025-04-02 23:03:43','','Performed a thorough patrol on Level 13, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58879','1548','5921','MO-OT','1','2025-04-02 22:02:32','2025-04-02 22:04:24','','Performed a thorough patrol on Level 40, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58880','1548','5922','MO-OT','1','2025-04-02 22:01:23','2025-04-02 22:02:28','','Performed a thorough patrol on Level 41, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58881','1548','5923','MO-OT','1','2025-04-02 23:14:33','2025-04-02 23:15:56','','Performed a thorough patrol on Level 9, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58882','1548','5924','MO-OT','1','2025-04-02 23:03:51','2025-04-02 23:05:30','','Performed a thorough patrol on Level 12, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58883','1548','5925','MO-OT','1','2025-04-02 23:05:44','2025-04-02 23:07:53','','Performed a thorough patrol on Level 11, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58884','1548','5926','MO-OT','1','2025-04-02 22:31:22','2025-04-02 22:32:59','','Performed a thorough patrol on Level 26, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58885','1548','5927','MO-OT','1','2025-04-02 22:33:09','2025-04-02 22:35:06','','Performed a thorough patrol on Level 25, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58886','1548','5928','MO-OT','1','2025-04-02 22:45:21','2025-04-02 22:47:18','','Performed a thorough patrol on Level 22, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58887','1548','5929','MO-OT','1','2025-04-02 22:08:09','2025-04-02 22:09:53','','Performed a thorough patrol on Level 37, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58888','1548','5930','MO-OT','1','2025-04-02 22:09:59','2025-04-02 22:12:27','','Performed a thorough patrol on Level 36, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58889','1548','5931','MO-OT','1','2025-04-02 22:12:34','2025-04-02 22:14:14','','Performed a thorough patrol on Level 35, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58890','1548','5932','MO-OT','1','2025-04-02 22:17:05','2025-04-02 22:18:52','','Performed a thorough patrol on Level 33, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58891','1548','5933','MO-OT','1','2025-04-02 22:16:47','2025-04-02 22:21:44','','Performed a thorough patrol on Level 32, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58892','1548','5934','MO-OT','1','2025-04-02 22:21:56','2025-04-02 22:23:12','','Performed a thorough patrol on Level 31, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58893','1548','5935','MO-OT','1','2025-04-02 22:23:54','2025-04-02 22:25:13','','Performed a thorough patrol on Level 30, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58894','1548','5936','MO-OT','1','2025-04-02 22:23:26','2025-04-02 22:26:55','','Performed a thorough patrol on Level 29, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58895','1548','5937','MO-OT','1','2025-04-02 22:27:06','2025-04-02 22:29:17','','Performed a thorough patrol on Level 28, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58896','1548','5938','MO-OT','1','2025-04-02 22:04:27','2025-04-02 22:06:00','','Performed a thorough patrol on Level 39, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58897','1548','5939','MO-OT','1','2025-04-02 22:49:05','2025-04-02 22:50:45','','Performed a thorough patrol on Level 20, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58898','1548','5940','MO-OT','1','2025-04-02 22:47:21','2025-04-02 22:49:00','','Performed a thorough patrol on Level 21, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58899','1548','5941','MO-OT','1','2025-04-02 22:39:48','2025-04-02 22:43:20','','Performed a thorough patrol on Level 24, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58900','1548','5942','MO-OT','1','2025-04-02 22:43:22','2025-04-02 22:45:19','','Performed a thorough patrol on Level 23, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58901','1548','5943','MO-OT','1','2025-04-02 22:14:21','2025-04-02 22:16:36','','Performed a thorough patrol on Level 34, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58902','1548','5944','MO-OT','1','2025-04-02 23:10:34','2025-04-02 23:11:04','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58903','1548','5945','MO-OT','1','2025-04-02 22:40:46','2025-04-02 23:10:32','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58904','1548','5946','MO-OT','1','2025-04-02 22:06:03','2025-04-02 22:36:25','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58905','1548','5947','MO-OT','1','2025-04-02 22:39:56','2025-04-02 22:40:08','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58906','1548','5948','MO-OT','1','2025-04-02 22:40:13','2025-04-02 22:40:27','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58907','1548','5949','MO-OT','1','2025-04-02 22:37:29','2025-04-02 22:37:40','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58908','1548','5950','MO-OT','1','2025-04-02 23:11:54','2025-04-02 23:12:06','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58909','1548','5951','MO-OT','1','2025-04-02 23:11:29','2025-04-02 23:11:38','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58910','1548','5952','MO-OT','1','2025-04-02 23:11:17','2025-04-02 23:11:27','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58911','1548','5953','MO-OT','1','2025-04-02 23:11:05','2025-04-02 23:11:16','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58912','1548','5954','MO-OT','1','2025-04-02 22:39:06','2025-04-02 22:39:17','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58913','1548','5955','MO-OT','1','2025-04-02 23:12:08','2025-04-02 23:12:21','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58914','1548','5956','MO-OT','1','2025-04-02 23:12:22','2025-04-02 23:12:35','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58915','1548','5957','MO-OT','1','2025-04-02 23:15:59','2025-04-02 23:17:15','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58916','1548','5958','MO-OT','1','2025-04-02 23:13:18','2025-04-02 23:13:45','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58917','1548','5959','MO-OT','1','2025-04-02 23:13:48','2025-04-02 23:14:02','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58918','1548','5960','MO-OT','1','2025-04-02 22:40:31','2025-04-02 22:40:43','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58919','1548','5961','MO-OT','1','2025-04-02 22:36:55','2025-04-02 22:37:08','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58920','1548','5962','MO-OT','1','2025-04-02 22:37:10','2025-04-02 22:37:26','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58921','1548','5963','MO-OT','1','2025-04-02 23:14:07','2025-04-02 23:14:29','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58922','1548','5964','MO-OT','1','2025-04-02 20:34:06','2025-04-02 22:35:59','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58923','1548','5965','MO-OT','1','2025-04-02 22:39:19','2025-04-02 22:39:33','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58924','1548','5966','MO-OT','1','2025-04-02 22:37:53','2025-04-02 22:38:03','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58925','1548','5967','MO-OT','1','2025-04-02 22:38:18','2025-04-02 22:38:29','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58926','1548','5968','MO-OT','1','2025-04-02 22:38:30','2025-04-02 22:38:44','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58927','1548','5969','MO-OT','1','2025-04-02 22:38:46','2025-04-02 22:38:56','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58928','1548','5970','MO-OT','1','2025-04-02 23:11:40','2025-04-02 23:11:53','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58929','1548','5971','MO-OT','1','2025-04-02 22:36:00','2025-04-02 22:36:12','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58930','1548','5972','MO-OT','1','2025-04-02 22:37:41','2025-04-02 22:37:52','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58931','1548','5973','MO-OT','1','2025-04-02 22:38:05','2025-04-02 22:38:17','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58932','1548','5974','MO-OT','1','2025-04-02 22:36:26','2025-04-02 22:36:38','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58933','1548','5975','MO-OT','1','2025-04-02 22:39:35','2025-04-02 22:39:46','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58934','1548','5976','MO-OT','1','2025-04-02 22:07:47','2025-04-02 22:36:53','','Water meter checks were performed and no leaks or issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58935','1548','5977','Real-Time Report MO-OT','1','2025-04-02 20:05:59','2025-04-02 20:06:30','3.0821583333333336,101.69972166666666','Report Duty at 20:06 PM ','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58936','1548','5978','Real-Time Report MO-OT','1','2025-04-02 23:57:54','2025-04-03 00:18:25','','Off Duty at 00:18am','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58937','1548','5979','Real-Time Report MO-OT','1','2025-04-02 23:12:55','2025-04-02 23:13:12','','Hourly report submitted at 11:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58938','1548','5980','Real-Time Report MO-OT','1','2025-04-02 11:50:22','2025-04-03 00:03:35','','Hourly report submitted at 12:00 AM','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58939','1548','5981','Real-Time Report MO-OT','1','2025-04-02 21:20:17','2025-04-02 21:21:04','3.0804358,101.7035737','Hourly report submitted at 9:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58940','1549','4562','Patrolling Block B','1','2025-04-02 12:43:13','2025-04-02 12:45:02','3.0825273,101.700466','Performed a thorough patrol on Level 10, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58941','1549','4563','Patrolling Block B','1','2025-04-02 12:34:22','2025-04-02 12:35:35','3.0824561,101.6999802','Performed a thorough patrol on Level 15, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58942','1549','4564','Patrolling Block B','1','2025-04-02 12:26:22','2025-04-02 12:31:38','3.0791739,101.6966524','Performed a thorough patrol on Level 16, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58943','1549','4565','Patrolling Block B','1','2025-04-02 12:14:12','2025-04-02 12:15:44','3.0828433,101.700764','Performed a thorough patrol on Level 17, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58944','1549','4566','Patrolling Block B','1','2025-04-02 12:11:44','2025-04-02 12:13:49','3.0823829,101.700259','Performed a thorough patrol on Level 18, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58945','1549','4567','Patrolling Block B','1','2025-04-02 12:10:21','2025-04-02 12:11:43','3.0834616,101.7013616','Performed a thorough patrol on Level 19, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58946','1549','4568','Patrolling Block B','1','2025-04-02 12:08:14','2025-04-02 12:09:47','3.0825087,101.7007152','Performed a thorough patrol on Level 20, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58947','1549','4569','Patrolling Block B','1','2025-04-02 12:06:36','2025-04-02 12:08:11','3.0823613,101.7004666','Performed a thorough patrol on Level 22, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58948','1549','4570','Patrolling Block B','1','2025-04-02 11:52:03','2025-04-02 11:54:05','3.0824536,101.7004724','Performed a thorough patrol on Level 27, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58949','1549','4571','Patrolling Block B','1','2025-04-02 12:36:17','2025-04-02 12:37:30','3.0825064,101.7005559','','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58950','1549','4572','Patrolling Block B','1','2025-04-02 11:24:49','2025-04-02 11:26:38','3.0836056,101.7008231','Performed a thorough patrol on Level 38, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58951','1549','4573','Patrolling Block B','1','2025-04-02 11:23:06','2025-04-02 11:24:47','3.0779459,101.6977942','Performed a thorough patrol on Level 39, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58952','1549','4574','Patrolling Block B','1','2025-04-02 12:37:40','2025-04-02 12:39:32','3.0823853,101.7004401','Performed a thorough patrol on Level 13, no incidents were reported and no issues were found','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58953','1549','4575','Patrolling Block B','1','2025-04-02 11:20:21','2025-04-02 11:23:01','3.0824855,101.7003424','Performed a thorough patrol on Level 41, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58954','1549','4576','Patrolling Block B','1','2025-04-02 11:17:29','2025-04-02 11:19:33','3.0830031,101.7006138','Performed a thorough patrol on Level 41, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58955','1549','4577','Patrolling Block B','1','2025-04-02 12:45:08','2025-04-02 12:47:07','3.0824933,101.7004121','Performed a thorough patrol on Level 9, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58956','1549','4578','Patrolling Block B','1','2025-04-02 12:40:13','2025-04-02 12:41:19','3.0824397,101.70047','Performed a thorough patrol on Level 12, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58957','1549','4579','Patrolling Block B','1','2025-04-02 12:41:27','2025-04-02 12:43:11','3.0823421,101.7003032','Performed a thorough patrol on Level 11, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58958','1549','4580','Patrolling Block B','1','2025-04-02 11:43:29','2025-04-02 11:57:47','3.082418,101.7001312','Performed a thorough patrol on Level 26, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58959','1549','4581','Patrolling Block B','1','2025-04-02 11:57:55','2025-04-02 11:58:50','3.0825043,101.7004434','Performed a thorough patrol on Level 25, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58960','1549','4582','Patrolling Block B','1','2025-04-02 11:58:56','2025-04-02 12:01:24','3.0831049,101.70126','Performed a thorough patrol on Level 24, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58961','1549','4583','Patrolling Block B','1','2025-04-02 12:01:27','2025-04-02 12:03:54','3.0795802,101.6971227','Performed a thorough patrol on Level 23, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58962','1549','4584','Patrolling Block B','1','2025-04-02 12:03:57','2025-04-02 12:06:12','3.0828209,101.7007831','Performed a thorough patrol on Level 21, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58963','1549','4585','Patrolling Block B','1','2025-04-02 11:26:46','2025-04-02 11:28:52','3.083332,101.7008759','Performed a thorough patrol on Level 37, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58964','1549','4586','Patrolling Block B','1','2025-04-02 11:30:01','2025-04-02 11:31:58','3.0824716,101.7005937','Performed a thorough patrol on Level 36, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58965','1549','4587','Patrolling Block B','1','2025-04-02 11:32:00','2025-04-02 11:34:11','3.0820069,101.7003599','Performed a thorough patrol on Level 35, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58966','1549','4588','Patrolling Block B','1','2025-04-02 11:34:13','2025-04-02 11:37:18','3.0824144,101.7006778','Performed a thorough patrol on Level 34, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58967','1549','4589','Patrolling Block B','1','2025-04-02 11:37:32','2025-04-02 11:39:36','3.082429,101.7005883','Performed a thorough patrol on Level 33, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58968','1549','4590','Patrolling Block B','1','2025-04-02 11:41:08','2025-04-02 11:43:26','3.0788506,101.6977059','Performed a thorough patrol on Level 32, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58969','1549','4591','Patrolling Block B','1','2025-04-02 11:43:31','2025-04-02 11:44:48','3.0824387,101.7005832','Performed a thorough patrol on Level 31, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58970','1549','4592','Patrolling Block B','1','2025-04-02 11:44:51','2025-04-02 11:47:01','3.082418,101.7005609','Performed a thorough patrol on Level 30, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58971','1549','4593','Patrolling Block B','1','2025-04-02 09:37:13','2025-04-02 11:49:11','3.0824182,101.7005808','Performed a thorough patrol on Level 29, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58972','1549','4594','Patrolling Block B','1','2025-04-02 11:49:13','2025-04-02 11:51:56','3.0824181,101.700495','Performed a thorough patrol on Level 28, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58973','1549','4711','Patrolling Block B - PH','1','2025-04-02 17:52:47','2025-04-02 18:41:52','3.0825551,101.7004152','Performed a thorough patrol on Level 10, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58974','1549','4712','Patrolling Block B - PH','1','2025-04-02 18:29:24','2025-04-02 18:31:10','3.0822868,101.7004075','Performed a thorough patrol on Level 15, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58975','1549','4713','Patrolling Block B - PH','1','2025-04-02 18:27:43','2025-04-02 18:29:22','3.0823543,101.7004741','Performed a thorough patrol on Level 16, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58976','1549','4714','Patrolling Block B - PH','1','2025-04-02 18:24:11','2025-04-02 18:27:41','3.0833537,101.7006933','erformed a thorough patrol on Level 17, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58977','1549','4715','Patrolling Block B - PH','1','2025-04-02 18:22:14','2025-04-02 18:24:06','3.083351,101.7012504','Performed a thorough patrol on Level 18, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58978','1549','4716','Patrolling Block B - PH','1','2025-04-02 18:20:24','2025-04-02 18:22:11','3.0827163,101.7003903','Performed a thorough patrol on Level 19, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58979','1549','4717','Patrolling Block B - PH','1','2025-04-02 18:17:50','2025-04-02 18:20:21','3.0829693,101.7005631','Performed a thorough patrol on Level 20, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58980','1549','4718','Patrolling Block B - PH','1','2025-04-02 18:15:57','2025-04-02 18:17:48','3.081895,101.699629','Performed a thorough patrol on Level 21, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58981','1549','4719','Patrolling Block B - PH','1','2025-04-02 18:06:03','2025-04-02 18:07:30','3.0832473,101.7008622','Performed a thorough patrol on Level 27, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58982','1549','4720','Patrolling Block B - PH','1','2025-04-02 18:31:12','2025-04-02 18:32:43','3.083245,101.7009124','Performed a thorough patrol on Level 14, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58983','1549','4721','Patrolling Block B - PH','1','2025-04-02 17:39:16','2025-04-02 17:41:11','3.0825323,101.700474','Performed a thorough patrol on Level 38, no incidents were reported and no issues were found','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58984','1549','4722','Patrolling Block B - PH','1','2025-04-02 17:36:56','2025-04-02 17:39:13','3.0776297,101.6986277','Performed a thorough patrol on Level 39, no incidents were reported and no issues were found','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58985','1549','4723','Patrolling Block B - PH','1','2025-04-02 14:04:06','2025-04-02 18:34:22','3.0823744,101.7004571','Performed a thorough patrol on Level 13, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58986','1549','4724','Patrolling Block B - PH','1','2025-04-02 17:35:51','2025-04-02 17:36:49','3.0824126,101.7002999','Performed a thorough patrol on Level 40, no incidents were reported and no issues were found','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58987','1549','4725','Patrolling Block B - PH','1','2025-04-02 17:32:46','2025-04-02 17:34:16','3.0825688,101.7002061','Performed a thorough patrol on Level 41, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58988','1549','4726','Patrolling Block B - PH','1','2025-04-02 18:41:53','2025-04-02 18:43:09','3.0825161,101.7004642','Performed a thorough patrol on Level 9, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58989','1549','4727','Patrolling Block B - PH','1','2025-04-02 18:34:23','2025-04-02 18:38:10','3.0832368,101.7007219','Performed a thorough patrol on Level 12, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58990','1549','4728','Patrolling Block B - PH','1','2025-04-02 18:38:18','2025-04-02 18:39:56','3.0822872,101.7003271','Performed a thorough patrol on Level 11, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58991','1549','4729','Patrolling Block B - PH','1','2025-04-02 18:07:32','2025-04-02 18:08:56','3.0825485,101.7005388','Performed a thorough patrol on Level 26, no incidents were reported and no issues were found','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58992','1549','4730','Patrolling Block B - PH','1','2025-04-02 18:08:59','2025-04-02 18:10:54','3.0825359,101.700413','Performed a thorough patrol on Level 25, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58993','1549','4731','Patrolling Block B - PH','1','2025-04-02 18:10:55','2025-04-02 18:12:44','3.0831821,101.7011655','Performed a thorough patrol on Level 24, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58994','1549','4732','Patrolling Block B - PH','1','2025-04-02 18:13:11','2025-04-02 18:14:28','3.0825699,101.7002603','Performed a thorough patrol on Level 23, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58995','1549','4733','Patrolling Block B - PH','1','2025-04-02 18:14:30','2025-04-02 18:15:55','3.082491,101.7004492','Performed a thorough patrol on Level 22, no incidents were reported and no issues were found','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58996','1549','4734','Patrolling Block B - PH','1','2025-04-02 17:41:17','2025-04-02 17:46:54','3.0838197,101.7013848','Performed a thorough patrol on Level 37, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58997','1549','4735','Patrolling Block B - PH','1','2025-04-02 17:46:55','2025-04-02 17:48:39','3.0781431,101.6961924','Performed a thorough patrol on Level 36, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58998','1549','4736','Patrolling Block B - PH','1','2025-04-02 17:48:40','2025-04-02 17:50:17','3.0824285,101.7005977','Performed a thorough patrol on Level 35, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('58999','1549','4737','Patrolling Block B - PH','1','2025-04-02 17:50:18','2025-04-02 17:52:07','3.0824247,101.7006804','Performed a thorough patrol on Level 34, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59000','1549','4738','Patrolling Block B - PH','1','2025-04-02 17:21:14','2025-04-02 17:56:42','3.0780659,101.6975148','Performed a thorough patrol on Level 33, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59001','1549','4739','Patrolling Block B - PH','1','2025-04-02 17:56:46','2025-04-02 17:58:04','3.0824616,101.7005575','Performed a thorough patrol on Level 32, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59002','1549','4740','Patrolling Block B - PH','1','2025-04-02 17:58:07','2025-04-02 18:00:21','3.0824537,101.7005457','Performed a thorough patrol on Level 31, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59003','1549','4741','Patrolling Block B - PH','1','2025-04-02 18:01:19','2025-04-02 18:02:16','3.0824972,101.7004145','Performed a thorough patrol on Level 30, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59004','1549','4742','Patrolling Block B - PH','1','2025-04-02 18:02:19','2025-04-02 18:04:28','3.0824336,101.7006024','Performed a thorough patrol on Level 29, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59005','1549','4743','Patrolling Block B - PH','1','2025-04-02 18:05:04','2025-04-02 18:05:56','3.0828565,101.700922','Performed a thorough patrol on Level 28, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59006','1549','4744','Parcel Collection / Arrangement','1','2025-04-02 10:40:15','2025-04-02 11:09:57','3.0823434,101.7005238','Each parcel has been checked and labeled with today’s date. All parcels have been collected from the delivery area and arranged in the mailbox area.\r\nNumber of parcels that are damaged or opened:','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59007','1549','4757','Parcel Collection / Arrangement','1','2025-04-02 10:58:16','2025-04-02 11:07:55','3.0823657,101.7004553','Each parcel has been checked and labeled with today’s date. All parcels have been collected from the delivery area and arranged in the mailbox area.\r\nNumber of parcels that are damaged or opened:','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59008','1549','4758','Parcel Collection / Arrangement','1','2025-04-02 17:13:46','2025-04-02 17:15:41','3.082362,101.7004851','Each parcel has been checked and labeled with today’s date. All parcels have been collected from the delivery area and arranged in the mailbox area.\r\nNumber of parcels that are damaged or opened:','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59009','1549','4760','Parcel Collection / Arrangement','1','2025-04-02 17:06:01','2025-04-02 17:18:28','3.0823826,101.7004106','Each parcel has been checked and labeled with today’s date. All parcels have been collected from the delivery area and arranged in the mailbox area.\r\nNumber of parcels that are damaged or opened:','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59010','1549','4761','Parcel Collection / Arrangement','1','2025-04-02 11:10:10','2025-04-02 11:14:57','3.0824644,101.6998776','Each parcel has been checked and labeled with today’s date. All parcels have been collected from the delivery area and arranged in the mailbox area.\r\nNumber of parcels that are damaged or opened:','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59011','1549','4762','Parcel Collection / Arrangement','1','2025-04-02 17:18:30','2025-04-02 17:20:55','3.0824094,101.7001908','Each parcel has been checked and labeled with today’s date. All parcels have been collected from the delivery area and arranged in the mailbox area.\r\nNumber of parcels that are damaged or opened:','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59012','1549','4814','Static Guard 4','1','2025-04-02 13:30:36','2025-04-02 13:31:42','3.0824462,101.6989719','Routine rounds of the guardhouse and its perimeter were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59013','1549','4815','Static Guard 4','1','2025-04-02 11:15:33','2025-04-02 14:32:11','3.0821076,101.7008804','Routine rounds of the guardhouse and its perimeter were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59014','1549','4816','Static Guard 4','1','2025-04-02 15:32:50','2025-04-02 15:33:44','3.0822911,101.7006324','Routine rounds of the guardhouse and its perimeter were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59015','1549','4817','Static Guard 4','1','2025-04-02 16:37:22','2025-04-02 16:38:13','3.0797411,101.703992','Routine rounds of the guardhouse and its perimeter were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59016','1549','4818','Static Guard 4','1','2025-04-02 18:33:00','2025-04-02 18:37:12','3.0776334,101.6932265','SO IZZ MELAPORKAN PATROLLING MASIH LAGI BELUM ABIS . GUARD HOUSE PUNYA REPORT SAYA AKAN UPDATE GAMBAR  DI LEVEL 12','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59017','1549','4819','Static Guard 4','1','2025-04-02 19:07:33','2025-04-02 19:35:59','3.0822809,101.7006115','Routine rounds of the guardhouse and its perimeter were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59018','1549','4821','Static Guard 4','1','2025-04-02 09:34:55','2025-04-02 09:36:13','','Routine rounds of the guardhouse and its perimeter were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59019','1549','4822','Static Guard 4','1','2025-04-02 08:30:23','2025-04-02 08:31:42','','Routine rounds of the guardhouse and its perimeter were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59020','1549','4823','Static Guard 4','1','2025-04-02 10:40:21','2025-04-02 10:41:45','3.0817968,101.7009584','Routine rounds of the guardhouse and its perimeter were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59021','1549','4824','Static Guard 4','1','2025-04-02 17:52:36','2025-04-02 17:55:33','3.0827248,101.7001626','SO IZZ  melaporkan sedang Patrolling block B. ','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59022','1549','5028','Real-Time Report','1','2025-04-02 10:06:35','2025-04-02 10:07:08','','Hourly report submitted at 10:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59023','1549','5029','Real-Time Report','1','2025-04-02 11:15:02','2025-04-02 11:15:26','3.0825235,101.6998565','Hourly report submitted at 11:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59024','1549','5030','Real-Time Report','1','2025-04-02 14:02:23','2025-04-02 14:03:39','3.0823211,101.7005139','Hourly report submitted at 02:00 PM','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59025','1549','5031','Real-Time Report','1','2025-04-02 15:04:58','2025-04-02 15:05:44','3.0822552,101.7008353','Hourly report submitted at 03:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59026','1549','5032','Real-Time Report','1','2025-04-02 15:33:57','2025-04-02 16:08:49','3.0822384,101.7007959','Hourly report submitted at 04:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59027','1549','5033','Real-Time Report','1','2025-04-02 17:02:54','2025-04-02 17:03:24','3.0826209,101.699411','Hourly report submitted at 05:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59028','1549','5034','Real-Time Report','1','2025-04-02 18:17:57','2025-04-02 18:19:00','3.0827757,101.7004925','Hourly report submitted at 06:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59029','1549','5035','Real-Time Report','1','2025-04-02 19:07:29','2025-04-02 19:20:38','3.0837693,101.7014148','Hourly report submitted at 07:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59030','1549','5036','Real-Time Report','1','2025-04-02 07:59:32','2025-04-02 08:08:48','','Report Duty at','1','Waiting for Izz','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59031','1549','5037','Real-Time Report','1','2025-04-02 19:07:35','2025-04-02 20:17:53','3.0822779,101.7002134','Off Duty at','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59032','1549','5038','Real-Time Report','1','2025-04-02 08:59:58','2025-04-02 09:00:26','','Hourly report submitted at 09:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59033','1549','5039','Real-Time Report','1','2025-04-02 12:45:06','2025-04-02 13:04:16','3.0824955,101.7004731','Hourly report submitted at 01:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59034','1549','5040','Real-Time Report','1','2025-04-02 12:31:41','2025-04-02 12:34:06','3.0792301,101.6969725','Hourly report submitted at 12:00 PM.','1','Tengah  buat Patrolling blok B  dan beteri phone abis . ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59035','1550','4765','Lobby','1','2025-04-02 08:12:00','2025-04-02 08:24:22','','Handover & Inventory Check:\r\nWalkie-Talkie (1)\r\nBaton (1)\r\nAccess Card (1)\r\nBodycam (1)\r\nTraffic Control Light (1)','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59036','1550','4766','Static Guard 1','1','2025-04-02 14:33:15','2025-04-02 15:51:33','','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59037','1550','4767','Static Guard 1','1','2025-04-02 16:26:45','2025-04-02 16:31:09','','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59038','1550','4768','Static Guard 1','1','2025-04-02 17:30:28','2025-04-02 17:36:12','','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59039','1550','4769','Static Guard 1','1','2025-04-02 18:32:26','2025-04-02 18:37:00','','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59040','1550','4770','Static Guard 1','1','2025-04-02 19:25:06','2025-04-02 19:30:14','','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59041','1550','4771','Static Guard 1','1','2025-04-02 08:30:47','2025-04-02 08:34:37','','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59042','1550','4772','Static Guard 1','1','2025-04-02 09:38:27','2025-04-02 09:40:07','','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59043','1550','4773','Static Guard 1','1','2025-04-02 10:39:21','2025-04-02 10:41:04','','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59044','1550','4774','Static Guard 1','1','2025-04-02 12:34:02','2025-04-02 12:36:00','','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59045','1550','4775','Static Guard 1','1','2025-04-02 11:31:49','2025-04-02 11:33:38','','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59046','1550','4776','Static Guard 1','1','2025-04-02 13:30:58','2025-04-02 13:33:27','','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59047','1550','4777','Static Guard 1','1','2025-04-02 14:31:18','2025-04-02 14:33:13','','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59048','1550','5000','Real-Time Report - OT Guard 1st','1','2025-04-02 19:03:36','2025-04-02 20:16:48','','Report Duty at 20:00 pm','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59049','1550','5001','Real-Time Report - OT Guard 1st','1','2025-04-03 00:57:20','2025-04-03 02:01:47','','Off Duty at 02:01 am','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59050','1550','5002','Real-Time Report - OT Guard 1st','1','2025-04-02 22:05:33','2025-04-02 22:05:55','','Hourly report submitted at 10:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59051','1550','5003','Real-Time Report - OT Guard 1st','1','2025-04-02 23:14:21','2025-04-02 23:15:02','','Hourly report submitted at 11:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59052','1550','5004','Real-Time Report - OT Guard 1st','1','2025-04-02 11:11:57','2025-04-03 00:02:08','','Hourly report submitted at 12:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59053','1550','5005','Real-Time Report - OT Guard 1st','1','2025-04-03 01:11:43','2025-04-03 01:12:17','','Hourly report submitted at 01:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59054','1550','5006','Real-Time Report - OT Guard 1st','1','2025-04-02 19:30:29','2025-04-02 21:01:48','','Hourly report submitted at 9:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59055','1550','5028','Real-Time Report','1','2025-04-02 09:59:53','2025-04-02 10:00:59','','Hourly report submitted at 10:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59056','1550','5029','Real-Time Report','1','2025-04-02 11:11:26','2025-04-02 11:11:51','','Hourly report submitted at 11:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59057','1550','5030','Real-Time Report','1','2025-04-02 14:13:16','2025-04-02 14:13:35','','Hourly report submitted at 02:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59058','1550','5031','Real-Time Report','1','2025-04-02 15:00:31','2025-04-02 15:00:54','','Hourly report submitted at 03:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59059','1550','5032','Real-Time Report','1','2025-04-02 16:26:02','2025-04-02 16:26:20','','Hourly report submitted at 04:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59060','1550','5033','Real-Time Report','1','2025-04-02 17:03:10','2025-04-02 17:03:32','','Hourly report submitted at 05:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59061','1550','5034','Real-Time Report','1','2025-04-02 18:05:53','2025-04-02 18:06:19','','Hourly report submitted at 06:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59062','1550','5035','Real-Time Report','1','2025-04-02 19:02:26','2025-04-02 19:02:54','','Hourly report submitted at 07:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59063','1550','5036','Real-Time Report','1','2025-04-02 08:11:19','2025-04-02 08:11:57','','Report Duty at 08:00 am','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59064','1550','5037','Real-Time Report','1','2025-04-02 19:03:31','2025-04-02 20:16:14','','Off Duty at 20:00 pm','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59065','1550','5038','Real-Time Report','1','2025-04-02 09:00:47','2025-04-02 09:01:16','','Hourly report submitted at 09:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59066','1550','5039','Real-Time Report','1','2025-04-02 13:05:58','2025-04-02 13:06:21','','Hourly report submitted at 01:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59067','1550','5040','Real-Time Report','1','2025-04-02 12:00:03','2025-04-02 12:00:31','','Hourly report submitted at 12:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59068','1550','5864','OT SG 1 - 1st','1','2025-04-02 23:38:21','2025-04-02 23:40:01','','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59069','1550','5870','OT SG 1 - 1st','1','2025-04-02 22:33:41','2025-04-02 22:35:54','','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59070','1550','5871','OT SG 1 - 1st','1','2025-04-03 00:02:10','2025-04-03 00:36:16','','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59071','1550','5872','OT SG 1 - 1st','1','2025-04-03 00:57:16','2025-04-03 01:30:21','','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted, with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59072','1550','5873','OT SG 1 - 1st','1','2025-04-02 19:03:50','2025-04-02 20:42:58','','Routine rounds of the guardhouse and its perimeter were conducted, with no issues identified. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59073','1550','5874','OT SG 1 - 1st','1','2025-04-02 21:32:30','2025-04-02 21:33:13','','Routine rounds of the guardhouse and its perimeter were conducted, with no issues identified. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59074','1551','4764','Level 8','1','2025-04-02 08:27:45','2025-04-02 08:29:21','3.0834313,101.7003086','Handover & Inventory Check:\r\nWalkie-Talkie (1)\r\nBaton (1)\r\nAccess Card (1)\r\nBodycam (1)\r\nGym Pass (11)','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59075','1551','4778','Static Guard 2','1','2025-04-02 08:37:30','2025-04-02 08:40:55','3.0827411,101.7002391','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59076','1551','4779','Static Guard 2','1','2025-04-02 09:34:38','2025-04-02 09:38:14','3.083232,101.7000115','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59077','1551','4780','Static Guard 2','1','2025-04-02 10:32:23','2025-04-02 10:35:31','3.0825568,101.7005067','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59078','1551','4781','Static Guard 2','1','2025-04-02 17:34:03','2025-04-02 17:36:53','3.0826916,101.699029','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59079','1551','4782','Static Guard 2','1','2025-04-02 11:29:51','2025-04-02 11:33:23','3.0824969,101.7005086','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59080','1551','4783','Static Guard 2','1','2025-04-02 12:33:19','2025-04-02 12:36:37','3.0828246,101.7002898','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59081','1551','4784','Static Guard 2','1','2025-04-02 13:32:03','2025-04-02 13:35:55','3.0825898,101.7006497','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59082','1551','4785','Static Guard 2','1','2025-04-02 14:28:30','2025-04-02 14:31:39','3.0824753,101.7005138','Routine rounds of the gym, swimming pool, library, BBQ area and Multipurpose Hall were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59083','1551','4786','Static Guard 2','1','2025-04-02 15:40:28','2025-04-02 15:42:27','3.0803332,101.703662','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59084','1551','4787','Static Guard 2','1','2025-04-02 16:38:54','2025-04-02 16:41:15','3.0823452,101.7005275','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59085','1551','4788','Static Guard 2','1','2025-04-02 18:32:08','2025-04-02 18:34:51','3.0823468,101.7005317','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59086','1551','4789','Static Guard 2','1','2025-04-02 19:34:14','2025-04-02 19:35:58','3.0823431,101.7005301','Routine rounds of the Lobby A, Lobby B, Pedestrian Bridge and its perimeter were conducted with no issues found. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59087','1551','5028','Real-Time Report','1','2025-04-02 10:05:17','2025-04-02 10:05:41','3.0825568,101.7005067','Hourly report submitted at 10:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59088','1551','5029','Real-Time Report','1','2025-04-02 11:06:07','2025-04-02 11:07:20','3.0824969,101.7005086','Hourly report submitted at 11:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59089','1551','5030','Real-Time Report','1','2025-04-02 14:00:47','2025-04-02 14:01:10','3.0824753,101.7005138','Hourly report submitted at 02:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59090','1551','5031','Real-Time Report','1','2025-04-02 15:01:54','2025-04-02 15:09:42','3.0823149,101.7006121','Hourly report submitted at 03:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59091','1551','5032','Real-Time Report','1','2025-04-02 16:03:18','2025-04-02 16:03:49','3.0822484,101.7007262','Hourly report submitted at 04:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59092','1551','5033','Real-Time Report','1','2025-04-02 17:01:26','2025-04-02 17:01:49','3.0820449,101.7001265','Hourly report submitted at 05:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59093','1551','5034','Real-Time Report','1','2025-04-02 18:03:10','2025-04-02 18:03:30','3.0823475,101.7005303','Hourly report submitted at 06:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59094','1551','5035','Real-Time Report','1','2025-04-02 19:00:39','2025-04-02 19:01:38','3.0823476,101.7003443','Hourly report submitted at 07:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59095','1551','5036','Real-Time Report','1','2025-04-02 08:12:01','2025-04-02 08:12:39','3.0823007,101.700611','Report Duty at:08:11am','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59096','1551','5037','Real-Time Report','1','2025-04-02 20:18:22','2025-04-02 20:19:11','3.0823436,101.7004208','Off Duty at :20:18pm','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59097','1551','5038','Real-Time Report','1','2025-04-02 09:04:52','2025-04-02 09:05:14','3.0824888,101.7005361','Hourly report submitted at 09:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59098','1551','5039','Real-Time Report','1','2025-04-02 13:03:31','2025-04-02 13:03:56','3.0825898,101.7006497','Hourly report submitted at 01:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59099','1551','5040','Real-Time Report','1','2025-04-02 12:05:34','2025-04-02 12:05:55','3.0828246,101.7002898','Hourly report submitted at 12:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59100','1552','5041','Real-Time Report','1','2025-04-02 20:02:06','2025-04-02 20:03:22','3.0821772,101.7008485','On Duty Reporting 08 02 pm ','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59101','1552','5042','Real-Time Report','1','2025-04-03 07:34:56','2025-04-03 08:10:37','3.0823312,101.6994994','Off Duty at 08 07am ','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59102','1552','5043','Real-Time Report','1','2025-04-02 20:22:24','2025-04-02 22:08:23','3.0823469,101.6990708','Hourly report submitted at 10:00 PM.\r\n','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59103','1552','5044','Real-Time Report','1','2025-04-02 22:55:32','2025-04-02 23:20:51','3.0821503,101.7008584','Hourly report submitted at 11:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59104','1552','5045','Real-Time Report','1','2025-04-02 23:57:49','2025-04-03 00:01:05','3.0823504,101.700452','Hourly report submitted at 12:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59105','1552','5046','Real-Time Report','1','2025-04-03 01:02:17','2025-04-03 01:02:42','3.0823039,101.7004941','Hourly report submitted at 01:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59106','1552','5047','Real-Time Report','1','2025-04-03 02:06:30','2025-04-03 02:07:10','3.0823555,101.700498','Hourly report submitted 02:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59107','1552','5048','Real-Time Report','1','2025-04-03 03:00:13','2025-04-03 03:00:33','3.0822421,101.7004337','Hourly report submitted at 03:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59108','1552','5049','Real-Time Report','1','2025-04-03 04:10:48','2025-04-03 04:11:09','3.0820623,101.7005317','Hourly report submitted at 04:00 AM.\r\n','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59109','1552','5050','Real-Time Report','1','2025-04-03 05:02:57','2025-04-03 05:03:15','3.0823063,101.7003577','Hourly report submitted at 05:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59110','1552','5051','Real-Time Report','1','2025-04-03 06:03:46','2025-04-03 06:04:28','3.0823578,101.7004937','Hourly report submitted at 06:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59111','1552','5052','Real-Time Report','1','2025-04-03 07:01:27','2025-04-03 07:01:55','3.0823872,101.6987576','Hourly report submitted at 07:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59112','1552','5053','Real-Time Report','1','2025-04-02 20:22:12','2025-04-02 21:01:54','3.0821426,101.7008813','Hourly report submitted at 9:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59113','1552','5438','Car Park Patrolling','1','2025-04-03 06:06:33','2025-04-03 06:08:39','3.0824782,101.7005749','Performed a thorough patrol on Level 7, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59114','1552','5439','Car Park Patrolling','1','2025-04-03 03:10:20','2025-04-03 03:12:52','3.0839983,101.7009065','Performed a thorough patrol on Level 5, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59115','1552','5440','Car Park Patrolling','1','2025-04-03 03:12:54','2025-04-03 03:15:55','3.0832399,101.7013433','Performed a thorough patrol on Level 4, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59116','1552','5441','Car Park Patrolling','1','2025-04-03 03:07:45','2025-04-03 03:10:17','3.082415,101.7006026','Performed a thorough patrol on Level 6, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59117','1552','5442','Car Park Patrolling','1','2025-04-03 02:56:49','2025-04-03 03:19:02','3.0832492,101.7001696','Performed a thorough patrol on Level 3, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59118','1552','5443','Car Park Patrolling','1','2025-04-03 03:21:58','2025-04-03 03:24:39','3.0836029,101.7004287','Performed a thorough patrol on Level 1, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59119','1552','5444','Car Park Patrolling','1','2025-04-03 03:24:42','2025-04-03 03:27:14','3.0824633,101.6998355','Performed a thorough patrol on GF, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59120','1552','5445','Car Park Patrolling','1','2025-04-03 03:19:04','2025-04-03 03:21:54','3.083158,101.7006331','Performed a thorough patrol on Level 2, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59121','1552','5446','Car Park Patrolling','1','2025-04-03 03:27:24','2025-04-03 03:29:51','3.0823389,101.7005373','Performed a thorough patrol on Basement, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59122','1552','5447','Car Park Patrolling','1','2025-04-03 03:04:53','2025-04-03 03:07:42','3.0849648,101.7009426','Performed a thorough patrol on Level 7, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59123','1552','5448','Car Park Patrolling','1','2025-04-03 06:10:42','2025-04-03 06:12:53','3.0831621,101.7000697','Performed a thorough patrol on Level 5, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59124','1552','5449','Car Park Patrolling','1','2025-04-03 06:12:55','2025-04-03 06:15:10','3.0835246,101.701057','Performed a thorough patrol on Level 4, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59125','1552','5450','Car Park Patrolling','1','2025-04-03 06:08:41','2025-04-03 06:10:40','3.0830796,101.7015067','Performed a thorough patrol on Level 6, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59126','1552','5451','Car Park Patrolling','1','2025-04-03 06:15:12','2025-04-03 06:17:31','3.0833776,101.7013021','Performed a thorough patrol on Level 3, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59127','1552','5452','Car Park Patrolling','1','2025-04-03 06:19:48','2025-04-03 06:22:09','3.0835976,101.7005489','Performed a thorough patrol on Level 1, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59128','1552','5453','Car Park Patrolling','1','2025-04-03 06:22:14','2025-04-03 06:24:36','3.08248,101.6998286','Performed a thorough patrol on GF, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59129','1552','5454','Car Park Patrolling','1','2025-04-03 06:17:33','2025-04-03 06:19:46','3.0836738,101.7006365','Performed a thorough patrol on Level 2, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59130','1552','5455','Car Park Patrolling','1','2025-04-03 06:24:41','2025-04-03 06:26:41','3.0824411,101.699831','Performed a thorough patrol on Basement, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59131','1552','5507','Car Park Patrolling','1','2025-04-02 20:44:31','2025-04-03 00:15:44','3.0824753,101.7005078','Performed a thorough patrol on Level 7, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59132','1552','5508','Car Park Patrolling','1','2025-04-02 20:08:42','2025-04-03 00:19:55','3.0832539,101.7014266','Performed a thorough patrol on Level 5, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59133','1552','5509','Car Park Patrolling','1','2025-04-03 00:19:58','2025-04-03 00:22:04','3.0805185,101.7035776','Performed a thorough patrol on Level 4, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59134','1552','5510','Car Park Patrolling','1','2025-04-03 00:15:46','2025-04-03 00:17:49','3.0829135,101.7017173','Performed a thorough patrol on Level 6, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59135','1552','5511','Car Park Patrolling','1','2025-04-03 00:22:08','2025-04-03 00:24:09','3.0847297,101.7008865','Performed a thorough patrol on Level 3, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59136','1552','5512','Car Park Patrolling','1','2025-04-03 00:27:11','2025-04-03 00:29:28','3.0835637,101.7005128','Performed a thorough patrol on Level 1, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59137','1552','5513','Car Park Patrolling','1','2025-04-03 00:29:38','2025-04-03 00:31:42','3.082441,101.6998291','Performed a thorough patrol on GF, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59138','1552','5514','Car Park Patrolling','1','2025-04-03 00:24:11','2025-04-03 00:26:53','3.0833958,101.700893','Performed a thorough patrol on Level 2, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59139','1552','5515','Car Park Patrolling','1','2025-04-03 00:31:47','2025-04-03 00:34:15','3.0823437,101.7005379','Performed a thorough patrol on Basement, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59140','1552','5528','Static Guard 1','1','2025-04-02 20:08:53','2025-04-02 20:43:55','3.0824191,101.7005069','Routine rounds of the guardhouse and its perimeter were conducted, with no issues identified. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59141','1552','5529','Static Guard 1','1','2025-04-02 20:15:26','2025-04-02 22:37:23','3.0824571,101.6987717','Routine rounds of the guardhouse and its perimeter were conducted, with no issues identified. Everything is in proper order.\r\n','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59142','1552','5530','Static Guard 1','1','2025-04-02 20:17:48','2025-04-03 00:41:03','3.0823244,101.7000984','Routine rounds of the guardhouse and its perimeter were conducted, with no issues identified. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59143','1552','5531','Static Guard 1','1','2025-04-02 23:37:39','2025-04-02 23:39:02','3.0822841,101.7005606','Routine rounds of the guardhouse and its perimeter were conducted, with no issues identified. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59144','1552','5532','Static Guard 1','1','2025-04-03 01:31:55','2025-04-03 01:38:32','3.0823103,101.7002215','Routine rounds of the guardhouse and its perimeter were conducted, with no issues identified. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59145','1552','5533','Static Guard 1','1','2025-04-03 03:30:00','2025-04-03 03:31:35','3.0821448,101.6999405','Routine rounds of the guardhouse and its perimeter were conducted, with no issues identified. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59146','1552','5534','Static Guard 1','1','2025-04-03 04:34:21','2025-04-03 04:35:13','3.0823267,101.700068','Routine rounds of the guardhouse and its perimeter were conducted, with no issues identified. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59147','1552','5535','Static Guard 1','1','2025-04-03 05:32:09','2025-04-03 05:34:05','3.0823594,101.7001027','Routine rounds of the guardhouse and its perimeter were conducted, with no issues identified. Everything is in proper order','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59148','1552','5536','Static Guard 1','1','2025-04-03 06:26:50','2025-04-03 06:33:23','3.0822447,101.7006093','Routine rounds of the guardhouse and its perimeter were conducted, with no issues identified. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59149','1552','5537','Static Guard 1','1','2025-04-03 07:35:01','2025-04-03 07:35:56','3.0823383,101.7004645','Routine rounds of the guardhouse and its perimeter were conducted, with no issues identified. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59150','1552','5538','Static Guard 1','1','2025-04-02 23:22:00','2025-04-03 02:56:36','3.0822421,101.7004337','Routine rounds of the guardhouse and its perimeter were conducted, with no issues identified. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59151','1553','821','Roll Call','1','2025-04-02 20:11:10','2025-04-02 20:22:27','','1-Durga\r\n2-hasta\r\n3-Brataman\r\n4 dipak\r\n5-judda\r\n\r\n','1','ot People settle','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59152','1553','4940','Guard House','1','2025-04-02 20:22:37','2025-04-02 20:27:30','','Handover & Inventory Check:\r\nWalkie-Talkie (2) & Charger Set (4)\r\nBaton (3)\r\nAccess Card (2)\r\nRain-Coat (3)\r\nHandphone (1)\r\nFire Blanket (2)\r\nFirst-Aid Box (1)\r\nWheelchair (1)\r\nBodycam (5)\r\ne-Bike & Charger Set (1)\r\nTraffic Control Light (1)','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59153','1553','5041','Real-Time Report','1','2025-04-02 20:03:23','2025-04-02 20:03:57','','Report Duty at 20:00pm','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59154','1553','5042','Real-Time Report','1','2025-04-03 08:03:23','2025-04-03 08:04:39','','Off Duty at08:05am','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59155','1553','5043','Real-Time Report','1','2025-04-02 22:10:09','2025-04-02 22:10:31','','Hourly report submitted at 10:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59156','1553','5044','Real-Time Report','1','2025-04-02 23:02:34','2025-04-02 23:02:58','','Hourly report submitted at 11:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59157','1553','5045','Real-Time Report','1','2025-04-03 00:04:02','2025-04-03 00:04:33','','Hourly report submitted at 12:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59158','1553','5046','Real-Time Report','1','2025-04-02 21:19:50','2025-04-03 01:06:57','','Hourly report submitted at 01:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59159','1553','5047','Real-Time Report','1','2025-04-03 02:03:16','2025-04-03 02:03:46','','Hourly report submitted 02:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59160','1553','5048','Real-Time Report','1','2025-04-03 03:02:03','2025-04-03 03:02:27','','Hourly report submitted at 03:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59161','1553','5049','Real-Time Report','1','2025-04-03 04:08:06','2025-04-03 04:08:37','','Hourly report submitted at 04:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59162','1553','5050','Real-Time Report','1','2025-04-03 05:25:28','2025-04-03 05:26:02','','Hourly report submitted at 05:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59163','1553','5051','Real-Time Report','1','2025-04-03 06:01:39','2025-04-03 06:02:04','','Hourly report submitted at 06:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59164','1553','5052','Real-Time Report','1','2025-04-03 07:04:43','2025-04-03 07:05:14','','Hourly report submitted at 07:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59165','1553','5053','Real-Time Report','1','2025-04-02 21:00:29','2025-04-02 21:01:00','','Hourly report submitted at 9:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59177','1553','5466','Water Tank / Water Pump','1','2025-04-03 00:51:19','2025-04-03 00:53:34','','Conducted regular checks of the water pump and water tank to ensure proper function and level readings.\r\nWater Pump Check: The water pump is functioning properly with no signs of damage or unusual noises.\r\nWater Tank (1) Reading:240\r\nWater Tank (2) Reading:240\r\nWater Tank (3) Reading:0','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59178','1553','5467','Water Tank / Water Pump','1','2025-04-03 00:53:37','2025-04-03 01:06:10','','','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59600','1562','43','Roll Call','1','2025-04-03 08:08:54','2025-04-03 08:15:54','3.0796916,101.7036655','Security Personnel On-Duty Report:\r\n1. judda \r\n2. DIPAk \r\n3.anit\r\n4. laxuman \r\n5.durga ','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59601','1562','4763','Guard House','1','2025-04-03 08:16:01','2025-04-03 08:24:13','3.0814858,101.7013142','Handover & Inventory Check:\r\nWalkie-Talkie (2) & Charger Set (4)\r\nBaton (3)\r\nAccess Card (2)\r\nRain-Coat (3)\r\nHandphone (1)\r\nFire Blanket (2)\r\nFirst-Aid Box (1)\r\nWheelchair (1)\r\nBodycam (5)\r\ne-Bike & Charger Set (1)\r\nTraffic Control Light (1)','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59609','1562','4843','Supervisor','1','2025-04-03 11:33:59','2025-04-03 11:35:49','3.0822842,101.7007126','Routine rounds of the guardhouse and its perimeter were conducted with no issues identified. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59610','1562','4844','Supervisor','1','2025-04-03 12:44:27','2025-04-03 12:46:29','3.0822992,101.7005838','Routine rounds of the guardhouse and its perimeter were conducted with no issues identified. Everything is in proper order.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59613','1562','4854','Car Park Patrolling','1','2025-04-03 18:28:18','2025-04-03 18:31:44','','Performed a thorough patrol on Level 7, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59614','1562','4855','Car Park Patrolling','1','2025-04-03 18:36:27','2025-04-03 18:40:54','','Performed a thorough patrol on Level 5, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59615','1562','4856','Car Park Patrolling','1','2025-04-03 18:40:56','2025-04-03 18:45:18','','Performed a thorough patrol on Level 4, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59616','1562','4857','Car Park Patrolling','1','2025-04-03 18:31:46','2025-04-03 18:36:25','','Performed a thorough patrol on Level 6, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59617','1562','4858','Car Park Patrolling','1','2025-04-03 18:45:36','2025-04-03 18:49:51','','Performed a thorough patrol on Level 3, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59618','1562','4859','Car Park Patrolling','1','2025-04-03 18:54:40','2025-04-03 18:58:06','','Performed a thorough patrol on Level 1, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59619','1562','4860','Car Park Patrolling','1','2025-04-03 18:58:09','2025-04-03 19:01:06','','Performed a thorough patrol on GF, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59620','1562','4861','Car Park Patrolling','1','2025-04-03 18:49:53','2025-04-03 18:54:39','','Performed a thorough patrol on Level 2, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59621','1562','4862','Car Park Patrolling','1','2025-04-03 19:01:08','2025-04-03 19:06:29','','Performed a thorough patrol on Basement, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59622','1562','5028','Real-Time Report','1','2025-04-03 10:13:09','2025-04-03 10:13:38','3.082412,101.6999001','Hourly report submitted at 10:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59623','1562','5029','Real-Time Report','1','2025-04-03 11:04:14','2025-04-03 11:04:59','3.0822509,101.7004753','Hourly report submitted at 11:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59624','1562','5030','Real-Time Report','1','2025-04-03 14:04:52','2025-04-03 14:05:23','3.0821659,101.7008823','Hourly report submitted at 02:00 PM','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59625','1562','5031','Real-Time Report','1','2025-04-03 15:06:56','2025-04-03 15:07:48','3.0822109,101.7007528','Hourly report submitted at 03:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59626','1562','5032','Real-Time Report','1','2025-04-03 16:10:12','2025-04-03 16:10:53','3.0823409,101.7004946','Hourly report submitted at 04:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59627','1562','5033','Real-Time Report','1','2025-04-03 17:07:27','2025-04-03 17:08:18','','Hourly report submitted at 05:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59628','1562','5034','Real-Time Report','1','2025-04-03 18:03:42','2025-04-03 18:04:06','3.0821465,101.7007844','Hourly report submitted at 06:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59629','1562','5035','Real-Time Report','1','2025-04-03 19:06:33','2025-04-03 19:06:48','','Hourly report submitted at 07:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59630','1562','5036','Real-Time Report','1','2025-04-03 08:03:42','2025-04-03 08:04:32','','Report Duty at 08:04 am','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59631','1562','5037','Real-Time Report','1','2025-04-03 20:14:50','2025-04-03 20:16:05','','Off Duty at 20:15 pm ','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59632','1562','5038','Real-Time Report','1','2025-04-03 09:02:09','2025-04-03 09:02:42','3.0825388,101.6990694','Hourly report submitted at 09:00 AM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59633','1562','5039','Real-Time Report','1','2025-04-03 13:03:28','2025-04-03 13:04:41','3.0823006,101.7005992','Hourly report submitted at 01:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59634','1562','5040','Real-Time Report','1','2025-04-03 12:01:15','2025-04-03 12:01:46','3.08224,101.6995062','Hourly report submitted at 12:00 PM.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59635','1562','6845','Management Office','1','2025-04-03 10:14:04','2025-04-03 10:40:23','3.0823387,101.7005553','','1','Provide updates to management on security issues observed during shifts, including suspicious activities, incidents or safety hazards.\r\n2. Hand over any overnight parking fees collected to management.\r\n3. Prepare detailed incident reports to assist management in taking necessary actions or communicating with residents.\r\n4. Update management on any building maintenance needs or violations of house rules by residents.','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59636','1562','6846','Management Office','1','2025-04-03 16:11:00','2025-04-03 16:12:13','3.0822911,101.7006411','Obtain updates from the management office regarding any information related to the building.\r\n2. Collect notices or news to share with residents to keep them informed.\r\n3. Receive instructions from the management office on any other security-related matters.\r\n4. Assist the management office with any issues related to the building or residents.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59637','1563','4562','Patrolling Block B','1','2025-04-03 13:14:39','2025-04-03 13:15:52','3.082452,101.7004774','Performed a thorough patrol on Level 10, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59638','1563','4563','Patrolling Block B','1','2025-04-03 13:01:53','2025-04-03 13:03:32','3.0796251,101.6970632','Performed a thorough patrol on Level 15, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59639','1563','4564','Patrolling Block B','1','2025-04-03 12:59:25','2025-04-03 13:01:14','3.0823225,101.7004793','Performed a thorough patrol on Level 16, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59640','1563','4565','Patrolling Block B','1','2025-04-03 12:57:29','2025-04-03 12:59:23','3.0830983,101.7007128','Performed a thorough patrol on Level 17, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59641','1563','4566','Patrolling Block B','1','2025-04-03 12:55:26','2025-04-03 12:57:08','3.0776034,101.6984128','Performed a thorough patrol on Level 18, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59642','1563','4567','Patrolling Block B','1','2025-04-03 12:51:39','2025-04-03 12:54:27','3.0835979,101.7014073','Performed a thorough patrol on Level 19, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59643','1563','4568','Patrolling Block B','1','2025-04-03 12:50:06','2025-04-03 12:51:10','3.0827626,101.7005149','','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59644','1563','4569','Patrolling Block B','1','2025-04-03 12:47:19','2025-04-03 12:50:05','3.0828558,101.700504','Performed a thorough patrol on Level 21, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59645','1563','4570','Patrolling Block B','1','2025-04-03 12:25:37','2025-04-03 12:30:13','3.082406,101.6998546','Performed a thorough patrol on Level 27, no incidents were reported and no issues were found','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59646','1563','4571','Patrolling Block B','1','2025-04-03 13:03:33','2025-04-03 13:05:28','3.082365,101.7007341','Performed a thorough patrol on Level 14, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59647','1563','4572','Patrolling Block B','1','2025-04-03 11:43:19','2025-04-03 11:45:39','3.083471,101.7008754','Performed a thorough patrol on Level 38, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59648','1563','4573','Patrolling Block B','1','2025-04-03 11:39:56','2025-04-03 11:42:07','','Performed a thorough patrol on Level 39, no incidents were reported and no issues were found','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59649','1563','4574','Patrolling Block B','1','2025-04-03 13:06:57','2025-04-03 13:08:22','3.0831597,101.7007246','Performed a thorough patrol on Level 13, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59650','1563','4575','Patrolling Block B','1','2025-04-03 11:36:23','2025-04-03 11:39:06','','Performed a thorough patrol on Level 40, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59651','1563','4576','Patrolling Block B','1','2025-04-03 11:03:19','2025-04-03 11:35:23','','Performed a thorough patrol on Level 41, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59652','1563','4577','Patrolling Block B','1','2025-04-03 13:17:02','2025-04-03 13:18:13','3.0824,101.700394','Performed a thorough patrol on Level 9, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59653','1563','4578','Patrolling Block B','1','2025-04-03 13:08:24','2025-04-03 13:12:24','3.0788143,101.6976883','Performed a thorough patrol on Level 12, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59654','1563','4579','Patrolling Block B','1','2025-04-03 13:08:37','2025-04-03 13:14:36','3.0823636,101.7003515','Info:\r\nPerformed a thorough patrol on Level 11, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59655','1563','4580','Patrolling Block B','1','2025-04-03 12:30:14','2025-04-03 12:34:17','3.0786909,101.6978461','Performed a thorough patrol on Level 26, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59656','1563','4581','Patrolling Block B','1','2025-04-03 12:34:19','2025-04-03 12:36:25','3.0826276,101.7005107','Performed a thorough patrol on Level 25, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59657','1563','4582','Patrolling Block B','1','2025-04-03 12:37:22','2025-04-03 12:38:26','3.0831558,101.7012215','Performed a thorough patrol on Level 24, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59658','1563','4583','Patrolling Block B','1','2025-04-03 12:39:01','2025-04-03 12:44:44','3.0824642,101.7001173','Performed a thorough patrol on Level 23, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59659','1563','4584','Patrolling Block B','1','2025-04-03 12:44:46','2025-04-03 12:46:49','3.0824403,101.7003474','Performed a thorough patrol on Level 22, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59660','1563','4585','Patrolling Block B','1','2025-04-03 11:46:44','2025-04-03 11:49:07','3.0834203,101.7010929','Performed a thorough patrol on Level 37, no incidents were reported and no issues were found','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59661','1563','4586','Patrolling Block B','1','2025-04-03 11:49:11','2025-04-03 11:52:01','3.0787672,101.696357','Performed a thorough patrol on Level 36, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59662','1563','4587','Patrolling Block B','1','2025-04-03 11:52:18','2025-04-03 11:54:25','3.0825266,101.7003317','Performed a thorough patrol on Level 35, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59663','1563','4588','Patrolling Block B','1','2025-04-03 11:54:29','2025-04-03 12:01:13','3.0783383,101.6972706','Performed a thorough patrol on Level 34, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59664','1563','4589','Patrolling Block B','1','2025-04-03 12:01:55','2025-04-03 12:10:25','3.0824799,101.7002688','Performed a thorough patrol on Level 33, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59665','1563','4590','Patrolling Block B','1','2025-04-03 12:10:42','2025-04-03 12:12:50','3.0704035,101.7038049','Performed a thorough patrol on Level 32, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59666','1563','4591','Patrolling Block B','1','2025-04-03 12:15:02','2025-04-03 12:17:26','3.0843636,101.7009969','Performed a thorough patrol on Level 31, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59667','1563','4592','Patrolling Block B','1','2025-04-03 12:17:29','2025-04-03 12:18:50','3.0824377,101.700467','Performed a thorough patrol on Level 30, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59668','1563','4593','Patrolling Block B','1','2025-04-03 11:54:26','2025-04-03 12:22:36','3.0824046,101.7004612','Performed a thorough patrol on Level 29, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59669','1563','4594','Patrolling Block B','1','2025-04-03 12:23:08','2025-04-03 12:24:28','3.0824101,101.7004662','Performed a thorough patrol on Level 29, no incidents were reported and no issues were found.','0','','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59670','1563','4814','Static Guard 4','1','2025-04-03 14:00:59','2025-04-03 14:02:10','3.0832192,101.7013337','Routine rounds of the guardhouse and its perimeter were conducted with no issues found. Everything is in proper order.','1','Pergi meetings dengan encik fitri','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59671','1563','4815','Static Guard 4','1','2025-04-03 17:04:12','2025-04-03 17:10:42','3.0826207,101.6993849','Routine rounds of the guardhouse and its perimeter were conducted with no issues found. Everything is in proper order.','1','Ade meeting  kat luar . ','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59672','1563','4816','Static Guard 4','1','2025-04-03 17:15:02','2025-04-03 18:07:01','3.0823238,101.7005408','Routine rounds of the guardhouse and its perimeter were conducted with no issues found. Everything is in proper order.','1','PERGI CHECK ROOF TOP DENGAN ENCIK FITRI','0',NULL,NULL,NULL,NULL,NULL,NULL,'0');
INSERT INTO `duty_task` (`id`,`duty_id`,`task_id`,`area`,`status`,`sdtm`,`dtm`,`gps`,`iremark`,`problem`,`remark`,`pdone`,`pdonedtm`,`premark`,`employee_id`,`name`,`info`,`tm`,`dur`) VALUES ('59673','1563','4817','Static Guard 4','1','2025-04-03 18:07:03','2025-04-03 18:08:21','3.0822139,101.7007671','Routine rounds